/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.imr.impl;

import com.google.common.collect.Maps;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.nshmp2.util.Params;
import org.opensha.nshmp2.util.Utils;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.param.EqkRuptureParams.MagParam;
import org.opensha.sha.imr.param.EqkRuptureParams.RupTopDepthParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceRupParameter;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;
import org.opensha.sha.util.TectonicRegionType;

public class AB2003_AttenRel
extends AttenuationRelationship
implements ParameterChangeListener {
    public static final String SHORT_NAME = "AB2003";
    public static final String NAME = "Atkinson and Boore (2003) Subduction";
    private static final long serialVersionUID = 1L;
    private static final double[] pd = new double[]{0.0, 0.2, 1.0, 0.1, 0.3, 0.5, 0.75, 2.0, 3.0};
    private static final double[] c1 = new double[]{-0.25, 0.4, -0.98, 0.16, 0.195, -0.172, -0.67648, -2.25, -3.64};
    private static final double[] c1w = new double[]{-0.04713, 0.51589, -1.02133, 0.43928, 0.26067, -0.16568, -0.69924, -2.39234, -3.70012};
    private static final double[] c2 = new double[]{0.6909, 0.69186, 0.8789, 0.66675, 0.73228, 0.7904, -0.84559, 0.9964, 1.1169};
    private static final double[] c3 = new double[]{0.0113, 0.00572, 0.0013, 0.0108, 0.00372, 0.00166, 0.0014349, 0.00364, 0.00615};
    private static final double[] c4 = new double[]{-0.00202, -0.00192, -0.00173, -0.00219, -0.00185, -0.00177, -0.0017457, -0.00118, -4.5E-4};
    private static final double[] c5 = new double[]{0.19, 0.15, 0.1, 0.15, 0.1383, 0.125, 0.10941, 0.1, 0.1};
    private static final double[] c6 = new double[]{0.24, 0.27, 0.3, 0.23, 0.3285, 0.353, 0.322, 0.25, 0.25};
    private static final double[] c7 = new double[]{0.29, 0.25, 0.55, 0.2, 0.3261, 0.4214, 0.4966, 0.4, 0.36};
    private static final double[] sigs = new double[]{0.27, 0.28, 0.29, 0.28, 0.28, 0.282, 0.2869, 0.3, 0.3};
    private static final double[] s1 = new double[]{2.79, 2.54, 2.18, 2.5, 2.516, 2.418, 2.241635, 2.33, 2.36};
    private static final double[] s1g = new double[]{2.991, 2.5711536, 2.1442, 2.7789, 2.6168785, 2.536019, 2.288355, 2.1907, 2.301};
    private static final double[] s2 = new double[]{0.03525, 0.12386, 0.1345, 0.09841, 0.1373, 0.1444, 0.14504924, 0.07148, 0.02237};
    private static final double[] s2g = new double[]{0.03525, 0.13976128, 0.1345, 0.09841, 0.13694176, 0.1324168, 0.13728201, 0.07148, 0.02237};
    private static final double[] s3 = new double[]{0.00759, 0.00884, 0.00521, 0.00974, 0.00789, 0.00671, 0.0059208343, 0.00224, 1.2E-4};
    private static final double[] s3g = new double[]{0.00759, 0.00779948, 0.00521, 0.00974, 0.00812251, 0.007951397, 0.006429092, 0.00224, 1.2E-4};
    private static final double[] s4 = new double[]{-0.00206, -0.0028, -0.0011, -0.00287, -0.00252, -0.00195, -0.0015903986, 0.0, 0.0};
    private static final double[] s4g = new double[]{-0.00206, -0.00249985, -0.0011, -0.00287, -0.0026353553, -0.0024560375, -0.0017370114, 0.0, 0.0};
    private static final double[] s5 = new double[]{0.19, 0.15, 0.1, 0.15, 0.14, 0.12, 0.106354214, 0.1, 0.1};
    private static final double[] s5g = new double[]{0.19, 0.13666, 0.1, 0.15, 0.1429013, 0.13579784, 0.11287035, 0.1, 0.1};
    private static final double[] s6 = new double[]{0.24, 0.23, 0.3, 0.23, 0.253, 0.277, 0.34101113, 0.25, 0.25};
    private static final double[] s6g = new double[]{0.24, 0.32338, 0.3, 0.23, 0.30005046, 0.32512766, 0.2953982, 0.25, 0.25};
    private static final double[] s7 = new double[]{0.29, 0.25, 0.55, 0.2, 0.319, 0.416, 0.53479433, 0.4, 0.36};
    private static final double[] s7g = new double[]{0.29, 0.33671, 0.55, 0.2, 0.29974141, 0.34473022, 0.49243947, 0.4, 0.36};
    private static final double[] sigi = new double[]{0.23, 0.28, 0.34, 0.27, 0.286, 0.31, 0.34, 0.34, 0.36};
    private HashMap<Double, Integer> indexFromPerHashMap;
    private int iper;
    private double rRup;
    private double mag;
    private double vs30;
    private double depth;
    private TectonicRegionType subType;
    private boolean global;
    private EnumParameter<TectonicRegionType> subTypeParam;
    private BooleanParameter globalParam;
    private transient ParameterChangeWarningListener warningListener = null;
    private static final double ALN10 = 2.30258509;
    private static final double gfac = 2.9912261;

    public AB2003_AttenRel(ParameterChangeWarningListener listener) {
        this.warningListener = listener;
        this.initSupportedIntensityMeasureParams();
        this.indexFromPerHashMap = Maps.newHashMap();
        for (int i = 0; i < pd.length; ++i) {
            this.indexFromPerHashMap.put(pd[i], i);
        }
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
        this.initParameterEventListeners();
        this.setParamDefaults();
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.magParam.setValueIgnoreWarning(eqkRupture.getMag());
        this.eqkRupture = eqkRupture;
        this.setPropagationEffectParams();
    }

    @Override
    public void setSite(Site site) throws ParameterException {
        this.vs30Param.setValueIgnoreWarning((Double)site.getParameter("Vs30").getValue());
        this.site = site;
        this.setPropagationEffectParams();
    }

    @Override
    protected void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.distanceRupParam.setValue(this.eqkRupture, this.site);
        }
    }

    private void setCoeffIndex() throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("Intensity Measure Param not set");
        }
        this.iper = this.indexFromPerHashMap.get(this.saPeriodParam.getValue());
        this.intensityMeasureChanged = false;
    }

    @Override
    public double getMean() {
        if (this.rRup > this.USER_MAX_DISTANCE) {
            return -35.0;
        }
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        return this.getMean(this.iper, this.vs30, this.mag, this.rRup, this.depth, this.subType, this.global);
    }

    @Override
    public double getStdDev() {
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        return this.getStdDev(this.iper, this.subType.equals(TectonicRegionType.SUBDUCTION_SLAB));
    }

    @Override
    public void setParamDefaults() {
        this.vs30Param.setValueAsDefault();
        this.subTypeParam.setValueAsDefault();
        this.globalParam.setValueAsDefault();
        this.magParam.setValueAsDefault();
        this.distanceRupParam.setValueAsDefault();
        this.rupTopDepthParam.setValueAsDefault();
        this.saParam.setValueAsDefault();
        this.saPeriodParam.setValueAsDefault();
        this.saDampingParam.setValueAsDefault();
        this.pgaParam.setValueAsDefault();
        this.vs30 = (Double)this.vs30Param.getValue();
        this.subType = (TectonicRegionType)this.subTypeParam.getValue();
        this.global = (Boolean)this.globalParam.getValue();
        this.rRup = (Double)this.distanceRupParam.getValue();
        this.mag = (Double)this.magParam.getValue();
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.distanceRupParam);
        this.meanIndependentParams.addParameter(this.rupTopDepthParam);
        this.meanIndependentParams.addParameter(this.vs30Param);
        this.meanIndependentParams.addParameter(this.magParam);
        this.meanIndependentParams.addParameter(this.subTypeParam);
        this.meanIndependentParams.addParameter(this.globalParam);
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameter(this.subTypeParam);
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameterList(this.meanIndependentParams);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    @Override
    protected void initSiteParams() {
        this.vs30Param = new Vs30_Param(150.0, 1500.0);
        this.siteParams.clear();
        this.siteParams.addParameter(this.vs30Param);
    }

    @Override
    protected void initEqkRuptureParams() {
        this.magParam = new MagParam(7.5);
        this.rupTopDepthParam = new RupTopDepthParam(0.0, 100.0, 20.0);
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
        this.eqkRuptureParams.addParameter(this.rupTopDepthParam);
    }

    @Override
    protected void initPropagationEffectParams() {
        this.distanceRupParam = new DistanceRupParameter(0.0);
        this.distanceRupParam.addParameterChangeWarningListener(this.listener);
        this.distanceRupParam.setNonEditable();
        this.propagationEffectParams.addParameter(this.distanceRupParam);
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        DoubleDiscreteConstraint perConstraint = new DoubleDiscreteConstraint();
        for (int i = 0; i < pd.length; ++i) {
            perConstraint.addDouble((Double)pd[i]);
        }
        perConstraint.setNonEditable();
        this.saPeriodParam = new PeriodParam(perConstraint);
        this.saDampingParam = new DampingParam();
        this.saParam = new SA_Param(this.saPeriodParam, this.saDampingParam);
        this.saParam.setNonEditable();
        this.pgaParam = new PGA_Param();
        this.pgaParam.setNonEditable();
        this.saParam.addParameterChangeWarningListener(this.warningListener);
        this.pgaParam.addParameterChangeWarningListener(this.warningListener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saParam);
        this.supportedIMParams.addParameter(this.pgaParam);
    }

    @Override
    protected void initOtherParams() {
        super.initOtherParams();
        this.subTypeParam = Params.createSubType();
        this.globalParam = Params.createGlobalFlag();
        this.otherParams.addParameter(this.subTypeParam);
        this.otherParams.addParameter(this.globalParam);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        String pName = e.getParameterName();
        Object val = e.getNewValue();
        if (pName.equals("DistanceRup")) {
            this.rRup = (Double)val;
        } else if (pName.equals("Vs30")) {
            this.vs30 = (Double)val;
        } else if (pName.equals("Magnitude")) {
            this.mag = (Double)val;
        } else if (pName.equals("SA Period")) {
            this.intensityMeasureChanged = true;
        } else if (pName.equals(this.subTypeParam.getName())) {
            this.subType = (TectonicRegionType)val;
        } else if (pName.equals(this.globalParam.getName())) {
            this.global = (Boolean)val;
        } else if (pName.equals("Rupture Top Depth")) {
            this.depth = (Double)val;
        }
    }

    @Override
    public void resetParameterEventListeners() {
        this.distanceRupParam.removeParameterChangeListener(this);
        this.rupTopDepthParam.removeParameterChangeListener(this);
        this.vs30Param.removeParameterChangeListener(this);
        this.magParam.removeParameterChangeListener(this);
        this.saPeriodParam.removeParameterChangeListener(this);
        this.subTypeParam.removeParameterChangeListener(this);
        this.globalParam.removeParameterChangeListener(this);
        this.initParameterEventListeners();
    }

    @Override
    protected void initParameterEventListeners() {
        this.distanceRupParam.addParameterChangeListener(this);
        this.rupTopDepthParam.addParameterChangeListener(this);
        this.vs30Param.addParameterChangeListener(this);
        this.magParam.addParameterChangeListener(this);
        this.saPeriodParam.addParameterChangeListener(this);
        this.subTypeParam.addParameterChangeListener(this);
        this.globalParam.addParameterChangeListener(this);
    }

    public URL getAttenuationRelationshipURL() throws MalformedURLException {
        return null;
    }

    @Override
    public DiscretizedFunc getExceedProbabilities(DiscretizedFunc imls) {
        return Utils.getExceedProbabilities(imls, this.getMean(), this.getStdDev(), false, 0.0);
    }

    private double getStdDev(int iper, boolean slab) {
        double sigma = slab ? sigs[iper] : sigi[iper];
        return sigma * 2.30258509;
    }

    public double getMean(int ip, double vs30, double mag, double rRup, double depth, TectonicRegionType trt, boolean global) {
        double gnd0;
        double r1;
        double c07;
        double c06;
        double c05;
        double c04;
        double c03;
        double c02;
        double r4;
        double r3;
        double r2;
        double freq;
        boolean slab = trt.equals(TectonicRegionType.SUBDUCTION_SLAB);
        double period = pd[ip];
        double d = freq = period == 0.0 ? 100.0 : 1.0 / period;
        if (slab) {
            r2 = c2[0];
            r3 = c3[0];
            r4 = c4[0];
            c02 = c2[ip];
            c03 = c3[ip];
            c04 = c4[ip];
            c05 = c5[ip];
            c06 = c6[ip];
            c07 = c7[ip];
            if (global) {
                r1 = c1w[0];
                gnd0 = c1w[ip];
            } else {
                r1 = c1[0];
                gnd0 = c1[ip];
            }
        } else {
            r2 = s2[0];
            r3 = s3[0];
            r4 = s4[0];
            if (global) {
                r1 = s1g[0];
                gnd0 = s1g[ip];
                c02 = s2g[ip];
                c03 = s3g[ip];
                c04 = s4g[ip];
                c05 = s5g[ip];
                c06 = s6g[ip];
                c07 = s7g[ip];
            } else {
                r1 = s1[0];
                gnd0 = s1[ip];
                c02 = s2[ip];
                c03 = s3[ip];
                c04 = s4[ip];
                c05 = s5[ip];
                c06 = s6[ip];
                c07 = s7[ip];
            }
        }
        mag = Math.min(mag, slab ? 8.0 : 8.5);
        double delta = 0.00724 * Math.pow(10.0, 0.507 * mag);
        double g = slab ? Math.pow(10.0, 0.301 - 0.01 * mag) : Math.pow(10.0, 1.2 - 0.18 * mag);
        double gndm = gnd0 + c02 * mag;
        double dist2 = Math.sqrt(rRup * rRup + delta * delta);
        double gnd = gndm + c03 * depth + c04 * dist2 - g * Math.log10(dist2);
        double rpga = r1 + r2 * mag + r3 * depth + r4 * dist2 - g * Math.log10(dist2);
        rpga = Math.pow(10.0, rpga);
        double sl = rpga <= 100.0 || freq <= 1.0 ? 1.0 : (rpga > 100.0 && rpga < 500.0 && freq > 1.0 && freq < 2.0 ? 1.0 - (freq - 1.0) * (rpga - 100.0) / 400.0 : (rpga >= 500.0 && freq > 1.0 && freq < 2.0 ? 1.0 - (freq - 1.0) : (rpga > 100.0 && rpga < 500.0 && freq >= 2.0 ? 1.0 - (rpga - 100.0) / 400.0 : 0.0)));
        gnd = slab ? (vs30 > 780.0 ? (gnd -= 2.9912261) : (vs30 > 660.0 ? gnd + sl * c05 * 0.5 - 2.9912261 : (vs30 > 360.0 ? gnd + sl * c05 - 2.9912261 : (vs30 > 190.0 ? gnd + sl * c06 - 2.9912261 : gnd + sl * c07 - 2.9912261)))) : (vs30 > 900.0 ? (gnd -= 2.9912261) : (vs30 > 720.0 ? gnd + sl * c05 * 0.5 - 2.9912261 : (vs30 >= 380.0 ? gnd + sl * c05 - 2.9912261 : (vs30 >= 350.0 ? gnd + 0.5 * sl * (c05 + c06) - 2.9912261 : (vs30 >= 190.0 ? gnd + sl * c06 - 2.9912261 : (vs30 >= 170.0 ? gnd + 0.5 * sl * (c06 + c07) - 2.9912261 : gnd + sl * c07 - 2.9912261))))));
        return gnd *= 2.30258509;
    }
}

