/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.imr.impl;

import com.google.common.collect.Maps;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.nshmp2.util.Params;
import org.opensha.nshmp2.util.SiteType;
import org.opensha.nshmp2.util.Utils;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.param.EqkRuptureParams.MagParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceRupParameter;

public class TP2005_AttenRel
extends AttenuationRelationship
implements ParameterChangeListener {
    public static final String SHORT_NAME = "TP2005";
    private static final long serialVersionUID = 1234567890987654353L;
    public static final String NAME = "Tavakoli and Pezeshk (2005)";
    private double[] pd = new double[]{0.0, 0.04, 0.05, 0.08, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 0.75, 1.0, 1.5, 2.0, 3.0, 4.0};
    private double[] clamp = new double[]{3.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private double[] c1h = new double[]{1.14, 2.2217764, 1.82, 0.683, 0.869, 2.38, -0.548, -0.513, 0.18295555, 0.24, -0.679, -1.55, -2.3, -2.7, -2.42, -3.69};
    private double[] c1 = new double[]{1.559, 2.6819708, 2.24, 1.1, 1.4229, 2.87, 0.017, 0.0293, 0.9333664, 0.6974, -0.323, -1.257, -1.94, -2.5177, -2.28, -2.28};
    private double[] c2 = new double[]{0.623, 0.42201685, 0.533, 0.743, 0.607, 0.501, 0.857, 0.667, 0.5887256, 0.611, 0.666, 0.764, 0.794, 0.805, 0.801, 0.817};
    private double[] c3 = new double[]{-0.0483, -0.05892166, -0.0475, -0.0293, -0.0474, -0.0642, -0.0262, -0.0443, -0.068179324, -0.0789, -0.083, -0.0859, -0.0884, -0.0929, -0.108, -0.118};
    private double[] c4 = new double[]{-1.81, -1.5474958, -1.63, -1.71, -1.52, -1.73, -1.68, -1.42, -1.4782926, -1.55, -1.48, -1.49, -1.45, -1.44, -1.65, -1.46};
    private double[] c5 = new double[]{-0.652, -0.46962538, -0.567, -0.756, -0.704, -0.976, -0.861, -0.47, -0.6740682, -0.844, -0.734, -0.941, -0.886, -0.923, -0.898, -0.845};
    private double[] c6 = new double[]{0.446, 0.44941282, 0.454, 0.46, 0.449, 0.414, 0.433, 0.468, 0.4376, 0.43636485, 0.435, 0.424, 0.412, 0.408, 0.437, 0.425};
    private double[] c7 = new double[]{-2.93E-5, 0.00911331, 0.00777, -9.68E-4, -0.00619, 0.0066, 0.00279, 0.0108, 0.009212394, 0.00789, 0.00953, -0.00584, 0.0083, 0.0206, 0.0167, 0.0113};
    private double[] c8 = new double[]{-0.00405, -0.0047678155, -0.00491, -0.00494, -0.0047, -0.0048, -0.00365, -0.00541, -0.00463148, -0.00365, -0.00337, -0.00209, -0.00327, -0.00214, -0.00203, -0.00172};
    private double[] c9 = new double[]{0.00946, -0.0015620958, -0.00314, -0.0055, -0.00424, 0.00393, -0.00202, 0.00644, 0.004467385, -2.65E-4, -0.00119, 0.0033, 0.00251, 0.0023, 0.00358, -0.00334};
    private double[] c10 = new double[]{1.41, 0.90152883, 0.98, 1.13, 1.04, 1.51, 1.64, 1.52, 1.543476, 1.59, 1.55, 1.52, 1.71, 1.43, 1.93, 1.69};
    private double[] c11 = new double[]{-0.961, -0.95111495, -0.939, -0.916, -0.913, -0.865, -0.925, -0.915, -0.8872426, -0.859, -0.784, -0.757, -0.769, -0.755, -0.818, -0.737};
    private double[] c12 = new double[]{4.32E-4, 4.995133E-4, 5.12E-4, 4.82E-4, 4.11E-4, 3.64E-4, 1.61E-4, 4.32E-4, 3.839152E-4, 2.77E-4, 2.45E-4, 1.17E-4, 2.33E-4, 2.14E-4, 1.16E-4, 1.1E-4};
    private double[] c13 = new double[]{1.33E-4, 8.605951E-4, 9.3E-4, 7.33E-4, 3.58E-4, 6.84E-4, 6.43E-4, 2.87E-4, 1.2648004E-4, 1.46E-4, 5.47E-4, 7.59E-4, 1.66E-4, 3.91E-4, 3.98E-4, 3.59E-4};
    private double[] c14 = new double[]{1.21, 1.221863, 1.22, 1.22, 1.23, 1.24, 1.24, 1.26, 1.2742121, 1.28, 1.28, 1.28, 1.27, 1.26, 1.26, 1.25};
    private double[] c15 = new double[]{-0.111, -0.10814471, -0.108, -0.108, -0.108, -0.108, -0.108, -0.109, -0.10839832, -0.1073, -0.105, -0.103, -0.0999, -0.0978, -0.0952, -0.0926};
    private double[] c16 = new double[]{0.409, 0.43780863, 0.441, 0.449, 0.456, 0.464, 0.469, 0.479, 0.49330785, 0.505, 0.522, 0.537, 0.551, 0.562, 0.573, 0.589};
    private HashMap<Double, Integer> indexFromPerHashMap;
    private int iper;
    private double rRup;
    private double mag;
    private SiteType siteType;
    private boolean clampMean;
    private boolean clampStd;
    private BooleanParameter clampMeanParam;
    private BooleanParameter clampStdParam;
    private EnumParameter<SiteType> siteTypeParam;
    private static final Double MAG_WARN_MIN = 4.0;
    private static final Double MAG_WARN_MAX = 8.0;
    private static final Double DISTANCE_RUP_WARN_MIN = 0.0;
    private static final Double DISTANCE_RUP_WARN_MAX = 1000.0;
    private transient ParameterChangeWarningListener warningListener = null;

    public TP2005_AttenRel(ParameterChangeWarningListener listener) {
        this.warningListener = listener;
        this.initSupportedIntensityMeasureParams();
        this.indexFromPerHashMap = Maps.newHashMap();
        for (int i = 0; i < this.pd.length; ++i) {
            this.indexFromPerHashMap.put(this.pd[i], i);
        }
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
        this.initParameterEventListeners();
        this.setParamDefaults();
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.magParam.setValueIgnoreWarning(eqkRupture.getMag());
        this.eqkRupture = eqkRupture;
        this.setPropagationEffectParams();
    }

    @Override
    public void setSite(Site site) throws ParameterException {
        this.siteTypeParam.setValue((SiteType)((Object)site.getParameter(this.siteTypeParam.getName()).getValue()));
        this.site = site;
        this.setPropagationEffectParams();
    }

    @Override
    protected void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.distanceRupParam.setValue(this.eqkRupture, this.site);
        }
    }

    private void setCoeffIndex() throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("Intensity Measure Param not set");
        }
        this.iper = this.indexFromPerHashMap.get(this.saPeriodParam.getValue());
        this.intensityMeasureChanged = false;
    }

    @Override
    public double getMean() {
        if (this.rRup > this.USER_MAX_DISTANCE) {
            return -35.0;
        }
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        return this.getMean(this.iper, this.siteType, this.rRup, this.mag);
    }

    @Override
    public double getStdDev() {
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        return this.getStdDev(this.iper, this.mag);
    }

    @Override
    public void setParamDefaults() {
        this.siteTypeParam.setValueAsDefault();
        this.clampMeanParam.setValueAsDefault();
        this.clampStdParam.setValueAsDefault();
        this.magParam.setValueAsDefault();
        this.distanceRupParam.setValueAsDefault();
        this.saParam.setValueAsDefault();
        this.saPeriodParam.setValueAsDefault();
        this.saDampingParam.setValueAsDefault();
        this.pgaParam.setValueAsDefault();
        this.siteType = (SiteType)((Object)this.siteTypeParam.getValue());
        this.clampMean = (Boolean)this.clampMeanParam.getValue();
        this.clampStd = (Boolean)this.clampStdParam.getValue();
        this.rRup = (Double)this.distanceRupParam.getValue();
        this.mag = (Double)this.magParam.getValue();
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.distanceRupParam);
        this.meanIndependentParams.addParameter(this.siteTypeParam);
        this.meanIndependentParams.addParameter(this.magParam);
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameter(this.magParam);
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameterList(this.meanIndependentParams);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    @Override
    protected void initSiteParams() {
        this.siteTypeParam = Params.createSiteType();
        this.siteParams.clear();
        this.siteParams.addParameter(this.siteTypeParam);
    }

    @Override
    protected void initEqkRuptureParams() {
        this.magParam = new MagParam(MAG_WARN_MIN, (double)MAG_WARN_MAX);
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
    }

    @Override
    protected void initPropagationEffectParams() {
        this.distanceRupParam = new DistanceRupParameter(0.0);
        DoubleConstraint warn = new DoubleConstraint(DISTANCE_RUP_WARN_MIN, DISTANCE_RUP_WARN_MAX);
        warn.setNonEditable();
        this.distanceRupParam.addParameterChangeWarningListener(this.listener);
        this.distanceRupParam.setWarningConstraint(warn);
        this.distanceRupParam.setNonEditable();
        this.propagationEffectParams.addParameter(this.distanceRupParam);
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        DoubleDiscreteConstraint perConstraint = new DoubleDiscreteConstraint();
        for (int i = 0; i < this.pd.length; ++i) {
            perConstraint.addDouble((Double)this.pd[i]);
        }
        perConstraint.setNonEditable();
        this.saPeriodParam = new PeriodParam(perConstraint);
        this.saDampingParam = new DampingParam();
        this.saParam = new SA_Param(this.saPeriodParam, this.saDampingParam);
        this.saParam.setNonEditable();
        this.pgaParam = new PGA_Param();
        this.pgaParam.setNonEditable();
        this.saParam.addParameterChangeWarningListener(this.warningListener);
        this.pgaParam.addParameterChangeWarningListener(this.warningListener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saParam);
        this.supportedIMParams.addParameter(this.pgaParam);
    }

    @Override
    protected void initOtherParams() {
        super.initOtherParams();
        this.clampMeanParam = new BooleanParameter("Clamp Mean", true);
        this.clampStdParam = new BooleanParameter("Clamp Std. Dev.", true);
        this.otherParams.addParameter(this.clampMeanParam);
        this.otherParams.addParameter(this.clampStdParam);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        String pName = e.getParameterName();
        Object val = e.getNewValue();
        if (pName.equals("DistanceRup")) {
            this.rRup = (Double)val;
        } else if (pName.equals(this.siteTypeParam.getName())) {
            this.siteType = (SiteType)((Object)this.siteTypeParam.getValue());
        } else if (pName.equals(this.clampMeanParam.getName())) {
            this.clampMean = (Boolean)this.clampMeanParam.getValue();
        } else if (pName.equals(this.clampStdParam.getName())) {
            this.clampStd = (Boolean)this.clampStdParam.getValue();
        } else if (pName.equals("Magnitude")) {
            this.mag = (Double)val;
        } else if (pName.equals("SA Period")) {
            this.intensityMeasureChanged = true;
        }
    }

    @Override
    public void resetParameterEventListeners() {
        this.distanceRupParam.removeParameterChangeListener(this);
        this.siteTypeParam.removeParameterChangeListener(this);
        this.clampMeanParam.removeParameterChangeListener(this);
        this.clampStdParam.removeParameterChangeListener(this);
        this.magParam.removeParameterChangeListener(this);
        this.saPeriodParam.removeParameterChangeListener(this);
        this.initParameterEventListeners();
    }

    @Override
    protected void initParameterEventListeners() {
        this.distanceRupParam.addParameterChangeListener(this);
        this.siteTypeParam.addParameterChangeListener(this);
        this.clampMeanParam.addParameterChangeListener(this);
        this.clampMeanParam.addParameterChangeListener(this);
        this.magParam.addParameterChangeListener(this);
        this.saPeriodParam.addParameterChangeListener(this);
    }

    public URL getAttenuationRelationshipURL() throws MalformedURLException {
        return null;
    }

    private double getMean(int iper, SiteType st, double rRup, double mag) {
        double vs30 = st == SiteType.HARD_ROCK ? 2000.0 : 760.0;
        double period = this.pd[iper];
        double c5sq = this.c5[iper] * this.c5[iper];
        double f1 = vs30 >= 1500.0 ? this.c1h[iper] + this.c2[iper] * mag + this.c3[iper] * Math.pow(8.5 - mag, 2.5) : (vs30 > 900.0 ? 0.5 * (this.c1h[iper] + this.c1[iper]) + this.c2[iper] * mag + this.c3[iper] * Math.pow(8.5 - mag, 2.5) : this.c1[iper] + this.c2[iper] * mag + this.c3[iper] * Math.pow(8.5 - mag, 2.5));
        double cor = Math.exp(this.c6[iper] * mag + this.c7[iper] * Math.pow(8.5 - mag, 2.5));
        double corsq = cor * cor;
        double f2 = this.c9[iper] * Math.log(rRup + 4.5);
        if (rRup > 70.0) {
            f2 += this.c10[iper] * Math.log(rRup / 70.0);
        }
        if (rRup > 130.0) {
            f2 += this.c11[iper] * Math.log(rRup / 130.0);
        }
        double R = Math.sqrt(rRup * rRup + c5sq * corsq);
        double f3 = (this.c4[iper] + this.c13[iper] * mag) * Math.log(R) + (this.c8[iper] + this.c12[iper] * mag) * R;
        double gnd = f1 + f2 + f3;
        if (this.clampMean) {
            gnd = Utils.ceusMeanClip(period, gnd);
        }
        return gnd;
    }

    private double getStdDev(int iper, double mag) {
        return mag < 7.2 ? this.c14[iper] + this.c15[iper] * mag : this.c16[iper];
    }

    @Override
    public DiscretizedFunc getExceedProbabilities(DiscretizedFunc imls) {
        return Utils.getExceedProbabilities(imls, this.getMean(), this.getStdDev(), this.clampStd, this.clamp[this.iper]);
    }
}

