/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.calc.sectionDists;

import java.util.Comparator;
import java.util.Map;
import org.opensha.refFaultParamDb.calc.sectionDists.FaultSectDistRecord;
import org.opensha.refFaultParamDb.calc.sectionDists.RecordDistComparator;

public class RecordAveQuantityComparator
implements Comparator<FaultSectDistRecord> {
    private Map<Integer, Double> idQuantityMap;
    private int mult;
    private RecordDistComparator distCompare = new RecordDistComparator();

    public RecordAveQuantityComparator(Map<Integer, Double> idQuantityMap, boolean smallestFirst) {
        this.idQuantityMap = idQuantityMap;
        this.mult = smallestFirst ? 1 : -1;
    }

    public void setMap(Map<Integer, Double> idQuantityMap) {
        this.idQuantityMap = idQuantityMap;
    }

    private double getAve(FaultSectDistRecord record) {
        double val1 = this.idQuantityMap.get(record.getID1());
        double val2 = this.idQuantityMap.get(record.getID2());
        return (val1 + val2) * 0.5;
    }

    @Override
    public int compare(FaultSectDistRecord o1, FaultSectDistRecord o2) {
        double avg1 = this.getAve(o1);
        double avg2 = this.getAve(o2);
        boolean nan1 = Double.isNaN(avg1);
        boolean nan2 = Double.isNaN(avg2);
        if (nan1 && nan2) {
            return this.distCompare.compare(o1, o2);
        }
        if (nan1 && !nan2) {
            return 1;
        }
        if (!nan1 && nan2) {
            return -1;
        }
        if (avg1 < avg2) {
            return -1 * this.mult;
        }
        if (avg1 > avg2) {
            return 1 * this.mult;
        }
        return this.distCompare.compare(o1, o2);
    }
}

