/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import java.sql.SQLException;
import javax.sql.rowset.CachedRowSet;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.EstimateInstancesDB_DAO;
import org.opensha.refFaultParamDb.dao.exception.InsertException;
import org.opensha.refFaultParamDb.dao.exception.QueryException;
import org.opensha.refFaultParamDb.vo.CombinedDisplacementInfo;
import org.opensha.refFaultParamDb.vo.EstimateInstances;

public class CombinedDisplacementInfoDB_DAO {
    private static final String TABLE_NAME = "Combined_Displacement_Info";
    private static final String INFO_ID = "Info_Id";
    private static final String ENTRY_DATE = "Entry_Date";
    private static final String TOTAL_SLIP_EST_ID = "Total_Slip_Est_Id";
    private static final String DISP_ASEISMIC_SLIP_FACTOR_EST_ID = "Disp_Aseismic_Est_Id";
    private static final String TOTAL_SLIP_COMMENTS = "Total_Slip_Comments";
    private static final String SENSE_OF_MOTION_RAKE = "Sense_of_Motion_Rake";
    private static final String SENSE_OF_MOTION_QUAL = "Sense_of_Motion_Qual";
    private static final String MEASURED_SLIP_COMP_QUAL = "Measured_Slip_Comp_Qual";
    private DB_AccessAPI dbAccess;
    private EstimateInstancesDB_DAO estimateInstancesDAO;

    public CombinedDisplacementInfoDB_DAO(DB_AccessAPI dbAccess) {
        this.setDB_Connection(dbAccess);
    }

    public void setDB_Connection(DB_AccessAPI dbAccess) {
        this.dbAccess = dbAccess;
        this.estimateInstancesDAO = new EstimateInstancesDB_DAO(dbAccess);
    }

    public void addDisplacementInfo(int infoId, String entryDate, CombinedDisplacementInfo combinedDispInfo) {
        EstimateInstances aseismicSlipEst;
        int displacementId = this.estimateInstancesDAO.addEstimateInstance(combinedDispInfo.getDisplacementEstimate());
        String comments = combinedDispInfo.getDisplacementComments();
        if (comments == null) {
            comments = "";
        }
        String somQual = combinedDispInfo.getSenseOfMotionQual();
        String measuredCompQual = combinedDispInfo.getMeasuredComponentQual();
        Object colNames = "";
        Object colVals = "";
        EstimateInstances somRake = combinedDispInfo.getSenseOfMotionRake();
        if (somRake != null) {
            colNames = (String)colNames + "Sense_of_Motion_Rake,";
            int rakeEstId = this.estimateInstancesDAO.addEstimateInstance(somRake);
            colVals = (String)colVals + rakeEstId + ",";
        }
        if (somQual != null) {
            colNames = (String)colNames + "Sense_of_Motion_Qual,";
            colVals = (String)colVals + "'" + somQual + "',";
        }
        if (measuredCompQual != null) {
            colNames = (String)colNames + "Measured_Slip_Comp_Qual,";
            colVals = (String)colVals + "'" + measuredCompQual + "',";
        }
        if ((aseismicSlipEst = combinedDispInfo.getASeismicSlipFactorEstimateForDisp()) != null) {
            int aSeisId = this.estimateInstancesDAO.addEstimateInstance(aseismicSlipEst);
            colNames = (String)colNames + "Disp_Aseismic_Est_Id,";
            colVals = (String)colVals + aSeisId + ",";
        }
        String sql = "insert into Combined_Displacement_Info(Total_Slip_Est_Id," + (String)colNames + "Total_Slip_Comments,Info_Id,Entry_Date) values (" + displacementId + "," + (String)colVals + "'" + comments + "'," + infoId + ",'" + entryDate + "')";
        try {
            this.dbAccess.insertUpdateOrDeleteData(sql);
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
    }

    public CombinedDisplacementInfo getDisplacementInfo(int infoId, String entryDate) {
        CombinedDisplacementInfo combinedDisplacementInfo = null;
        String sql = "select Disp_Aseismic_Est_Id,Sense_of_Motion_Rake,Sense_of_Motion_Qual,Measured_Slip_Comp_Qual,Total_Slip_Est_Id,Total_Slip_Comments from Combined_Displacement_Info where Info_Id=" + infoId + " and Entry_Date='" + entryDate + "'";
        try {
            CachedRowSet rs = this.dbAccess.queryData(sql);
            while (rs.next()) {
                combinedDisplacementInfo = new CombinedDisplacementInfo();
                combinedDisplacementInfo.setDisplacementComments(rs.getString(TOTAL_SLIP_COMMENTS));
                combinedDisplacementInfo.setDisplacementEstimate(this.estimateInstancesDAO.getEstimateInstance(rs.getInt(TOTAL_SLIP_EST_ID)));
                EstimateInstances aseismicSlipFactorEst = null;
                int aseismicSlipFactorEstId = rs.getInt(DISP_ASEISMIC_SLIP_FACTOR_EST_ID);
                if (!rs.wasNull()) {
                    aseismicSlipFactorEst = this.estimateInstancesDAO.getEstimateInstance(aseismicSlipFactorEstId);
                }
                int senseOfMotionRakeId = rs.getInt(SENSE_OF_MOTION_RAKE);
                EstimateInstances senseOfMotionRake = null;
                if (!rs.wasNull()) {
                    senseOfMotionRake = this.estimateInstancesDAO.getEstimateInstance(senseOfMotionRakeId);
                }
                String senseOfMotionQual = rs.getString(SENSE_OF_MOTION_QUAL);
                if (rs.wasNull()) {
                    senseOfMotionQual = null;
                }
                String measuedCompQual = rs.getString(MEASURED_SLIP_COMP_QUAL);
                if (rs.wasNull()) {
                    measuedCompQual = null;
                }
                combinedDisplacementInfo.setASeismicSlipFactorEstimateForDisp(aseismicSlipFactorEst);
                combinedDisplacementInfo.setSenseOfMotionRake(senseOfMotionRake);
                combinedDisplacementInfo.setSenseOfMotionQual(senseOfMotionQual);
                combinedDisplacementInfo.setMeasuredComponentQual(measuedCompQual);
            }
        }
        catch (SQLException ex) {
            throw new QueryException(ex.getMessage());
        }
        return combinedDisplacementInfo;
    }
}

