/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import java.sql.SQLException;
import javax.sql.rowset.CachedRowSet;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.EstimateInstancesDB_DAO;
import org.opensha.refFaultParamDb.dao.exception.InsertException;
import org.opensha.refFaultParamDb.dao.exception.QueryException;
import org.opensha.refFaultParamDb.vo.CombinedSlipRateInfo;
import org.opensha.refFaultParamDb.vo.EstimateInstances;

public class CombinedSlipRateInfoDB_DAO {
    private static final String TABLE_NAME = "Combined_Slip_Rate_Info";
    private static final String SLIP_ASEISMIC_SLIP_FACTOR_EST_ID = "Slip_Aseismic_Est_Id";
    private static final String SLIP_RATE_EST_ID = "Slip_Rate_Est_Id";
    private static final String SLIP_RATE_COMMENTS = "Slip_Rate_Comments";
    private static final String ENTRY_DATE = "Entry_Date";
    private static final String INFO_ID = "Info_Id";
    private static final String SENSE_OF_MOTION_RAKE = "Sense_of_Motion_Rake";
    private static final String SENSE_OF_MOTION_QUAL = "Sense_of_Motion_Qual";
    private static final String MEASURED_SLIP_COMP_QUAL = "Measured_Slip_Comp_Qual";
    private DB_AccessAPI dbAccess;
    private EstimateInstancesDB_DAO estimateInstancesDAO;

    public CombinedSlipRateInfoDB_DAO(DB_AccessAPI dbAccess) {
        this.setDB_Connection(dbAccess);
    }

    public void setDB_Connection(DB_AccessAPI dbAccess) {
        this.dbAccess = dbAccess;
        this.estimateInstancesDAO = new EstimateInstancesDB_DAO(dbAccess);
    }

    public void addSlipRateInfo(int infoId, String entryDate, CombinedSlipRateInfo combinedSlipRateInfo) {
        EstimateInstances aseismicSlipEst;
        int slipRateId = this.estimateInstancesDAO.addEstimateInstance(combinedSlipRateInfo.getSlipRateEstimate());
        String comments = combinedSlipRateInfo.getSlipRateComments();
        if (comments == null) {
            comments = "";
        }
        Object colNames = "";
        Object colVals = "";
        String somQual = combinedSlipRateInfo.getSenseOfMotionQual();
        String measuredCompQual = combinedSlipRateInfo.getMeasuredComponentQual();
        EstimateInstances somRake = combinedSlipRateInfo.getSenseOfMotionRake();
        if (somRake != null) {
            colNames = (String)colNames + "Sense_of_Motion_Rake,";
            int rakeEstId = this.estimateInstancesDAO.addEstimateInstance(somRake);
            colVals = (String)colVals + rakeEstId + ",";
        }
        if (somQual != null) {
            colNames = (String)colNames + "Sense_of_Motion_Qual,";
            colVals = (String)colVals + "'" + somQual + "',";
        }
        if (measuredCompQual != null) {
            colNames = (String)colNames + "Measured_Slip_Comp_Qual,";
            colVals = (String)colVals + "'" + measuredCompQual + "',";
        }
        if ((aseismicSlipEst = combinedSlipRateInfo.getASeismicSlipFactorEstimateForSlip()) != null) {
            int aSeisId = this.estimateInstancesDAO.addEstimateInstance(aseismicSlipEst);
            colNames = (String)colNames + "Slip_Aseismic_Est_Id,";
            colVals = (String)colVals + aSeisId + ",";
        }
        String sql = "insert into Combined_Slip_Rate_Info(Slip_Rate_Est_Id," + (String)colNames + "Slip_Rate_Comments,Info_Id,Entry_Date) values (" + slipRateId + "," + (String)colVals + "'" + comments + "'," + infoId + ",'" + entryDate + "')";
        try {
            this.dbAccess.insertUpdateOrDeleteData(sql);
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
    }

    public CombinedSlipRateInfo getCombinedSlipRateInfo(int infoId, String entryDate) {
        CombinedSlipRateInfo combinedSlipRateInfo = null;
        String sql = "select Slip_Aseismic_Est_Id,Sense_of_Motion_Rake,Sense_of_Motion_Qual,Measured_Slip_Comp_Qual,Slip_Rate_Est_Id,Slip_Rate_Comments from Combined_Slip_Rate_Info where Info_Id=" + infoId + " and Entry_Date='" + entryDate + "'";
        try {
            CachedRowSet rs = this.dbAccess.queryData(sql);
            while (rs.next()) {
                combinedSlipRateInfo = new CombinedSlipRateInfo();
                combinedSlipRateInfo.setSlipRateComments(rs.getString(SLIP_RATE_COMMENTS));
                combinedSlipRateInfo.setSlipRateEstimate(this.estimateInstancesDAO.getEstimateInstance(rs.getInt(SLIP_RATE_EST_ID)));
                EstimateInstances aseismicSlipFactorEst = null;
                int aseismicSlipFactorEstId = rs.getInt(SLIP_ASEISMIC_SLIP_FACTOR_EST_ID);
                if (!rs.wasNull()) {
                    aseismicSlipFactorEst = this.estimateInstancesDAO.getEstimateInstance(aseismicSlipFactorEstId);
                }
                int senseOfMotionRakeId = rs.getInt(SENSE_OF_MOTION_RAKE);
                EstimateInstances senseOfMotionRake = null;
                if (!rs.wasNull()) {
                    senseOfMotionRake = this.estimateInstancesDAO.getEstimateInstance(senseOfMotionRakeId);
                }
                String senseOfMotionQual = rs.getString(SENSE_OF_MOTION_QUAL);
                if (rs.wasNull()) {
                    senseOfMotionQual = null;
                }
                String measuedCompQual = rs.getString(MEASURED_SLIP_COMP_QUAL);
                if (rs.wasNull()) {
                    measuedCompQual = null;
                }
                combinedSlipRateInfo.setASeismicSlipFactorEstimateForSlip(aseismicSlipFactorEst);
                combinedSlipRateInfo.setSenseOfMotionRake(senseOfMotionRake);
                combinedSlipRateInfo.setSenseOfMotionQual(senseOfMotionQual);
                combinedSlipRateInfo.setMeasuredComponentQual(measuedCompQual);
            }
        }
        catch (SQLException ex) {
            throw new QueryException(ex.getMessage());
        }
        return combinedSlipRateInfo;
    }
}

