/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import java.security.MessageDigest;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Random;
import javax.sql.rowset.CachedRowSet;
import org.apache.commons.codec.binary.Base64;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.exception.InsertException;
import org.opensha.refFaultParamDb.dao.exception.QueryException;
import org.opensha.refFaultParamDb.dao.exception.UpdateException;
import org.opensha.refFaultParamDb.vo.Contributor;

public class ContributorDB_DAO {
    private static final String SEQUENCE_NAME = "Contributors_Sequence";
    public static final String TABLE_NAME = "Contributors";
    private static final String CONTRIBUTOR_ID = "Contributor_Id";
    public static final String CONTRIBUTOR_NAME = "Contributor_Name";
    private static final String FIRST_NAME = "First_Name";
    private static final String LAST_NAME = "Last_Name";
    public static final String EMAIL = "Email";
    public static final String PASSWORD = "Password";
    private DB_AccessAPI dbAccessAPI;

    public ContributorDB_DAO(DB_AccessAPI dbAccessAPI) {
        this.setDB_Connection(dbAccessAPI);
    }

    public void setDB_Connection(DB_AccessAPI dbAccessAPI) {
        this.dbAccessAPI = dbAccessAPI;
    }

    public int addContributor(Contributor contributor, String password) throws InsertException {
        int contributorId = -1;
        try {
            contributorId = this.dbAccessAPI.getNextSequenceNumber(SEQUENCE_NAME);
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
        String passwordStr = ContributorDB_DAO.getEnryptedPassword(password);
        String sql = "insert into Contributors(Contributor_Id,Contributor_Name,First_Name,Last_Name,Email,Password) values (" + contributorId + ",'" + contributor.getName() + "','" + contributor.getFirstName() + "','" + contributor.getLastName() + "','" + contributor.getEmail() + "','" + passwordStr + "')";
        try {
            this.dbAccessAPI.insertUpdateOrDeleteData(sql);
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
        return contributorId;
    }

    public static String getEnryptedPassword(String password) {
        if (password == null) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(password.getBytes());
            return Base64.encodeBase64String((byte[])md.digest()).trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean updatePassword(String userName, String oldPassword, String newPassword) throws UpdateException {
        String sql = "update Contributors set Password= '" + ContributorDB_DAO.getEnryptedPassword(newPassword) + "' where Contributor_Name='" + userName + "' and Password='" + ContributorDB_DAO.getEnryptedPassword(oldPassword) + "'";
        try {
            int numRows = this.dbAccessAPI.insertUpdateOrDeleteData(sql);
            return numRows == 1;
        }
        catch (SQLException e) {
            throw new UpdateException(e.getMessage());
        }
    }

    public void resetPasswordByEmail(String email) throws UpdateException {
        try {
            this.dbAccessAPI.resetPasswordByEmail(email);
        }
        catch (SQLException e) {
            throw new UpdateException(e.getMessage());
        }
    }

    private static int rand(int lo, int hi, Random rn) {
        int n = hi - lo + 1;
        int i = rn.nextInt() % n;
        if (i < 0) {
            i = -i;
        }
        return lo + i;
    }

    public static String getRandomPassword() {
        Random rn = new Random();
        int n = ContributorDB_DAO.rand(8, 12, rn);
        return ContributorDB_DAO.getPassword(n);
    }

    public static String getPassword(int n) {
        char[] pw = new char[n];
        int c = 65;
        int r1 = 0;
        for (int i = 0; i < n; ++i) {
            r1 = (int)(Math.random() * 3.0);
            switch (r1) {
                case 0: {
                    c = 48 + (int)(Math.random() * 10.0);
                    break;
                }
                case 1: {
                    c = 97 + (int)(Math.random() * 26.0);
                    break;
                }
                case 2: {
                    c = 65 + (int)(Math.random() * 26.0);
                }
            }
            pw[i] = (char)c;
        }
        return new String(pw);
    }

    public Contributor getContributor(int contributorId) throws QueryException {
        Contributor contributor = null;
        String condition = " where Contributor_Id=" + contributorId;
        ArrayList<Contributor> contributorList = this.query(condition);
        if (contributorList.size() > 0) {
            contributor = contributorList.get(0);
        }
        return contributor;
    }

    public Contributor getContributor(String name) throws QueryException {
        Contributor contributor = null;
        String condition = " where Contributor_Name='" + name + "'";
        ArrayList<Contributor> contributorList = this.query(condition);
        if (contributorList.size() > 0) {
            contributor = contributorList.get(0);
        }
        return contributor;
    }

    public Contributor getContributorByEmail(String emailAdd) throws QueryException {
        Contributor contributor = null;
        String condition = " where Email='" + emailAdd + "'";
        ArrayList<Contributor> contributorList = this.query(condition);
        if (contributorList.size() > 0) {
            contributor = contributorList.get(0);
        }
        return contributor;
    }

    public Contributor getValidatedContributor(String name, String password) {
        String condition = " where Contributor_Name='" + name + "' and Password='" + ContributorDB_DAO.getEnryptedPassword(password) + "'";
        ArrayList<Contributor> contributorList = this.query(condition);
        if (contributorList.size() > 0) {
            return contributorList.get(0);
        }
        return null;
    }

    public boolean isContributorValid(String name, String password) {
        return this.getValidatedContributor(name, password) != null;
    }

    public boolean removeContributor(int contributorId) throws UpdateException {
        String sql = "delete from Contributors  where Contributor_Id=" + contributorId;
        try {
            int numRows = this.dbAccessAPI.insertUpdateOrDeleteData(sql);
            if (numRows == 1) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new UpdateException(e.getMessage());
        }
        return false;
    }

    public ArrayList<Contributor> getAllContributors() throws QueryException {
        return this.query(" ");
    }

    private ArrayList<Contributor> query(String condition) throws QueryException {
        ArrayList<Contributor> contributorList = new ArrayList<Contributor>();
        String sql = "select Contributor_Id,Contributor_Name from Contributors " + condition;
        try {
            CachedRowSet rs = this.dbAccessAPI.queryData(sql);
            while (rs.next()) {
                contributorList.add(new Contributor(rs.getInt(CONTRIBUTOR_ID), rs.getString(CONTRIBUTOR_NAME)));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return contributorList;
    }

    public static void main(String[] args) {
        String rand = ContributorDB_DAO.getRandomPassword();
        String md5 = ContributorDB_DAO.getEnryptedPassword(rand);
        System.out.println(rand);
        System.out.println(md5);
    }
}

