/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.sql.rowset.CachedRowSet;
import oracle.spatial.geometry.JGeometry;
import org.opensha.commons.data.estimate.MinMaxPrefEstimate;
import org.opensha.commons.geo.BorderType;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.DB_ConnectionPool;
import org.opensha.refFaultParamDb.dao.db.DeformationModelDB_DAO;
import org.opensha.refFaultParamDb.dao.db.EstimateInstancesDB_DAO;
import org.opensha.refFaultParamDb.dao.db.FaultModelDB_DAO;
import org.opensha.refFaultParamDb.dao.db.SectionSourceDB_DAO;
import org.opensha.refFaultParamDb.dao.db.SpatialQueryResult;
import org.opensha.refFaultParamDb.dao.db.SpatialUtils;
import org.opensha.refFaultParamDb.dao.exception.InsertException;
import org.opensha.refFaultParamDb.dao.exception.QueryException;
import org.opensha.refFaultParamDb.dao.exception.UpdateException;
import org.opensha.refFaultParamDb.gui.infotools.SessionInfo;
import org.opensha.refFaultParamDb.vo.EstimateInstances;
import org.opensha.refFaultParamDb.vo.FaultSectionData;
import org.opensha.refFaultParamDb.vo.FaultSectionSummary;
import org.opensha.sha.faultSurface.FaultTrace;

public class FaultSectionVer2_DB_DAO {
    public static final String TABLE_NAME = "Fault_Section";
    public static final String SEQUENCE_NAME = "Fault_Section_Sequence";
    public static final String SECTION_ID = "Section_Id";
    public static final String AVE_LONG_TERM_SLIP_RATE_EST = "Ave_Long_Term_Slip_Rate_Est";
    public static final String AVE_DIP_EST = "Ave_Dip_Est";
    public static final String AVE_RAKE_EST = "Ave_Rake_Est";
    public static final String AVE_UPPER_DEPTH_EST = "Ave_Upper_Depth_Est";
    public static final String AVE_LOWER_DEPTH_EST = "Ave_Lower_Depth_Est";
    public static final String CONTRIBUTOR_ID = "Contributor_Id";
    public static final String SECTION_NAME = "Name";
    public static final String SHORT_NAME = "Short_Name";
    public static final String ENTRY_DATE = "Entry_Date";
    public static final String COMMENTS = "Comments";
    public static final String FAULT_TRACE = "Fault_Section_Trace";
    public static final String ASEISMIC_SLIP_FACTOR_EST = "Average_Aseismic_Slip_Est";
    public static final String DIP_DIRECTION = "Dip_Direction";
    public static final String SECTION_SOURCE_ID = "Section_Source_Id";
    public static final String QFAULT_ID = "QFault_Id";
    public static final String CONNECTOR_FLAG = "CONNECTOR_FLAG";
    public static final String CONNECTOR_FLAG_YES = "Y";
    public static final String CONNECTOR_FLAG_NO = "N";
    public static final String CONNECTOR_FLAG_DEFAULT = "N";
    public static final String FAULT_ZONE_POLYGON = "FAULT_ZONE_POLYGON";
    public static final BorderType POLYGON_BORDER_TYPE = BorderType.MERCATOR_LINEAR;
    private DB_AccessAPI dbAccess;
    private EstimateInstancesDB_DAO estimateInstancesDAO;
    private SectionSourceDB_DAO sectionSourceDAO;

    public FaultSectionVer2_DB_DAO(DB_AccessAPI dbAccess) {
        this.setDB_Connection(dbAccess);
    }

    public void setDB_Connection(DB_AccessAPI dbAccess) {
        this.dbAccess = dbAccess;
        this.estimateInstancesDAO = new EstimateInstancesDB_DAO(dbAccess);
        this.sectionSourceDAO = new SectionSourceDB_DAO(dbAccess);
    }

    public int addFaultSection(FaultSectionData faultSection) {
        String shortName;
        String qfaultId;
        float dipDirection;
        EstimateInstances aveRakeEst;
        String systemDate;
        int faultSectionId = faultSection.getSectionId();
        try {
            if (faultSectionId <= 0) {
                faultSectionId = this.dbAccess.getNextSequenceNumber(SEQUENCE_NAME);
            }
            systemDate = this.dbAccess.getSystemDate();
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
        JGeometry faultSectionTraceGeom = SpatialUtils.getMultiPointGeomtery(faultSection.getFaultTrace());
        int aveDipEst = this.estimateInstancesDAO.addEstimateInstance(faultSection.getAveDipEst());
        int aveUpperDepthEst = this.estimateInstancesDAO.addEstimateInstance(faultSection.getAveUpperDepthEst());
        int aveLowerDepthEst = this.estimateInstancesDAO.addEstimateInstance(faultSection.getAveLowerDepthEst());
        int aseismicSlipFactorEst = this.estimateInstancesDAO.addEstimateInstance(faultSection.getAseismicSlipFactorEst());
        int sectionSourceId = this.sectionSourceDAO.getSectionSource(faultSection.getSource()).getSourceId();
        Object columnNames = "";
        Object columnVals = "";
        EstimateInstances slipRateEst = faultSection.getAveLongTermSlipRateEst();
        if (slipRateEst != null) {
            int aveLongTermSlipRateEstId = this.estimateInstancesDAO.addEstimateInstance(slipRateEst);
            columnNames = (String)columnNames + "Ave_Long_Term_Slip_Rate_Est,";
            columnVals = (String)columnVals + aveLongTermSlipRateEstId + ",";
        }
        if ((aveRakeEst = faultSection.getAveRakeEst()) != null) {
            int aveRakeEstId = this.estimateInstancesDAO.addEstimateInstance(aveRakeEst);
            columnNames = (String)columnNames + "Ave_Rake_Est,";
            columnVals = (String)columnVals + aveRakeEstId + ",";
        }
        if (!Float.isNaN(dipDirection = faultSection.getDipDirection())) {
            columnNames = (String)columnNames + "Dip_Direction,";
            columnVals = (String)columnVals + dipDirection + ",";
        }
        if ((qfaultId = faultSection.getQFaultId()) != null) {
            columnNames = (String)columnNames + "QFault_Id,";
            columnVals = (String)columnVals + "'" + qfaultId + "',";
        }
        if ((shortName = faultSection.getShortName()) != null) {
            columnNames = (String)columnNames + "Short_Name,";
            columnVals = (String)columnVals + "'" + shortName + "',";
        }
        ArrayList<JGeometry> geomteryObjectList = new ArrayList<JGeometry>();
        if (faultSection.getZonePolygon() != null) {
            columnNames = (String)columnNames + "FAULT_ZONE_POLYGON,";
            columnVals = (String)columnVals + "?,";
            geomteryObjectList.add(SpatialUtils.getMultiPointGeomtery(faultSection.getZonePolygon().getBorder()));
        }
        String connectorStr = faultSection.isConnector() ? CONNECTOR_FLAG_YES : "N";
        geomteryObjectList.add(faultSectionTraceGeom);
        String sql = "insert into Fault_Section(Section_Id," + (String)columnNames + "Ave_Dip_Est,Ave_Upper_Depth_Est,Ave_Lower_Depth_Est,Contributor_Id,Name,Entry_Date,Comments,Fault_Section_Trace,Average_Aseismic_Slip_Est,Section_Source_Id,CONNECTOR_FLAG) values (" + faultSectionId + "," + (String)columnVals + aveDipEst + "," + aveUpperDepthEst + "," + aveLowerDepthEst + "," + SessionInfo.getContributor().getId() + ",'" + faultSection.getSectionName() + "','" + systemDate + "','" + faultSection.getComments() + "',?," + aseismicSlipFactorEst + "," + sectionSourceId + ",'" + connectorStr + "')";
        try {
            this.dbAccess.insertUpdateOrDeleteData(sql, geomteryObjectList);
            return faultSectionId;
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
    }

    public void update(FaultSectionData faultSection) {
        String systemDate;
        try {
            systemDate = this.dbAccess.getSystemDate();
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
        JGeometry faultSectionTraceGeom = SpatialUtils.getMultiPointGeomtery(faultSection.getFaultTrace());
        int aveDipEst = this.estimateInstancesDAO.addEstimateInstance(faultSection.getAveDipEst());
        int aveUpperDepthEst = this.estimateInstancesDAO.addEstimateInstance(faultSection.getAveUpperDepthEst());
        int aveLowerDepthEst = this.estimateInstancesDAO.addEstimateInstance(faultSection.getAveLowerDepthEst());
        int aseismicSlipFactorEst = this.estimateInstancesDAO.addEstimateInstance(faultSection.getAseismicSlipFactorEst());
        int sectionSourceId = this.sectionSourceDAO.getSectionSource(faultSection.getSource()).getSourceId();
        Object columnNames = "";
        EstimateInstances slipRateEst = faultSection.getAveLongTermSlipRateEst();
        if (slipRateEst != null) {
            int aveLongTermSlipRateEstId = this.estimateInstancesDAO.addEstimateInstance(slipRateEst);
            columnNames = (String)columnNames + "Ave_Long_Term_Slip_Rate_Est=" + aveLongTermSlipRateEstId + ",";
        } else {
            columnNames = (String)columnNames + "Ave_Long_Term_Slip_Rate_Est=NULL,";
        }
        EstimateInstances aveRakeEst = faultSection.getAveRakeEst();
        if (aveRakeEst != null) {
            int aveRakeEstId = this.estimateInstancesDAO.addEstimateInstance(aveRakeEst);
            columnNames = (String)columnNames + "Ave_Rake_Est=" + aveRakeEstId + ",";
        } else {
            columnNames = (String)columnNames + "Ave_Rake_Est=NULL,";
        }
        float dipDirection = faultSection.getDipDirection();
        columnNames = !Float.isNaN(dipDirection) ? (String)columnNames + "Dip_Direction=" + dipDirection + "," : (String)columnNames + "Dip_Direction=NULL,";
        String qfaultId = faultSection.getQFaultId();
        columnNames = qfaultId != null ? (String)columnNames + "QFault_Id='" + qfaultId + "'," : (String)columnNames + "QFault_Id=NULL,";
        ArrayList<JGeometry> geomteryObjectList = new ArrayList<JGeometry>();
        String shortName = faultSection.getShortName();
        columnNames = shortName != null ? (String)columnNames + "Short_Name='" + shortName + "'," : (String)columnNames + "Short_Name=NULL,";
        if (faultSection.getZonePolygon() != null) {
            columnNames = (String)columnNames + "FAULT_ZONE_POLYGON=?,";
            geomteryObjectList.add(SpatialUtils.getMultiPointGeomtery(faultSection.getZonePolygon().getBorder()));
        } else {
            columnNames = (String)columnNames + "FAULT_ZONE_POLYGON=NULL,";
        }
        String connectorStr = faultSection.isConnector() ? CONNECTOR_FLAG_YES : "N";
        geomteryObjectList.add(faultSectionTraceGeom);
        String sql = "update Fault_Section set " + (String)columnNames + "Ave_Dip_Est=" + aveDipEst + ",Ave_Upper_Depth_Est=" + aveUpperDepthEst + ",Ave_Lower_Depth_Est=" + aveLowerDepthEst + ",Contributor_Id=" + SessionInfo.getContributor().getId() + ",Name='" + faultSection.getSectionName() + "',Entry_Date='" + systemDate + "',Comments='" + faultSection.getComments() + "',Fault_Section_Trace=?,Average_Aseismic_Slip_Est=" + aseismicSlipFactorEst + ",Section_Source_Id=" + sectionSourceId + ",CONNECTOR_FLAG='" + connectorStr + "' where Section_Id=" + faultSection.getSectionId();
        try {
            this.dbAccess.insertUpdateOrDeleteData(sql, geomteryObjectList);
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
    }

    public void updateDipDirection(int faultSectionId, float dipDirection) {
        String sql = "update Fault_Section set Dip_Direction=" + dipDirection + " where Section_Id=" + faultSectionId;
        try {
            this.dbAccess.insertUpdateOrDeleteData(sql);
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
    }

    public void updateZonePolygon(int faultSectionId, Region polygon) {
        ArrayList<JGeometry> geomteryObjectList = new ArrayList<JGeometry>();
        Object sql = "UPDATE Fault_Section SET FAULT_ZONE_POLYGON=";
        if (polygon == null) {
            sql = (String)sql + "NULL";
        } else {
            sql = (String)sql + "?";
            geomteryObjectList.add(SpatialUtils.getMultiPointGeomtery(polygon.getBorder()));
        }
        sql = (String)sql + " WHERE Section_Id=" + faultSectionId;
        try {
            this.dbAccess.insertUpdateOrDeleteData((String)sql, geomteryObjectList);
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
    }

    public FaultSectionData getFaultSection(int faultSectionId) {
        String condition = " where Section_Id=" + faultSectionId;
        ArrayList<FaultSectionData> faultSectionsList = this.query(condition);
        FaultSectionData faultSection = null;
        if (faultSectionsList.size() > 0) {
            faultSection = faultSectionsList.get(0);
        }
        return faultSection;
    }

    public ArrayList<FaultSectionData> getAllFaultSections() {
        return this.query(" ");
    }

    public ArrayList<FaultSectionSummary> getAllFaultSectionsSummary() {
        return this.getSummary("");
    }

    public FaultSectionSummary getFaultSectionSummary(int faultSectionId) {
        ArrayList<FaultSectionSummary> faultSectionSummaryList = this.getSummary(" where Section_Id=" + faultSectionId);
        FaultSectionSummary faultSectionSummary = null;
        if (faultSectionSummaryList.size() > 0) {
            faultSectionSummary = faultSectionSummaryList.get(0);
        }
        return faultSectionSummary;
    }

    public FaultSectionSummary getFaultSectionSummary(String faultSectionName) {
        ArrayList<FaultSectionSummary> faultSectionSummaryList = this.getSummary(" where Name='" + faultSectionName + "'");
        FaultSectionSummary faultSectionSummary = null;
        if (faultSectionSummaryList.size() > 0) {
            faultSectionSummary = faultSectionSummaryList.get(0);
        }
        return faultSectionSummary;
    }

    private ArrayList<FaultSectionSummary> getSummary(String condition) {
        ArrayList<FaultSectionSummary> faultSectionsSummaryList = new ArrayList<FaultSectionSummary>();
        String sql = "select Section_Id,Name from Fault_Section " + condition + " order by (Name)";
        try {
            CachedRowSet rs = this.dbAccess.queryData(sql);
            while (rs.next()) {
                FaultSectionSummary faultSectionSummary = new FaultSectionSummary();
                faultSectionSummary.setSectionId(rs.getInt(SECTION_ID));
                faultSectionSummary.setSectionName(rs.getString(SECTION_NAME));
                faultSectionsSummaryList.add(faultSectionSummary);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return faultSectionsSummaryList;
    }

    public HashMap<Integer, EstimateInstances> getSlipRateEstimates() {
        HashMap<Integer, EstimateInstances> sectionSlipRate = new HashMap<Integer, EstimateInstances>();
        try {
            String sql = "select Section_Id,Ave_Long_Term_Slip_Rate_Est from Fault_Section";
            CachedRowSet rs = this.dbAccess.queryData(sql);
            while (rs.next()) {
                EstimateInstances slipRateEstInstance = null;
                int slipRateEstId = rs.getInt(AVE_LONG_TERM_SLIP_RATE_EST);
                if (!rs.wasNull()) {
                    slipRateEstInstance = this.estimateInstancesDAO.getEstimateInstance(slipRateEstId);
                }
                sectionSlipRate.put(rs.getInt(SECTION_ID), slipRateEstInstance);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sectionSlipRate;
    }

    private ArrayList<FaultSectionData> query(String condition) {
        ArrayList<FaultSectionData> faultSectionsList = new ArrayList<FaultSectionData>();
        String sqlWithSpatialColumnNames = "select Section_Id,to_char(Entry_Date) as Entry_Date,Ave_Long_Term_Slip_Rate_Est,Ave_Dip_Est,Ave_Rake_Est,Ave_Upper_Depth_Est,Ave_Lower_Depth_Est,Name,Comments,Fault_Section_Trace,Average_Aseismic_Slip_Est,(Dip_Direction+0) Dip_Direction,Section_Source_Id,QFault_Id,Short_Name,CONNECTOR_FLAG,FAULT_ZONE_POLYGON from Fault_Section" + condition;
        String sqlWithNoSpatialColumnNames = "select Section_Id,to_char(Entry_Date) as Entry_Date,Ave_Long_Term_Slip_Rate_Est,Ave_Dip_Est,Ave_Rake_Est,Ave_Upper_Depth_Est,Ave_Lower_Depth_Est,Name,Comments,Average_Aseismic_Slip_Est,(Dip_Direction+0) Dip_Direction,Section_Source_Id,QFault_Id,Short_Name,CONNECTOR_FLAG from Fault_Section" + condition;
        ArrayList<String> spatialColumnNames = new ArrayList<String>();
        spatialColumnNames.add(FAULT_TRACE);
        spatialColumnNames.add(FAULT_ZONE_POLYGON);
        try {
            SpatialQueryResult spatialQueryResult = this.dbAccess.queryData(sqlWithSpatialColumnNames, sqlWithNoSpatialColumnNames, spatialColumnNames);
            CachedRowSet rs = spatialQueryResult.getCachedRowSet();
            int i = 0;
            while (rs.next()) {
                Region zone;
                FaultSectionData faultSection = new FaultSectionData();
                faultSection.setSectionId(rs.getInt(SECTION_ID));
                faultSection.setComments(rs.getString(COMMENTS));
                faultSection.setEntryDate(rs.getString(ENTRY_DATE));
                faultSection.setSectionName(rs.getString(SECTION_NAME));
                faultSection.setSource(this.sectionSourceDAO.getSectionSource(rs.getInt(SECTION_SOURCE_ID)).getSectionSourceName());
                faultSection.setAseismicSlipFactorEst(this.estimateInstancesDAO.getEstimateInstance(rs.getInt(ASEISMIC_SLIP_FACTOR_EST)));
                faultSection.setAveDipEst(this.estimateInstancesDAO.getEstimateInstance(rs.getInt(AVE_DIP_EST)));
                int slipRateEstId = rs.getInt(AVE_LONG_TERM_SLIP_RATE_EST);
                if (!rs.wasNull()) {
                    faultSection.setAveLongTermSlipRateEst(this.estimateInstancesDAO.getEstimateInstance(slipRateEstId));
                }
                int rakeEstId = rs.getInt(AVE_RAKE_EST);
                if (!rs.wasNull()) {
                    faultSection.setAveRakeEst(this.estimateInstancesDAO.getEstimateInstance(rakeEstId));
                }
                float dipDirection = rs.getFloat(DIP_DIRECTION);
                if (rs.wasNull()) {
                    dipDirection = Float.NaN;
                }
                faultSection.setDipDirection(dipDirection);
                faultSection.setAveLowerDepthEst(this.estimateInstancesDAO.getEstimateInstance(rs.getInt(AVE_LOWER_DEPTH_EST)));
                faultSection.setAveUpperDepthEst(this.estimateInstancesDAO.getEstimateInstance(rs.getInt(AVE_UPPER_DEPTH_EST)));
                String sectionName = faultSection.getSectionName();
                double upperDepth = ((MinMaxPrefEstimate)faultSection.getAveUpperDepthEst().getEstimate()).getPreferred();
                ArrayList<JGeometry> geometries = spatialQueryResult.getGeometryObjectsList(i++);
                FaultTrace faultTrace = FaultSectionVer2_DB_DAO.getFaultTrace(sectionName, upperDepth, geometries);
                faultSection.setFaultTrace(faultTrace);
                String qFaultId = rs.getString(QFAULT_ID);
                if (!rs.wasNull()) {
                    faultSection.setQFaultId(qFaultId);
                }
                String shortName = rs.getString(SHORT_NAME);
                if (!rs.wasNull()) {
                    faultSection.setShortName(shortName);
                }
                String connStr = rs.getString(CONNECTOR_FLAG);
                boolean connector = connStr.equals(CONNECTOR_FLAG_YES);
                faultSection.setConnector(connector);
                if (geometries.size() < 2 || geometries.get(1) == null) {
                    zone = null;
                } else {
                    JGeometry geom = geometries.get(1);
                    LocationList zoneLocs = SpatialUtils.loadMultiPointGeometries(geom, 0.0);
                    zone = new Region(zoneLocs, POLYGON_BORDER_TYPE);
                }
                faultSection.setZonePolygon(zone);
                faultSectionsList.add(faultSection);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return faultSectionsList;
    }

    public static FaultTrace getFaultTrace(String sectionName, double upperDepth, ArrayList<JGeometry> geometries) {
        JGeometry faultSectionGeom = geometries.get(0);
        FaultTrace faultTrace = new FaultTrace(sectionName);
        faultTrace.addAll(SpatialUtils.loadMultiPointGeometries(faultSectionGeom, upperDepth));
        return faultTrace;
    }

    public void removeFaultSection(int faultSectionId) {
        String sql = "delete from Fault_Section where Section_Id=" + faultSectionId;
        try {
            this.dbAccess.insertUpdateOrDeleteData(sql);
            FaultModelDB_DAO fm2db = new FaultModelDB_DAO(this.dbAccess);
            fm2db.removeSectionFromAllModels(faultSectionId);
            DeformationModelDB_DAO dm2db = new DeformationModelDB_DAO(this.dbAccess);
            dm2db.removeSectionFromAllModels(faultSectionId);
        }
        catch (SQLException e) {
            throw new UpdateException(e.getMessage());
        }
    }

    public static void main(String[] args) {
        DB_AccessAPI db = DB_ConnectionPool.getLatestReadOnlyConn();
        FaultSectionVer2_DB_DAO fs2db = new FaultSectionVer2_DB_DAO(db);
        for (FaultSectionData fs : fs2db.getAllFaultSections()) {
            System.out.println("Connector? " + fs.isConnector());
            System.out.println("Zone? " + String.valueOf(fs.getZonePolygon()));
        }
        try {
            db.destroy();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

