/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.rowset.CachedRowSet;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.exception.QueryException;
import org.opensha.refFaultParamDb.vo.QFault2002B;

public class QFault2002B_DB_DAO {
    private static final String TABLE_NAME = "QFault_2002B";
    private static final String SECTION_ID = "Section_Id";
    private static final String SECTION_NAME = "Section_Name";
    private static final String EFFECTIVE_DATE = "Effective_Date";
    private static final String COMMENTS = "comments";
    private static final String AVG_SLIP_RATE = "Avg_Slip_Rate";
    private static final String SLIP_COMMENTS = "Slip_Comments";
    private static final String SLIP_RATE_STDDEV = "Slip_Rate_StdDev";
    private static final String SLIP_DEV_COMMENTS = "Slip_Dev_Comment";
    private static final String AVG_DIP = "Avg_Dip";
    private static final String DIP_COMMENTS = "Dip_Comments";
    private static final String AVG_UPPER_DEPTH = "Avg_Upper_Depth";
    private static final String UPPER_D_COMMENT = "Upper_D_Comment";
    private static final String AVG_LOWER_DEPTH = "Avg_Lower_Depth";
    private static final String LOWER_D_COMMENT = "Lower_D_Comment";
    private static final String AVG_RAKE = "Avg_Rake";
    private static final String RAKE_COMMENTS = "Rake_Comments";
    private DB_AccessAPI dbAccessAPI;

    public QFault2002B_DB_DAO(DB_AccessAPI dbAccessAPI) {
        this.setDB_Connection(dbAccessAPI);
    }

    public void setDB_Connection(DB_AccessAPI dbAccessAPI) {
        this.dbAccessAPI = dbAccessAPI;
    }

    public QFault2002B getFaultSection(String sectionId) throws QueryException {
        QFault2002B faultSection = null;
        String condition = " where Section_Id='" + sectionId + "'";
        ArrayList<QFault2002B> faultSectionList = this.query(condition);
        if (faultSectionList.size() > 0) {
            faultSection = faultSectionList.get(0);
        }
        return faultSection;
    }

    public ArrayList<QFault2002B> getAllFaultSections() throws QueryException {
        return this.query(" ");
    }

    private ArrayList<QFault2002B> query(String condition) throws QueryException {
        ArrayList<QFault2002B> faultSectionList = new ArrayList<QFault2002B>();
        String sql = "select Section_Id,Section_Name,Effective_Date,comments,Avg_Slip_Rate,Slip_Comments,Slip_Rate_StdDev,Slip_Dev_Comment,Avg_Dip,Dip_Comments,Avg_Upper_Depth,Upper_D_Comment,Avg_Lower_Depth,Lower_D_Comment,Avg_Rake,Rake_Comments from QFault_2002B" + condition;
        try {
            CachedRowSet rs = this.dbAccessAPI.queryData(sql);
            while (rs.next()) {
                QFault2002B faultSection = new QFault2002B();
                faultSection.setSectionId(rs.getString(SECTION_ID));
                faultSection.setSectionName(rs.getString(SECTION_NAME));
                faultSection.setEffectiveDate(rs.getDate(EFFECTIVE_DATE));
                faultSection.setComments(rs.getString(COMMENTS));
                faultSection.setAvgSlipRate(rs.getFloat(AVG_SLIP_RATE));
                faultSection.setSlipComments(rs.getString(SLIP_COMMENTS));
                faultSection.setSlipRateStdDev(rs.getFloat(SLIP_RATE_STDDEV));
                faultSection.setSlipDevComment(rs.getString(SLIP_DEV_COMMENTS));
                faultSection.setAveDip(rs.getFloat(AVG_DIP));
                faultSection.setDipComments(rs.getString(DIP_COMMENTS));
                faultSection.setAvgUpperDepth(rs.getFloat(AVG_UPPER_DEPTH));
                faultSection.setUpperDepthComment(rs.getString(UPPER_D_COMMENT));
                faultSection.setAvgLowerDepth(rs.getFloat(AVG_LOWER_DEPTH));
                faultSection.setLowerDepthComment(rs.getString(LOWER_D_COMMENT));
                faultSection.setAveRake(rs.getFloat(AVG_RAKE));
                faultSection.setRakeComments(rs.getString(RAKE_COMMENTS));
                faultSectionList.add(faultSection);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return faultSectionList;
    }
}

