/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.rowset.CachedRowSet;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.exception.QueryException;
import org.opensha.refFaultParamDb.vo.SectionSource;

public class SectionSourceDB_DAO {
    private static final String TABLE_NAME = "Section_Source";
    private static final String SECTION_SOURCE_ID = "Section_Source_Id";
    private static final String SECTION_SOURCE_NAME = "Section_Source_Name";
    private DB_AccessAPI dbAccessAPI;

    public SectionSourceDB_DAO(DB_AccessAPI dbAccessAPI) {
        this.setDB_Connection(dbAccessAPI);
    }

    public void setDB_Connection(DB_AccessAPI dbAccessAPI) {
        this.dbAccessAPI = dbAccessAPI;
    }

    public SectionSource getSectionSource(int sectionSourceId) throws QueryException {
        String condition = " where Section_Source_Id=" + sectionSourceId;
        ArrayList<SectionSource> sectionSourceList = this.query(condition);
        SectionSource sectionSource = null;
        if (sectionSourceList.size() > 0) {
            sectionSource = sectionSourceList.get(0);
        }
        return sectionSource;
    }

    public SectionSource getSectionSource(String sectionSourceName) throws QueryException {
        String condition = " where Section_Source_Name='" + sectionSourceName + "'";
        ArrayList<SectionSource> sectionSourceList = this.query(condition);
        SectionSource sectionSource = null;
        if (sectionSourceList.size() > 0) {
            sectionSource = sectionSourceList.get(0);
        }
        return sectionSource;
    }

    public ArrayList<SectionSource> getAllSectionSource() {
        return this.query(" ");
    }

    public int addSectionSource(String name) {
        if (name == null) {
            throw new NullPointerException("new section source name can't be null!");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("new section source name can't be blank!");
        }
        int maxID = 1;
        for (SectionSource source : this.getAllSectionSource()) {
            if (source.getSourceId() > maxID) {
                maxID = source.getSourceId();
            }
            if (!source.getSectionSourceName().equals(name)) continue;
            throw new RuntimeException("Section source '" + name + "' already exists!");
        }
        int sourceID = maxID + 1;
        Object sql = "INSERT INTO Section_Source (Section_Source_Id, Section_Source_Name) ";
        sql = (String)sql + "\nVALUES (" + sourceID + ", '" + name + "')";
        System.out.println((String)sql);
        try {
            return this.dbAccessAPI.insertUpdateOrDeleteData((String)sql);
        }
        catch (SQLException e) {
            throw new QueryException(e);
        }
    }

    private ArrayList<SectionSource> query(String condition) throws QueryException {
        ArrayList<SectionSource> sectionSourceList = new ArrayList<SectionSource>();
        String sql = "select Section_Source_Id,Section_Source_Name from Section_Source" + condition;
        try {
            CachedRowSet rs = this.dbAccessAPI.queryData(sql);
            while (rs.next()) {
                sectionSourceList.add(new SectionSource(rs.getInt(SECTION_SOURCE_ID), rs.getString(SECTION_SOURCE_NAME)));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e);
        }
        return sectionSourceList;
    }
}

