/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.rowset.CachedRowSet;
import oracle.spatial.geometry.JGeometry;
import org.opensha.commons.util.ServerPrefUtils;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.PrioritizedDB_Access;
import org.opensha.refFaultParamDb.dao.db.SpatialQueryResult;
import org.opensha.refFaultParamDb.gui.infotools.SessionInfo;

public class ServerDB_Access
implements Serializable,
DB_AccessAPI {
    private static final long serialVersionUID = 1L;
    private static final boolean D = false;
    public static final String SERVLET_URL_DB2 = ServerPrefUtils.SERVER_PREFS.getServletBaseURL() + "Fault_DB_AccessServlet";
    public static final String SERVLET_URL_DB3 = ServerPrefUtils.SERVER_PREFS.getServletBaseURL() + "Fault_DB_AccessServlet_Ver3";
    public static final String UPDATE_ALL_PREF_DATA = "Update Pref Data";
    private String servletURL;

    public ServerDB_Access(String servletURL) {
        this.servletURL = servletURL;
    }

    @Override
    public int getNextSequenceNumber(String sequenceName) throws SQLException {
        Object dataFromServlet = this.openServletConnection("get sequence number", sequenceName, null, null);
        if (dataFromServlet instanceof SQLException) {
            throw (SQLException)dataFromServlet;
        }
        int SeqNo = (Integer)dataFromServlet;
        return SeqNo;
    }

    @Override
    public int insertUpdateOrDeleteData(String sql) throws SQLException {
        Object dataFromServlet = this.openServletConnection("insert/update/delete query", sql, null, null);
        if (dataFromServlet instanceof SQLException) {
            throw (SQLException)dataFromServlet;
        }
        int key = (Integer)dataFromServlet;
        return key;
    }

    @Override
    public int[] insertUpdateOrDeleteBatch(ArrayList<String> sqls, boolean rollbackOnFail) throws SQLException {
        Object dataFromServlet = this.openServletConnection("insert/update/delete query", sqls, rollbackOnFail, null);
        if (dataFromServlet instanceof SQLException) {
            throw (SQLException)dataFromServlet;
        }
        int[] key = (int[])dataFromServlet;
        return key;
    }

    @Override
    public int insertUpdateOrDeleteData(String sql, ArrayList<JGeometry> geometryList) throws SQLException {
        Object dataFromServlet = this.openServletConnection("insert/update spatial", sql, null, geometryList);
        if (dataFromServlet instanceof SQLException) {
            throw (SQLException)dataFromServlet;
        }
        int key = (Integer)dataFromServlet;
        return key;
    }

    @Override
    public CachedRowSet queryData(String sql) throws SQLException {
        Object dataFromServlet = this.openServletConnection("select query", sql, null, null);
        if (dataFromServlet instanceof SQLException) {
            throw (SQLException)dataFromServlet;
        }
        CachedRowSet rowSet = (CachedRowSet)dataFromServlet;
        return rowSet;
    }

    @Override
    public SpatialQueryResult queryData(String sqlWithSpatialColumnName, String sqlWithNoSpatialColumnName, ArrayList<String> spatialColumnNames) throws SQLException {
        Object dataFromServlet = this.openServletConnection("select query spatial", sqlWithSpatialColumnName, sqlWithNoSpatialColumnName, spatialColumnNames);
        if (dataFromServlet instanceof SQLException) {
            throw (SQLException)dataFromServlet;
        }
        SpatialQueryResult spatialQueryResult = (SpatialQueryResult)dataFromServlet;
        return spatialQueryResult;
    }

    @Override
    public String getSystemDate() throws SQLException {
        String sql = "select to_char(sysdate) from dual";
        CachedRowSet result = this.queryData(sql);
        result.next();
        return result.getString(1);
    }

    @Override
    public int resetPasswordByEmail(String sql) throws SQLException {
        Object dataFromServlet = this.openServletConnection("reset password", sql, null, null);
        if (dataFromServlet instanceof SQLException) {
            throw (SQLException)dataFromServlet;
        }
        int key = (Integer)dataFromServlet;
        return key;
    }

    public void updateAllPrefData() {
        Object retVal = this.openServletConnection(UPDATE_ALL_PREF_DATA, null, null, null);
        if (retVal instanceof Boolean) {
            if (((Boolean)retVal).booleanValue()) {
                return;
            }
            throw new RuntimeException("Unknown error occured while updating pref data");
        }
        if (retVal instanceof RuntimeException) {
            throw (RuntimeException)retVal;
        }
        if (retVal instanceof Exception) {
            throw new RuntimeException((Exception)retVal);
        }
        throw new RuntimeException("Unknown error occured while updating pref data (" + String.valueOf(retVal) + ")");
    }

    private Object openServletConnection(String sqlFunction, Object sql, Object sql1, ArrayList<?> geometryList) {
        Object outputFromRemoteDB = null;
        try {
            URL dbAccessServlet = new URL(this.servletURL);
            URLConnection servletConnection = dbAccessServlet.openConnection();
            servletConnection.setDoInput(true);
            servletConnection.setDoOutput(true);
            servletConnection.setUseCaches(false);
            servletConnection.setDefaultUseCaches(false);
            servletConnection.setRequestProperty("Content-Type", "application/octet-stream");
            ObjectOutputStream outputToServlet = new ObjectOutputStream(servletConnection.getOutputStream());
            outputToServlet.writeObject(SessionInfo.getUserName());
            outputToServlet.writeObject(SessionInfo.getPassword());
            outputToServlet.writeObject(sqlFunction);
            outputToServlet.writeObject(sql);
            if (sql1 != null) {
                outputToServlet.writeObject(sql1);
            }
            if (geometryList != null) {
                outputToServlet.writeObject(geometryList);
            }
            outputToServlet.flush();
            outputToServlet.close();
            ObjectInputStream inputToServlet = new ObjectInputStream(servletConnection.getInputStream());
            outputFromRemoteDB = inputToServlet.readObject();
            if (outputFromRemoteDB instanceof Exception) {
                throw new RuntimeException((Exception)outputFromRemoteDB);
            }
            inputToServlet.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return outputFromRemoteDB;
    }

    public static void main(String[] args) {
        ServerDB_Access db = new ServerDB_Access(SERVLET_URL_DB2);
        boolean valid = PrioritizedDB_Access.isAccessorValid(db);
        System.out.println("Valid? " + valid);
        System.exit(0);
    }

    @Override
    public void destroy() throws SQLException {
    }

    @Override
    public void destroy(int millis) throws SQLException {
    }
}

