/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui;

import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.constraint.impl.IntegerConstraint;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.impl.IntegerParameter;
import org.opensha.refFaultParamDb.data.ExactTime;

public class ExactTimeGuiBean
extends ParameterListEditor {
    public static final String YEAR_PARAM_NAME = "Year";
    private IntegerParameter yearParam;
    private IntegerConstraint yearConstraint = new IntegerConstraint(0, Integer.MAX_VALUE);
    private static final Integer YEAR_PARAM_DEFAULT = 2005;
    public static final String MONTH_PARAM_NAME = "Month";
    private IntegerParameter monthParam;
    private IntegerConstraint monthConstraint = new IntegerConstraint(1, 12);
    private static final Integer MONTH_PARAM_DEFAULT = 1;
    public static final String DAY_PARAM_NAME = "Day";
    private IntegerParameter dayParam;
    private static final Integer DAY_PARAM_DEFAULT = 1;
    private IntegerConstraint dayConstraint = new IntegerConstraint(1, 31);
    public static final String HOUR_PARAM_NAME = "Hour";
    private IntegerParameter hourParam;
    private static final Integer HOUR_PARAM_DEFAULT = 0;
    private IntegerConstraint hourConstraint = new IntegerConstraint(0, 59);
    public static final String MINUTE_PARAM_NAME = "Minute";
    private IntegerParameter minuteParam;
    private static final Integer MINUTE_PARAM_DEFAULT = 0;
    private IntegerConstraint minuteConstraint = new IntegerConstraint(0, 59);
    public static final String SECOND_PARAM_NAME = "Second";
    private IntegerParameter secondParam;
    private static final Integer SECOND_PARAM_DEFAULT = 0;
    private IntegerConstraint secondConstraint = new IntegerConstraint(0, 59);

    public ExactTimeGuiBean(String title) {
        this.initParamsList();
        this.addParameters();
        this.setTitle(title);
    }

    public void setTime(ExactTime exactTime) {
        int year = exactTime.getYear();
        int month = exactTime.getMonth();
        int day = exactTime.getDay();
        int hour = exactTime.getHour();
        int minute = exactTime.getMinute();
        int second = exactTime.getSecond();
        this.yearParam.setValue(exactTime.getYear());
        this.getParameterEditor(this.yearParam.getName()).refreshParamEditor();
        if (month != 0) {
            this.monthParam.setValue(month);
            this.getParameterEditor(this.monthParam.getName()).refreshParamEditor();
        }
        if (day != 0) {
            this.dayParam.setValue(day);
            this.getParameterEditor(this.dayParam.getName()).refreshParamEditor();
        }
        if (hour != 0) {
            this.hourParam.setValue(hour);
            this.getParameterEditor(this.hourParam.getName()).refreshParamEditor();
        }
        if (minute != 0) {
            this.minuteParam.setValue(minute);
            this.getParameterEditor(this.minuteParam.getName()).refreshParamEditor();
        }
        if (second != 0) {
            this.secondParam.setValue(second);
            this.getParameterEditor(this.secondParam.getName()).refreshParamEditor();
        }
    }

    private void initParamsList() {
        this.parameterList = new ParameterList();
        this.yearParam = new IntegerParameter(YEAR_PARAM_NAME, (ParameterConstraint<Integer>)this.yearConstraint, YEAR_PARAM_DEFAULT);
        this.monthConstraint.setNullAllowed(true);
        this.dayConstraint.setNullAllowed(true);
        this.hourConstraint.setNullAllowed(true);
        this.minuteConstraint.setNullAllowed(true);
        this.secondConstraint.setNullAllowed(true);
        this.monthParam = new IntegerParameter(MONTH_PARAM_NAME, (ParameterConstraint<Integer>)this.monthConstraint, MONTH_PARAM_DEFAULT);
        this.dayParam = new IntegerParameter(DAY_PARAM_NAME, (ParameterConstraint<Integer>)this.dayConstraint, DAY_PARAM_DEFAULT);
        this.hourParam = new IntegerParameter(HOUR_PARAM_NAME, (ParameterConstraint<Integer>)this.hourConstraint, HOUR_PARAM_DEFAULT);
        this.minuteParam = new IntegerParameter(MINUTE_PARAM_NAME, (ParameterConstraint<Integer>)this.minuteConstraint, MINUTE_PARAM_DEFAULT);
        this.secondParam = new IntegerParameter(SECOND_PARAM_NAME, (ParameterConstraint<Integer>)this.secondConstraint, SECOND_PARAM_DEFAULT);
        this.parameterList.addParameter(this.yearParam);
        this.parameterList.addParameter(this.monthParam);
        this.parameterList.addParameter(this.dayParam);
        this.parameterList.addParameter(this.hourParam);
        this.parameterList.addParameter(this.minuteParam);
        this.parameterList.addParameter(this.secondParam);
    }

    public ExactTime getExactTime() {
        Integer secondParamVal;
        Integer minuteParamVal;
        Integer hourParamVal;
        Integer dayParamVal;
        int year = (Integer)this.yearParam.getValue();
        int month = 0;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        Integer monthParamVal = (Integer)this.monthParam.getValue();
        if (monthParamVal != null) {
            month = monthParamVal;
        }
        if ((dayParamVal = (Integer)this.dayParam.getValue()) != null) {
            day = dayParamVal;
        }
        if ((hourParamVal = (Integer)this.hourParam.getValue()) != null) {
            hour = hourParamVal;
        }
        if ((minuteParamVal = (Integer)this.minuteParam.getValue()) != null) {
            minute = minuteParamVal;
        }
        if ((secondParamVal = (Integer)this.secondParam.getValue()) != null) {
            second = secondParamVal;
        }
        ExactTime exactTime = new ExactTime(year, month, day, hour, minute, second, false);
        return exactTime;
    }
}

