/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.opensha.commons.util.ApplicationVersion;
import org.opensha.commons.util.bugReports.DefaultExceptionHandler;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.DB_ConnectionPool;
import org.opensha.refFaultParamDb.gui.LoginWindow;
import org.opensha.refFaultParamDb.gui.addEdit.connections.ConnectionsEditor;
import org.opensha.refFaultParamDb.gui.addEdit.deformationModel.EditDeformationModel;
import org.opensha.refFaultParamDb.gui.addEdit.faultModel.AddEditFaultModel;
import org.opensha.refFaultParamDb.gui.view.FaultSectionsDistanceCalcGUI;
import org.opensha.refFaultParamDb.gui.view.ViewFaultSection;

public class FaultSectionsAndModelsApp
extends JFrame {
    private static final long serialVersionUID = 1L;
    public static final String APP_NAME = "WGCEP Fault Sections and Models Application";
    public static final String APP_SHORT_NAME = "FaultSections";
    private static ApplicationVersion version;
    private static DefaultExceptionHandler eh;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private static final String FAULT_SECTION = "Fault Section";
    private static final String FAULT_MODEL = "Fault Model";
    private static final String DEFORMATION_MODEL = "Deformation Model";
    private static final String FAULT_SECTIONS_DIST_CALC = "Fault Sections Distance Calc";
    private static final String CONNECTIONS = "Fault Sections Connections";
    private static final DB_AccessAPI dbConnection;

    public static ApplicationVersion getAppVersion() {
        if (version == null) {
            try {
                version = ApplicationVersion.loadBuildVersion();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return version;
    }

    public FaultSectionsAndModelsApp() {
        if (eh != null) {
            eh.setApp(this);
            eh.setParent(this);
        }
        this.tabbedPane.addTab(FAULT_SECTION, new JScrollPane(new ViewFaultSection(dbConnection)));
        this.tabbedPane.addTab(FAULT_MODEL, new JScrollPane(new AddEditFaultModel(dbConnection)));
        this.tabbedPane.addTab(DEFORMATION_MODEL, new JScrollPane(new EditDeformationModel(dbConnection)));
        this.tabbedPane.addTab(FAULT_SECTIONS_DIST_CALC, new JScrollPane(new FaultSectionsDistanceCalcGUI(dbConnection)));
        this.tabbedPane.addTab(CONNECTIONS, new JScrollPane(new ConnectionsEditor(dbConnection)));
        this.setTitle("WGCEP Fault Sections and Models Application (" + String.valueOf(FaultSectionsAndModelsApp.getAppVersion()) + ")");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.setDefaultCloseOperation(3);
        this.pack();
        this.setVisible(true);
    }

    public static void main(String[] args) {
        eh = new DefaultExceptionHandler(APP_SHORT_NAME, FaultSectionsAndModelsApp.getAppVersion(), null, null);
        Thread.setDefaultUncaughtExceptionHandler(eh);
        new LoginWindow(dbConnection, FaultSectionsAndModelsApp.class.getName());
    }

    static {
        dbConnection = DB_ConnectionPool.getLatestReadWriteConn();
    }
}

