/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.opensha.commons.util.ClassUtils;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.exception.DBConnectException;
import org.opensha.refFaultParamDb.gui.infotools.SessionInfo;
import org.opensha.refFaultParamDb.gui.login.ChangePassword;
import org.opensha.refFaultParamDb.gui.login.GetAccountInfo;
import org.opensha.refFaultParamDb.gui.login.RequestUserAccount;

public class LoginWindow
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final boolean D = false;
    private static final String TITLE = "Login";
    private JPanel passwordPanel = new JPanel();
    private JButton loginButton = new JButton();
    private JPasswordField passwordText = new JPasswordField();
    private JLabel headerLabel = new JLabel();
    private JLabel passwordLabel = new JLabel();
    private JTextField usernameText = new JTextField();
    private JLabel userNameLabel = new JLabel();
    private JComboBox loginTypeComboBox = new JComboBox();
    private JLabel loginTypeLabel = new JLabel();
    private JButton newUserButton = new JButton();
    private JButton forgetPassButton = new JButton();
    private JButton changePassButton = new JButton();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private BorderLayout borderLayout1 = new BorderLayout();
    public static final String MSG_INVALID_USERNAME_PWD = "Invalid username/password";
    private static final String READ_ONLY = "Read Only";
    private static final String READ_WRITE = "Read/Write";
    private String appClassName;
    private DB_AccessAPI dbConnection;

    public LoginWindow(DB_AccessAPI dbConnection, String className) {
        this.dbConnection = dbConnection;
        this.setDefaultCloseOperation(3);
        this.init();
        this.showHideUserNamePwd();
        this.appClassName = className;
    }

    public void init() {
        try {
            this.jbInit();
            this.setTitle(TITLE);
            this.addActionListeners();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addActionListeners() {
        this.loginButton.addActionListener(this);
        this.newUserButton.addActionListener(this);
        this.forgetPassButton.addActionListener(this);
        this.changePassButton.addActionListener(this);
        this.loginTypeComboBox.addActionListener(this);
    }

    private void jbInit() throws Exception {
        this.usernameText.setForeground(new Color(80, 80, 133));
        this.usernameText.setBackground(Color.white);
        this.passwordText.setBackground(Color.white);
        this.loginTypeComboBox.setForeground(new Color(80, 80, 133));
        this.loginTypeComboBox.addItem(READ_ONLY);
        this.loginTypeComboBox.addItem(READ_WRITE);
        this.getContentPane().setLayout(this.borderLayout1);
        this.newUserButton.setFont(new Font("Dialog", 1, 12));
        this.newUserButton.setForeground(new Color(80, 80, 133));
        this.newUserButton.setText("New User");
        this.forgetPassButton.setFont(new Font("Dialog", 1, 12));
        this.forgetPassButton.setForeground(new Color(80, 80, 133));
        this.forgetPassButton.setToolTipText("Forgot Password");
        this.forgetPassButton.setText("Forgot Passwd");
        this.changePassButton.setText("Change Passwd");
        this.changePassButton.setToolTipText("Change Password");
        this.changePassButton.setActionCommand("Forgot Passwd");
        this.changePassButton.setForeground(new Color(80, 80, 133));
        this.changePassButton.setFont(new Font("Dialog", 1, 12));
        this.getContentPane().add((Component)this.passwordPanel, "Center");
        this.passwordPanel.setLayout(this.gridBagLayout1);
        this.loginButton.setFont(new Font("Dialog", 1, 12));
        this.loginButton.setForeground(new Color(80, 80, 133));
        this.loginButton.setText(TITLE);
        this.passwordText.setBackground(Color.white);
        this.passwordText.setFont(new Font("Dialog", 1, 12));
        this.passwordText.setForeground(new Color(80, 80, 133));
        this.headerLabel.setFont(new Font("Dialog", 1, 16));
        this.headerLabel.setForeground(new Color(80, 80, 133));
        this.headerLabel.setHorizontalAlignment(0);
        this.headerLabel.setHorizontalTextPosition(0);
        this.headerLabel.setText("Authorizing User");
        this.passwordLabel.setFont(new Font("Dialog", 1, 12));
        this.passwordLabel.setForeground(new Color(80, 80, 133));
        this.passwordLabel.setText("Enter Password:");
        this.userNameLabel.setFont(new Font("Dialog", 1, 12));
        this.userNameLabel.setForeground(new Color(80, 80, 133));
        this.userNameLabel.setText("Enter Username:");
        this.loginTypeLabel.setFont(new Font("Dialog", 1, 12));
        this.loginTypeLabel.setForeground(new Color(80, 80, 133));
        this.loginTypeLabel.setText("Login Type:");
        this.passwordPanel.add((Component)this.headerLabel, new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0, 17, 0, new Insets(6, 2, 0, 4), 271, 13));
        this.passwordPanel.add((Component)this.passwordText, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 17, 2, new Insets(9, 7, 7, 23), 134, 3));
        this.passwordPanel.add((Component)this.passwordLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 9, 0, 0), 20, 13));
        this.passwordPanel.add((Component)this.userNameLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(21, 9, 0, 0), 20, 13));
        this.passwordPanel.add((Component)this.usernameText, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(21, 7, 6, 23), 132, 2));
        this.passwordPanel.add((Component)this.loginTypeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(21, 9, 0, 0), 20, 13));
        this.passwordPanel.add((Component)this.loginTypeComboBox, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(21, 7, 6, 23), 132, 2));
        this.passwordPanel.add((Component)this.headerLabel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(13, 41, 0, 36), 86, 0));
        this.passwordPanel.add((Component)this.forgetPassButton, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 0, new Insets(7, 9, 0, 0), 5, 0));
        this.passwordPanel.add((Component)this.loginButton, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 58, 0, 23), 5, 0));
        this.passwordPanel.add((Component)this.changePassButton, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 0, new Insets(8, 9, 26, 0), 6, 0));
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.loginButton) {
            if (this.loginTypeComboBox.getSelectedItem().equals(READ_WRITE)) {
                SessionInfo.setPassword(new String(this.passwordText.getPassword()).trim());
                SessionInfo.setUserName(this.usernameText.getText());
                try {
                    SessionInfo.setContributorInfo();
                    if (SessionInfo.getContributor() == null) {
                        JOptionPane.showMessageDialog(this, MSG_INVALID_USERNAME_PWD);
                        return;
                    }
                }
                catch (DBConnectException connectException) {
                    JOptionPane.showMessageDialog(this, MSG_INVALID_USERNAME_PWD);
                    return;
                }
            }
            ClassUtils.createNoArgConstructorClassInstance(this.appClassName);
            this.dispose();
        } else if (source == this.newUserButton) {
            new RequestUserAccount();
        } else if (source == this.forgetPassButton) {
            new GetAccountInfo(this.dbConnection);
        } else if (source == this.changePassButton) {
            new ChangePassword(this.dbConnection);
        } else if (source == this.loginTypeComboBox) {
            this.showHideUserNamePwd();
        }
    }

    private void showHideUserNamePwd() {
        String selected = (String)this.loginTypeComboBox.getSelectedItem();
        if (selected.equalsIgnoreCase(READ_ONLY)) {
            this.userNameLabel.setVisible(false);
            this.usernameText.setVisible(false);
            this.passwordLabel.setVisible(false);
            this.passwordText.setVisible(false);
            this.newUserButton.setVisible(false);
            this.forgetPassButton.setVisible(false);
            this.changePassButton.setVisible(false);
        } else {
            this.userNameLabel.setVisible(true);
            this.usernameText.setVisible(true);
            this.passwordLabel.setVisible(true);
            this.passwordText.setVisible(true);
            this.newUserButton.setVisible(true);
            this.forgetPassButton.setVisible(true);
            this.changePassButton.setVisible(true);
        }
    }

    static {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

