/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.addEdit.connections;

import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.refFaultParamDb.vo.FaultSectionData;
import org.opensha.sha.faultSurface.FaultTrace;

public class PotentialConnectionPoint
implements Comparable<PotentialConnectionPoint> {
    private FaultSectionData fs1;
    private FaultSectionData fs2;
    private double[][] distances = new double[2][2];

    public PotentialConnectionPoint(FaultSectionData fs1, FaultSectionData fs2) {
        this.fs1 = fs1;
        this.fs2 = fs2;
    }

    private PotentialConnectionPoint(FaultSectionData fs1, FaultSectionData fs2, double[][] distances) {
        this.fs1 = fs1;
        this.fs2 = fs2;
        this.distances = distances;
    }

    public void compute() {
        FaultTrace trace1 = this.fs1.getFaultTrace();
        Location first1 = (Location)trace1.get(0);
        Location last1 = (Location)trace1.get(trace1.size() - 1);
        FaultTrace trace2 = this.fs2.getFaultTrace();
        Location first2 = (Location)trace2.get(0);
        Location last2 = (Location)trace2.get(trace2.size() - 1);
        this.distances[0][0] = LocationUtils.horzDistanceFast(first1, first2);
        this.distances[1][0] = LocationUtils.horzDistanceFast(last1, first2);
        this.distances[0][1] = LocationUtils.horzDistanceFast(first1, last2);
        this.distances[1][1] = LocationUtils.horzDistanceFast(last1, last2);
    }

    public double getMinDist() {
        double min = Double.MAX_VALUE;
        double[][] dArray = this.distances;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] dist1;
            for (double dist : dist1 = dArray[i]) {
                if (!(dist < min)) continue;
                min = dist;
            }
        }
        return min;
    }

    public double getDistance(int i, int j) {
        return this.distances[i][j];
    }

    public PotentialConnectionPoint getReversal() {
        double[][] rev = new double[2][2];
        rev[0][0] = this.distances[0][0];
        rev[0][1] = this.distances[1][0];
        rev[1][0] = this.distances[0][1];
        rev[1][1] = this.distances[1][1];
        return new PotentialConnectionPoint(this.fs2, this.fs1, rev);
    }

    public FaultSectionData getFSD1() {
        return this.fs1;
    }

    public FaultSectionData getFSD2() {
        return this.fs2;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fs1 == null ? 0 : this.fs1.hashCode());
        result = 31 * result + (this.fs2 == null ? 0 : this.fs2.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PotentialConnectionPoint other = (PotentialConnectionPoint)obj;
        if (this.fs1 == null ? other.fs1 != null : !this.fs1.equals(other.fs1)) {
            return false;
        }
        return !(this.fs2 == null ? other.fs2 != null : !this.fs2.equals(other.fs2));
    }

    @Override
    public int compareTo(PotentialConnectionPoint o) {
        double myMin = this.getMinDist();
        double otherMin = o.getMinDist();
        return Double.compare(myMin, otherMin);
    }
}

