/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.addEdit.deformationModel;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.editor.impl.ConstrainedStringParameterEditor;
import org.opensha.commons.param.editor.impl.StringParameterEditor;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.DeformationModelSummaryDB_DAO;
import org.opensha.refFaultParamDb.dao.db.FaultModelSummaryDB_DAO;
import org.opensha.refFaultParamDb.gui.addEdit.deformationModel.EditDeformationModel;
import org.opensha.refFaultParamDb.vo.DeformationModelSummary;
import org.opensha.refFaultParamDb.vo.FaultModelSummary;

public class AddDeformationModel
extends JFrame
implements ActionListener {
    private static final String DEFORMATION_MODEL_PARAM_NAME = "Deformation Model";
    private StringParameter deformationModelParam;
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private static final String MSG_NO_FAULT_MODELS_AVAILABLE = "No fault models exist. Fault model should be created before creating deformation model";
    private static final String MSG_DEF_MODEL_NAME_MISSING = "Deformation model name is missing";
    private static final String MSG_DEF_MODEL_ADD_SUCCESS = "Deformation Model added successfully to the database";
    private ArrayList faultModelsList;
    private FaultModelSummaryDB_DAO faultModelDB_DAO;
    private DeformationModelSummaryDB_DAO defModelSummaryDB_DAO;
    private StringParameter faultModelsParam;
    private static final String AVAILABLE_FAULT_MODEL_PARAM_NAME = "Choose Fault Model";
    private EditDeformationModel editDeformationModel;

    public AddDeformationModel(DB_AccessAPI dbConnection, EditDeformationModel editDeformationModel) {
        this.faultModelDB_DAO = new FaultModelSummaryDB_DAO(dbConnection);
        this.defModelSummaryDB_DAO = new DeformationModelSummaryDB_DAO(dbConnection);
        this.editDeformationModel = editDeformationModel;
        this.getContentPane().setLayout(new GridBagLayout());
        this.makeDeformationModelNameParam();
        try {
            this.loadAllFaultModels();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage());
            this.dispose();
            return;
        }
        this.addButtons();
        this.pack();
        this.show();
    }

    private void addButtons() {
        this.getContentPane().add((Component)this.okButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.cancelButton, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.okButton) {
            String defModelName = (String)this.deformationModelParam.getValue();
            if (defModelName.equalsIgnoreCase("")) {
                JOptionPane.showMessageDialog(this, MSG_DEF_MODEL_NAME_MISSING);
                return;
            }
            try {
                this.defModelSummaryDB_DAO.addDeformationModel(this.getDeformationModelSummary(defModelName));
                JOptionPane.showMessageDialog(this, MSG_DEF_MODEL_ADD_SUCCESS);
                this.editDeformationModel.newDeformationModelAdded();
                this.dispose();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getMessage());
            }
        } else if (source == this.cancelButton) {
            this.dispose();
        }
    }

    private DeformationModelSummary getDeformationModelSummary(String deformationModelName) {
        DeformationModelSummary deformationModelSummary = new DeformationModelSummary();
        deformationModelSummary.setDeformationModelName(deformationModelName);
        deformationModelSummary.setFaultModel(this.getFaultModel((String)this.faultModelsParam.getValue()));
        return deformationModelSummary;
    }

    private FaultModelSummary getFaultModel(String selectedFaultModel) {
        for (int i = 0; i < this.faultModelsList.size(); ++i) {
            FaultModelSummary faultModel = (FaultModelSummary)this.faultModelsList.get(i);
            if (!faultModel.getFaultModelName().equalsIgnoreCase(selectedFaultModel)) continue;
            return faultModel;
        }
        return null;
    }

    private void makeDeformationModelNameParam() {
        try {
            this.deformationModelParam = new StringParameter(DEFORMATION_MODEL_PARAM_NAME, "");
            StringParameterEditor deformationModelParamEditor = new StringParameterEditor((Parameter)this.deformationModelParam);
            this.getContentPane().add((Component)deformationModelParamEditor, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadAllFaultModels() {
        this.faultModelsList = this.faultModelDB_DAO.getAllFaultModels();
        ArrayList<String> faultModelNames = new ArrayList<String>();
        for (int i = 0; i < this.faultModelsList.size(); ++i) {
            faultModelNames.add(((FaultModelSummary)this.faultModelsList.get(i)).getFaultModelName());
        }
        if (faultModelNames == null || faultModelNames.size() == 0) {
            throw new RuntimeException(MSG_NO_FAULT_MODELS_AVAILABLE);
        }
        this.faultModelsParam = new StringParameter(AVAILABLE_FAULT_MODEL_PARAM_NAME, faultModelNames, (String)faultModelNames.get(0));
        ConstrainedStringParameterEditor faultModelsParamEditor = new ConstrainedStringParameterEditor(this.faultModelsParam);
        this.getContentPane().add((Component)faultModelsParamEditor, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }
}

