/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.addEdit.paleoSite;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import org.opensha.commons.data.estimate.Estimate;
import org.opensha.commons.gui.LabeledBoxPanel;
import org.opensha.commons.param.constraint.impl.EstimateConstraint;
import org.opensha.commons.param.editor.impl.ConstrainedEstimateParameterEditor;
import org.opensha.commons.param.editor.impl.ConstrainedStringParameterEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.EstimateParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.refFaultParamDb.gui.addEdit.paleoSite.MeasuredCompPanel;
import org.opensha.refFaultParamDb.gui.addEdit.paleoSite.SenseOfMotionPanel;
import org.opensha.refFaultParamDb.gui.infotools.GUI_Utils;
import org.opensha.refFaultParamDb.gui.params.CommentsParameterEditor;
import org.opensha.refFaultParamDb.vo.CombinedDisplacementInfo;
import org.opensha.refFaultParamDb.vo.EstimateInstances;

public class AddEditCumDisplacement
extends LabeledBoxPanel
implements ParameterChangeListener {
    private static final String ASEISMIC_AVAILABLE_PARAM_NAME = "Asiesmic Slip Factor";
    private static final String KNOWN = "Known";
    private static final String UNKNOWN = "Unknown";
    private static final String ASEISMIC_SLIP_FACTOR_PARAM_NAME = "Aseismic Slip Factor Estimate(0-1, 1=all aseismic)";
    private static final String ASEISMIC_SLIP_FACTOR_ = "Aseismic Slip Factor";
    private static final double ASEISMIC_SLIP_FACTOR_MIN = 0.0;
    private static final double ASEISMIC_SLIP_FACTOR_MAX = 1.0;
    public static final String ASEISMIC_SLIP_FACTOR_UNITS = " ";
    private static final String CUMULATIVE_DISPLACEMENT_PARAM_NAME = "Cumulative Displacement Estimate";
    private static final String CUMULATIVE_DISPLACEMENT = "Cumulative Disp";
    private static final String CUMULATIVE_DISPLACEMENT_COMMENTS_PARAM_NAME = "Cumulative Displacement Comments";
    public static final String CUMULATIVE_DISPLACEMENT_UNITS = "m";
    private static final double CUMULATIVE_DISPLACEMENT_MIN = 0.0;
    private static final double CUMULATIVE_DISPLACEMENT_MAX = Double.POSITIVE_INFINITY;
    private EstimateParameter aSeismicSlipFactorParam;
    private EstimateParameter cumDisplacementParam;
    private StringParameter displacementCommentsParam;
    private StringParameter aseismicAvailableParam;
    private ConstrainedEstimateParameterEditor aSeismicSlipFactorParamEditor;
    private ConstrainedEstimateParameterEditor cumDisplacementParamEditor;
    private ConstrainedStringParameterEditor aseismicAvailableParamEditor;
    private CommentsParameterEditor displacementCommentsParamEditor;
    private SenseOfMotionPanel senseOfMotionPanel;
    private MeasuredCompPanel measuredCompPanel;
    private static final String CUM_DISPLACEMENT_PARAMS_TITLE = "Cumulative Displacement Params";

    public AddEditCumDisplacement() {
        try {
            this.senseOfMotionPanel = new SenseOfMotionPanel();
            this.measuredCompPanel = new MeasuredCompPanel();
            this.setLayout(GUI_Utils.gridBagLayout);
            this.addCumulativeDisplacementParameters();
            this.setAseismicEditorVisibility();
            this.setMinimumSize(new Dimension(0, 0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AddEditCumDisplacement(CombinedDisplacementInfo combinedDisplacementInfo) {
        this();
        if (combinedDisplacementInfo != null) {
            this.setValuesInParameters(combinedDisplacementInfo);
        }
    }

    private void setValuesInParameters(CombinedDisplacementInfo combinedDisplacementInfo) {
        this.cumDisplacementParam.setValue(combinedDisplacementInfo.getDisplacementEstimate().getEstimate());
        this.cumDisplacementParamEditor.refreshParamEditor();
        EstimateInstances aseismicSlipFactor = combinedDisplacementInfo.getASeismicSlipFactorEstimateForDisp();
        if (aseismicSlipFactor == null) {
            this.aseismicAvailableParam.setValue(UNKNOWN);
        } else {
            this.aseismicAvailableParam.setValue(KNOWN);
            this.aSeismicSlipFactorParam.setValue(aseismicSlipFactor.getEstimate());
            this.aSeismicSlipFactorParamEditor.refreshParamEditor();
        }
        this.aseismicAvailableParamEditor.refreshParamEditor();
        this.displacementCommentsParam.setValue(combinedDisplacementInfo.getDisplacementComments());
        this.displacementCommentsParamEditor.refreshParamEditor();
        this.measuredCompPanel.setMeasuredCompVal(combinedDisplacementInfo.getMeasuredComponentQual());
        EstimateInstances somQuan = combinedDisplacementInfo.getSenseOfMotionRake();
        Estimate rake = null;
        if (somQuan != null) {
            rake = somQuan.getEstimate();
        }
        this.senseOfMotionPanel.setSenseOfMotion(combinedDisplacementInfo.getSenseOfMotionQual(), rake);
    }

    private void addCumulativeDisplacementParameters() throws Exception {
        ArrayList allowedEstimates = EstimateConstraint.createConstraintForPositiveDoubleValues();
        this.cumDisplacementParam = new EstimateParameter(CUMULATIVE_DISPLACEMENT_PARAM_NAME, CUMULATIVE_DISPLACEMENT_UNITS, 0.0, Double.POSITIVE_INFINITY, allowedEstimates);
        this.cumDisplacementParamEditor = new ConstrainedEstimateParameterEditor(this.cumDisplacementParam, true);
        ArrayList<String> allowedVals = new ArrayList<String>();
        allowedVals.add(KNOWN);
        allowedVals.add(UNKNOWN);
        this.aseismicAvailableParam = new StringParameter(ASEISMIC_AVAILABLE_PARAM_NAME, allowedVals, (String)allowedVals.get(0));
        this.aseismicAvailableParam.addParameterChangeListener(this);
        this.aseismicAvailableParamEditor = new ConstrainedStringParameterEditor(this.aseismicAvailableParam);
        this.aSeismicSlipFactorParam = new EstimateParameter(ASEISMIC_SLIP_FACTOR_PARAM_NAME, ASEISMIC_SLIP_FACTOR_UNITS, 0.0, 1.0, allowedEstimates);
        this.aSeismicSlipFactorParamEditor = new ConstrainedEstimateParameterEditor(this.aSeismicSlipFactorParam, true);
        this.displacementCommentsParam = new StringParameter(CUMULATIVE_DISPLACEMENT_COMMENTS_PARAM_NAME);
        this.displacementCommentsParamEditor = new CommentsParameterEditor(this.displacementCommentsParam);
        int yPos = 0;
        this.add((Component)this.measuredCompPanel, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.cumDisplacementParamEditor, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.aseismicAvailableParamEditor, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.aSeismicSlipFactorParamEditor, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.senseOfMotionPanel, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.displacementCommentsParamEditor, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setTitle(CUM_DISPLACEMENT_PARAMS_TITLE);
    }

    public CombinedDisplacementInfo getCombinedDisplacementInfo() {
        CombinedDisplacementInfo combinedDisplacementInfo = new CombinedDisplacementInfo();
        combinedDisplacementInfo.setDisplacementComments(this.getDisplacementComments());
        combinedDisplacementInfo.setASeismicSlipFactorEstimateForDisp(this.getAseismicEstimate());
        combinedDisplacementInfo.setDisplacementEstimate(this.getDisplacementEstimate());
        combinedDisplacementInfo.setMeasuredComponentQual(this.measuredCompPanel.getMeasuredComp());
        combinedDisplacementInfo.setSenseOfMotionRake(this.senseOfMotionPanel.getSenseOfMotionRake());
        combinedDisplacementInfo.setSenseOfMotionQual(this.senseOfMotionPanel.getSenseOfMotionQual());
        return combinedDisplacementInfo;
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        if (event.getParameterName().equalsIgnoreCase(ASEISMIC_AVAILABLE_PARAM_NAME)) {
            this.setAseismicEditorVisibility();
        }
    }

    private void setAseismicEditorVisibility() {
        String aseismicSlipFactorAvailability = (String)this.aseismicAvailableParam.getValue();
        if (aseismicSlipFactorAvailability.equalsIgnoreCase(KNOWN)) {
            this.aSeismicSlipFactorParamEditor.setVisible(true);
        } else {
            this.aSeismicSlipFactorParamEditor.setVisible(false);
        }
    }

    private EstimateInstances getDisplacementEstimate() {
        this.cumDisplacementParamEditor.setEstimateInParameter();
        return new EstimateInstances((Estimate)this.cumDisplacementParam.getValue(), CUMULATIVE_DISPLACEMENT_UNITS);
    }

    private EstimateInstances getAseismicEstimate() {
        String aseismicSlipFactorAvailability = (String)this.aseismicAvailableParam.getValue();
        if (aseismicSlipFactorAvailability.equalsIgnoreCase(UNKNOWN)) {
            return null;
        }
        this.aSeismicSlipFactorParamEditor.setEstimateInParameter();
        return new EstimateInstances((Estimate)this.aSeismicSlipFactorParam.getValue(), ASEISMIC_SLIP_FACTOR_UNITS);
    }

    private String getDisplacementComments() {
        return (String)this.displacementCommentsParam.getValue();
    }
}

