/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.addEdit.paleoSite;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import org.opensha.refFaultParamDb.dao.db.CombinedEventsInfoDB_DAO;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.data.TimeAPI;
import org.opensha.refFaultParamDb.gui.addEdit.paleoSite.AddEditCumDisplacement;
import org.opensha.refFaultParamDb.gui.addEdit.paleoSite.AddEditNumEvents;
import org.opensha.refFaultParamDb.gui.addEdit.paleoSite.AddEditSequence;
import org.opensha.refFaultParamDb.gui.addEdit.paleoSite.AddEditSlipRate;
import org.opensha.refFaultParamDb.gui.addEdit.paleoSite.AddEditTimeSpan;
import org.opensha.refFaultParamDb.gui.addEdit.paleoSite.ChooseReference;
import org.opensha.refFaultParamDb.gui.event.DbAdditionFrame;
import org.opensha.refFaultParamDb.gui.infotools.ConnectToEmailServlet;
import org.opensha.refFaultParamDb.gui.infotools.SessionInfo;
import org.opensha.refFaultParamDb.vo.CombinedDisplacementInfo;
import org.opensha.refFaultParamDb.vo.CombinedEventsInfo;
import org.opensha.refFaultParamDb.vo.CombinedNumEventsInfo;
import org.opensha.refFaultParamDb.vo.CombinedSlipRateInfo;
import org.opensha.refFaultParamDb.vo.PaleoSitePublication;
import org.opensha.refFaultParamDb.vo.Reference;

public class AddSiteInfo
extends DbAdditionFrame
implements ActionListener {
    private JSplitPane mainSplitPane;
    private JButton okButton;
    private JButton cancelButton;
    private GridBagLayout gridBagLayout1;
    private boolean isSlipVisible;
    private boolean isDisplacementVisible;
    private boolean isNumEventsVisible;
    private boolean isSequenceVisible;
    private ArrayList referenceList;
    private AddEditNumEvents addEditNumEvents;
    private AddEditSlipRate addEditSlipRate;
    private AddEditCumDisplacement addEditCumDisp;
    private AddEditSequence addEditSequence;
    private AddEditTimeSpan addEditTimeSpan;
    private JTabbedPane tabbedPane;
    private static final String NUM_EVENTS_TITLE = "Num Events Est";
    private static final String SLIP_RATE_TITLE = "Slip Rate Est";
    private static final String DISPLACEMENT_TITLE = "Displacement Est";
    private static final String SEQUENCE_TITLE = "Sequence";
    private static final String ATLEAT_ONE_MSG = "Atleast one of Slip, Cumulative Displacement, Num events or Sequence should be specified";
    private static final int W = 900;
    private static final int H = 650;
    private static final String TITLE = "Add Data for Slip Rate, Displacement, or Number of Events";
    private static final String MSG_DB_OPERATION_SUCCESS = "Site Info successfully inserted into the database";
    private static final String MSG_NO_REFERENCE_CHOSEN = "Cannot add info to database as reference has not been chosen";
    private int siteId;
    private String siteEntryDate;
    private String siteRepresentativeIndex;
    private ArrayList siteTypes;
    private CombinedEventsInfoDB_DAO combinedEventsInfoDAO;

    public AddSiteInfo(DB_AccessAPI dbConnection, int siteId, String siteEntryDate, boolean isSlipVisible, boolean isDisplacementVisible, boolean isNumEventsVisible, boolean isSequenceVisible) {
        this(dbConnection, siteId, siteEntryDate, isSlipVisible, isDisplacementVisible, isNumEventsVisible, isSequenceVisible, null);
    }

    public AddSiteInfo(DB_AccessAPI dbConnection, int siteId, String siteEntryDate, boolean isSlipVisible, boolean isDisplacementVisible, boolean isNumEventsVisible, boolean isSequenceVisible, CombinedEventsInfo combinedInfo) {
        block11: {
            this.mainSplitPane = new JSplitPane();
            this.okButton = new JButton("Submit");
            this.cancelButton = new JButton("Cancel");
            this.gridBagLayout1 = new GridBagLayout();
            this.tabbedPane = new JTabbedPane();
            this.combinedEventsInfoDAO = new CombinedEventsInfoDB_DAO(dbConnection);
            this.siteId = siteId;
            if (!(isSlipVisible || isDisplacementVisible || isNumEventsVisible || isSequenceVisible)) {
                throw new RuntimeException(ATLEAT_ONE_MSG);
            }
            this.isSlipVisible = isSlipVisible;
            this.isDisplacementVisible = isDisplacementVisible;
            this.isNumEventsVisible = isNumEventsVisible;
            this.isSequenceVisible = isSequenceVisible;
            this.siteEntryDate = siteEntryDate;
            try {
                if (this.isSequenceVisible) {
                    this.addEditSequence = new AddEditSequence(dbConnection, siteId, siteEntryDate);
                }
            }
            catch (RuntimeException e) {
                JOptionPane.showMessageDialog(this, e.getMessage());
                this.isSequenceVisible = false;
                if (isSlipVisible || isDisplacementVisible || isNumEventsVisible) break block11;
                this.dispose();
                return;
            }
        }
        if (isSlipVisible) {
            CombinedSlipRateInfo combinedSlipRateInfo = null;
            if (combinedInfo != null) {
                combinedSlipRateInfo = combinedInfo.getCombinedSlipRateInfo();
            }
            this.addEditSlipRate = new AddEditSlipRate(combinedSlipRateInfo);
        }
        if (isDisplacementVisible) {
            CombinedDisplacementInfo combinedDispInfo = null;
            if (combinedInfo != null) {
                combinedDispInfo = combinedInfo.getCombinedDisplacementInfo();
            }
            this.addEditCumDisp = new AddEditCumDisplacement(combinedDispInfo);
        }
        if (isNumEventsVisible) {
            CombinedNumEventsInfo combinedEventsInfo = null;
            if (combinedInfo != null) {
                combinedEventsInfo = combinedInfo.getCombinedNumEventsInfo();
            }
            this.addEditNumEvents = new AddEditNumEvents(combinedEventsInfo);
        }
        this.addEditTimeSpan = combinedInfo != null ? new AddEditTimeSpan(combinedInfo.getStartTime(), combinedInfo.getEndTime(), combinedInfo.getDatedFeatureComments()) : new AddEditTimeSpan();
        this.jbInit();
        this.addActionListeners();
        this.setSize(900, 650);
        this.setTitle(TITLE);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        ChooseReference referencesDialog = new ChooseReference(dbConnection, this);
        referencesDialog.setFocusableWindowState(true);
        referencesDialog.setVisible(true);
        if (combinedInfo != null) {
            PaleoSitePublication paleoSitePub = combinedInfo.getPaleoSitePublication();
            referencesDialog.setParameters(paleoSitePub.getSiteTypeNames().get(0), paleoSitePub.getRepresentativeStrandName(), paleoSitePub.getReference());
            this.setSiteType(paleoSitePub.getSiteTypeNames().get(0));
            this.setSiteRepresentativeStrandIndex(paleoSitePub.getRepresentativeStrandName());
            this.setReference(paleoSitePub.getReference());
        }
    }

    public void setSiteType(String siteType) {
        this.siteTypes = new ArrayList();
        this.siteTypes.add(siteType);
    }

    public void setSiteRepresentativeStrandIndex(String representativeStrandIndex) {
        this.siteRepresentativeIndex = representativeStrandIndex;
    }

    public void setReference(Reference reference) {
        this.referenceList = new ArrayList();
        this.referenceList.add(reference);
        try {
            int pubYear = Integer.parseInt(reference.getRefYear());
            this.addEditTimeSpan.setNowYearVal(pubYear);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void addActionListeners() {
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.cancelButton) {
            this.dispose();
        } else if (source == this.okButton) {
            try {
                if ((this.isSlipVisible || this.isDisplacementVisible || this.isNumEventsVisible || this.isSequenceVisible) && (this.referenceList == null || this.referenceList.size() == 0)) {
                    throw new RuntimeException(MSG_NO_REFERENCE_CHOSEN);
                }
                this.putSiteInfoInDatabase();
                JOptionPane.showMessageDialog(this, MSG_DB_OPERATION_SUCCESS);
                ConnectToEmailServlet.sendEmail("New Site Info added successfully for site Id=" + this.siteId + " by " + SessionInfo.getUserName());
                this.dispose();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getMessage());
            }
        }
    }

    private void putSiteInfoInDatabase() {
        CombinedEventsInfo combinedEventsInfo = new CombinedEventsInfo();
        combinedEventsInfo.setIsExpertOpinion(false);
        try {
            TimeAPI startTime = this.addEditTimeSpan.getStartTime();
            startTime.setReferencesList(this.referenceList);
            combinedEventsInfo.setStartTime(startTime);
        }
        catch (Exception e) {
            throw new RuntimeException("Check Start Time\n" + e.getMessage());
        }
        try {
            TimeAPI endTime = this.addEditTimeSpan.getEndTime();
            endTime.setReferencesList(this.referenceList);
            combinedEventsInfo.setEndTime(endTime);
        }
        catch (Exception e) {
            throw new RuntimeException("Check End Time\n" + e.getMessage());
        }
        combinedEventsInfo.setReferenceList(this.referenceList);
        combinedEventsInfo.setDatedFeatureComments(this.addEditTimeSpan.getTimeSpanComments());
        combinedEventsInfo.setSiteEntryDate(this.siteEntryDate);
        combinedEventsInfo.setSiteId(this.siteId);
        PaleoSitePublication paleoSitePub = new PaleoSitePublication();
        paleoSitePub.setReference((Reference)this.referenceList.get(0));
        paleoSitePub.setRepresentativeStrandName(this.siteRepresentativeIndex);
        paleoSitePub.setSiteTypeNames(this.siteTypes);
        paleoSitePub.setSiteId(this.siteId);
        paleoSitePub.setSiteEntryDate(this.siteEntryDate);
        combinedEventsInfo.setPaleoSitePublication(paleoSitePub);
        try {
            if (this.isSlipVisible) {
                CombinedSlipRateInfo combinedSlipRateInfo = this.addEditSlipRate.getCombinedSlipRateInfo();
                combinedEventsInfo.setCombinedSlipRateInfo(combinedSlipRateInfo);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Check  " + SLIP_RATE_TITLE + "\n" + e.getMessage());
        }
        try {
            if (this.isDisplacementVisible) {
                CombinedDisplacementInfo combinedDisplacementInfo = this.addEditCumDisp.getCombinedDisplacementInfo();
                combinedEventsInfo.setCombinedDisplacementInfo(combinedDisplacementInfo);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Check " + DISPLACEMENT_TITLE + "\n" + e.getMessage());
        }
        try {
            if (this.isNumEventsVisible) {
                CombinedNumEventsInfo combinedNumEventsInfo = this.addEditNumEvents.getCombinedNumEventsInfo();
                combinedEventsInfo.setCombinedNumEventsInfo(combinedNumEventsInfo);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Check " + NUM_EVENTS_TITLE + "\n" + e.getMessage());
        }
        try {
            if (this.isSequenceVisible) {
                combinedEventsInfo.setEventSequenceList(this.addEditSequence.getAllSequences());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Check " + SEQUENCE_TITLE + "\n" + e.getMessage());
        }
        ConnectToEmailServlet.sendEmail(SessionInfo.getUserName() + " trying to add new combined events info to database\n" + combinedEventsInfo.toString());
        this.combinedEventsInfoDAO.addCombinedEventsInfo(combinedEventsInfo);
        this.sendEventToListeners(combinedEventsInfo);
    }

    private void jbInit() {
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.mainSplitPane.setOrientation(1);
        this.getContentPane().add((Component)this.mainSplitPane, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(1, 3, 0, 0), 237, 411));
        this.getContentPane().add((Component)this.okButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 155, 11, 0), 39, -1));
        this.getContentPane().add((Component)this.cancelButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 22, 11, 175), 8, 0));
        String constraints = "";
        this.mainSplitPane.add((Component)this.addEditTimeSpan, "left");
        this.mainSplitPane.add((Component)this.tabbedPane, "right");
        if (this.isSlipVisible) {
            this.tabbedPane.add(SLIP_RATE_TITLE, this.addEditSlipRate);
        }
        if (this.isDisplacementVisible) {
            this.tabbedPane.add(DISPLACEMENT_TITLE, this.addEditCumDisp);
        }
        if (this.isNumEventsVisible) {
            this.tabbedPane.add(NUM_EVENTS_TITLE, this.addEditNumEvents);
        }
        if (this.isSequenceVisible) {
            this.tabbedPane.add(SEQUENCE_TITLE, this.addEditSequence);
        }
        this.mainSplitPane.setDividerLocation(600);
    }
}

