/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.view;

import org.opensha.commons.data.CSVFile;
import org.opensha.commons.geo.Location;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.gui.view.AbstractSectionInfoFileWriter;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;

public class SectionInfoCSVFileWriter
extends AbstractSectionInfoFileWriter {
    private static String[] colNames = new String[]{"Fault Section ID", "Fault Name", "Longitude", "Latitude", "Depth"};
    private SaveType saveType;
    private static boolean aseisReducesArea = true;

    public SectionInfoCSVFileWriter(DB_AccessAPI dbConnection, SaveType saveType) {
        super(dbConnection);
        this.saveType = saveType;
    }

    @Override
    public String getFaultAsString(FaultSectionPrefData prefData) {
        Object line = "";
        String id = "" + prefData.getSectionId();
        String name = prefData.getSectionName();
        if (this.saveType == SaveType.CSV_TRACE_DESC) {
            for (Location loc : prefData.getFaultTrace()) {
                line = (String)line + SectionInfoCSVFileWriter.getLine(loc, id, name) + "\n";
            }
        } else {
            StirlingGriddedSurface surf = new StirlingGriddedSurface(prefData.getSimpleFaultData(aseisReducesArea), 1.0);
            for (int row = 0; row < surf.getNumRows(); ++row) {
                if (this.saveType == SaveType.CSV_TOP_BOTTOM_POINTS && row != 0 && row != surf.getNumRows() - 1) continue;
                for (int col = 0; col < surf.getNumCols(); ++col) {
                    Location loc = surf.getLocation(row, col);
                    line = (String)line + SectionInfoCSVFileWriter.getLine(loc, id, name) + "\n";
                }
            }
        }
        return line;
    }

    private static String getLine(Location loc, String id, String name) {
        String lat = "" + loc.getLatitude();
        String lon = "" + loc.getLongitude();
        String depth = "" + loc.getDepth();
        Object[] vals = new String[]{id, name, lon, lat, depth};
        return CSVFile.getLineStr(vals);
    }

    @Override
    public String getFileHeader() {
        return CSVFile.getLineStr(colNames);
    }

    public static enum SaveType {
        CSV_ALL_POINTS("CSV File - All Fault Surface Points"),
        CSV_TOP_BOTTOM_POINTS("CSV File - Top/Bottom Fault Surface Points"),
        CSV_TRACE_DESC("CSV File - Fault Trace Only");

        private String desc;

        private SaveType(String desc) {
            this.desc = desc;
        }

        public String getDescription() {
            return this.desc;
        }

        public static SaveType forDesc(String desc) {
            for (SaveType type : SaveType.values()) {
                if (!type.getDescription().equals(desc)) continue;
                return type;
            }
            throw new IllegalStateException("Unknown save type: " + desc);
        }
    }
}

