/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.opensha.commons.data.estimate.Estimate;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.editor.impl.ConstrainedStringParameterEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.commons.util.ClassUtils;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.FaultSectionVer2_DB_DAO;
import org.opensha.refFaultParamDb.dao.db.PrefFaultSectionDataDB_DAO;
import org.opensha.refFaultParamDb.gui.addEdit.faultSection.EditFaultSection;
import org.opensha.refFaultParamDb.gui.infotools.GUI_Utils;
import org.opensha.refFaultParamDb.gui.infotools.InfoLabel;
import org.opensha.refFaultParamDb.gui.infotools.SessionInfo;
import org.opensha.refFaultParamDb.gui.view.SectionInfoTextFileWriter;
import org.opensha.refFaultParamDb.vo.FaultSectionData;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.refFaultParamDb.vo.FaultSectionSummary;
import org.opensha.sha.faultSurface.FaultTrace;

public class ViewFaultSection
extends JPanel
implements ParameterChangeListener,
ActionListener {
    private static final String FAULT_SECTION_PARAM_NAME = "Fault Section";
    private StringParameter faultSectionParam;
    private static final String SHORT_NAME = "Short Name";
    private InfoLabel shortNameLabel = new InfoLabel();
    private static final String ENTRY_DATE = "Entry Date";
    private InfoLabel entryDateLabel = new InfoLabel();
    private static final String SOURCE = "Source";
    private InfoLabel sourceLabel = new InfoLabel();
    private static final String AVE_LONG_TERM_SLIP_RATE = "Ave Long Term Slip Rate (mm/yr)";
    private InfoLabel slipRateLabel = new InfoLabel();
    private static final String DIP = "Ave Dip (degrees)";
    private InfoLabel dipLabel = new InfoLabel();
    private static final String DIP_DIRECTION = "Dip Direction";
    private InfoLabel dipDirectionLabel = new InfoLabel();
    private static final String RAKE = "Ave Rake";
    private InfoLabel rakeLabel = new InfoLabel();
    private static final String UPPER_DEPTH = "Upper Seis Depth (km)";
    private InfoLabel upperDepthLabel = new InfoLabel();
    private static final String LOWER_DEPTH = "Lower Seis Depth (km)";
    private InfoLabel lowerDepthLabel = new InfoLabel();
    private static final String ASEISMIC_SLIP = "Aseismic Slip Factor";
    private InfoLabel aseismicSlipLabel = new InfoLabel();
    private static final String FAULT_TRACE = "Fault Section Trace";
    private InfoLabel faultTraceLabel = new InfoLabel();
    private static final String QFAULT_ID = "QFault_Id";
    private InfoLabel qfaultLabel = new InfoLabel();
    private static final String COMMENTS = "COMMENTS";
    private static final String PROB = "Prob";
    private static final String INFO = "Info";
    private InfoLabel commentsLabel = new InfoLabel();
    private static final String DERIVED_VALS = "Derived Values";
    private static final String SECTION_LENGTH = "Fault Trace Length (km)";
    private InfoLabel sectionLengthLabel = new InfoLabel();
    private static final String SECTION_DOWN_DIP_WIDTH = "Down Dip Width (km)";
    private InfoLabel downDipWidthLabel = new InfoLabel();
    private static final String SECTION_AREA = "Area (sq km)";
    private InfoLabel sectionAreaLabel = new InfoLabel();
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private FaultSectionVer2_DB_DAO faultSectionDAO;
    private PrefFaultSectionDataDB_DAO prefFaultSectionDAO;
    private JButton editButton = new JButton("Edit");
    private JButton removeButton = new JButton("Remove");
    private JButton saveButton = new JButton("Save All");
    private JButton saveSubSections = new JButton("Save Subsections");
    private JButton updateFaultPrefDataButton = new JButton("Update Fault Pref. Data");
    private JButton updateAllPrefDataButton = new JButton("Update All Pref. Data");
    private static final String SAVE_BUTTON_TOOL_TIP = "Save All Fault Sections to a txt file";
    private static final String SAVE_SUBSECTIONS_BUTTON_TOOL_TIP = "Save All Sub Sections to a txt file";
    private JButton addButton = new JButton("Add");
    private static final String MSG_REMOVE_CONFIRM = "Do you want to delete this fault Section from the database?\nAll PaleoSites associated with this Fault Section will be removed.";
    private static final String MSG_REMOVE_SUCCESS = "Fault Section removed sucessfully from the database";
    private FaultSectionData selectedFaultSection;
    private ConstrainedStringParameterEditor faultSectionParamEditor;
    private DB_AccessAPI dbConnection;

    public ViewFaultSection(DB_AccessAPI dbConnection) {
        this(dbConnection, null);
    }

    public ViewFaultSection(DB_AccessAPI dbConnection, String selectedFaultSectionNameId) {
        this.dbConnection = dbConnection;
        this.faultSectionDAO = new FaultSectionVer2_DB_DAO(dbConnection);
        this.prefFaultSectionDAO = new PrefFaultSectionDataDB_DAO(dbConnection);
        this.initGUI();
        if (selectedFaultSectionNameId != null) {
            this.faultSectionParam.setValue(selectedFaultSectionNameId);
        }
        this.refreshFaultSectionValues();
        if (SessionInfo.getContributor() == null) {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.addButton.setEnabled(false);
            this.updateFaultPrefDataButton.setEnabled(false);
            this.updateAllPrefDataButton.setEnabled(false);
        }
    }

    public void setSelectedFaultSectionNameId(String selectedFaultSectionNameId) {
        this.faultSectionParam.setValue(selectedFaultSectionNameId);
        this.faultSectionParamEditor.refreshParamEditor();
        this.refreshFaultSectionValues();
    }

    private void initGUI() {
        this.setLayout(this.gridBagLayout);
        int pos = 1;
        this.makeFaultSectionNamesEditor();
        JPanel idPanel = this.getInfoPanel();
        this.add((Component)idPanel, new GridBagConstraints(0, pos++, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)GUI_Utils.getPanel(this.faultTraceLabel, FAULT_TRACE), new GridBagConstraints(0, pos++, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)GUI_Utils.getPanel(this.upperDepthLabel, UPPER_DEPTH), new GridBagConstraints(0, pos++, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)GUI_Utils.getPanel(this.lowerDepthLabel, LOWER_DEPTH), new GridBagConstraints(0, pos++, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        pos = 0;
        this.add((Component)this.makeButtonPanel(), new GridBagConstraints(1, pos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)GUI_Utils.getPanel(this.slipRateLabel, AVE_LONG_TERM_SLIP_RATE), new GridBagConstraints(1, pos++, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel dipPanel = this.getDipPanel();
        this.add((Component)dipPanel, new GridBagConstraints(1, pos++, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)GUI_Utils.getPanel(this.rakeLabel, RAKE), new GridBagConstraints(1, pos++, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)GUI_Utils.getPanel(this.aseismicSlipLabel, ASEISMIC_SLIP), new GridBagConstraints(1, pos++, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.getDerivedValsPanel(), new GridBagConstraints(1, pos++, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel makeButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel top = new JPanel();
        top.setLayout(new BoxLayout(top, 0));
        JPanel bottom = new JPanel();
        bottom.setLayout(new BoxLayout(bottom, 0));
        top.add(this.editButton);
        this.editButton.addActionListener(this);
        top.add(this.removeButton);
        this.removeButton.addActionListener(this);
        top.add(this.addButton);
        this.addButton.addActionListener(this);
        top.add(this.updateFaultPrefDataButton);
        this.updateFaultPrefDataButton.addActionListener(this);
        bottom.add(this.saveButton);
        this.saveButton.addActionListener(this);
        this.saveButton.setToolTipText(SAVE_BUTTON_TOOL_TIP);
        bottom.add(this.saveSubSections);
        this.saveSubSections.addActionListener(this);
        this.saveSubSections.setToolTipText(SAVE_SUBSECTIONS_BUTTON_TOOL_TIP);
        bottom.add(this.updateAllPrefDataButton);
        this.updateAllPrefDataButton.addActionListener(this);
        panel.add(top);
        panel.add(bottom);
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.editButton) {
            EditFaultSection editFaultSection = new EditFaultSection(this.dbConnection, this.selectedFaultSection, this);
        } else if (source == this.removeButton) {
            this.removeFaultSection();
            this.refreshFaultSectionValues();
        } else if (source == this.addButton) {
            EditFaultSection editFaultSection = new EditFaultSection(this.dbConnection, null, this);
        } else if (source == this.saveButton) {
            File file = this.getOutFile();
            if (file != null) {
                this.writeSectionsToFile(file);
            }
        } else if (source == this.saveSubSections) {
            String str = JOptionPane.showInputDialog(this, "Enter Maximum Length (in km) of a subsection", "10");
            try {
                double subSecLen = Double.parseDouble(str);
                File file = this.getOutFile();
                if (file != null) {
                    this.writeSubSectionsToFile(file, subSecLen);
                }
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this, "Invalid subsection length");
            }
        } else if (source == this.updateFaultPrefDataButton) {
            this.updateFaultPrefData();
        } else if (source == this.updateAllPrefDataButton) {
            this.updateAllPrefData();
        }
    }

    private void updateFaultPrefData() {
        try {
            this.prefFaultSectionDAO.rePopulatePrefDataTable(this.selectedFaultSection.getSectionId());
            JOptionPane.showMessageDialog(this, "Pref. Data updated successfully!", "Update Successfull", 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "An error was encountered while\nupdating the Pref. fault section data.\n\nException Type: " + ClassUtils.getClassNameWithoutPackage(e.getClass()), "Error Updating Pref. Data", 0);
        }
    }

    private void updateAllPrefData() {
        try {
            this.prefFaultSectionDAO.rePopulatePrefDataTable();
            JOptionPane.showMessageDialog(this, "Pref. Data updated successfully!", "Update Successfull", 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "An error was encountered while\nupdating the Pref. fault section data.\n\nException Type: " + ClassUtils.getClassNameWithoutPackage(e.getClass()), "Error Updating Pref. Data", 0);
        }
    }

    private File getOutFile() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.showSaveDialog(this);
        File file = fileChooser.getSelectedFile();
        return file;
    }

    private void writeSubSectionsToFile(File file, double subSecLen) {
        ArrayList<FaultSectionPrefData> faultSectionPrefDataList = this.prefFaultSectionDAO.getAllFaultSectionPrefData();
        SectionInfoTextFileWriter sectionWriter = new SectionInfoTextFileWriter(this.dbConnection);
        try {
            FileWriter fw = new FileWriter(file);
            fw.write(sectionWriter.getFileHeader());
            int totalSubSections = 0;
            for (int i = 0; i < faultSectionPrefDataList.size(); ++i) {
                FaultSectionPrefData faultSecPrefData = faultSectionPrefDataList.get(i);
                List subSecList = faultSecPrefData.getSubSectionsList(subSecLen);
                totalSubSections += ((ArrayList)subSecList).size();
                for (int j = 0; j < ((ArrayList)subSecList).size(); ++j) {
                    sectionWriter.writeForFaultModel((FaultSectionPrefData)((ArrayList)subSecList).get(j), fw);
                }
            }
            System.out.println("Total Subsections=" + totalSubSections);
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeSectionsToFile(File file) {
        ArrayList<FaultSectionSummary> faultSectionsSummaryList = this.faultSectionDAO.getAllFaultSectionsSummary();
        int[] faultSectionIds = new int[faultSectionsSummaryList.size()];
        for (int i = 0; i < faultSectionsSummaryList.size(); ++i) {
            faultSectionIds[i] = faultSectionsSummaryList.get(i).getSectionId();
        }
        SectionInfoTextFileWriter fileWriter = new SectionInfoTextFileWriter(this.dbConnection);
        fileWriter.writeForFaultModel(faultSectionIds, file);
    }

    private void removeFaultSection() {
        int option = JOptionPane.showConfirmDialog(this, MSG_REMOVE_CONFIRM);
        if (option == 0) {
            String faultSectionName = (String)this.faultSectionParam.getValue();
            FaultSectionSummary faultSectionSummary = FaultSectionSummary.getFaultSectionSummary(faultSectionName);
            this.faultSectionDAO.removeFaultSection(faultSectionSummary.getSectionId());
            JOptionPane.showMessageDialog(this, MSG_REMOVE_SUCCESS);
            this.makeFaultSectionNamesEditor();
        }
    }

    private JPanel getDipPanel() {
        JPanel dipPanel = GUI_Utils.getPanel(DIP);
        dipPanel.add((Component)this.dipLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        dipPanel.add((Component)this.dipDirectionLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        return dipPanel;
    }

    private JPanel getDerivedValsPanel() {
        JPanel derivedValsPanel = GUI_Utils.getPanel(DERIVED_VALS);
        derivedValsPanel.add((Component)this.sectionLengthLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        derivedValsPanel.add((Component)this.downDipWidthLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        derivedValsPanel.add((Component)this.sectionAreaLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return derivedValsPanel;
    }

    private JPanel getInfoPanel() {
        JPanel idPanel = GUI_Utils.getPanel(INFO);
        idPanel.add((Component)this.shortNameLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        idPanel.add((Component)this.entryDateLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        idPanel.add((Component)this.qfaultLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        idPanel.add((Component)this.sourceLabel, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        idPanel.add((Component)this.commentsLabel, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return idPanel;
    }

    public void makeFaultSectionNamesEditor() {
        if (this.faultSectionParamEditor != null) {
            this.remove(this.faultSectionParamEditor);
        }
        ArrayList<FaultSectionSummary> faultSectionsSummaryList = this.faultSectionDAO.getAllFaultSectionsSummary();
        ArrayList<String> faultSectionsList = new ArrayList<String>();
        for (int i = 0; i < faultSectionsSummaryList.size(); ++i) {
            faultSectionsList.add(faultSectionsSummaryList.get(i).getAsString());
        }
        this.faultSectionParam = new StringParameter(FAULT_SECTION_PARAM_NAME, faultSectionsList, (String)faultSectionsList.get(0));
        this.faultSectionParam.addParameterChangeListener(this);
        this.faultSectionParamEditor = new ConstrainedStringParameterEditor(this.faultSectionParam);
        this.add((Component)this.faultSectionParamEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.updateUI();
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        this.refreshFaultSectionValues();
    }

    public void refreshFaultSectionValues() {
        String faultSectionName = (String)this.faultSectionParam.getValue();
        FaultSectionSummary faultSectionSummary = FaultSectionSummary.getFaultSectionSummary(faultSectionName);
        this.selectedFaultSection = this.faultSectionDAO.getFaultSection(faultSectionSummary.getSectionId());
        this.entryDateLabel.setTextAsHTML(ENTRY_DATE, this.selectedFaultSection.getEntryDate());
        this.sourceLabel.setTextAsHTML(SOURCE, this.selectedFaultSection.getSource());
        Estimate slipRateEst = null;
        if (this.selectedFaultSection.getAveLongTermSlipRateEst() != null) {
            slipRateEst = this.selectedFaultSection.getAveLongTermSlipRateEst().getEstimate();
        }
        this.slipRateLabel.setTextAsHTML(slipRateEst, AVE_LONG_TERM_SLIP_RATE, PROB);
        Estimate dipEst = null;
        if (this.selectedFaultSection.getAveDipEst() != null) {
            dipEst = this.selectedFaultSection.getAveDipEst().getEstimate();
        }
        this.dipLabel.setTextAsHTML(dipEst, DIP, PROB);
        String label = "" + this.selectedFaultSection.getDipDirection();
        label = label + " (calculated val: " + this.selectedFaultSection.getFaultTrace().getDipDirection() + ")";
        this.dipDirectionLabel.setTextAsHTML(DIP_DIRECTION, label);
        Estimate rakeEst = null;
        if (this.selectedFaultSection.getAveRakeEst() != null) {
            rakeEst = this.selectedFaultSection.getAveRakeEst().getEstimate();
        }
        this.rakeLabel.setTextAsHTML(rakeEst, RAKE, PROB);
        Estimate upperDepthEst = null;
        if (this.selectedFaultSection.getAveUpperDepthEst() != null) {
            upperDepthEst = this.selectedFaultSection.getAveUpperDepthEst().getEstimate();
        }
        this.upperDepthLabel.setTextAsHTML(upperDepthEst, UPPER_DEPTH, PROB);
        Estimate lowerDepthEst = null;
        if (this.selectedFaultSection.getAveLowerDepthEst() != null) {
            lowerDepthEst = this.selectedFaultSection.getAveLowerDepthEst().getEstimate();
        }
        this.lowerDepthLabel.setTextAsHTML(lowerDepthEst, LOWER_DEPTH, PROB);
        Estimate aseismicSlipEst = null;
        if (this.selectedFaultSection.getAseismicSlipFactorEst() != null) {
            aseismicSlipEst = this.selectedFaultSection.getAseismicSlipFactorEst().getEstimate();
        }
        this.aseismicSlipLabel.setTextAsHTML(aseismicSlipEst, ASEISMIC_SLIP, PROB);
        FaultTrace faultTrace = this.selectedFaultSection.getFaultTrace();
        ArrayList<CallSite> locsAsString = new ArrayList<CallSite>();
        int numLocs = faultTrace.getNumLocations();
        for (int i = 0; i < numLocs; ++i) {
            Location loc = (Location)faultTrace.get(i);
            locsAsString.add((CallSite)((Object)(loc.getLongitude() + "," + loc.getLatitude())));
        }
        this.faultTraceLabel.setTextAsHTML(locsAsString);
        FaultSectionPrefData faultsectionPrefData = this.selectedFaultSection.getFaultSectionPrefData();
        double length = faultsectionPrefData.getTraceLength();
        this.sectionLengthLabel.setTextAsHTML(SECTION_LENGTH, "" + (float)length);
        double ddw = faultsectionPrefData.getOrigDownDipWidth();
        this.downDipWidthLabel.setTextAsHTML(SECTION_DOWN_DIP_WIDTH, "" + (float)ddw);
        this.sectionAreaLabel.setTextAsHTML(SECTION_AREA, "" + (float)(length * ddw));
        this.commentsLabel.setTextAsHTML(COMMENTS, this.selectedFaultSection.getComments());
        this.qfaultLabel.setTextAsHTML(QFAULT_ID, this.selectedFaultSection.getQFaultId());
        this.shortNameLabel.setTextAsHTML(SHORT_NAME, this.selectedFaultSection.getShortName());
    }
}

