/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.LightFixedXFunc;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeWarningEvent;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.calc.AbstractCalculator;
import org.opensha.sha.calc.HazardCurveCalculatorAPI;
import org.opensha.sha.calc.params.NonSupportedTRT_OptionsParam;
import org.opensha.sha.calc.params.NumStochasticEventSetsParam;
import org.opensha.sha.calc.params.SetTRTinIMR_FromSourceParam;
import org.opensha.sha.calc.params.filters.FixedDistanceCutoffFilter;
import org.opensha.sha.calc.params.filters.MagDependentDistCutoffFilter;
import org.opensha.sha.calc.params.filters.MinMagFilter;
import org.opensha.sha.calc.params.filters.SourceFilter;
import org.opensha.sha.calc.params.filters.SourceFilterManager;
import org.opensha.sha.calc.params.filters.SourceFilters;
import org.opensha.sha.calc.params.filters.SourceFiltersParam;
import org.opensha.sha.calc.params.filters.TectonicRegionDistCutoffFilter;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.SiteAdaptiveSource;
import org.opensha.sha.earthquake.rupForecastImpl.Frankel96.Frankel96_EqkRupForecast;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.attenRelImpl.BJF_1997_AttenRel;
import org.opensha.sha.util.TRTUtils;
import org.opensha.sha.util.TectonicRegionType;

public class HazardCurveCalculator
extends AbstractCalculator
implements ParameterChangeWarningListener,
HazardCurveCalculatorAPI {
    private static final String C = "HazardCurveCalculator";
    private static final boolean D = false;
    private SourceFilterManager sourceFilters;
    private SourceFiltersParam sourceFilterParam;
    private FixedDistanceCutoffFilter fixedDistanceFilter;
    private MagDependentDistCutoffFilter magDependentFilter;
    private TectonicRegionDistCutoffFilter trtDependentFilter;
    private MinMagFilter minMagFilter;
    private NumStochasticEventSetsParam numStochEventSetRealizationsParam;
    private SetTRTinIMR_FromSourceParam setTRTinIMR_FromSourceParam;
    private NonSupportedTRT_OptionsParam nonSupportedTRT_OptionsParam;
    private ParameterList adjustableParams;
    private boolean trackProgress = false;
    private int currRuptures = -1;
    private int totRuptures = 0;
    private int sourceIndex;
    private int numSources;

    public HazardCurveCalculator() {
        this(SourceFiltersParam.getDefault());
    }

    public HazardCurveCalculator(SourceFilterManager sourceFilters) {
        this.sourceFilters = sourceFilters;
        this.sourceFilterParam = new SourceFiltersParam(sourceFilters);
        this.fixedDistanceFilter = (FixedDistanceCutoffFilter)sourceFilters.getFilterInstance(SourceFilters.FIXED_DIST_CUTOFF);
        this.magDependentFilter = (MagDependentDistCutoffFilter)sourceFilters.getFilterInstance(SourceFilters.MAG_DIST_CUTOFFS);
        this.trtDependentFilter = (TectonicRegionDistCutoffFilter)sourceFilters.getFilterInstance(SourceFilters.TRT_DIST_CUTOFFS);
        this.minMagFilter = (MinMagFilter)sourceFilters.getFilterInstance(SourceFilters.MIN_MAG);
        this.numStochEventSetRealizationsParam = new NumStochasticEventSetsParam();
        this.setTRTinIMR_FromSourceParam = new SetTRTinIMR_FromSourceParam();
        this.nonSupportedTRT_OptionsParam = new NonSupportedTRT_OptionsParam();
        this.adjustableParams = new ParameterList();
        this.adjustableParams.addParameter(this.sourceFilterParam);
        this.adjustableParams.addParameter(this.numStochEventSetRealizationsParam);
        this.adjustableParams.addParameter(this.setTRTinIMR_FromSourceParam);
        this.adjustableParams.addParameter(this.nonSupportedTRT_OptionsParam);
    }

    public SourceFilterManager getSourceFilterManager() {
        return this.sourceFilters;
    }

    @Override
    public List<SourceFilter> getSourceFilters() {
        return this.sourceFilters.getEnabledFilters();
    }

    @Override
    public void setMaxSourceDistance(double distance) {
        this.sourceFilters.setEnabled(SourceFilters.FIXED_DIST_CUTOFF, true);
        this.fixedDistanceFilter.setMaxDistance(distance);
        if (this.sourceFilterParam.isEditorBuilt()) {
            this.sourceFilterParam.getEditor().refreshParamEditor();
        }
    }

    @Override
    public void setMinMagnitude(double magnitude) {
        this.sourceFilters.setEnabled(SourceFilters.MIN_MAG, true);
        this.minMagFilter.setMinMagnitude(magnitude);
        if (this.sourceFilterParam.isEditorBuilt()) {
            this.sourceFilterParam.getEditor().refreshParamEditor();
        }
    }

    @Override
    public void setNumStochEventSetRealizations(int numRealizations) {
        this.numStochEventSetRealizationsParam.setValue(numRealizations);
    }

    @Override
    public double getMaxSourceDistance() {
        double maxDist = Double.POSITIVE_INFINITY;
        if (this.sourceFilters.isEnabled(SourceFilters.FIXED_DIST_CUTOFF)) {
            maxDist = this.fixedDistanceFilter.getMaxDistance();
        }
        if (this.sourceFilters.isEnabled(SourceFilters.MAG_DIST_CUTOFFS)) {
            maxDist = Math.min(maxDist, this.magDependentFilter.getMagDistFunc().getMaxX());
        }
        if (this.sourceFilters.isEnabled(SourceFilters.TRT_DIST_CUTOFFS)) {
            maxDist = Math.min(maxDist, this.trtDependentFilter.getCutoffs().getLargestCutoffDist());
        }
        return maxDist;
    }

    @Override
    public void setMagDistCutoffFunc(ArbitrarilyDiscretizedFunc magDistfunc) {
        this.sourceFilters.setEnabled(SourceFilters.MAG_DIST_CUTOFFS, true);
        this.magDependentFilter.setMagDistFunc(magDistfunc);
        if (this.sourceFilterParam.isEditorBuilt()) {
            this.sourceFilterParam.getEditor().refreshParamEditor();
        }
    }

    @Override
    public void setIncludeMagDistCutoff(boolean include) {
        this.sourceFilters.setEnabled(SourceFilters.MAG_DIST_CUTOFFS, include);
    }

    @Override
    public ArbitrarilyDiscretizedFunc getMagDistCutoffFunc() {
        if (this.sourceFilters.isEnabled(SourceFilters.MAG_DIST_CUTOFFS)) {
            return this.magDependentFilter.getMagDistFunc();
        }
        return null;
    }

    @Override
    public DiscretizedFunc getAnnualizedRates(DiscretizedFunc hazFunction, double years) {
        DiscretizedFunc annualizedRateFunc = hazFunction.deepClone();
        int size = annualizedRateFunc.size();
        for (int i = 0; i < size; ++i) {
            annualizedRateFunc.set(i, -Math.log(1.0 - annualizedRateFunc.getY(i)) / years);
        }
        return annualizedRateFunc;
    }

    @Override
    public DiscretizedFunc getHazardCurve(DiscretizedFunc hazFunction, Site site, ScalarIMR imr, ERF eqkRupForecast) {
        return this.getHazardCurve(hazFunction, site, TRTUtils.wrapInHashMap(imr), eqkRupForecast);
    }

    @Override
    public DiscretizedFunc getHazardCurve(DiscretizedFunc hazFunction, Site site, Map<TectonicRegionType, ScalarIMR> imrMap, ERF eqkRupForecast) {
        this.signalReset();
        boolean setTRTinIMR_FromSource = (Boolean)this.setTRTinIMR_FromSourceParam.getValue();
        HashMap<ScalarIMR, TectonicRegionType> trtOrigVals = null;
        if (setTRTinIMR_FromSource) {
            trtOrigVals = TRTUtils.getTRTsSetInIMRs(imrMap);
        }
        this.currRuptures = -1;
        boolean poissonSource = false;
        DiscretizedFunc origHazFunc = hazFunction;
        hazFunction = new LightFixedXFunc(hazFunction);
        DiscretizedFunc condProbFunc = new LightFixedXFunc(hazFunction);
        LightFixedXFunc sourceHazFunc = new LightFixedXFunc(hazFunction);
        int numPoints = hazFunction.size();
        double maxDistance = this.getMaxSourceDistance();
        List<SourceFilter> filters = this.getSourceFilters();
        for (ScalarIMR imr : imrMap.values()) {
            imr.resetParameterEventListeners();
            imr.setUserMaxDistance(maxDistance);
            imr.setSite(site);
        }
        this.numSources = eqkRupForecast.getNumSources();
        if (this.trackProgress) {
            this.totRuptures = 0;
            this.sourceIndex = 0;
            this.sourceIndex = 0;
            while (this.sourceIndex < this.numSources) {
                ProbEqkSource source = eqkRupForecast.getSource(this.sourceIndex);
                if (source instanceof SiteAdaptiveSource) {
                    source = ((SiteAdaptiveSource)((Object)source)).getForSite(site);
                }
                this.totRuptures += source.getNumRuptures();
                ++this.sourceIndex;
            }
        }
        this.currRuptures = 0;
        this.initDiscretizeValues(hazFunction, 1.0);
        boolean sourceUsed = false;
        this.sourceIndex = 0;
        while (this.sourceIndex < this.numSources) {
            if (this.isCancelled()) {
                return null;
            }
            ProbEqkSource source = eqkRupForecast.getSource(this.sourceIndex);
            TectonicRegionType trt = source.getTectonicRegionType();
            if (source instanceof SiteAdaptiveSource) {
                source = ((SiteAdaptiveSource)((Object)source)).getForSite(site);
            }
            ScalarIMR imr = TRTUtils.getIMRforTRT(imrMap, trt);
            if (setTRTinIMR_FromSource) {
                TRTUtils.setTRTinIMR(imr, trt, this.nonSupportedTRT_OptionsParam, trtOrigVals.get(imr));
            }
            if (HazardCurveCalculator.canSkipSource(filters, source, site)) {
                this.currRuptures += source.getNumRuptures();
            } else {
                int k;
                poissonSource = source.isSourcePoissonian();
                if (!poissonSource) {
                    this.initDiscretizeValues(sourceHazFunc, 0.0);
                }
                int numRuptures = source.getNumRuptures();
                int n = 0;
                while (n < numRuptures) {
                    ProbEqkRupture rupture = source.getRupture(n);
                    try {
                        double qkProb = rupture.getProbability();
                        if (qkProb != 0.0 && !HazardCurveCalculator.canSkipRupture(filters, rupture, site)) {
                            sourceUsed = true;
                            imr.setEqkRupture(rupture);
                            condProbFunc = imr.getExceedProbabilities(condProbFunc);
                            if (poissonSource) {
                                if (Math.log(1.0 - qkProb) < -30.0) {
                                    throw new RuntimeException("Error: The probability for this ProbEqkRupture (" + qkProb + ") is too high for a Possion source (~infinite number of events)");
                                }
                                double lnBase = Math.log1p(-qkProb);
                                Preconditions.checkState((boolean)Double.isFinite(lnBase), (String)"Bad lnBase=%s for qkProb=%s", (Object)lnBase, (Object)qkProb);
                                for (k = 0; k < numPoints; ++k) {
                                    hazFunction.set(k, hazFunction.getY(k) * Math.exp(lnBase * condProbFunc.getY(k)));
                                }
                            } else {
                                for (k = 0; k < numPoints; ++k) {
                                    sourceHazFunc.set(k, sourceHazFunc.getY(k) + qkProb * condProbFunc.getY(k));
                                }
                            }
                        }
                    }
                    catch (Throwable t) {
                        System.err.println("Error occured while calculating hazard curve for rupture:  " + this.sourceIndex + " " + n);
                        System.err.println("Type: " + String.valueOf(t.getClass()));
                        System.err.println("Message: " + t.getMessage());
                        System.err.println("Source Name: " + source.getName());
                        System.err.println("Surface Type: " + rupture.getRuptureSurface().getClass().getName());
                        System.err.println("Mag: " + rupture.getMag());
                        System.err.println("Probability: " + rupture.getProbability());
                        System.err.println("ERF: " + eqkRupForecast.getName());
                        System.err.println("IMR: " + imr.getName());
                        System.err.println("Site: " + String.valueOf(site));
                        System.err.println("Curve: " + String.valueOf(hazFunction));
                        System.err.flush();
                        ExceptionUtils.throwAsRuntimeException(t);
                    }
                    ++n;
                    ++this.currRuptures;
                }
                if (!poissonSource) {
                    for (k = 0; k < numPoints; ++k) {
                        hazFunction.set(k, hazFunction.getY(k) * (1.0 - sourceHazFunc.getY(k)));
                    }
                }
            }
            ++this.sourceIndex;
        }
        if (sourceUsed) {
            for (int i = 0; i < numPoints; ++i) {
                origHazFunc.set(i, 1.0 - hazFunction.getY(i));
            }
            hazFunction = origHazFunc;
        } else {
            hazFunction = origHazFunc;
            this.initDiscretizeValues(hazFunction, 0.0);
        }
        if (trtOrigVals != null) {
            TRTUtils.resetTRTsInIMRs(trtOrigVals);
        }
        return hazFunction;
    }

    public static boolean canSkipSource(Collection<SourceFilter> filters, ProbEqkSource source, Site site) {
        if (filters == null || filters.isEmpty()) {
            return false;
        }
        if (!filters.isEmpty()) {
            double distance = source.getMinDistance(site);
            for (SourceFilter filter : filters) {
                if (!filter.canSkipSource(source, site, distance)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canSkipRupture(Collection<SourceFilter> filters, EqkRupture rupture, Site site) {
        if (filters == null || filters.isEmpty()) {
            return false;
        }
        if (!filters.isEmpty()) {
            for (SourceFilter filter : filters) {
                if (!filter.canSkipRupture(rupture, site)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public DiscretizedFunc getAverageEventSetHazardCurve(DiscretizedFunc hazFunction, Site site, ScalarIMR imr, ERF eqkRupForecast) {
        this.signalReset();
        int numEventSets = (Integer)this.numStochEventSetRealizationsParam.getValue();
        DiscretizedFunc hazCurve = hazFunction.deepClone();
        this.initDiscretizeValues(hazFunction, 0.0);
        int numPts = hazCurve.size();
        this.currRuptures = 0;
        for (int i = 0; i < numEventSets; ++i) {
            if (this.isCancelled()) {
                return null;
            }
            List<EqkRupture> events = eqkRupForecast.drawRandomEventSet(site, this.getSourceFilters());
            if (i == 0) {
                this.totRuptures = events.size() * numEventSets;
            }
            this.currRuptures += events.size();
            this.getEventSetHazardCurve(hazCurve, site, imr, events, false);
            for (int x = 0; x < numPts; ++x) {
                hazFunction.set(x, hazFunction.getY(x) + hazCurve.getY(x));
            }
        }
        for (int x = 0; x < numPts; ++x) {
            hazFunction.set(x, hazFunction.getY(x) / (double)numEventSets);
        }
        return hazFunction;
    }

    @Override
    public DiscretizedFunc getEventSetHazardCurve(DiscretizedFunc hazFunction, Site site, ScalarIMR imr, List<EqkRupture> eqkRupList, boolean updateCurrRuptures) {
        this.signalReset();
        DiscretizedFunc condProbFunc = hazFunction.deepClone();
        ((AttenuationRelationship)imr).resetParameterEventListeners();
        int numPoints = hazFunction.size();
        double maxDistance = this.getMaxSourceDistance();
        List<SourceFilter> filters = this.getSourceFilters();
        imr.setUserMaxDistance(maxDistance);
        int totRups = eqkRupList.size();
        if (updateCurrRuptures) {
            this.totRuptures = totRups;
            this.currRuptures = 0;
        }
        this.initDiscretizeValues(hazFunction, 1.0);
        imr.setSite(site);
        for (int n = 0; n < totRups; ++n) {
            EqkRupture rupture;
            if (this.isCancelled()) {
                return null;
            }
            if (updateCurrRuptures) {
                ++this.currRuptures;
            }
            if (HazardCurveCalculator.canSkipRupture(filters, rupture = eqkRupList.get(n), site)) continue;
            imr.setEqkRupture(rupture);
            condProbFunc = imr.getExceedProbabilities(condProbFunc);
            for (int k = 0; k < numPoints; ++k) {
                hazFunction.set(k, hazFunction.getY(k) * (1.0 - condProbFunc.getY(k)));
            }
        }
        for (int i = 0; i < numPoints; ++i) {
            hazFunction.set(i, 1.0 - hazFunction.getY(i));
        }
        return hazFunction;
    }

    public DiscretizedFunc getEventSetExpNumExceedCurve(DiscretizedFunc hazFunction, Site site, ScalarIMR imr, List<EqkRupture> eqkRupList, boolean updateCurrRuptures) {
        this.signalReset();
        DiscretizedFunc condProbFunc = hazFunction.deepClone();
        ((AttenuationRelationship)imr).resetParameterEventListeners();
        int numPoints = hazFunction.size();
        double maxDistance = this.getMaxSourceDistance();
        List<SourceFilter> filters = this.getSourceFilters();
        imr.setUserMaxDistance(maxDistance);
        int totRups = eqkRupList.size();
        if (updateCurrRuptures) {
            this.totRuptures = totRups;
            this.currRuptures = 0;
        }
        this.initDiscretizeValues(hazFunction, 0.0);
        imr.setSite(site);
        for (int n = 0; n < totRups; ++n) {
            EqkRupture rupture;
            if (this.isCancelled()) {
                return null;
            }
            if (updateCurrRuptures) {
                ++this.currRuptures;
            }
            if (HazardCurveCalculator.canSkipRupture(filters, rupture = eqkRupList.get(n), site)) continue;
            imr.setEqkRupture(rupture);
            condProbFunc = imr.getExceedProbabilities(condProbFunc);
            for (int k = 0; k < numPoints; ++k) {
                hazFunction.set(k, hazFunction.getY(k) + condProbFunc.getY(k));
            }
        }
        return hazFunction;
    }

    public DiscretizedFunc getEventSetHazardCurveRandomIML(DiscretizedFunc hazFunction, Site site, ScalarIMR imr, List<EqkRupture> eqkRupList, boolean updateCurrRuptures, Random random) {
        this.signalReset();
        if (random == null) {
            random = new Random();
        }
        ((AttenuationRelationship)imr).resetParameterEventListeners();
        int numPoints = hazFunction.size();
        double maxDistance = this.getMaxSourceDistance();
        List<SourceFilter> filters = this.getSourceFilters();
        imr.setUserMaxDistance(maxDistance);
        int totRups = eqkRupList.size();
        if (updateCurrRuptures) {
            this.totRuptures = totRups;
            this.currRuptures = 0;
        }
        imr.setSite(site);
        double maxIML = Double.NEGATIVE_INFINITY;
        for (int n = 0; n < totRups; ++n) {
            EqkRupture rupture;
            if (this.isCancelled()) {
                return null;
            }
            if (updateCurrRuptures) {
                ++this.currRuptures;
            }
            if (HazardCurveCalculator.canSkipRupture(filters, rupture = eqkRupList.get(n), site)) continue;
            imr.setEqkRupture(rupture);
            double randIML = imr.getRandomIML(random);
            if (!(maxIML < randIML)) continue;
            maxIML = randIML;
        }
        for (int i = 0; i < numPoints; ++i) {
            if (hazFunction.getX(i) < maxIML) {
                hazFunction.set(i, 1.0);
                continue;
            }
            hazFunction.set(i, 0.0);
        }
        return hazFunction;
    }

    public DiscretizedFunc getEventSetNumExceedCurveRandomIML(DiscretizedFunc hazFunction, Site site, ScalarIMR imr, List<EqkRupture> eqkRupList, boolean updateCurrRuptures, Random random) {
        this.signalReset();
        ((AttenuationRelationship)imr).resetParameterEventListeners();
        double maxDistance = this.getMaxSourceDistance();
        List<SourceFilter> filters = this.getSourceFilters();
        imr.setUserMaxDistance(maxDistance);
        int totRups = eqkRupList.size();
        if (updateCurrRuptures) {
            this.totRuptures = totRups;
            this.currRuptures = 0;
        }
        imr.setSite(site);
        for (int n = 0; n < totRups; ++n) {
            EqkRupture rupture;
            if (this.isCancelled()) {
                return null;
            }
            if (updateCurrRuptures) {
                ++this.currRuptures;
            }
            if (HazardCurveCalculator.canSkipRupture(filters, rupture = eqkRupList.get(n), site)) continue;
            imr.setEqkRupture(rupture);
            double randIML = imr.getRandomIML(random);
            for (int i = 0; i < hazFunction.size() && hazFunction.getX(i) < randIML; ++i) {
                hazFunction.set(i, hazFunction.getY(i) + 1.0);
            }
        }
        return hazFunction;
    }

    @Override
    public DiscretizedFunc getHazardCurve(DiscretizedFunc hazFunction, Site site, ScalarIMR imr, EqkRupture rupture) {
        List<SourceFilter> filters = this.getSourceFilters();
        if (HazardCurveCalculator.canSkipRupture(filters, rupture, site)) {
            hazFunction.scale(0.0);
            return hazFunction;
        }
        ((AttenuationRelationship)imr).resetParameterEventListeners();
        imr.setSite(site);
        imr.setEqkRupture(rupture);
        hazFunction = imr.getExceedProbabilities(hazFunction);
        return hazFunction;
    }

    @Override
    public void setTrackProgress(boolean trackProgress) {
        this.trackProgress = trackProgress;
    }

    @Override
    public boolean isTrackProgress() {
        return this.trackProgress;
    }

    @Override
    public int getCurrRuptures() {
        if (this.trackProgress) {
            return this.currRuptures;
        }
        return -1;
    }

    @Override
    public int getTotRuptures() {
        if (this.trackProgress) {
            return this.totRuptures;
        }
        return -1;
    }

    protected void initDiscretizeValues(DiscretizedFunc arb, double val) {
        int num = arb.size();
        for (int i = 0; i < num; ++i) {
            arb.set(i, val);
        }
        Preconditions.checkState((num == arb.size() ? 1 : 0) != 0, (Object)"initializing X values changed size of function! It is possible that there is a NaN or infitite value in the hazard curve.");
    }

    @Override
    public ParameterList getAdjustableParams() {
        return this.adjustableParams;
    }

    @Override
    public void setAdjustableParams(ParameterList paramList) {
        this.adjustableParams = paramList;
        this.sourceFilterParam = (SourceFiltersParam)paramList.getParameter("Source Filters");
        this.sourceFilters = (SourceFilterManager)this.sourceFilterParam.getValue();
        this.fixedDistanceFilter = (FixedDistanceCutoffFilter)this.sourceFilters.getFilterInstance(SourceFilters.FIXED_DIST_CUTOFF);
        this.magDependentFilter = (MagDependentDistCutoffFilter)this.sourceFilters.getFilterInstance(SourceFilters.MAG_DIST_CUTOFFS);
        this.trtDependentFilter = (TectonicRegionDistCutoffFilter)this.sourceFilters.getFilterInstance(SourceFilters.TRT_DIST_CUTOFFS);
        this.minMagFilter = (MinMagFilter)this.sourceFilters.getFilterInstance(SourceFilters.MIN_MAG);
        this.numStochEventSetRealizationsParam = (NumStochasticEventSetsParam)paramList.getParameter("Num Event Sets");
        this.setTRTinIMR_FromSourceParam = (SetTRTinIMR_FromSourceParam)paramList.getParameter("Set TRT From Source?");
        this.nonSupportedTRT_OptionsParam = (NonSupportedTRT_OptionsParam)paramList.getParameter("If source TRT not supported by IMR");
    }

    @Override
    public ListIterator<Parameter<?>> getAdjustableParamsIterator() {
        return this.adjustableParams.getParametersIterator();
    }

    public void testEventSetHazardCurve(int numIterations) {
        this.setMaxSourceDistance(300.0);
        this.numStochEventSetRealizationsParam.setValue(numIterations);
        BJF_1997_AttenRel imr = new BJF_1997_AttenRel(this);
        imr.setParamDefaults();
        imr.setIntensityMeasure("PGA");
        Site site = new Site();
        ListIterator<Parameter<?>> it = imr.getSiteParamsIterator();
        while (it.hasNext()) {
            site.addParameter(it.next());
        }
        site.setLocation(new Location(34.0, -118.0));
        Frankel96_EqkRupForecast eqkRupForecast = new Frankel96_EqkRupForecast();
        eqkRupForecast.updateForecast();
        ArbitrarilyDiscretizedFunc hazCurve = new ArbitrarilyDiscretizedFunc();
        hazCurve.set(-3.0, 1.0);
        hazCurve.set(-2.0, 1.0);
        hazCurve.set(-1.0, 1.0);
        hazCurve.set(1.0, 1.0);
        hazCurve.set(2.0, 1.0);
        hazCurve.setName("Hazard Curve");
        this.getHazardCurve((DiscretizedFunc)hazCurve, site, (ScalarIMR)imr, (ERF)eqkRupForecast);
        System.out.println(hazCurve.toString());
        ArbitrarilyDiscretizedFunc aveCurve = hazCurve.deepClone();
        this.getAverageEventSetHazardCurve(aveCurve, site, imr, eqkRupForecast);
        aveCurve.setName("Ave from " + numIterations + " event sets");
        System.out.println(aveCurve.toString());
    }

    @Override
    public void parameterChangeWarning(ParameterChangeWarningEvent event) {
    }

    @Override
    protected boolean isCancelled() {
        boolean cancelled = super.isCancelled();
        return cancelled;
    }

    public static void main(String[] args) {
        HazardCurveCalculator calc = new HazardCurveCalculator();
        calc.testEventSetHazardCurve(1000);
    }
}

