/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.IM_EventSet;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.opensha.commons.data.siteData.SiteDataValue;
import org.opensha.commons.geo.Location;
import org.opensha.commons.util.FileUtils;

public class SiteFileLoader {
    private ArrayList<Location> locs;
    private ArrayList<ArrayList<SiteDataValue<?>>> valsList;
    private final String measurementType;
    private final boolean lonFirst;
    private final ArrayList<String> siteDataTypes;
    public static String[] allSiteDataTypes = new String[]{"Vs30", "Depth to Vs = 1.0 km/sec", "Depth to Vs = 2.5 km/sec"};
    public static String COM = "#";

    public SiteFileLoader(boolean lonFirst, String measurementType, ArrayList<String> siteDataTypes) {
        this.lonFirst = lonFirst;
        this.measurementType = measurementType;
        this.siteDataTypes = siteDataTypes;
    }

    public void loadFile(File file) throws IOException, ParseException {
        ArrayList<String> lines = FileUtils.loadFile(file.getAbsolutePath());
        this.locs = new ArrayList();
        this.valsList = new ArrayList();
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i).trim();
            if (line.startsWith(COM)) continue;
            StringTokenizer tok = new StringTokenizer(line);
            if (tok.countTokens() < 2) {
                throw new ParseException("Line " + (i + 1) + " has less than 2 fields!", 0);
            }
            ArrayList vals = new ArrayList();
            try {
                double lat;
                double lon;
                if (this.lonFirst) {
                    lon = Double.parseDouble(tok.nextToken());
                    lat = Double.parseDouble(tok.nextToken());
                } else {
                    lat = Double.parseDouble(tok.nextToken());
                    lon = Double.parseDouble(tok.nextToken());
                }
                Location loc = new Location(lat, lon);
                for (String type : this.siteDataTypes) {
                    if (!tok.hasMoreTokens()) break;
                    SiteDataValue<?> siteDataValue = this.getValue(type, this.measurementType, tok.nextToken());
                    vals.add(siteDataValue);
                }
                this.locs.add(loc);
                this.valsList.add(vals);
                continue;
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Error parsing number at line " + (i + 1));
            }
        }
    }

    public ArrayList<Location> getLocs() {
        return this.locs;
    }

    public ArrayList<ArrayList<SiteDataValue<?>>> getValsList() {
        return this.valsList;
    }

    private SiteDataValue<?> getValue(String type, String measType, String valStr) {
        Double val;
        valStr = valStr.trim();
        try {
            if (valStr.equalsIgnoreCase("null")) {
                return new SiteDataValue<Object>(type, measType, null);
            }
            val = Double.parseDouble(valStr);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("'" + valStr + "' cannot be parsed into a numerical value!");
        }
        return new SiteDataValue<Double>(type, measType, val);
    }
}

