/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.IM_EventSet.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.opensha.commons.data.siteData.OrderedSiteDataProviderList;
import org.opensha.commons.data.siteData.gui.beans.OrderedSiteDataGUIBean;
import org.opensha.commons.geo.Location;
import org.opensha.commons.gui.DisclaimerDialog;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.util.ApplicationVersion;
import org.opensha.commons.util.FileUtils;
import org.opensha.commons.util.bugReports.BugReport;
import org.opensha.commons.util.bugReports.BugReportDialog;
import org.opensha.commons.util.bugReports.DefaultExceptionHandler;
import org.opensha.sha.calc.IM_EventSet.AbstractIMEventSetCalc;
import org.opensha.sha.calc.IM_EventSet.IMEventSetERFUtils;
import org.opensha.sha.calc.IM_EventSet.IM_EventSetOutputWriter;
import org.opensha.sha.calc.IM_EventSet.gui.IMEventSetCalcGUIImpl;
import org.opensha.sha.calc.IM_EventSet.gui.IMR_ChooserPanel;
import org.opensha.sha.calc.IM_EventSet.gui.IMT_ChooserPanel;
import org.opensha.sha.calc.IM_EventSet.gui.SitesPanel;
import org.opensha.sha.calc.IM_EventSet.outputImpl.HAZ01Writer;
import org.opensha.sha.calc.IM_EventSet.outputImpl.OriginalModWriter;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.gui.HazardCurveApplication;
import org.opensha.sha.gui.beans.ERF_GuiBean;
import org.opensha.sha.gui.infoTools.IndeterminateProgressBar;
import org.opensha.sha.imr.ScalarIMR;

public class IMEventSetCalculatorGUI
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static ApplicationVersion version;
    public static final String APP_NAME = "IM Event Set Calculator";
    public static final String APP_SHORT_NAME = "IM_EventSetCalc";
    private static final File cwd;
    private SitesPanel sitesPanel = null;
    private ERF_GuiBean erfGuiBean = null;
    private IMR_ChooserPanel imrChooser = null;
    private IMT_ChooserPanel imtChooser = null;
    private OrderedSiteDataGUIBean dataBean = null;
    private JButton computeButton;
    private JFileChooser outputChooser;
    private JComboBox<?> outputWriterChooser;
    private final IndeterminateProgressBar bar = new IndeterminateProgressBar("Calculating...");
    private Timer doneTimer = null;

    public IMEventSetCalculatorGUI() {
        try {
            AbstractIMEventSetCalc.initLogger(Level.WARNING);
            this.erfGuiBean = IMEventSetERFUtils.createERF_GUI_Bean();
            this.imtChooser = new IMT_ChooserPanel();
            OrderedSiteDataProviderList providers = OrderedSiteDataProviderList.createSiteDataProviderDefaults();
            this.dataBean = new OrderedSiteDataGUIBean(providers);
            this.sitesPanel = new SitesPanel(this.dataBean);
            this.imrChooser = new IMR_ChooserPanel(this.imtChooser, this.sitesPanel);
            JPanel imPanel = new JPanel();
            imPanel.setLayout(new BoxLayout(imPanel, 0));
            imPanel.add(this.imrChooser);
            imPanel.add(this.imtChooser);
            JPanel siteERFPanel = new JPanel();
            siteERFPanel.setLayout(new BoxLayout(siteERFPanel, 0));
            siteERFPanel.add(this.sitesPanel);
            siteERFPanel.add(this.erfGuiBean);
            JTabbedPane tabbedPane = new JTabbedPane();
            tabbedPane.addTab("IMRs/IMTs", imPanel);
            tabbedPane.addTab("Sites/ERF", siteERFPanel);
            tabbedPane.addTab("Site Data Providers", this.dataBean);
            JPanel buttonPanel = new JPanel(new GridBagLayout()){
                private static final long serialVersionUID = 1L;

                @Override
                public void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    g.setColor(Color.gray);
                    g.drawLine(0, 0, this.getWidth(), 0);
                }
            };
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(12, 24, 12, 40));
            buttonPanel.setBackground(HazardCurveApplication.getBottomBarColor());
            JLabel shaLogo = new JLabel(new ImageIcon(FileUtils.loadImage("logos/opensha_64.png")));
            String[] writers = new String[]{"OpenSHA Format Writer", "HAZ01 Format Writer"};
            this.outputWriterChooser = new JComboBox<String>(writers);
            this.computeButton = new JButton("Compute");
            this.computeButton.addActionListener(this);
            JPanel buttonWrapper = new JPanel(new BorderLayout());
            buttonWrapper.setOpaque(false);
            buttonWrapper.setBorder(BorderFactory.createEmptyBorder(-4, 0, 2, 0));
            buttonWrapper.add((Component)this.computeButton, "Center");
            JPanel controlsPanel = new JPanel();
            controlsPanel.setLayout(new BoxLayout(controlsPanel, 0));
            controlsPanel.setOpaque(false);
            controlsPanel.add(this.outputWriterChooser);
            controlsPanel.add(Box.createHorizontalStrut(18));
            controlsPanel.add(buttonWrapper);
            Dimension controlsPanelSize = controlsPanel.getPreferredSize();
            this.bar.setPreferredSize(new Dimension(controlsPanelSize.width, this.bar.getPreferredSize().height));
            this.bar.setMaximumSize(new Dimension(controlsPanelSize.width, this.bar.getPreferredSize().height));
            JPanel rightPanel = new JPanel();
            rightPanel.setLayout(new BoxLayout(rightPanel, 1));
            rightPanel.setOpaque(false);
            rightPanel.add(controlsPanel);
            rightPanel.add(Box.createVerticalStrut(5));
            rightPanel.add(this.bar);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 1.0;
            gbc.anchor = 21;
            gbc.fill = 0;
            gbc.insets = new Insets(0, 0, 0, 0);
            buttonPanel.add((Component)shaLogo, gbc);
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            buttonPanel.add(Box.createHorizontalGlue(), gbc);
            gbc.gridx = 2;
            gbc.weightx = 0.0;
            gbc.anchor = 22;
            gbc.fill = 0;
            buttonPanel.add((Component)rightPanel, gbc);
            JPanel mainPanel = new JPanel(new BorderLayout());
            mainPanel.add((Component)tabbedPane, "Center");
            mainPanel.add((Component)buttonPanel, "South");
            this.setTitle("IM Event Set Calculator (" + String.valueOf(IMEventSetCalculatorGUI.getAppVersion()) + ")");
            this.setContentPane(mainPanel);
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
            BugReport bug = new BugReport(e, "Error occurred during app initialization.", APP_SHORT_NAME, IMEventSetCalculatorGUI.getAppVersion(), this);
            BugReportDialog bugDialog = new BugReportDialog((Component)this, bug, true);
            bugDialog.setVisible(true);
        }
    }

    private boolean isReadyForCalc(ArrayList<Location> locs, ArrayList<ParameterList> dataLists, ERF erf, ArrayList<ScalarIMR> imrs, ArrayList<String> imts) {
        if (locs.isEmpty()) {
            JOptionPane.showMessageDialog(this, "You must add at least 1 site!", "No Sites Selected!", 0);
            return false;
        }
        if (locs.size() != dataLists.size()) {
            JOptionPane.showMessageDialog(this, "Internal error: Site data lists not same size as site list!", "Internal error", 0);
            return false;
        }
        if (erf == null) {
            JOptionPane.showMessageDialog(this, "Error instantiating ERF!", "Error with ERF!", 0);
            return false;
        }
        if (imrs.isEmpty()) {
            JOptionPane.showMessageDialog(this, "You must add at least 1 IMR!", "No IMRs Selected!", 0);
            return false;
        }
        if (imts.isEmpty()) {
            JOptionPane.showMessageDialog(this, "You must add at least 1 IMT!", "No IMTs Selected!", 0);
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final IMEventSetCalculatorGUI instance = this;
        if (e.getSource().equals(this.computeButton)) {
            SwingWorker<Boolean, Integer> precalcWorker = new SwingWorker<Boolean, Integer>(this){
                ArrayList<Location> locs = null;
                ArrayList<ParameterList> dataLists = null;
                ERF erf = null;
                ArrayList<ScalarIMR> imrs = null;
                ArrayList<String> imts = null;
                Exception precalcException;
                final /* synthetic */ IMEventSetCalculatorGUI this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                protected Boolean doInBackground() {
                    try {
                        if (this.this$0.doneTimer != null && this.this$0.doneTimer.isRunning()) {
                            this.this$0.doneTimer.stop();
                            this.this$0.doneTimer = null;
                        }
                        this.locs = this.this$0.sitesPanel.getLocs();
                        this.dataLists = this.this$0.sitesPanel.getSiteDataParams();
                        this.erf = (ERF)this.this$0.erfGuiBean.getSelectedERF();
                        this.imrs = this.this$0.imrChooser.getSelectedIMRs();
                        this.imts = this.this$0.imtChooser.getIMTStrings();
                        return this.this$0.isReadyForCalc(this.locs, this.dataLists, this.erf, this.imrs, this.imts);
                    }
                    catch (Exception e) {
                        this.precalcException = e;
                        return false;
                    }
                }

                @Override
                protected void done() {
                    boolean readyForCalc = false;
                    try {
                        readyForCalc = (Boolean)this.get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        this.precalcException = e;
                    }
                    if (!readyForCalc) {
                        if (this.precalcException != null) {
                            this.precalcException.printStackTrace();
                            JOptionPane.showMessageDialog(instance, this.precalcException.getMessage(), "Exception Preparing Calculation", 0);
                        }
                        return;
                    }
                    SwingUtilities.invokeLater(() -> {
                        int returnVal;
                        if (this.this$0.outputChooser == null) {
                            this.this$0.outputChooser = new JFileChooser(cwd);
                            this.this$0.outputChooser.setDialogTitle("Select Output Directory");
                            this.this$0.outputChooser.setFileSelectionMode(1);
                        }
                        if ((returnVal = this.this$0.outputChooser.showOpenDialog(instance)) == 0) {
                            IM_EventSetOutputWriter writer;
                            File outputDir = this.this$0.outputChooser.getSelectedFile();
                            IMEventSetCalcGUIImpl calc = new IMEventSetCalcGUIImpl(this.locs, this.dataLists, outputDir, this.this$0.dataBean.getProviderList());
                            String writerName = (String)this.this$0.outputWriterChooser.getSelectedItem();
                            if (writerName == null) {
                                throw new RuntimeException("No output writer selected");
                            }
                            if (writerName.equals("OpenSHA Format Writer")) {
                                writer = new OriginalModWriter(calc);
                            } else if (writerName.equals("HAZ01 Format Writer")) {
                                writer = new HAZ01Writer(calc);
                            } else {
                                throw new RuntimeException("Unknown writer: " + writerName);
                            }
                            SwingWorker<Boolean, Integer> calcWorker = new SwingWorker<Boolean, Integer>(this){
                                Exception calcException;
                                final /* synthetic */ 2 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                protected Boolean doInBackground() {
                                    instance.validate();
                                    try {
                                        writer.writeFiles(this.this$1.erf, this.this$1.imrs, this.this$1.imts);
                                        return true;
                                    }
                                    catch (IOException e) {
                                        this.calcException = e;
                                        return false;
                                    }
                                }

                                @Override
                                protected void done() {
                                    boolean calcSuccess = false;
                                    try {
                                        calcSuccess = (Boolean)this.get();
                                    }
                                    catch (InterruptedException | ExecutionException e2) {
                                        this.calcException = e2;
                                    }
                                    if (!calcSuccess) {
                                        this.this$1.this$0.bar.toggle();
                                        this.this$1.this$0.computeButton.setEnabled(true);
                                        if (this.calcException != null) {
                                            this.calcException.printStackTrace();
                                        }
                                        throw new RuntimeException(this.calcException);
                                    }
                                    this.this$1.this$0.computeButton.setEnabled(true);
                                    this.this$1.this$0.bar.toggle();
                                    this.this$1.this$0.bar.setString("Done!");
                                    this.this$1.this$0.bar.setStringPainted(true);
                                    this.this$1.this$0.sitesPanel.rebuildSiteDataList();
                                    this.this$1.this$0.doneTimer = new Timer(1200, e -> {
                                        this.this$1.this$0.bar.setStringPainted(false);
                                        this.this$1.this$0.bar.setString("Calculating...");
                                    });
                                    this.this$1.this$0.doneTimer.start();
                                }
                            };
                            this.this$0.bar.toggle();
                            this.this$0.computeButton.setEnabled(false);
                            calcWorker.execute();
                        }
                    });
                }
            };
            precalcWorker.execute();
        }
    }

    public static void main(String[] args) {
        new DisclaimerDialog(APP_NAME, APP_SHORT_NAME, IMEventSetCalculatorGUI.getAppVersion());
        DefaultExceptionHandler exp = new DefaultExceptionHandler(APP_SHORT_NAME, IMEventSetCalculatorGUI.getAppVersion(), null, null);
        Thread.setDefaultUncaughtExceptionHandler(exp);
        IMEventSetCalculatorGUI.launch(exp);
    }

    public static IMEventSetCalculatorGUI launch(DefaultExceptionHandler handler) {
        IMEventSetCalculatorGUI applet = new IMEventSetCalculatorGUI();
        if (handler != null) {
            handler.setApp(applet);
            handler.setParent(applet);
        }
        applet.setDefaultCloseOperation(3);
        applet.setSize(900, 700);
        applet.setVisible(true);
        return applet;
    }

    public static ApplicationVersion getAppVersion() {
        if (version == null) {
            try {
                version = ApplicationVersion.loadBuildVersion();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return version;
    }

    static {
        cwd = new File(System.getProperty("user.dir"));
        try {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        catch (Exception e1) {
            System.err.println("WARNING: could not set property 'apple.laf.useScreenMenuBar'");
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

