/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.IM_EventSet.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.opensha.commons.data.siteData.OrderedSiteDataProviderList;
import org.opensha.commons.data.siteData.SiteDataValue;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.sha.calc.IM_EventSet.SiteFileLoader;
import org.opensha.sha.util.SiteTranslator;

public class SiteImporterPanel
extends JPanel
implements ActionListener {
    private final JLabel formatLabel = new JLabel();
    private final JLabel measLabel = new JLabel("Site Data Measurement Type: ");
    private final JButton reverseButton = new JButton("Swap lat/lon");
    private final JButton addButton = new JButton("Add Site Data Column");
    private final JButton removeButton = new JButton("Remove Site Data Column");
    private final JCheckBox setFromWebCheck = new JCheckBox("Set Params from Web Services");
    private final JComboBox<String> typeChooser;
    private final JComboBox<String> measChooser;
    private final JTextField fileField = new JTextField();
    private final JButton browseButton = new JButton("Browse");
    private final JFileChooser chooser;
    private boolean lonFirst = true;
    private final ArrayList<String> siteDataTypes = new ArrayList();
    private ArrayList<Location> locs;
    private ArrayList<ParameterList> userParams;
    private ParameterList defaultSiteDataParams;
    private final SiteTranslator siteTrans = new SiteTranslator();
    private final OrderedSiteDataProviderList providers;
    private static final File cwd = new File(System.getProperty("user.dir"));

    public SiteImporterPanel(ParameterList defaultSiteDataParams, OrderedSiteDataProviderList providers) {
        this.setLayout(new BoxLayout(this, 1));
        this.providers = providers;
        this.defaultSiteDataParams = defaultSiteDataParams;
        this.typeChooser = new JComboBox<String>(SiteFileLoader.allSiteDataTypes);
        this.chooser = new JFileChooser(cwd);
        this.updateLabel();
        this.reverseButton.addActionListener(this);
        this.addButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.removeButton.setEnabled(false);
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add((Component)this.reverseButton, "West");
        JPanel rightButtonPanel = new JPanel();
        rightButtonPanel.setLayout(new BoxLayout(rightButtonPanel, 0));
        rightButtonPanel.add(this.typeChooser);
        rightButtonPanel.add(this.addButton);
        rightButtonPanel.add(this.removeButton);
        buttonPanel.add((Component)rightButtonPanel, "East");
        JPanel setFromWebPanel = new JPanel();
        setFromWebPanel.setLayout(new BoxLayout(setFromWebPanel, 0));
        setFromWebPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JTextArea infoText = new JTextArea("Checking the box to the left will retrieve the best available data for each site's location\nwith the values from the web services. Values provided from the imported file are not overwritten.\nSee the \"Site Data Providers\" pane to add or remove selected providers.\n");
        infoText.setEditable(false);
        infoText.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        setFromWebPanel.add(this.setFromWebCheck);
        setFromWebPanel.add(Box.createHorizontalStrut(10));
        setFromWebPanel.add(infoText);
        this.measChooser = new JComboBox<String>(new String[]{"Inferred", "Measured"});
        JPanel measPanel = new JPanel();
        measPanel.setLayout(new BoxLayout(measPanel, 0));
        this.measLabel.setEnabled(false);
        this.measChooser.setEnabled(false);
        measPanel.add(this.measLabel);
        measPanel.add(this.measChooser);
        JPanel newMeasPanel = new JPanel();
        newMeasPanel.add(measPanel);
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        labelPanel.add(this.formatLabel);
        this.add(labelPanel);
        JPanel newButtonPanel = new JPanel();
        newButtonPanel.add(buttonPanel);
        this.add(newButtonPanel);
        this.add(newMeasPanel);
        this.add(new JSeparator(0));
        JPanel newSetFromWebPanel = new JPanel();
        newSetFromWebPanel.add(setFromWebPanel);
        this.add(newSetFromWebPanel);
        this.add(new JSeparator(0));
        JPanel browsePanel = new JPanel(new BorderLayout());
        browsePanel.add((Component)this.fileField, "Center");
        browsePanel.add((Component)this.browseButton, "East");
        this.fileField.setColumns(40);
        this.browseButton.addActionListener(this);
        JPanel newBrowsePanel = new JPanel();
        newBrowsePanel.add(browsePanel);
        this.add(newBrowsePanel);
        this.setSize(1000, 350);
    }

    private void updateLabel() {
        StringBuilder label = new StringBuilder("File format: ");
        if (this.lonFirst) {
            label.append("<Longitude> <Latitude>");
        } else {
            label.append("<Latitude> <Longitude>");
        }
        for (String dataType : this.siteDataTypes) {
            label.append(" <").append(dataType).append(">");
        }
        this.formatLabel.setText(label.toString());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int returnVal;
        if (e.getSource().equals(this.reverseButton)) {
            this.lonFirst = !this.lonFirst;
        } else if (e.getSource().equals(this.addButton)) {
            int selected = this.typeChooser.getSelectedIndex();
            this.siteDataTypes.add((String)this.typeChooser.getSelectedItem());
            this.typeChooser.removeItemAt(selected);
        } else if (e.getSource().equals(this.removeButton)) {
            int index = this.siteDataTypes.size() - 1;
            this.typeChooser.addItem(this.siteDataTypes.get(index));
            this.siteDataTypes.remove(index);
        } else if (e.getSource().equals(this.browseButton) && (returnVal = this.chooser.showOpenDialog(this)) == 0) {
            File file = this.chooser.getSelectedFile();
            this.fileField.setText(file.getAbsolutePath());
        }
        this.addButton.setEnabled(this.typeChooser.getItemCount() > 0);
        boolean hasTypes = !this.siteDataTypes.isEmpty();
        this.measLabel.setEnabled(hasTypes);
        this.measChooser.setEnabled(hasTypes);
        this.removeButton.setEnabled(hasTypes);
        this.updateLabel();
    }

    public File getSelectedFile() {
        String fileName = this.fileField.getText();
        return new File(fileName);
    }

    public void importFile(File file) throws IOException, ParseException {
        SiteFileLoader loader = new SiteFileLoader(this.lonFirst, (String)this.measChooser.getSelectedItem(), this.siteDataTypes);
        loader.loadFile(file);
        this.locs = loader.getLocs();
        this.userParams = new ArrayList();
        for (ArrayList<SiteDataValue<?>> siteVals : loader.getValsList()) {
            ParameterList params = (ParameterList)this.defaultSiteDataParams.clone();
            params.forEach(param -> this.siteTrans.setParameterValue((Parameter)param, (Collection<SiteDataValue<?>>)siteVals));
            this.userParams.add(params);
        }
    }

    public void setDefaultSiteDataParams(ParameterList defaultSiteDataParams) {
        this.defaultSiteDataParams = defaultSiteDataParams;
    }

    public ArrayList<Location> getLocs() {
        return this.locs;
    }

    public ArrayList<ParameterList> getSiteData() {
        if (!this.setFromWebCheck.isSelected()) {
            return this.userParams;
        }
        ArrayList<ParameterList> siteData = new ArrayList<ParameterList>();
        for (int i = 0; i < this.userParams.size(); ++i) {
            if (this.userParams.get(i) == null) continue;
            ParameterList mergedData = (ParameterList)this.userParams.get(i).clone();
            Location loc = this.getLocs().get(i);
            if (loc == null) continue;
            ArrayList<SiteDataValue<?>> provData = this.providers.getBestAvailableData(loc);
            for (Parameter<?> param : mergedData) {
                if (param.getName().equals("Vs30 Type") || this.siteDataTypes.contains("Vs30") && param.getName().equals("Vs30") || this.siteDataTypes.contains("Depth to Vs = 1.0 km/sec") && param.getName().equals("Depth 1.0 km/sec") || this.siteDataTypes.contains("Depth to Vs = 2.5 km/sec") && param.getName().equals("Depth 2.5 km/sec")) continue;
                this.siteTrans.setParameterValue(param, provData);
            }
            siteData.add(mergedData);
        }
        return siteData;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        ParameterList params = new ParameterList();
        frame.setContentPane(new SiteImporterPanel(params, OrderedSiteDataProviderList.createSiteDataProviderDefaults()));
        frame.setSize(1000, 350);
        frame.setVisible(true);
    }
}

