/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.IM_EventSet.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.opensha.commons.data.siteData.OrderedSiteDataProviderList;
import org.opensha.commons.data.siteData.gui.beans.OrderedSiteDataGUIBean;
import org.opensha.commons.data.siteData.impl.WillsMap2000;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.sha.calc.IM_EventSet.gui.AddSitePanel;
import org.opensha.sha.calc.IM_EventSet.gui.SiteExporterPanel;
import org.opensha.sha.calc.IM_EventSet.gui.SiteImporterPanel;
import org.opensha.sha.imr.IntensityMeasureRelationship;
import org.opensha.sha.imr.ScalarIMR;

public class SitesPanel
extends JPanel
implements ListSelectionListener,
ActionListener {
    protected JList sitesList;
    protected JList siteDataList;
    protected JButton addSiteButton = new JButton("Add Site");
    protected JButton removeSiteButton = new JButton("Remove Site(s)");
    protected JButton editSiteButton = new JButton("Edit Site");
    protected JButton importSitesButton = new JButton("Import Sites From File");
    protected JButton exportSitesButton = new JButton("Export Sites");
    private ArrayList<Location> locs;
    private ArrayList<ParameterList> siteDataParams;
    private ParameterList defaultSiteDataParams;
    private final OrderedSiteDataGUIBean siteDataGUIBean;
    private SiteImporterPanel imp;
    private SiteExporterPanel exp;

    public SitesPanel(OrderedSiteDataGUIBean siteDataGUIBean) {
        this.setLayout(new BoxLayout(this, 1));
        this.siteDataGUIBean = siteDataGUIBean;
        this.locs = new ArrayList();
        this.siteDataParams = new ArrayList();
        this.defaultSiteDataParams = new ParameterList();
        this.sitesList = new JList();
        this.sitesList.setSelectionMode(2);
        this.sitesList.setSelectedIndex(0);
        this.sitesList.addListSelectionListener(this);
        JScrollPane listScroller = new JScrollPane(this.sitesList);
        listScroller.setPreferredSize(new Dimension(250, 650));
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add((Component)new JLabel("Sites"), "North");
        northPanel.add((Component)listScroller, "Center");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        JPanel leftButtonPanel = new JPanel();
        JPanel rightButtonPanel = new JPanel();
        leftButtonPanel.setLayout(new BoxLayout(leftButtonPanel, 0));
        rightButtonPanel.setLayout(new BoxLayout(rightButtonPanel, 0));
        rightButtonPanel.add((Component)this.editSiteButton, "East");
        rightButtonPanel.add((Component)this.importSitesButton, "East");
        rightButtonPanel.add((Component)this.exportSitesButton, "East");
        leftButtonPanel.add(this.addSiteButton);
        leftButtonPanel.add(this.removeSiteButton);
        buttonPanel.add((Component)leftButtonPanel, "West");
        buttonPanel.add((Component)rightButtonPanel, "East");
        this.removeSiteButton.setEnabled(false);
        this.addSiteButton.addActionListener(this);
        this.removeSiteButton.addActionListener(this);
        this.editSiteButton.addActionListener(this);
        this.importSitesButton.addActionListener(this);
        this.exportSitesButton.addActionListener(this);
        northPanel.add((Component)buttonPanel, "South");
        this.siteDataList = new JList();
        this.siteDataList.setSelectionMode(2);
        this.siteDataList.setSelectedIndex(0);
        this.siteDataList.addListSelectionListener(this);
        JScrollPane dataListScroller = new JScrollPane(this.siteDataList);
        dataListScroller.setPreferredSize(new Dimension(250, 150));
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add((Component)new JLabel("Site Data Values"), "North");
        southPanel.add((Component)dataListScroller, "Center");
        JPanel dataButtonPanel = new JPanel();
        dataButtonPanel.setLayout(new BoxLayout(dataButtonPanel, 0));
        southPanel.add((Component)dataButtonPanel, "South");
        this.rebuildSiteList();
        this.add(northPanel);
        this.add(southPanel);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource().equals(this.sitesList)) {
            this.rebuildSiteDataList();
        }
    }

    private void checkEnableRemoveSite() {
        this.removeSiteButton.setEnabled(!this.sitesList.isSelectionEmpty());
    }

    private void checkEnableEditSite() {
        this.editSiteButton.setEnabled(!this.sitesList.isSelectionEmpty());
    }

    private void checkEnableExportSite() {
        this.exportSitesButton.setEnabled(!this.locs.isEmpty());
    }

    private void replaceSite(int index, Location loc, ParameterList params) {
        this.locs.set(index, loc);
        this.siteDataParams.set(index, params);
        this.rebuildSiteList();
    }

    protected void addSite(Location loc, ParameterList params) {
        this.locs.add(loc);
        this.siteDataParams.add(params);
        this.rebuildSiteList();
    }

    public void clear() {
        this.locs.clear();
        this.siteDataParams.clear();
        this.rebuildSiteList();
    }

    private void removeSite(int i) {
        this.locs.remove(i);
        this.siteDataParams.remove(i);
        this.rebuildSiteList();
    }

    private void removeSite(int[] indices) {
        Arrays.sort(indices);
        for (int i = indices.length - 1; i >= 0; --i) {
            this.locs.remove(i);
            this.siteDataParams.remove(i);
        }
        this.rebuildSiteList();
    }

    private void rebuildSiteList() {
        String[] data = new String[this.locs.size()];
        for (int i = 0; i < this.locs.size(); ++i) {
            Location loc = this.locs.get(i);
            data[i] = i + 1 + ". " + loc.getLatitude() + ", " + loc.getLongitude();
        }
        this.sitesList.setListData(data);
        this.checkEnableRemoveSite();
        this.checkEnableEditSite();
        this.checkEnableExportSite();
        this.rebuildSiteDataList();
        this.validate();
    }

    private int getSingleSelectedIndex() {
        int[] selection = this.sitesList.getSelectedIndices();
        if (selection.length > 1) {
            return -1;
        }
        return selection[0];
    }

    public void rebuildSiteDataList() {
        if (this.sitesList.isSelectionEmpty()) {
            String[] data = new String[]{"(no site(s) selected)"};
            this.siteDataList.setListData(data);
            return;
        }
        int index = this.getSingleSelectedIndex();
        if (index < 0) {
            String[] data = new String[]{"(multiple selected)"};
            this.siteDataList.setListData(data);
            return;
        }
        ParameterList params = this.siteDataParams.get(index);
        String[] data = new String[params.size()];
        int i = 0;
        for (Parameter<?> param : params) {
            data[i] = SitesPanel.getDataListString(i++, param);
        }
        this.siteDataList.setListData(data);
        this.checkEnableRemoveSite();
        this.checkEnableEditSite();
        this.checkEnableExportSite();
    }

    public static String getDataListString(int index, Parameter<?> param) {
        return index + 1 + ". " + param.getName() + ": " + String.valueOf(param.getValue());
    }

    private int promptNewSite(AddSitePanel siteAdd, Location exception) {
        int selection = JOptionPane.showConfirmDialog(this, siteAdd, "Add Site", 2);
        if (selection == 0) {
            boolean allowDuplicateSite;
            Location loc = siteAdd.getSiteLocation();
            boolean bl = allowDuplicateSite = exception != null && exception.getLongitude() == loc.getLongitude() && exception.getLatitude() == loc.getLatitude();
            if (!allowDuplicateSite && this.locs.contains(loc)) {
                JOptionPane.showMessageDialog(this, "Site with coordinates (" + loc.getLatitude() + ", " + loc.getLongitude() + ") already exists", "Cannot add site", 0);
                return this.promptNewSite(siteAdd, exception);
            }
        }
        return selection;
    }

    private int promptNewSite(AddSitePanel siteAdd) {
        return this.promptNewSite(siteAdd, null);
    }

    private void importSites() {
        if (this.imp == null) {
            this.imp = new SiteImporterPanel(this.defaultSiteDataParams, this.siteDataGUIBean.getProviderList());
        } else {
            this.imp.setDefaultSiteDataParams(this.defaultSiteDataParams);
        }
        int selection = JOptionPane.showConfirmDialog(this, this.imp, "Import Sites", 2);
        if (selection == 0) {
            File file = this.imp.getSelectedFile();
            if (file.exists()) {
                try {
                    this.imp.importFile(file);
                    ArrayList<Location> importedLocs = this.imp.getLocs();
                    ArrayList<ParameterList> importedVals = this.imp.getSiteData();
                    for (int i = 0; i < importedLocs.size(); ++i) {
                        Location impLoc = importedLocs.get(i);
                        ParameterList impVals = importedVals.get(i);
                        if (this.locs.contains(impLoc)) {
                            this.replaceSite(this.locs.indexOf(impLoc), impLoc, impVals);
                            continue;
                        }
                        this.locs.add(impLoc);
                        this.siteDataParams.add(impVals);
                    }
                    this.rebuildSiteList();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    JOptionPane.showMessageDialog(this, "I/O error reading file!", "I/O error reading file!", 0);
                }
                catch (ParseException e1) {
                    e1.printStackTrace();
                    JOptionPane.showMessageDialog(this, e1.getMessage(), "Error Parsing File", 0);
                }
                catch (NumberFormatException e1) {
                    e1.printStackTrace();
                    JOptionPane.showMessageDialog(this, e1.getMessage(), "Error Parsing Number", 0);
                }
                catch (InvalidRangeException e1) {
                    e1.printStackTrace();
                    JOptionPane.showMessageDialog(this, e1.getMessage(), "Invalid location", 0);
                }
            } else {
                JOptionPane.showMessageDialog(this, "File '" + file.getPath() + "' doesn't exist!", "File Not Found", 0);
            }
        }
    }

    private void exportSites() {
        if (this.exp == null) {
            this.exp = new SiteExporterPanel(this.locs, this.siteDataParams);
        } else {
            this.exp.updateSiteData(this.locs, this.siteDataParams);
        }
        int selection = JOptionPane.showConfirmDialog(this, this.exp, "Export Sites", 2);
        if (selection == 0) {
            try {
                this.exp.exportFile();
            }
            catch (IOException e1) {
                e1.printStackTrace();
                JOptionPane.showMessageDialog(this, "I/O error reading file!", "I/O error reading file!", 0);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        OrderedSiteDataProviderList providers = this.siteDataGUIBean.getProviderList();
        if (e.getSource().equals(this.addSiteButton)) {
            if (this.defaultSiteDataParams.isEmpty()) {
                JOptionPane.showMessageDialog(this, "Must have at least 1 IMR selected to add sites", "Cannot add site", 0);
                return;
            }
            ParameterList params = (ParameterList)this.defaultSiteDataParams.clone();
            AddSitePanel siteAdd = new AddSitePanel(params, providers);
            int selection = this.promptNewSite(siteAdd);
            if (selection == 0) {
                Location loc = siteAdd.getSiteLocation();
                System.out.println("Adding site: " + String.valueOf(loc) + " (" + params.size() + " vals)");
                this.addSite(loc, params);
                this.rebuildSiteDataList();
            }
        } else if (e.getSource().equals(this.removeSiteButton)) {
            int[] indices = this.sitesList.getSelectedIndices();
            this.removeSite(indices);
        } else if (e.getSource().equals(this.editSiteButton)) {
            int siteIndex = this.sitesList.getSelectedIndex();
            ParameterList params = this.siteDataParams.get(siteIndex);
            AddSitePanel siteAdd = new AddSitePanel(params, providers, this.locs.get(siteIndex));
            int selection = this.promptNewSite(siteAdd, this.locs.get(siteIndex));
            if (selection == 0) {
                Location loc = siteAdd.getSiteLocation();
                System.out.println("Editing site: " + String.valueOf(loc) + " (" + params.size() + " vals)");
                this.replaceSite(siteIndex, loc, params);
                this.rebuildSiteDataList();
            }
        } else if (e.getSource().equals(this.importSitesButton)) {
            if (this.defaultSiteDataParams.isEmpty()) {
                JOptionPane.showMessageDialog(this, "Must have at least 1 IMR selected to import sites", "Cannot import sites", 0);
                return;
            }
            this.importSites();
        } else if (e.getSource().equals(this.exportSitesButton)) {
            this.exportSites();
        }
    }

    private ParameterList updateSiteDataParams(List<ScalarIMR> imrs, ParameterList params) {
        ParameterList oldParams = (ParameterList)params.clone();
        ParameterList newParams = ParameterList.union((ParameterList[])imrs.stream().map(IntensityMeasureRelationship::getSiteParams).toArray(ParameterList[]::new));
        for (Parameter<?> oldParam : oldParams) {
            if (!newParams.containsParameter(oldParam)) continue;
            newParams.setValue(oldParam.getName(), oldParam.getValue());
        }
        return newParams;
    }

    private List<String> getSiteDataTypes() {
        ArrayList<String> supportedTypes = new ArrayList<String>();
        for (Parameter<?> param : this.defaultSiteDataParams) {
            supportedTypes.add(param.getName());
        }
        return supportedTypes;
    }

    public void updateSiteDataParams(List<ScalarIMR> imrs) {
        List<String> invalidatedSiteDataTypes = this.getSiteDataTypes();
        System.out.println(invalidatedSiteDataTypes);
        this.defaultSiteDataParams = this.updateSiteDataParams(imrs, this.defaultSiteDataParams);
        List<String> newSiteDataTypes = this.getSiteDataTypes();
        invalidatedSiteDataTypes.removeAll(newSiteDataTypes);
        ArrayList<ParameterList> newSiteDataParams = new ArrayList<ParameterList>();
        for (ParameterList params : this.siteDataParams) {
            newSiteDataParams.add(this.updateSiteDataParams(imrs, params));
        }
        this.siteDataParams = newSiteDataParams;
        if (!invalidatedSiteDataTypes.isEmpty()) {
            JOptionPane.showMessageDialog(this, "The following site data parameters were previously set and have been removed across all sites added so far.\nRemoved Site Data Types: " + String.join((CharSequence)",", invalidatedSiteDataTypes) + "\nSite data parameters are generated from the selected IMRs. To avoid this in the future, select all desired IMRs before adding sites.", "Site Data Parameter Removal", 1);
        }
        this.rebuildSiteDataList();
    }

    public ArrayList<Location> getLocs() {
        return this.locs;
    }

    public ArrayList<ParameterList> getSiteDataParams() {
        return this.siteDataParams;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(400, 600);
        ArrayList params = new ArrayList();
        params.add(new WillsMap2000());
        OrderedSiteDataProviderList providers = new OrderedSiteDataProviderList(params);
        SitesPanel sites = new SitesPanel(new OrderedSiteDataGUIBean(providers));
        sites.addSite(new Location(34.0, -118.0), null);
        frame.setContentPane(sites);
        frame.setVisible(true);
    }
}

