/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.IM_EventSet.outputImpl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.opensha.commons.util.FileUtils;
import org.opensha.sha.calc.IM_EventSet.IM_EventSetOutputWriter;

public class HAZ01ASegment {
    private String erf;
    private int siteID;
    private String imr;
    private String imt;
    private ArrayList<Integer> sourceIDs = null;
    private ArrayList<Integer> rupIDs = null;
    private ArrayList<Double> vs30Vals = null;
    private ArrayList<Double> distVals = null;
    private ArrayList<Double> meanVals = null;
    private ArrayList<Double> stdDevVals = null;
    private ArrayList<Double> interStdDevVals = null;
    private boolean listsInitialized = false;

    public HAZ01ASegment(String erf, int siteID, String imr, String imt) {
        this.erf = erf;
        this.siteID = siteID;
        this.imr = imr;
        this.imt = imt;
    }

    public String getErf() {
        return this.erf;
    }

    public int getSiteID() {
        return this.siteID;
    }

    public String getIMR() {
        return this.imr;
    }

    public String getIMT() {
        return this.imt;
    }

    public Double getVs30Val(int i) {
        return this.vs30Vals.get(i);
    }

    public Double getDistVal(int i) {
        return this.distVals.get(i);
    }

    public Double getMeanVal(int i) {
        return this.meanVals.get(i);
    }

    public Double getStdDevVal(int i) {
        return this.stdDevVals.get(i);
    }

    public Double getInterStdDevVal(int i) {
        return this.interStdDevVals.get(i);
    }

    public Integer getSourceID(int i) {
        return this.sourceIDs.get(i);
    }

    public Integer getRupID(int i) {
        return this.rupIDs.get(i);
    }

    public int size() {
        return this.sourceIDs.size();
    }

    public void addRecord(int sourceID, int rupID, double vs30, double dist, double mean, double stdDev, double interStdDev) {
        if (!this.listsInitialized) {
            this.sourceIDs = new ArrayList();
            this.rupIDs = new ArrayList();
            this.vs30Vals = new ArrayList();
            this.distVals = new ArrayList();
            this.meanVals = new ArrayList();
            this.stdDevVals = new ArrayList();
            this.interStdDevVals = new ArrayList();
            this.listsInitialized = true;
        }
        this.sourceIDs.add(sourceID);
        this.rupIDs.add(rupID);
        this.vs30Vals.add(vs30);
        this.distVals.add(dist);
        this.meanVals.add(mean);
        this.stdDevVals.add(stdDev);
        this.interStdDevVals.add(interStdDev);
    }

    public String getLine(int lineID, int i) {
        return this.getLine(lineID, this.sourceIDs.get(i), this.rupIDs.get(i), this.vs30Vals.get(i), this.distVals.get(i), this.meanVals.get(i), this.stdDevVals.get(i), this.interStdDevVals.get(i));
    }

    public String getLine(int lineID, int sourceID, int rupID, double vs30, double dist, double mean, double stdDev, double interStdDev) {
        String line = lineID + "," + this.erf + "," + sourceID + "," + rupID + "," + this.imr;
        line = line + "," + this.siteID + "," + vs30 + "," + IM_EventSetOutputWriter.distFormat.format(dist) + "," + this.imt;
        line = line + "," + IM_EventSetOutputWriter.meanSigmaFormat.format(mean) + "," + IM_EventSetOutputWriter.meanSigmaFormat.format(stdDev) + "," + IM_EventSetOutputWriter.meanSigmaFormat.format(interStdDev);
        return line;
    }

    public static ArrayList<HAZ01ASegment> loadHAZ01A(String file) throws FileNotFoundException, IOException {
        ArrayList<String> lines = FileUtils.loadFile(file);
        String curERF = "";
        String curIMR = "";
        int curSite = -1;
        String curIMT = "";
        HAZ01ASegment curSeg = null;
        ArrayList<HAZ01ASegment> segs = new ArrayList<HAZ01ASegment>();
        for (int i = 2; i < lines.size(); ++i) {
            String line = lines.get(i);
            StringTokenizer tok = new StringTokenizer(line, ",");
            tok.nextToken();
            String erf = tok.nextToken();
            int sourceID = Integer.parseInt(tok.nextToken());
            int rupID = Integer.parseInt(tok.nextToken());
            String imr = tok.nextToken();
            int site = Integer.parseInt(tok.nextToken());
            double vs30 = Double.parseDouble(tok.nextToken());
            double dist = Double.parseDouble(tok.nextToken());
            String imt = tok.nextToken();
            double mean = Double.parseDouble(tok.nextToken());
            double stdDev = Double.parseDouble(tok.nextToken());
            double interStdDev = Double.parseDouble(tok.nextToken());
            boolean newSec = false;
            if (!erf.equals(curERF)) {
                newSec = true;
                curERF = erf;
            }
            if (!imr.equals(curIMR)) {
                newSec = true;
                curIMR = imr;
            }
            if (!imt.equals(curIMT)) {
                newSec = true;
                curIMT = imt;
            }
            if (curSite != site) {
                newSec = true;
                curSite = site;
            }
            if (newSec) {
                if (curSeg != null) {
                    segs.add(curSeg);
                }
                curSeg = new HAZ01ASegment(erf, site, imr, imt);
            }
            curSeg.addRecord(sourceID, rupID, vs30, dist, mean, stdDev, interStdDev);
        }
        if (curSeg != null) {
            segs.add(curSeg);
        }
        return segs;
    }
}

