/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc;

import java.util.List;
import java.util.ListIterator;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.param.ParameterList;
import org.opensha.sha.calc.AbstractCalculator;
import org.opensha.sha.calc.HazardCurveCalculator;
import org.opensha.sha.calc.SpectrumCalculatorAPI;
import org.opensha.sha.calc.params.filters.SourceFilter;
import org.opensha.sha.calc.params.filters.SourceFilterManager;
import org.opensha.sha.calc.params.filters.SourceFiltersParam;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.gui.infoTools.IMT_Info;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.ScalarIMR;

public class SpectrumCalculator
extends AbstractCalculator
implements SpectrumCalculatorAPI {
    private static final String C = "SpectrumCalculator";
    private static final boolean D = false;
    private SourceFilterManager sourceFilters;
    private SourceFiltersParam sourceFilterParam;
    private ParameterList adjustableParams;
    private int currRuptures = -1;
    private int totRuptures = 0;
    private int sourceIndex;
    private int numSources;

    public SpectrumCalculator() {
        this(SourceFiltersParam.getDefault());
    }

    public SpectrumCalculator(SourceFilterManager sourceFilters) {
        this.sourceFilters = sourceFilters;
        this.sourceFilterParam = new SourceFiltersParam(sourceFilters);
        this.adjustableParams = new ParameterList();
        this.adjustableParams.addParameter(this.sourceFilterParam);
    }

    @Override
    public ParameterList getAdjustableParams() {
        return this.adjustableParams;
    }

    @Override
    public void setAdjustableParams(ParameterList paramList) {
        this.adjustableParams = paramList;
        this.sourceFilterParam = (SourceFiltersParam)paramList.getParameter("Source Filters");
        this.sourceFilters = (SourceFilterManager)this.sourceFilterParam.getValue();
    }

    @Override
    public ListIterator getAdjustableParamsIterator() {
        return this.adjustableParams.getParametersIterator();
    }

    @Override
    public DiscretizedFunc getIML_SpectrumCurve(DiscretizedFunc spectrumFunction, Site site, ScalarIMR imr, ERF eqkRupForecast, double probVal, List supportedSA_Periods) {
        int j;
        this.signalReset();
        this.currRuptures = -1;
        boolean poissonSource = false;
        DiscretizedFunc tempSpecFunc = this.initDiscretizedValuesToLog(spectrumFunction, 1.0);
        int numSAPeriods = supportedSA_Periods.size();
        ArbitrarilyDiscretizedFunc[] hazFunction = new ArbitrarilyDiscretizedFunc[numSAPeriods];
        ArbitrarilyDiscretizedFunc[] sourceHazFunc = new ArbitrarilyDiscretizedFunc[numSAPeriods];
        for (int i = 0; i < numSAPeriods; ++i) {
            hazFunction[i] = tempSpecFunc.deepClone();
            sourceHazFunc[i] = tempSpecFunc.deepClone();
        }
        ArbitrarilyDiscretizedFunc condProbFunc = (ArbitrarilyDiscretizedFunc)tempSpecFunc.deepClone();
        ((AttenuationRelationship)imr).resetParameterEventListeners();
        int numPoints = tempSpecFunc.size();
        double maxDistance = this.sourceFilters.getMaxDistance();
        List<SourceFilter> filters = this.sourceFilters.getEnabledFilters();
        imr.setUserMaxDistance(maxDistance);
        this.numSources = eqkRupForecast.getNumSources();
        this.totRuptures = 0;
        this.sourceIndex = 0;
        this.sourceIndex = 0;
        while (this.sourceIndex < this.numSources) {
            this.totRuptures += eqkRupForecast.getSource(this.sourceIndex).getNumRuptures();
            ++this.sourceIndex;
        }
        this.currRuptures = 0;
        imr.setSite(site);
        boolean sourceUsed = false;
        this.sourceIndex = 0;
        while (this.sourceIndex < this.numSources) {
            if (this.isCancelled()) {
                return null;
            }
            ProbEqkSource source = eqkRupForecast.getSource(this.sourceIndex);
            double distance = source.getMinDistance(site);
            if (HazardCurveCalculator.canSkipSource(filters, source, site)) {
                this.currRuptures += source.getNumRuptures();
            } else {
                int k;
                sourceUsed = true;
                poissonSource = source.isSourcePoissonian();
                if (!poissonSource) {
                    for (int m = 0; m < numSAPeriods; ++m) {
                        this.initDiscretizeValues(sourceHazFunc[m], 0.0);
                    }
                }
                int numRuptures = source.getNumRuptures();
                int n = 0;
                while (n < numRuptures) {
                    ProbEqkRupture rupture = source.getRupture(n);
                    double qkProb = rupture.getProbability();
                    if (qkProb != 0.0 && !HazardCurveCalculator.canSkipRupture(filters, rupture, site)) {
                        imr.setEqkRupture(rupture);
                        for (int saPeriodIndex = 0; saPeriodIndex < numSAPeriods; ++saPeriodIndex) {
                            imr.getParameter("SA Period").setValue(supportedSA_Periods.get(saPeriodIndex));
                            condProbFunc = (ArbitrarilyDiscretizedFunc)imr.getExceedProbabilities(condProbFunc);
                            if (poissonSource) {
                                if (Math.log(1.0 - qkProb) < -30.0) {
                                    throw new RuntimeException("Error: The probability for this ProbEqkRupture (" + qkProb + ") is too high for a Possion source (~infinite number of events)");
                                }
                                for (k = 0; k < numPoints; ++k) {
                                    hazFunction[saPeriodIndex].set(k, hazFunction[saPeriodIndex].getY(k) * Math.pow(1.0 - qkProb, condProbFunc.getY(k)));
                                }
                                continue;
                            }
                            for (k = 0; k < numPoints; ++k) {
                                sourceHazFunc[saPeriodIndex].set(k, sourceHazFunc[saPeriodIndex].getY(k) + qkProb * condProbFunc.getY(k));
                            }
                        }
                    }
                    ++n;
                    ++this.currRuptures;
                }
                if (!poissonSource) {
                    for (int i = 0; i < numSAPeriods; ++i) {
                        for (k = 0; k < numPoints; ++k) {
                            hazFunction[i].set(k, hazFunction[i].getY(k) * (1.0 - sourceHazFunc[i].getY(k)));
                        }
                    }
                }
            }
            ++this.sourceIndex;
        }
        if (sourceUsed) {
            for (j = 0; j < numSAPeriods; ++j) {
                for (int i = 0; i < numPoints; ++i) {
                    hazFunction[j].set(i, 1.0 - hazFunction[j].getY(i));
                }
            }
        } else {
            for (j = 0; j < numSAPeriods; ++j) {
                for (int i = 0; i < numPoints; ++i) {
                    hazFunction[j].set(i, 0.0);
                }
            }
        }
        ArbitrarilyDiscretizedFunc[] tempHazFunction = new ArbitrarilyDiscretizedFunc[numSAPeriods];
        for (int j2 = 0; j2 < numSAPeriods; ++j2) {
            tempHazFunction[j2] = new ArbitrarilyDiscretizedFunc();
            for (int i = 0; i < numPoints; ++i) {
                tempHazFunction[j2].set(spectrumFunction.getX(i), hazFunction[j2].getY(i));
            }
        }
        ArbitrarilyDiscretizedFunc imlSpectrumFunction = new ArbitrarilyDiscretizedFunc();
        for (int j3 = 0; j3 < numSAPeriods; ++j3) {
            double val = tempHazFunction[j3].getFirstInterpolatedX_inLogXLogYDomain(probVal);
            imlSpectrumFunction.set((Double)supportedSA_Periods.get(j3), val);
        }
        return imlSpectrumFunction;
    }

    private void initDiscretizeValues(DiscretizedFunc arb, double val) {
        int num = arb.size();
        for (int i = 0; i < num; ++i) {
            arb.set(i, val);
        }
    }

    private DiscretizedFunc initDiscretizedValuesToLog(DiscretizedFunc linearFunc, double val) {
        ArbitrarilyDiscretizedFunc toXLogFunc = new ArbitrarilyDiscretizedFunc();
        if (IMT_Info.isIMT_LogNormalDist("SA")) {
            for (int i = 0; i < linearFunc.size(); ++i) {
                toXLogFunc.set(Math.log(linearFunc.getX(i)), val);
            }
        }
        return toXLogFunc;
    }

    @Override
    public DiscretizedFunc getSpectrumCurve(Site site, ScalarIMR imr, ERF eqkRupForecast, double imlVal, List supportedSA_Periods) {
        this.signalReset();
        ArbitrarilyDiscretizedFunc hazFunction = new ArbitrarilyDiscretizedFunc();
        this.initDiscretizeValues(hazFunction, supportedSA_Periods, 1.0);
        int numPoints = hazFunction.size();
        this.currRuptures = -1;
        boolean poissonSource = false;
        ((AttenuationRelationship)imr).resetParameterEventListeners();
        double maxDistance = this.sourceFilters.getMaxDistance();
        List<SourceFilter> filters = this.sourceFilters.getEnabledFilters();
        imr.setUserMaxDistance(maxDistance);
        ArbitrarilyDiscretizedFunc sourceHazFunc = new ArbitrarilyDiscretizedFunc();
        this.initDiscretizeValues(sourceHazFunc, supportedSA_Periods, 0.0);
        this.numSources = eqkRupForecast.getNumSources();
        this.totRuptures = 0;
        this.sourceIndex = 0;
        this.sourceIndex = 0;
        while (this.sourceIndex < this.numSources) {
            this.totRuptures += eqkRupForecast.getSource(this.sourceIndex).getNumRuptures();
            ++this.sourceIndex;
        }
        this.currRuptures = 0;
        imr.setSite(site);
        boolean sourceUsed = false;
        this.sourceIndex = 0;
        while (this.sourceIndex < this.numSources) {
            if (this.isCancelled()) {
                return null;
            }
            ProbEqkSource source = eqkRupForecast.getSource(this.sourceIndex);
            double distance = source.getMinDistance(site);
            if (HazardCurveCalculator.canSkipSource(filters, source, site)) {
                this.currRuptures += source.getNumRuptures();
            } else {
                int k;
                sourceUsed = true;
                poissonSource = source.isSourcePoissonian();
                int numRuptures = source.getNumRuptures();
                int n = 0;
                while (n < numRuptures) {
                    ProbEqkRupture rupture = source.getRupture(n);
                    double qkProb = rupture.getProbability();
                    if (qkProb != 0.0 && !HazardCurveCalculator.canSkipRupture(filters, rupture, site)) {
                        imr.setEqkRupture(rupture);
                        DiscretizedFunc condProbFunc = null;
                        condProbFunc = imr.getSA_ExceedProbSpectrum(Math.log(imlVal));
                        if (poissonSource) {
                            if (Math.log(1.0 - qkProb) < -30.0) {
                                throw new RuntimeException("Error: The probability for this ProbEqkRupture (" + qkProb + ") is too high for a Possion source (~infinite number of events)");
                            }
                            for (k = 0; k < numPoints; ++k) {
                                hazFunction.set(k, hazFunction.getY(k) * Math.pow(1.0 - qkProb, condProbFunc.getY(k)));
                            }
                        } else {
                            for (k = 0; k < numPoints; ++k) {
                                sourceHazFunc.set(k, sourceHazFunc.getY(k) + qkProb * condProbFunc.getY(k));
                            }
                        }
                    }
                    ++n;
                    ++this.currRuptures;
                }
                if (!poissonSource) {
                    for (k = 0; k < numPoints; ++k) {
                        hazFunction.set(k, hazFunction.getY(k) * (1.0 - sourceHazFunc.getY(k)));
                    }
                }
            }
            ++this.sourceIndex;
        }
        if (sourceUsed) {
            for (int i = 0; i < numPoints; ++i) {
                hazFunction.set(i, 1.0 - hazFunction.getY(i));
            }
        } else {
            for (int i = 0; i < numPoints; ++i) {
                hazFunction.set(i, 0.0);
            }
        }
        return hazFunction;
    }

    @Override
    public int getCurrRuptures() {
        return this.currRuptures;
    }

    @Override
    public int getTotRuptures() {
        return this.totRuptures;
    }

    private void initDiscretizeValues(DiscretizedFunc arb, List supportedSA_Periods, double val) {
        int num = supportedSA_Periods.size();
        for (int i = 0; i < num; ++i) {
            arb.set((Double)supportedSA_Periods.get(i), val);
        }
    }

    @Override
    public DiscretizedFunc getDeterministicSpectrumCurve(Site site, ScalarIMR imr, EqkRupture rupture, boolean probAtIML, double imlProbVal) {
        ((AttenuationRelationship)imr).resetParameterEventListeners();
        imr.setSite(site);
        imr.setEqkRupture(rupture);
        DiscretizedFunc hazFunction = null;
        if (probAtIML) {
            hazFunction = imr.getSA_ExceedProbSpectrum(Math.log(imlProbVal));
        } else {
            hazFunction = imr.getSA_IML_AtExceedProbSpectrum(imlProbVal);
            int numPoints = hazFunction.size();
            for (int i = 0; i < numPoints; ++i) {
                hazFunction.set(i, Math.exp(hazFunction.getY(i)));
            }
        }
        return hazFunction;
    }

    @Override
    protected boolean isCancelled() {
        boolean cancelled = super.isCancelled();
        return cancelled;
    }
}

