/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.disaggregation;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.LightFixedXFunc;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.mapping.gmt.GMT_MapGenerator;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.WarningParameter;
import org.opensha.commons.util.ServerPrefUtils;
import org.opensha.sha.calc.AbstractCalculator;
import org.opensha.sha.calc.HazardCurveCalculator;
import org.opensha.sha.calc.disaggregation.DisaggregationCalculatorAPI;
import org.opensha.sha.calc.disaggregation.DisaggregationPlotData;
import org.opensha.sha.calc.disaggregation.DisaggregationSourceRuptureComparator;
import org.opensha.sha.calc.disaggregation.DisaggregationSourceRuptureInfo;
import org.opensha.sha.calc.params.NonSupportedTRT_OptionsParam;
import org.opensha.sha.calc.params.SetTRTinIMR_FromSourceParam;
import org.opensha.sha.calc.params.filters.FixedDistanceCutoffFilter;
import org.opensha.sha.calc.params.filters.MagDependentDistCutoffFilter;
import org.opensha.sha.calc.params.filters.SourceFilter;
import org.opensha.sha.calc.params.filters.TectonicRegionDistCutoffFilter;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceRupParameter;
import org.opensha.sha.util.TRTUtils;
import org.opensha.sha.util.TectonicRegionType;

public class DisaggregationCalculator
extends AbstractCalculator
implements DisaggregationCalculatorAPI {
    private static final long serialVersionUID = 1L;
    private static final String C = "DisaggregationCalculator";
    private static final boolean D = false;
    private boolean storeRupProbEpsilons = false;
    private double[][][] rupProbEpsilons;
    private static final String OPENSHA_SERVLET_URL = ServerPrefUtils.SERVER_PREFS.getServletBaseURL() + "DisaggregationPlotServlet";
    private double[] mag_center;
    private double[] mag_binEdges;
    private double[] dist_center;
    private double[] dist_binEdges;
    private int NUM_E = EpsilonCategories.values().length;
    private double[][][] pdf3D;
    private double maxContrEpsilonForDisaggrPlot;
    private double maxContrEpsilonForGMT_Plot;
    private int iMag;
    private int iDist;
    private int iEpsilon;
    private double mag;
    private double dist;
    private double epsilon;
    private boolean withinBounds;
    private double Mbar;
    private double Dbar;
    private double Ebar;
    private int M_index_mode3D;
    private int D_index_mode3D;
    private String epsilonRangeString;
    private double totalRate;
    private double outOfBoundsRate;
    private int currRuptures = -1;
    private int totRuptures = 0;
    private int numSourcesToShow = 0;
    private boolean showDistances = true;
    private String sourceDisaggInfo;
    private List<DisaggregationSourceRuptureInfo> disaggSourceList;
    private String consolidatedSourceDisaggInfo;
    private List<DisaggregationSourceRuptureInfo> consolidatedDisaggSourceList;
    private boolean calcSourceExceedances = false;
    private DiscretizedFunc exceedXVals = null;
    public static final String DISAGGREGATION_PLOT_NAME = "DisaggregationPlot";
    public static final String DISAGGREGATION_PLOT_JPG_NAME = "DisaggregationPlot.jpg";
    public static final String DISAGGREGATION_PLOT_PNG_NAME = "DisaggregationPlot.png";
    public static final String DISAGGREGATION_PLOT_PDF_NAME = "DisaggregationPlot.pdf";
    private String disaggregationPlotImgWebAddr;
    static String[] epsilonColors = new String[EpsilonCategories.values().length];

    public DisaggregationCalculator() {
        this.setMagRange(5.0, 9, 0.5);
        this.setDistanceRange(5.0, 11, 10.0);
    }

    public static ParameterList getDefaultParams() {
        ParameterList disaggParams = new HazardCurveCalculator().getAdjustableParams();
        return disaggParams;
    }

    @Override
    public boolean disaggregate(double iml, Site site, ScalarIMR imr, ERF eqkRupForecast, Collection<SourceFilter> sourceFilters, ParameterList calcParams) {
        return this.disaggregate(iml, site, TRTUtils.wrapInHashMap(imr), eqkRupForecast, sourceFilters, calcParams);
    }

    @Override
    public boolean disaggregate(double iml, Site site, Map<TectonicRegionType, ScalarIMR> imrMap, ERF eqkRupForecast, Collection<SourceFilter> sourceFilters, ParameterList calcParams) {
        this.signalReset();
        if (Double.isInfinite(iml) || Double.isNaN(iml)) {
            this.currRuptures = 0;
            this.totRuptures = 0;
            return false;
        }
        SetTRTinIMR_FromSourceParam setTRTinIMR_FromSourceParam = (SetTRTinIMR_FromSourceParam)calcParams.getParameter("Set TRT From Source?");
        NonSupportedTRT_OptionsParam nonSupportedTRT_OptionsParam = (NonSupportedTRT_OptionsParam)calcParams.getParameter("If source TRT not supported by IMR");
        DecimalFormat f1 = new DecimalFormat("000000");
        DecimalFormat f2 = new DecimalFormat("00.00");
        this.pdf3D = new double[this.dist_center.length][this.mag_center.length][this.NUM_E];
        DistanceRupParameter distRup = new DistanceRupParameter();
        String S = "DisaggregationCalculator: disaggregate(): ";
        this.disaggSourceList = new ArrayList<DisaggregationSourceRuptureInfo>();
        this.sourceDisaggInfo = null;
        this.consolidatedDisaggSourceList = null;
        this.consolidatedSourceDisaggInfo = null;
        if (sourceFilters != null && !sourceFilters.isEmpty()) {
            double maxDist = Double.POSITIVE_INFINITY;
            for (SourceFilter filter : sourceFilters) {
                if (filter instanceof FixedDistanceCutoffFilter) {
                    maxDist = Math.min(maxDist, ((FixedDistanceCutoffFilter)filter).getMaxDistance());
                }
                if (filter instanceof MagDependentDistCutoffFilter) {
                    maxDist = Math.min(maxDist, ((MagDependentDistCutoffFilter)filter).getMagDistFunc().getMaxX());
                }
                if (!(filter instanceof TectonicRegionDistCutoffFilter)) continue;
                maxDist = Math.min(maxDist, ((TectonicRegionDistCutoffFilter)filter).getCutoffs().getLargestCutoffDist());
            }
            for (ScalarIMR imr : imrMap.values()) {
                imr.setUserMaxDistance(maxDist);
            }
        }
        for (ScalarIMR imr : imrMap.values()) {
            Parameter im = imr.getIntensityMeasure();
            if (im instanceof WarningParameter) {
                WarningParameter warnIM = (WarningParameter)im;
                warnIM.setValueIgnoreWarning(iml);
                continue;
            }
            im.setValue(iml);
        }
        int numSources = eqkRupForecast.getNumSources();
        if (this.storeRupProbEpsilons) {
            this.rupProbEpsilons = new double[numSources][][];
        }
        this.totRuptures = 0;
        for (int i = 0; i < numSources; ++i) {
            this.totRuptures += eqkRupForecast.getSource(i).getNumRuptures();
        }
        this.currRuptures = 0;
        for (ScalarIMR imr : imrMap.values()) {
            try {
                imr.setSite(site);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.Ebar = 0.0;
        this.Mbar = 0.0;
        this.Dbar = 0.0;
        this.totalRate = 0.0;
        this.outOfBoundsRate = 0.0;
        for (int i = 0; i < this.dist_center.length; ++i) {
            for (int j = 0; j < this.mag_center.length; ++j) {
                for (int k = 0; k < this.NUM_E; ++k) {
                    this.pdf3D[i][j][k] = 0.0;
                }
            }
        }
        int numRupRejected = 0;
        boolean setTRTinIMR_FromSource = (Boolean)setTRTinIMR_FromSourceParam.getValue();
        HashMap<ScalarIMR, TectonicRegionType> trtDefaults = null;
        if (setTRTinIMR_FromSource) {
            trtDefaults = TRTUtils.getTRTsSetInIMRs(imrMap);
        }
        LightFixedXFunc condProbFunc = null;
        if (this.calcSourceExceedances) {
            Preconditions.checkNotNull((Object)this.exceedXVals);
            condProbFunc = new LightFixedXFunc(this.exceedXVals);
        }
        for (int i = 0; i < numSources; ++i) {
            if (this.isCancelled()) {
                return false;
            }
            double sourceRate = 0.0;
            ProbEqkSource source = eqkRupForecast.getSource(i);
            String sourceName = source.getName();
            int numRuptures = eqkRupForecast.getNumRuptures(i);
            if (this.storeRupProbEpsilons) {
                this.rupProbEpsilons[i] = new double[numRuptures][2];
            }
            if (HazardCurveCalculator.canSkipSource(sourceFilters, source, site)) {
                this.currRuptures += numRuptures;
                continue;
            }
            TectonicRegionType trt = source.getTectonicRegionType();
            ScalarIMR imr = TRTUtils.getIMRforTRT(imrMap, trt);
            if (setTRTinIMR_FromSource) {
                TRTUtils.setTRTinIMR(imr, trt, nonSupportedTRT_OptionsParam, trtDefaults.get(imr));
            }
            XY_DataSet sourceHazFunc = null;
            boolean poissonSource = source.isPoissonianSource();
            if (this.calcSourceExceedances) {
                double[] xVals = new double[this.exceedXVals.size()];
                double[] yVals = new double[this.exceedXVals.size()];
                for (int x = 0; x < xVals.length; ++x) {
                    xVals[x] = this.exceedXVals.getX(x);
                    yVals[x] = poissonSource ? 1.0 : 0.0;
                }
                sourceHazFunc = new LightFixedXFunc(xVals, yVals);
            }
            int n = 0;
            while (n < numRuptures) {
                ProbEqkRupture rupture = source.getRupture(n);
                double qkProb = rupture.getProbability();
                if (HazardCurveCalculator.canSkipRupture(sourceFilters, rupture, site)) {
                    ++numRupRejected;
                } else {
                    imr.setEqkRupture(rupture);
                    double condProb = imr.getExceedProbability(iml);
                    if (condProb == 0.0) {
                        // empty if block
                    }
                    this.epsilon = imr.getEpsilon();
                    distRup.setValue(rupture, site);
                    this.dist = (Double)distRup.getValue();
                    this.mag = rupture.getMag();
                    double rate = -condProb * Math.log(1.0 - qkProb);
                    if (this.storeRupProbEpsilons) {
                        this.rupProbEpsilons[i][n][0] = rate;
                        this.rupProbEpsilons[i][n][1] = this.epsilon;
                    }
                    if (this.calcSourceExceedances) {
                        int k;
                        imr.getExceedProbabilities(condProbFunc);
                        if (poissonSource) {
                            if (Math.log(1.0 - qkProb) < -30.0) {
                                throw new RuntimeException("Error: The probability for this ProbEqkRupture (" + qkProb + ") is too high for a Possion source (~infinite number of events)");
                            }
                            for (k = 0; k < condProbFunc.size(); ++k) {
                                sourceHazFunc.set(k, sourceHazFunc.getY(k) * Math.pow(1.0 - qkProb, condProbFunc.getY(k)));
                            }
                        } else {
                            for (k = 0; k < condProbFunc.size(); ++k) {
                                sourceHazFunc.set(k, sourceHazFunc.getY(k) + qkProb * condProbFunc.getY(k));
                            }
                        }
                    }
                    if (rate > 0.0) {
                        if (Double.isNaN(this.epsilon)) {
                            throw new IllegalStateException("Epsilon is " + this.epsilon + ", rate=" + rate + ", mean=" + imr.getMean() + ", stdDev=" + imr.getStdDev());
                        }
                        this.setIndices();
                        if (this.withinBounds) {
                            double[] dArray = this.pdf3D[this.iDist][this.iMag];
                            int n2 = this.iEpsilon;
                            dArray[n2] = dArray[n2] + rate;
                        } else {
                            this.outOfBoundsRate += rate;
                        }
                        this.totalRate += rate;
                        this.Mbar += rate * this.mag;
                        this.Dbar += rate * this.dist;
                        this.Ebar += rate * this.epsilon;
                        sourceRate += rate;
                    }
                }
                ++n;
                ++this.currRuptures;
            }
            if (this.calcSourceExceedances && poissonSource) {
                for (int k = 0; k < sourceHazFunc.size(); ++k) {
                    sourceHazFunc.set(k, 1.0 - sourceHazFunc.getY(k));
                }
            }
            DisaggregationSourceRuptureInfo disaggInfo = new DisaggregationSourceRuptureInfo(sourceName, sourceRate, i, source, (DiscretizedFunc)sourceHazFunc);
            this.disaggSourceList.add(disaggInfo);
        }
        if (trtDefaults != null) {
            TRTUtils.resetTRTsInIMRs(trtDefaults);
        }
        if (!(this.totalRate > 0.0)) {
            System.out.println("Disagg filed: totalRate: " + this.totalRate);
            return false;
        }
        DisaggregationSourceRuptureComparator srcRupComparator = new DisaggregationSourceRuptureComparator();
        Collections.sort(this.disaggSourceList, srcRupComparator);
        UnaryOperator<List<DisaggregationSourceRuptureInfo>> sourceConsolidator = eqkRupForecast.getDisaggSourceConsolidator();
        if (sourceConsolidator != null) {
            this.consolidatedDisaggSourceList = (List)sourceConsolidator.apply(this.disaggSourceList);
            Collections.sort(this.consolidatedDisaggSourceList, srcRupComparator);
        }
        if (this.numSourcesToShow > 0) {
            boolean[] blArray;
            if (sourceConsolidator == null) {
                boolean[] blArray2 = new boolean[1];
                blArray = blArray2;
                blArray2[0] = false;
            } else {
                boolean[] blArray3 = new boolean[2];
                blArray3[0] = false;
                blArray = blArray3;
                blArray3[1] = true;
            }
            boolean[] consolidates = blArray;
            for (Object consolidated : (ProbEqkSource)consolidates) {
                List<DisaggregationSourceRuptureInfo> disaggSourceList = consolidated != false ? this.consolidatedDisaggSourceList : this.disaggSourceList;
                Object sourceDisaggInfo = "Source#\t% Contribution\tTotExceedRate\tSourceName";
                if (this.showDistances) {
                    sourceDisaggInfo = (String)sourceDisaggInfo + "\tDistRup\tDistX\tDistSeis\tDistJB";
                }
                sourceDisaggInfo = (String)sourceDisaggInfo + "\n";
                int size = disaggSourceList.size();
                if (size > this.numSourcesToShow) {
                    size = this.numSourcesToShow;
                }
                for (int i = 0; i < size; ++i) {
                    DisaggregationSourceRuptureInfo disaggInfo = disaggSourceList.get(i);
                    sourceDisaggInfo = (String)sourceDisaggInfo + f1.format(disaggInfo.getId()) + "\t" + f2.format(100.0 * disaggInfo.getRate() / this.totalRate) + "\t" + (float)disaggInfo.getRate() + "\t" + disaggInfo.getName();
                    if (this.showDistances) {
                        try {
                            ProbEqkSource source = disaggInfo.getSource();
                            RuptureSurface surf = source.getSourceSurface();
                            sourceDisaggInfo = (String)sourceDisaggInfo + "\t" + f2.format(surf.getDistanceRup(site.getLocation())) + "\t" + f2.format(surf.getDistanceX(site.getLocation())) + "\t" + f2.format(surf.getDistanceSeis(site.getLocation())) + "\t" + f2.format(surf.getDistanceJB(site.getLocation()));
                        }
                        catch (Exception e) {
                            sourceDisaggInfo = (String)sourceDisaggInfo + "\t(no source surface information available, likely a background or consolidated source)";
                        }
                    }
                    sourceDisaggInfo = (String)sourceDisaggInfo + "\n";
                    if (consolidated != false) {
                        this.consolidatedSourceDisaggInfo = sourceDisaggInfo;
                        continue;
                    }
                    this.sourceDisaggInfo = sourceDisaggInfo;
                }
            }
        }
        this.Mbar /= this.totalRate;
        this.Dbar /= this.totalRate;
        this.Ebar /= this.totalRate;
        if (this.storeRupProbEpsilons) {
            for (int i = 0; i < numSources; ++i) {
                for (int j = 0; j < eqkRupForecast.getNumRuptures(i); ++j) {
                    this.rupProbEpsilons[i][j][0] = this.rupProbEpsilons[i][j][0] / this.totalRate;
                }
            }
        }
        this.maxContrEpsilonForDisaggrPlot = -1.0;
        int modeMagBin = -1;
        int modeDistBin = -1;
        int modeEpsilonBin = -1;
        double maxContrBinRate = -1.0;
        for (int i = 0; i < this.dist_center.length; ++i) {
            for (int j = 0; j < this.mag_center.length; ++j) {
                double contrEpsilonSum = 0.0;
                for (int k = 0; k < this.NUM_E; ++k) {
                    this.pdf3D[i][j][k] = this.pdf3D[i][j][k] / this.totalRate * 100.0;
                    contrEpsilonSum += this.pdf3D[i][j][k];
                    if (!(this.pdf3D[i][j][k] > maxContrBinRate)) continue;
                    maxContrBinRate = this.pdf3D[i][j][k];
                    modeDistBin = i;
                    modeMagBin = j;
                    modeEpsilonBin = k;
                }
                if (!(contrEpsilonSum > this.maxContrEpsilonForDisaggrPlot)) continue;
                this.maxContrEpsilonForDisaggrPlot = contrEpsilonSum;
            }
        }
        this.M_index_mode3D = modeMagBin;
        this.D_index_mode3D = modeDistBin;
        this.epsilonRangeString = this.getEpsilonRange(modeEpsilonBin);
        if (numRupRejected > 0) {
            System.out.println("numRupRejected=" + numRupRejected);
        }
        return true;
    }

    @Override
    public String getDisaggregationSourceInfo() {
        if (this.numSourcesToShow > 0) {
            return this.sourceDisaggInfo;
        }
        return "";
    }

    @Override
    public List<DisaggregationSourceRuptureInfo> getDisaggregationSourceList() {
        return this.disaggSourceList;
    }

    @Override
    public String getConsolidatedDisaggregationSourceInfo() {
        if (this.numSourcesToShow > 0 && this.consolidatedSourceDisaggInfo != null) {
            return this.consolidatedSourceDisaggInfo;
        }
        return "";
    }

    @Override
    public List<DisaggregationSourceRuptureInfo> getConsolidatedDisaggregationSourceList() {
        return this.consolidatedDisaggSourceList;
    }

    public void setCalculateSourceExceedanceCurves(DiscretizedFunc xValues) {
        this.calcSourceExceedances = xValues != null;
        this.exceedXVals = xValues;
    }

    public void setSkipCalculateSourceExceedanceCurves() {
        this.calcSourceExceedances = false;
        this.exceedXVals = null;
    }

    @Override
    public void setMagRange(double minMag, int numMags, double deltaMag) {
        this.mag_center = new double[numMags];
        this.mag_binEdges = new double[numMags + 1];
        this.mag_binEdges[0] = minMag - deltaMag / 2.0;
        for (int i = 0; i < numMags; ++i) {
            this.mag_center[i] = minMag + (double)i * deltaMag;
            this.mag_binEdges[i + 1] = this.mag_center[i] + deltaMag / 2.0;
        }
    }

    public void setMagRange(double[] magBinEdges) {
        this.mag_binEdges = magBinEdges;
        this.mag_center = new double[this.mag_binEdges.length - 1];
        for (int i = 0; i < this.mag_center.length; ++i) {
            this.mag_center[i] = (this.mag_binEdges[i] + this.mag_binEdges[i + 1]) / 2.0;
        }
    }

    @Override
    public void setDistanceRange(double minDist, int numDist, double deltaDist) {
        this.dist_center = new double[numDist];
        this.dist_binEdges = new double[numDist + 1];
        this.dist_binEdges[0] = minDist - deltaDist / 2.0;
        for (int i = 0; i < numDist; ++i) {
            this.dist_center[i] = minDist + (double)i * deltaDist;
            this.dist_binEdges[i + 1] = this.dist_center[i] + deltaDist / 2.0;
        }
    }

    @Override
    public void setDistanceRange(double[] distBinEdges) {
        this.dist_binEdges = distBinEdges;
        this.dist_center = new double[distBinEdges.length - 1];
        for (int i = 0; i < this.dist_center.length; ++i) {
            this.dist_center[i] = (distBinEdges[i] + distBinEdges[i + 1]) / 2.0;
        }
    }

    @Override
    public void setMaxZAxisForPlot(double zMax) {
        this.maxContrEpsilonForGMT_Plot = !Double.isNaN(zMax) ? zMax : this.maxContrEpsilonForDisaggrPlot;
    }

    @Override
    public int getCurrRuptures() {
        return this.currRuptures;
    }

    @Override
    public int getTotRuptures() {
        return this.totRuptures;
    }

    @Override
    public boolean done() {
        return this.currRuptures == this.totRuptures;
    }

    @Override
    public String getMeanAndModeInfo() {
        float mm_l = (float)this.mag_binEdges[this.M_index_mode3D];
        float mm_u = (float)this.mag_binEdges[this.M_index_mode3D + 1];
        float dm_l = (float)this.dist_binEdges[this.D_index_mode3D];
        float dm_u = (float)this.dist_binEdges[this.D_index_mode3D + 1];
        String results = "\n\n  Mbar = " + (float)this.Mbar + "\n  Dbar = " + (float)this.Dbar + "\n  Ebar = " + (float)this.Ebar + "\n\n  " + mm_l + " \u2264 Mmode < " + mm_u + "\n  " + dm_l + " \u2264 Dmode < " + dm_u;
        results = results + "\n" + this.epsilonRangeString;
        if (this.totalRate == 0.0) {
            results = results + "\n\nNote:\nThe above NaN values result from the chosen IML\n(or that interpolated from the chosen probability)\nnever being exceeded.";
        }
        return results;
    }

    public double getTotalRate() {
        return this.totalRate;
    }

    @Override
    public String getBinData() {
        DecimalFormat f1 = new DecimalFormat("0.00");
        DecimalFormat f2 = new DecimalFormat("00.00");
        DecimalFormat f3 = new DecimalFormat("000.00");
        Object binInfo = "Dist\tMag\tE\u2264-2\t-2<E\u2264-1\t-1<E\u2264-0.5\t -0.5>E\u22640\t 0<E\u22640.5\t 0.5<E\u22641\t 1<E\u22642\t 2>E\tSum \n";
        binInfo = (String)binInfo + "-----\t----\t------\t------\t-------\t-------\t-------\t-------\t-------\t------\n";
        for (int i = 0; i < this.dist_center.length; ++i) {
            for (int j = 0; j < this.mag_center.length; ++j) {
                binInfo = (String)binInfo + f3.format(this.dist_center[i]) + " \t " + f1.format(this.mag_center[j]) + " \t ";
                Object E_String = "";
                double totPercent = 0.0;
                for (int k = 0; k < this.NUM_E; ++k) {
                    double percent = this.pdf3D[i][j][k];
                    E_String = (String)E_String + f2.format(percent) + " \t ";
                    totPercent += percent;
                }
                binInfo = (String)binInfo + (String)E_String + f2.format(totPercent) + "\n";
            }
        }
        return binInfo;
    }

    private void setIndices() {
        int i;
        this.withinBounds = true;
        this.iMag = -1;
        this.iDist = -1;
        for (i = 0; i < this.mag_center.length; ++i) {
            if (!(this.mag >= this.mag_binEdges[i]) || !(this.mag < this.mag_binEdges[i + 1])) continue;
            this.iMag = i;
            break;
        }
        for (i = 0; i < this.dist_center.length; ++i) {
            if (!(this.dist >= this.dist_binEdges[i]) || !(this.dist < this.dist_binEdges[i + 1])) continue;
            this.iDist = i;
            break;
        }
        this.iEpsilon = EpsilonCategories.locate(this.epsilon).ordinal();
        if (this.iMag == -1) {
            this.withinBounds = false;
        }
        if (this.iDist == -1) {
            this.withinBounds = false;
        }
    }

    private String getEpsilonRange(int iEpsilon) {
        switch (iEpsilon) {
            case 0: {
                return "Emode <= -2";
            }
            case 1: {
                return "-2 < Emode <= -1";
            }
            case 2: {
                return "-1 < Emode <= -0.5";
            }
            case 3: {
                return "-0.5 < Emode <= 0.0";
            }
            case 4: {
                return "0.0 < Emode <= 0.5";
            }
            case 5: {
                return "0.5 < Emode <= 1.0";
            }
            case 6: {
                return "1.0 < Emode <= 2.0";
            }
            case 7: {
                return "2.0 < Emode ";
            }
        }
        return "Incorrect Index";
    }

    @Override
    public String getDisaggregationPlotUsingServlet(String metadata) {
        DisaggregationPlotData data = this.getDisaggPlotData();
        this.disaggregationPlotImgWebAddr = this.openServletConnection(data, metadata);
        return this.disaggregationPlotImgWebAddr;
    }

    @Override
    public DisaggregationPlotData getDisaggPlotData() {
        return new DisaggregationPlotData(this.mag_center, this.mag_binEdges, this.dist_center, this.dist_binEdges, this.maxContrEpsilonForGMT_Plot, this.NUM_E, this.pdf3D);
    }

    public static ArrayList<String> createGMTScriptForDisaggregationPlot(DisaggregationPlotData data, String dir) {
        double x_axis_length = 4.5;
        double y_axis_length = 4.0;
        double z_axis_length = 2.5;
        int numTicksToDrawForZAxis = 5;
        double z_tick = Math.ceil(data.getMaxContrEpsilonForGMT_Plot() / (double)numTicksToDrawForZAxis);
        double maxZVal = z_tick * (double)numTicksToDrawForZAxis;
        Preconditions.checkState((maxZVal > 0.0 ? 1 : 0) != 0, (Object)"disagg max z val must be greater than 0!");
        ArrayList<String> gmtScriptLines = new ArrayList<String>();
        double[] dist_binEdges = data.getDist_binEdges();
        double[] mag_binEdges = data.getMag_binEdges();
        double[] dist_center = data.getDist_center();
        double[] mag_center = data.getMag_center();
        int numE = data.getNUM_E();
        double[][][] pdf3D = data.getPdf3D();
        float min_dist = (float)dist_binEdges[0];
        float max_dist = (float)dist_binEdges[dist_binEdges.length - 1];
        float min_mag = (float)mag_binEdges[0];
        float max_mag = (float)mag_binEdges[mag_binEdges.length - 1];
        double totDist = dist_binEdges[dist_binEdges.length - 1] - dist_binEdges[0];
        double x_tick = totDist < 115.0 ? 10.0 : (totDist < 225.0 ? 20.0 : (totDist < 335.0 ? 30.0 : (totDist < 445.0 ? 40.0 : 50.0)));
        double distBinWidthToInches = x_axis_length / totDist;
        double totMag = mag_binEdges[mag_binEdges.length - 1] - mag_binEdges[0];
        double y_tick = totMag < 5.0 ? 0.5 : 1.0;
        double magBinWidthToInches = y_axis_length / totMag;
        gmtScriptLines.add("#!/bin/bash");
        gmtScriptLines.add("");
        gmtScriptLines.add("cd " + dir);
        gmtScriptLines.add("");
        gmtScriptLines.addAll(GMT_MapGenerator.getGMTPathEnvLines());
        gmtScriptLines.add("## Plot Script ##");
        gmtScriptLines.add("");
        try {
            String region = "-R" + min_dist + "/" + max_dist + "/" + min_mag + "/" + max_mag + "/0/" + maxZVal;
            String projection = "-JX" + x_axis_length + "i/" + y_axis_length + "i";
            String viewAngle = "-p150/30";
            String boxPenWidth = "-W0.5p";
            String verticalScaling = "-JZ" + z_axis_length + "i";
            gmtScriptLines.add("${GMT_PATH}gmtset PS_PAGE_COLOR=255/255/255");
            gmtScriptLines.add("${GMT_PATH}gmtset MAP_ORIGIN_X=1.0i");
            gmtScriptLines.add("${GMT_PATH}gmtset MAP_ORIGIN_Y=2.0i");
            gmtScriptLines.add("");
            String img_ps_file = "DisaggregationPlot.ps";
            String axisBoundaryTicksBounds = "-B" + x_tick + ":\"Rupture Distance (km)\":/" + y_tick + ":Magnitude:/" + z_tick + ":%Contribution:wSnEZ";
            gmtScriptLines.add("${COMMAND_PATH}echo \"plotting axis\"");
            gmtScriptLines.add("${COMMAND_PATH}cat << END > temp_segments");
            for (double k = z_tick; k <= maxZVal; k += z_tick) {
                gmtScriptLines.add(">");
                gmtScriptLines.add(min_dist + "  " + min_mag + " " + k);
                gmtScriptLines.add(min_dist + "  " + max_mag + "  " + k);
                gmtScriptLines.add(">");
                gmtScriptLines.add(min_dist + "  " + max_mag + "  " + k);
                gmtScriptLines.add(max_dist + "   " + max_mag + "  " + k);
            }
            gmtScriptLines.add(">");
            gmtScriptLines.add(min_dist + "   " + max_mag + "  0");
            gmtScriptLines.add(min_dist + "  " + max_mag + "  " + maxZVal);
            gmtScriptLines.add(">");
            gmtScriptLines.add(max_dist + "  " + max_mag + " 0");
            gmtScriptLines.add(max_dist + "  " + max_mag + " " + maxZVal);
            gmtScriptLines.add("END");
            gmtScriptLines.add("");
            gmtScriptLines.add("${GMT_PATH}psxyz temp_segments -P " + region + "  " + projection + "  " + verticalScaling + " -K -G0/0/0 " + viewAngle + "  " + boxPenWidth + "  " + axisBoundaryTicksBounds + " >  " + img_ps_file);
            gmtScriptLines.add("${COMMAND_PATH}echo \"plotting disagg\"");
            for (int i = 0; i < dist_center.length; ++i) {
                gmtScriptLines.add("${COMMAND_PATH}echo \"plotting dist bin " + i + "\"");
                for (int j = mag_center.length - 1; j >= 0; --j) {
                    double box_x_width = (dist_binEdges[i + 1] - dist_binEdges[i]) * distBinWidthToInches - 0.05;
                    double box_y_width = (mag_binEdges[j + 1] - mag_binEdges[j]) * magBinWidthToInches - 0.05;
                    String symbol = " -So" + box_x_width + "i/" + box_y_width + "ib";
                    float base = 0.0f;
                    float top = 0.0f;
                    for (int k = 0; k < numE; ++k) {
                        float contribution = (float)pdf3D[i][j][k];
                        top = base + contribution;
                        if (!((double)contribution > 0.0)) continue;
                        gmtScriptLines.add("${COMMAND_PATH}echo \"" + dist_center[i] + " " + mag_center[j] + " " + top + "\" | ${GMT_PATH}psxyz -P " + region + " " + projection + " " + verticalScaling + symbol + base + " -K -O " + epsilonColors[k] + "  " + viewAngle + "  " + boxPenWidth + " >> " + img_ps_file);
                        base = top;
                    }
                }
            }
            gmtScriptLines.add("");
            gmtScriptLines.add("${COMMAND_PATH}echo \"plotting legend\"");
            gmtScriptLines.add("${COMMAND_PATH}echo \"" + dist_binEdges[dist_binEdges.length - 1] + " " + mag_binEdges[0] + " " + 0.8 * z_tick + "\" | ${GMT_PATH}psxyz -P -Y-1.25i -X-4.2i " + region + " " + projection + " " + verticalScaling + " -So0.3ib0  -K -O " + epsilonColors[0] + "  " + viewAngle + "  " + boxPenWidth + " >> " + img_ps_file);
            for (int k = 1; k < numE; ++k) {
                gmtScriptLines.add("${COMMAND_PATH}echo \"" + dist_binEdges[dist_binEdges.length - 1] + " " + mag_binEdges[0] + " " + 0.8 * z_tick + "\" | ${GMT_PATH}psxyz -P -X0.9i " + region + " " + projection + " " + verticalScaling + " -So0.3ib0  -K -O " + epsilonColors[k] + "  " + viewAngle + "  " + boxPenWidth + " >> " + img_ps_file);
            }
            gmtScriptLines.add("${COMMAND_PATH}echo \"0.0 0.75 13,12 0.0 CB e<-2\" > temp_label");
            gmtScriptLines.add("${COMMAND_PATH}echo \"0.9 0.75 13,12 0.0 CB -2<e<-1\" >> temp_label");
            gmtScriptLines.add("${COMMAND_PATH}echo \"1.8 0.75 13,12 0.0 CB -1<e<-0.5\" >> temp_label");
            gmtScriptLines.add("${COMMAND_PATH}echo \"2.7 0.75 13,12 0.0 CB -0.5<e<0\" >> temp_label");
            gmtScriptLines.add("${COMMAND_PATH}echo \"3.6 0.75 13,12 0.0 CB 0<e<0.5\" >> temp_label");
            gmtScriptLines.add("${COMMAND_PATH}echo \"4.5 0.75 13,12 0.0 CB 0.5<e<1\" >> temp_label");
            gmtScriptLines.add("${COMMAND_PATH}echo \"5.4 0.75 13,12 0.0 CB 1<e<2\" >> temp_label");
            gmtScriptLines.add("${COMMAND_PATH}echo \"6.3 0.75 13,12 0.0 CB 2<e\" >> temp_label");
            gmtScriptLines.add("${GMT_PATH}pstext temp_label -F+f+a+j -R0/8.5/0/11 -N -Jx1i -X-6.1 -P -O >> " + img_ps_file);
            gmtScriptLines.add("");
            gmtScriptLines.add("${COMMAND_PATH}echo \"converting postscript\"");
            gmtScriptLines.add("${PS2PDF_PATH} " + img_ps_file + "  DisaggregationPlot.pdf");
            gmtScriptLines.add("${CONVERT_PATH} -chop 0x300 " + img_ps_file + " DisaggregationPlot.jpg");
            gmtScriptLines.add("${CONVERT_PATH} -chop 0x300 " + img_ps_file + " DisaggregationPlot.png");
            gmtScriptLines.add("${COMMAND_PATH}rm temp_segments");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return gmtScriptLines;
    }

    private String openServletConnection(DisaggregationPlotData data, String metadata) throws RuntimeException {
        String webaddr = null;
        try {
            URL gmtPlotServlet = new URL(OPENSHA_SERVLET_URL);
            URLConnection servletConnection = gmtPlotServlet.openConnection();
            servletConnection.setDoInput(true);
            servletConnection.setDoOutput(true);
            servletConnection.setUseCaches(false);
            servletConnection.setDefaultUseCaches(false);
            servletConnection.setRequestProperty("Content-Type", "application/octet-stream");
            ObjectOutputStream outputToServlet = new ObjectOutputStream(servletConnection.getOutputStream());
            outputToServlet.writeObject(data);
            outputToServlet.writeObject(metadata);
            outputToServlet.flush();
            outputToServlet.close();
            ObjectInputStream inputToServlet = new ObjectInputStream(servletConnection.getInputStream());
            Object messageFromServlet = inputToServlet.readObject();
            inputToServlet.close();
            if (!(messageFromServlet instanceof String)) {
                throw (RuntimeException)messageFromServlet;
            }
            webaddr = (String)messageFromServlet;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Server is down , please try again later");
        }
        return webaddr;
    }

    @Override
    protected boolean isCancelled() {
        boolean cancelled = super.isCancelled();
        return cancelled;
    }

    @Override
    public void setNumSourcesToShow(int numSources) {
        this.numSourcesToShow = numSources;
    }

    @Override
    public int getNumSourcesToShow() {
        return this.numSourcesToShow;
    }

    @Override
    public void setShowDistances(boolean showDistances) {
        this.showDistances = showDistances;
    }

    public void setStoreRupProbEpsilons(boolean storeRupProbEpsilons) {
        this.storeRupProbEpsilons = storeRupProbEpsilons;
    }

    public boolean isStoreRupProbEpsilons() {
        return this.storeRupProbEpsilons;
    }

    public double[][][] getRupProbEpsilons() {
        return this.rupProbEpsilons;
    }

    static {
        for (int i = 0; i < epsilonColors.length; ++i) {
            DisaggregationCalculator.epsilonColors[i] = EpsilonCategories.values()[i].gmtColorStr();
        }
    }

    public static enum EpsilonCategories {
        LESS_NEG_TWO("\u03b5<-2", Double.NEGATIVE_INFINITY, -2.0, new Color(215, 38, 3)),
        NEG_TWO_ONE("-2<\u03b5<-1", -2.0, -1.0, new Color(252, 94, 62)),
        NEG_ONE_HALF("-1<\u03b5<-0.5", -1.0, -0.5, new Color(252, 180, 158)),
        NEG_HALF_ZERO("-0.5<\u03b5<0", -0.5, 0.0, new Color(254, 220, 210)),
        ZERO_HALF("0<\u03b5<0.5", 0.0, 0.5, new Color(217, 217, 255)),
        HALF_ONE("0.5<\u03b5<1", 0.5, 1.0, new Color(151, 151, 255)),
        ONE_TWO("1<\u03b5<2", 1.0, 2.0, new Color(0, 0, 255)),
        GREATER_TWO("2<\u03b5", 2.0, Double.POSITIVE_INFINITY, new Color(0, 0, 170));

        public final String label;
        public final double min;
        public final double max;
        public final Color color;

        private EpsilonCategories(String label, double min, double max, Color color) {
            this.label = label;
            this.min = min;
            this.max = max;
            this.color = color;
        }

        public String gmtColorStr() {
            return "-G" + this.color.getRed() + "/" + this.color.getGreen() + "/" + this.color.getBlue();
        }

        static EpsilonCategories locate(double epsilon) {
            if (Double.isInfinite(epsilon)) {
                if (epsilon < 0.0) {
                    return LESS_NEG_TWO;
                }
                return GREATER_TWO;
            }
            for (EpsilonCategories cat : EpsilonCategories.values()) {
                if (!(epsilon > cat.min) || !(epsilon <= cat.max)) continue;
                return cat;
            }
            throw new IllegalStateException("No category found for epsilon=" + epsilon);
        }
    }
}

