/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.disaggregation.chart3d;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.chart3d.data.AbstractDataset3D;
import org.jfree.chart3d.data.category.CategoryDataset3D;
import org.opensha.sha.calc.disaggregation.DisaggregationCalculator;
import org.opensha.sha.calc.disaggregation.DisaggregationPlotData;

class DisaggDataset3D
extends AbstractDataset3D
implements CategoryDataset3D<DisaggregationCalculator.EpsilonCategories, Double, Double>,
Serializable {
    private List<DisaggregationCalculator.EpsilonCategories> seriesKeys;
    private List<Double> rowKeys;
    private List<Double> columnKeys;
    private Map<Double, Integer> rowIndexMap;
    private Map<Double, Integer> columnIndexMap;
    private DisaggregationPlotData data;

    public DisaggDataset3D(DisaggregationPlotData data) {
        this.data = data;
        this.seriesKeys = List.of(DisaggregationCalculator.EpsilonCategories.values());
        this.rowKeys = Doubles.asList((double[])data.getDist_center());
        this.rowIndexMap = new HashMap<Double, Integer>(this.rowKeys.size());
        for (int i = 0; i < this.rowKeys.size(); ++i) {
            this.rowIndexMap.put(this.rowKeys.get(i), i);
        }
        double[] magCenters = data.getMag_center();
        this.columnKeys = new ArrayList<Double>(magCenters.length);
        int i = magCenters.length;
        while (--i >= 0) {
            this.columnKeys.add(magCenters[i]);
        }
        this.columnIndexMap = new HashMap<Double, Integer>(this.columnKeys.size());
        for (i = 0; i < this.columnKeys.size(); ++i) {
            this.columnIndexMap.put(this.columnKeys.get(i), i);
        }
    }

    public List<DisaggregationCalculator.EpsilonCategories> getSeriesKeys() {
        return this.seriesKeys;
    }

    public List<Double> getRowKeys() {
        return this.rowKeys;
    }

    public List<Double> getColumnKeys() {
        return this.columnKeys;
    }

    public DisaggregationCalculator.EpsilonCategories getSeriesKey(int seriesIndex) {
        return this.seriesKeys.get(seriesIndex);
    }

    public Double getRowKey(int rowIndex) {
        return this.rowKeys.get(rowIndex);
    }

    public Double getColumnKey(int columnIndex) {
        return this.columnKeys.get(columnIndex);
    }

    public int getSeriesIndex(DisaggregationCalculator.EpsilonCategories serieskey) {
        return serieskey.ordinal();
    }

    public int getRowIndex(Double rowkey) {
        return this.rowIndexMap.get(rowkey);
    }

    public int getColumnIndex(Double columnkey) {
        return this.columnIndexMap.get(columnkey);
    }

    private int columnIndexToDataIndex(int columnIndex) {
        Preconditions.checkState((columnIndex >= 0 && columnIndex < this.columnKeys.size() ? 1 : 0) != 0);
        return this.columnKeys.size() - 1 - columnIndex;
    }

    public Number getValue(DisaggregationCalculator.EpsilonCategories seriesKey, Double rowKey, Double columnKey) {
        int i = this.getRowIndex(rowKey);
        int j = this.columnIndexToDataIndex(this.getColumnIndex(columnKey));
        int k = seriesKey.ordinal();
        double val = this.data.getPdf3D()[i][j][k];
        if (val == 0.0) {
            return null;
        }
        return val;
    }

    public int getSeriesCount() {
        return this.seriesKeys.size();
    }

    public int getRowCount() {
        return this.rowKeys.size();
    }

    public int getColumnCount() {
        return this.columnKeys.size();
    }

    public Number getValue(int seriesIndex, int rowIndex, int columnIndex) {
        double val = this.data.getPdf3D()[rowIndex][this.columnIndexToDataIndex(columnIndex)][seriesIndex];
        if (val == 0.0) {
            return null;
        }
        return val;
    }

    public double getDoubleValue(int seriesIndex, int rowIndex, int columnIndex) {
        double val = this.data.getPdf3D()[rowIndex][this.columnIndexToDataIndex(columnIndex)][seriesIndex];
        if (val == 0.0) {
            return Double.NaN;
        }
        return val;
    }
}

