/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.hazardMap;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.geo.Location;
import org.opensha.sha.calc.hazardMap.HazardDataSetLoader;

public class AsciiCurveAverager {
    private ArrayList<String> dirs;
    private String outputDir;

    public AsciiCurveAverager(ArrayList<String> dirs, String outputDir) {
        File outputDirFile = new File((String)outputDir);
        if (!outputDirFile.exists()) {
            outputDirFile.mkdirs();
        }
        if (!((String)outputDir).endsWith(File.separator)) {
            outputDir = (String)outputDir + File.separator;
        }
        for (int i = 0; i < dirs.size(); ++i) {
            if (dirs.get(i).endsWith(File.separator)) continue;
            dirs.set(i, dirs.get(i) + File.separator);
        }
        this.dirs = dirs;
        this.outputDir = outputDir;
    }

    public void averageDirs() throws IOException {
        File[] dirList;
        File masterDir = new File(this.dirs.get(0));
        for (File dir : dirList = masterDir.listFiles()) {
            File[] subDirList;
            if (!dir.isDirectory() || dir.getName().endsWith(".")) continue;
            for (File file : subDirList = dir.listFiles()) {
                Location loc;
                String fileName = file.getName();
                File outSubDirFile = new File(this.outputDir + dir.getName());
                if (!outSubDirFile.exists()) {
                    outSubDirFile.mkdir();
                }
                if (!fileName.endsWith(".txt") || (loc = HazardDataSetLoader.decodeFileName(fileName)) == null) continue;
                String relativePath = dir.getName() + File.separator + fileName;
                System.out.println(relativePath);
                ArrayList<DiscretizedFunc> funcs = new ArrayList<DiscretizedFunc>();
                for (String curveDir : this.dirs) {
                    funcs.add(ArbitrarilyDiscretizedFunc.loadFuncFromSimpleFile(curveDir + relativePath));
                }
                DiscretizedFunc aveCurve = AsciiCurveAverager.averageCurves(funcs);
                ArbitrarilyDiscretizedFunc.writeSimpleFuncFile(aveCurve, this.outputDir + relativePath);
            }
        }
    }

    public static DiscretizedFunc averageCurves(ArrayList<DiscretizedFunc> curves) {
        if (curves.size() < 2) {
            throw new RuntimeException("At least 2 curves must be given to average.");
        }
        ArbitrarilyDiscretizedFunc aveFunc = new ArbitrarilyDiscretizedFunc();
        int numPoints = curves.get(0).size();
        for (DiscretizedFunc curve : curves) {
            if (numPoints == curve.size()) continue;
            throw new RuntimeException("All curves must have the same # of points!");
        }
        for (int i = 0; i < numPoints; ++i) {
            double x = curves.get(0).getX(i);
            double y = 0.0;
            for (DiscretizedFunc curve : curves) {
                if (x != curve.getX(i)) {
                    throw new RuntimeException("X values on curve don't match!");
                }
                y += curve.getY(i);
            }
            aveFunc.set(x, y /= (double)curves.size());
        }
        return aveFunc;
    }

    public static void main(String[] args) {
        ArrayList<String> dirs = new ArrayList<String>();
        String outputDir = null;
        if (args.length > 3) {
            for (int i = 0; i < args.length - 1; ++i) {
                dirs.add(args[i]);
            }
            outputDir = args[args.length - 1];
        } else {
            System.out.println("USAGE: CurveAverager dir1 dir2 dir3 [... dirN] outputDir");
            System.exit(2);
        }
        AsciiCurveAverager ave = new AsciiCurveAverager(dirs, outputDir);
        try {
            ave.averageDirs();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

