/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.hazardMap;

import com.google.common.collect.Maps;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.LightFixedXFunc;
import org.opensha.commons.geo.Location;
import org.opensha.sra.riskmaps.func.DiscreteInterpExterpFunc;

public class BinaryHazardCurveReader {
    private DataInputStream reader = null;
    private double[] imlvals;
    private double latitude;
    private double longitude;

    public BinaryHazardCurveReader(String filename) throws Exception {
        FilterInputStream in = new BufferedInputStream(new FileInputStream(filename));
        if (filename.toLowerCase().endsWith(".gz")) {
            in = new GZIPInputStream(in);
        }
        this.reader = new DataInputStream(in);
        int imlcount = this.reader.readInt();
        this.imlvals = new double[imlcount];
        for (int i = 0; i < imlcount; ++i) {
            this.imlvals[i] = this.reader.readDouble();
        }
    }

    public Map<Location, ArbitrarilyDiscretizedFunc> getCurveMap() throws Exception {
        HashMap map = Maps.newHashMap();
        ArbitrarilyDiscretizedFunc curve = this.nextCurve();
        while (curve != null) {
            Location loc = this.currentLocation();
            map.put(loc, curve);
            curve = this.nextCurve();
        }
        return map;
    }

    public ArbitrarilyDiscretizedFunc nextCurve() throws Exception {
        ArbitrarilyDiscretizedFunc function = new ArbitrarilyDiscretizedFunc();
        try {
            this.latitude = this.reader.readDouble();
            this.longitude = this.reader.readDouble();
            for (int i = 0; i < this.imlvals.length; ++i) {
                function.set(this.imlvals[i], this.reader.readDouble());
            }
        }
        catch (EOFException eof) {
            return null;
        }
        return function;
    }

    public LightFixedXFunc nextLightCurve() throws Exception {
        double[] yVals = new double[this.imlvals.length];
        try {
            this.latitude = this.reader.readDouble();
            this.longitude = this.reader.readDouble();
            for (int i = 0; i < this.imlvals.length; ++i) {
                yVals[i] = this.reader.readDouble();
            }
        }
        catch (EOFException eof) {
            return null;
        }
        return new LightFixedXFunc(this.imlvals, yVals);
    }

    public DiscreteInterpExterpFunc nextDiscreteCurve() throws Exception {
        double[] xVals = new double[this.imlvals.length];
        double[] yVals = new double[this.imlvals.length];
        try {
            this.latitude = this.reader.readDouble();
            this.longitude = this.reader.readDouble();
            for (int i = 0; i < this.imlvals.length; ++i) {
                xVals[i] = this.imlvals[i];
                yVals[i] = this.reader.readDouble();
            }
        }
        catch (EOFException eof) {
            return null;
        }
        return new DiscreteInterpExterpFunc(xVals, yVals);
    }

    public Location currentLocation() {
        return new Location(this.latitude, this.longitude);
    }

    public double[] currentLocationArray() {
        double[] result = new double[]{this.latitude, this.longitude};
        return result;
    }

    public int getNumVals() {
        return this.imlvals.length;
    }
}

