/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.hazardMap;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.xyz.ArbDiscrGeoDataSet;
import org.opensha.commons.data.xyz.GeoDataSet;
import org.opensha.commons.data.xyz.XYZ_DataSet;
import org.opensha.commons.geo.Location;
import org.opensha.commons.util.FileNameComparator;

public class HazardDataSetLoader {
    public static HashMap<Location, ArbitrarilyDiscretizedFunc> loadDataSet(File dir) throws FileNotFoundException, IOException {
        HashMap<Location, ArbitrarilyDiscretizedFunc> curves = new HashMap<Location, ArbitrarilyDiscretizedFunc>();
        File[] files = dir.listFiles();
        Arrays.sort(files, new FileNameComparator());
        for (File file : files) {
            if (HazardDataSetLoader.shouldSkip(file)) continue;
            if (file.isDirectory()) {
                curves.putAll(HazardDataSetLoader.loadDataSet(file));
                continue;
            }
            Location loc = HazardDataSetLoader.decodeFileName(file.getName());
            if (loc == null) {
                System.err.println("Could not decode filename, skipping: " + file.getAbsolutePath());
                continue;
            }
            ArbitrarilyDiscretizedFunc curve = ArbitrarilyDiscretizedFunc.loadFuncFromSimpleFile(file.getAbsolutePath());
            curves.put(loc, curve);
        }
        return curves;
    }

    public static boolean shouldSkip(File file) {
        if (file.getName().startsWith(".")) {
            return true;
        }
        return file.isFile() && !file.getName().endsWith(".txt");
    }

    public static GeoDataSet extractPointFromCurves(Map<Location, ArbitrarilyDiscretizedFunc> curves, boolean isProbAt_IML, double level) {
        ArbDiscrGeoDataSet xyz = new ArbDiscrGeoDataSet(true);
        for (Location loc : curves.keySet()) {
            ArbitrarilyDiscretizedFunc curve = curves.get(loc);
            double val = HazardDataSetLoader.getCurveVal(curve, isProbAt_IML, level);
            xyz.set(loc, val);
        }
        return xyz;
    }

    public static GeoDataSet extractPointFromCurves(File dir, boolean isProbAt_IML, double level) throws FileNotFoundException, IOException {
        ArbDiscrGeoDataSet xyz = new ArbDiscrGeoDataSet(true);
        File[] files = dir.listFiles();
        Arrays.sort(files, new FileNameComparator());
        for (File file : files) {
            if (HazardDataSetLoader.shouldSkip(file)) continue;
            if (file.isDirectory()) {
                xyz.setAll(HazardDataSetLoader.extractPointFromCurves(file, isProbAt_IML, level));
                continue;
            }
            Location loc = HazardDataSetLoader.decodeFileName(file.getName());
            if (loc == null) {
                System.err.println("Could not decode filename, skipping: " + file.getAbsolutePath());
                continue;
            }
            ArbitrarilyDiscretizedFunc curve = ArbitrarilyDiscretizedFunc.loadFuncFromSimpleFile(file.getAbsolutePath());
            double val = HazardDataSetLoader.getCurveVal(curve, isProbAt_IML, level);
            xyz.set(loc, val);
        }
        return xyz;
    }

    public static double getCurveVal(DiscretizedFunc func, boolean isProbAt_IML, double level) {
        if (isProbAt_IML) {
            return func.getInterpolatedY_inLogXLogYDomain(level);
        }
        try {
            double out = func.getFirstInterpolatedX_inLogXLogYDomain(level);
            return out;
        }
        catch (RuntimeException e) {
            if (level < func.getY(func.size() - 1)) {
                System.err.println("WARNING: Curve saturated at p=" + (float)level + ". Returning max IML");
                return func.getMaxX();
            }
            return Double.NaN;
        }
    }

    public static Location decodeFileName(String fileName) {
        int index = fileName.indexOf("_");
        int firstIndex = fileName.indexOf(".");
        int lastIndex = fileName.lastIndexOf(".");
        try {
            if (firstIndex != lastIndex) {
                Double latVal = Double.valueOf(fileName.substring(0, index).trim());
                Double lonVal = Double.valueOf(fileName.substring(index + 1, lastIndex).trim());
                return new Location(latVal, lonVal);
            }
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        long start = System.currentTimeMillis();
        String curveDir = "/home/kevin/OpenSHA/gem/ceus/curves_0.1/imrs2";
        String outfile = "/home/kevin/OpenSHA/gem/ceus/curves_0.1/imrs2_new.txt";
        boolean isProbAt_IML = false;
        double level = 0.02;
        GeoDataSet xyz = HazardDataSetLoader.extractPointFromCurves(new File(curveDir), isProbAt_IML, level);
        ArbDiscrGeoDataSet.writeXYZFile((XYZ_DataSet)xyz, outfile);
        System.out.println("took " + (double)(System.currentTimeMillis() - start) / 1000.0 + " secs");
    }
}

