/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.hazardMap;

import com.google.common.collect.Lists;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.xyz.ArbDiscrGeoDataSet;
import org.opensha.commons.geo.Location;
import org.opensha.sha.calc.hazardMap.HazardDataSetLoader;

public class MakeXYZFromHazardMapDir {
    public static int WRITES_UNTIL_FLUSH = 1000;
    private boolean latFirst;
    private boolean sort;
    private String dirName;

    public MakeXYZFromHazardMapDir(String dirName, boolean sort, boolean latFirst) {
        this.dirName = dirName;
        this.latFirst = latFirst;
        this.sort = sort;
    }

    public void writeXYZFile(boolean isProbAt_IML, double level, String fileName) throws IOException {
        this.parseFiles(isProbAt_IML, level, fileName, false);
    }

    public ArbDiscrGeoDataSet getXYZDataset(boolean isProbAt_IML, double level) throws IOException {
        return this.parseFiles(isProbAt_IML, level, null, false);
    }

    public ArbDiscrGeoDataSet getXYZDataset(boolean isProbAt_IML, double level, String fileName) throws IOException {
        return this.parseFiles(isProbAt_IML, level, fileName, true);
    }

    private ArbDiscrGeoDataSet parseFiles(boolean isProbAt_IML, double level, String fileName, boolean forceLoad) throws IOException {
        System.out.println("Generating XYZ dataset for dir: " + this.dirName);
        BufferedWriter out = null;
        ArbDiscrGeoDataSet xyz = null;
        if (fileName != null && fileName.length() > 0) {
            out = new BufferedWriter(new FileWriter(fileName));
        }
        if (out == null || forceLoad) {
            xyz = new ArbDiscrGeoDataSet(this.latFirst);
        }
        int count = 0;
        double minLat = Double.MAX_VALUE;
        double minLon = Double.MAX_VALUE;
        double maxLat = Double.MIN_VALUE;
        double maxLon = -9999.0;
        if (this.dirName.toLowerCase().trim().endsWith(".zip")) {
            ZipFile zip = new ZipFile(this.dirName);
            ArrayList entriesList = Lists.newArrayList();
            Enumeration<? extends ZipEntry> entriesEnum = zip.entries();
            while (entriesEnum.hasMoreElements()) {
                entriesList.add(entriesEnum.nextElement());
            }
            System.out.println("Found " + entriesList.size() + " entries");
            if (this.sort) {
                Collections.sort(entriesList, new ZipEntryComparator());
            }
            for (ZipEntry entry : entriesList) {
                String locNamePart;
                Location loc;
                String curveFileName = entry.getName();
                if (!curveFileName.endsWith(".txt") || (loc = HazardDataSetLoader.decodeFileName(locNamePart = new File(curveFileName).getName())) == null) continue;
                double latVal = loc.getLatitude();
                double lonVal = loc.getLongitude();
                double writeVal = this.handleFile(zip.getInputStream(entry), isProbAt_IML, level);
                if (this.latFirst) {
                    if (out != null) {
                        out.write(latVal + "     " + lonVal + "     " + writeVal + "\n");
                    }
                    if (xyz != null) {
                        xyz.set(loc, writeVal);
                    }
                } else {
                    if (out != null) {
                        out.write(lonVal + "     " + latVal + "     " + writeVal + "\n");
                    }
                    if (xyz != null) {
                        xyz.set(loc, writeVal);
                    }
                }
                if (latVal < minLat) {
                    minLat = latVal;
                } else if (latVal > maxLat) {
                    maxLat = latVal;
                }
                if (lonVal < minLon) {
                    minLon = lonVal;
                } else if (lonVal > maxLon) {
                    maxLon = lonVal;
                }
                if (out != null && count % WRITES_UNTIL_FLUSH == 0) {
                    System.out.println("Processed " + count + " curves");
                    out.flush();
                }
                ++count;
            }
        } else {
            File masterDir = new File(this.dirName);
            File[] dirList = masterDir.listFiles();
            if (this.sort) {
                Arrays.sort(dirList, new FileComparator());
            }
            for (File dir : dirList) {
                File[] subDirList;
                if (!dir.isDirectory() || dir.getName().endsWith(".")) continue;
                for (File file : subDirList = dir.listFiles()) {
                    Location loc;
                    String curveFileName;
                    if (file.isFile() && (curveFileName = file.getName()).endsWith(".txt") && (loc = HazardDataSetLoader.decodeFileName(curveFileName)) != null) {
                        double latVal = loc.getLatitude();
                        double lonVal = loc.getLongitude();
                        double writeVal = this.handleFile(file.getAbsolutePath(), isProbAt_IML, level);
                        if (this.latFirst) {
                            if (out != null) {
                                out.write(latVal + "     " + lonVal + "     " + writeVal + "\n");
                            }
                            if (xyz != null) {
                                xyz.set(loc, writeVal);
                            }
                        } else {
                            if (out != null) {
                                out.write(lonVal + "     " + latVal + "     " + writeVal + "\n");
                            }
                            if (xyz != null) {
                                xyz.set(loc, writeVal);
                            }
                        }
                        if (latVal < minLat) {
                            minLat = latVal;
                        } else if (latVal > maxLat) {
                            maxLat = latVal;
                        }
                        if (lonVal < minLon) {
                            minLon = lonVal;
                        } else if (lonVal > maxLon) {
                            maxLon = lonVal;
                        }
                        if (out != null && count % WRITES_UNTIL_FLUSH == 0) {
                            System.out.println("Processed " + count + " curves");
                            out.flush();
                        }
                    }
                    ++count;
                }
            }
        }
        if (out != null) {
            out.close();
        }
        System.out.println("DONE");
        System.out.println("MinLat: " + minLat + " MaxLat: " + maxLat + " MinLon: " + minLon + " MaxLon " + maxLon);
        System.out.println(count + " curves processed!");
        return xyz;
    }

    public double handleFile(String fileName, boolean isProbAt_IML, double val) {
        try {
            ArbitrarilyDiscretizedFunc func = AbstractDiscretizedFunc.loadFuncFromSimpleFile(fileName);
            return HazardDataSetLoader.getCurveVal(func, isProbAt_IML, val);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Double.NaN;
    }

    public double handleFile(InputStream is, boolean isProbAt_IML, double val) {
        try {
            ArbitrarilyDiscretizedFunc func = AbstractDiscretizedFunc.loadFuncFromSimpleFile(is);
            return HazardDataSetLoader.getCurveVal(func, isProbAt_IML, val);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Double.NaN;
    }

    public static void main(String[] args) {
        try {
            long start = System.currentTimeMillis();
            String curveDir = "/home/kevin/Simulators/maps/2013_04_10-rsqsim-long-la-box-0.05-pga-cb2008-30yrs/2013_04_10-rsqsim-long-la-box-0.05-pga-cb2008-30yrs_curves.zip";
            String outfile = "/home/kevin/Simulators/maps/2013_04_10-rsqsim-long-la-box-0.05-pga-cb2008-30yrs/2percent_in_30.txt";
            boolean isProbAt_IML = false;
            double level = 0.02;
            boolean latFirst = true;
            MakeXYZFromHazardMapDir maker = new MakeXYZFromHazardMapDir(curveDir, false, latFirst);
            maker.writeXYZFile(isProbAt_IML, level, outfile);
            System.out.println("took " + (double)(System.currentTimeMillis() - start) / 1000.0 + " secs");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class ZipEntryComparator
    implements Comparator<ZipEntry> {
        FileNameComparator c = new FileNameComparator();

        private ZipEntryComparator() {
        }

        @Override
        public int compare(ZipEntry f1, ZipEntry f2) {
            if (f1 == f2) {
                return 0;
            }
            return this.c.compare(f1.getName(), f2.getName());
        }
    }

    private static class FileComparator
    implements Comparator<File> {
        FileNameComparator c = new FileNameComparator();

        private FileComparator() {
        }

        @Override
        public int compare(File f1, File f2) {
            if (f1 == f2) {
                return 0;
            }
            if (f1.isDirectory() && f2.isFile()) {
                return -1;
            }
            if (f1.isFile() && f2.isDirectory()) {
                return 1;
            }
            return this.c.compare(f1.getName(), f2.getName());
        }
    }

    private static class FileNameComparator
    implements Comparator<String> {
        private static Collator c = Collator.getInstance();

        private FileNameComparator() {
        }

        public String invertFileName(String fileName) {
            int lastIndex;
            int index = fileName.indexOf("_");
            int firstIndex = fileName.indexOf(".");
            if (firstIndex != (lastIndex = fileName.lastIndexOf("."))) {
                String lat = fileName.substring(0, index).trim();
                String lon = fileName.substring(index + 1, lastIndex).trim();
                return lon + "_" + lat;
            }
            return fileName;
        }

        @Override
        public int compare(String o1, String o2) {
            return c.compare(this.invertFileName(o1), this.invertFileName(o2));
        }
    }
}

