/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.hazardMap.components;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Map;
import org.dom4j.Element;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.calc.hazardMap.BinaryRandomAccessHazardCurveWriter;
import org.opensha.sha.calc.hazardMap.components.CurveMetadata;
import org.opensha.sha.calc.hazardMap.components.CurveResultsArchiver;

public class BinaryCurveArchiver
implements CurveResultsArchiver {
    public static final String XML_METADATA_NAME = "BinaryFileCurveArchiver";
    private File outputDir;
    private Map<String, BinaryRandomAccessHazardCurveWriter> filesMap;
    public static final ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;

    public BinaryCurveArchiver(File outputDir, int numSites, Map<String, DiscretizedFunc> xValsMap) {
        this.outputDir = outputDir;
        if (!outputDir.exists()) {
            outputDir.mkdir();
        }
        this.filesMap = Maps.newHashMap();
        for (String imrName : xValsMap.keySet()) {
            File outputFile = new File(outputDir, imrName + ".bin");
            DiscretizedFunc xVals = xValsMap.get(imrName);
            BinaryRandomAccessHazardCurveWriter file = new BinaryRandomAccessHazardCurveWriter(outputFile, numSites, xVals);
            this.filesMap.put(imrName, file);
        }
    }

    public void initialize() {
        for (BinaryRandomAccessHazardCurveWriter file : this.filesMap.values()) {
            try {
                file.initialize();
            }
            catch (IOException e) {
                ExceptionUtils.throwAsRuntimeException(e);
            }
        }
    }

    @Override
    public Element toXMLMetadata(Element root) {
        Element el = root.addElement(XML_METADATA_NAME);
        el.addAttribute("outputDir", this.outputDir.getAbsolutePath());
        return root;
    }

    public static BinaryCurveArchiver fromXMLMetadata(Element archiverEl, int numSites, Map<String, DiscretizedFunc> xValsMap) throws IOException {
        String outputDir = archiverEl.attributeValue("outputDir");
        return new BinaryCurveArchiver(new File(outputDir), numSites, xValsMap);
    }

    @Override
    public synchronized void archiveCurve(DiscretizedFunc curve, CurveMetadata meta) throws IOException {
        String imrName = meta.getShortLabel();
        BinaryRandomAccessHazardCurveWriter file = this.filesMap.get(imrName);
        file.writeCurve(meta.getIndex(), meta.getSite().getLocation(), curve);
    }

    @Override
    public synchronized boolean isCurveCalculated(CurveMetadata meta, DiscretizedFunc xVals) {
        try {
            String imrName = meta.getShortLabel();
            return this.filesMap.get(imrName).isCurveCalculated(meta.getIndex(), meta.getSite().getLocation());
        }
        catch (IOException e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
    }

    @Override
    public File getStoreDir() {
        return this.outputDir;
    }

    @Override
    public void close() {
        for (BinaryRandomAccessHazardCurveWriter file : this.filesMap.values()) {
            try {
                file.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

