/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.hazardMap.components;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.opensha.commons.data.Site;
import org.opensha.commons.metadata.XMLSaveable;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.util.FileUtils;
import org.opensha.sha.calc.hazardMap.components.AsciiFileCurveArchiver;
import org.opensha.sha.calc.hazardMap.components.BinaryCurveArchiver;
import org.opensha.sha.calc.hazardMap.components.CalculationSettings;
import org.opensha.sha.calc.hazardMap.components.CurveResultsArchiver;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.imr.AbstractIMR;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.util.TectonicRegionType;

public class CalculationInputsXMLFile
implements XMLSaveable {
    private ERF erf;
    private List<Map<TectonicRegionType, ScalarIMR>> imrMaps;
    private List<Site> sites;
    private List<Parameter<Double>> imts;
    private CalculationSettings calcSettings;
    private CurveResultsArchiver archiver;
    private boolean erfSerialized = false;
    private String serializedERFFile;
    public static boolean UDPATE_FORECAST = true;
    public static final String XML_IMRS_NAME = "IMRs";
    public static final String XML_IMR_MAP_NAME = "IMR_Map";
    public static final String XML_IMR_MAPING_NAME = "IMR_Maping";
    public static final String XML_IMR_MAP_LIST_NAME = "IMR_Maps";

    public CalculationInputsXMLFile(ERF erf, List<Map<TectonicRegionType, ScalarIMR>> imrMaps, List<Site> sites, CalculationSettings calcSettings, CurveResultsArchiver archiver) {
        this(erf, imrMaps, null, sites, calcSettings, archiver);
    }

    public CalculationInputsXMLFile(ERF erf, List<Map<TectonicRegionType, ScalarIMR>> imrMaps, List<Parameter<Double>> imts, List<Site> sites, CalculationSettings calcSettings, CurveResultsArchiver archiver) {
        this.erf = erf;
        this.imrMaps = imrMaps;
        this.imts = imts;
        this.sites = sites;
        this.calcSettings = calcSettings;
        this.archiver = archiver;
    }

    public ERF getERF() {
        return this.erf;
    }

    public void serializeERF(String odir) throws IOException {
        this.erf.updateForecast();
        FileUtils.saveObjectInFile(this.serializedERFFile, this.erf);
        String serializedERFFile = odir + "erf.obj";
        this.setSerialized(serializedERFFile);
    }

    public void setSerialized(String serializedERFFile) {
        this.erfSerialized = serializedERFFile != null;
        this.serializedERFFile = serializedERFFile;
    }

    public List<Map<TectonicRegionType, ScalarIMR>> getIMRMaps() {
        return this.imrMaps;
    }

    public void setIMTs(List<Parameter<Double>> imts) {
        this.imts = imts;
    }

    public List<Parameter<Double>> getIMTs() {
        return this.imts;
    }

    public List<Site> getSites() {
        return this.sites;
    }

    public CalculationSettings getCalcSettings() {
        return this.calcSettings;
    }

    public CurveResultsArchiver getArchiver() {
        return this.archiver;
    }

    @Override
    public Element toXMLMetadata(Element root) {
        if (this.erf instanceof AbstractERF) {
            AbstractERF newERF = (AbstractERF)this.erf;
            root = newERF.toXMLMetadata(root);
            if (this.erfSerialized) {
                Element erfElement = root.element("ERF");
                root.add(erfElement.createCopy("ERF_REF"));
                erfElement.detach();
                Element newERFElement = root.addElement("ERF");
                newERFElement.addAttribute("fileName", this.serializedERFFile);
            }
        } else {
            throw new ClassCastException("Currently only EqkRupForecast subclasses can be saved to XML.");
        }
        ArrayList<ScalarIMR> imrs = new ArrayList<ScalarIMR>();
        ArrayList<Map<TectonicRegionType, ScalarIMR>> newList = new ArrayList<Map<TectonicRegionType, ScalarIMR>>();
        for (Map<TectonicRegionType, ScalarIMR> map : this.imrMaps) {
            newList.add(map);
            for (TectonicRegionType tect : map.keySet()) {
                ScalarIMR imr = map.get(tect);
                boolean add = true;
                for (ScalarIMR newIMR : imrs) {
                    if (!newIMR.getShortName().equals(imr.getShortName())) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                imrs.add(imr);
            }
        }
        CalculationInputsXMLFile.imrsToXML(imrs, root);
        CalculationInputsXMLFile.imrMapsToXML(newList, this.imts, root);
        Site.writeSitesToXML(this.sites, root);
        this.calcSettings.toXMLMetadata(root);
        this.archiver.toXMLMetadata(root);
        return null;
    }

    public static CalculationInputsXMLFile loadXML(Document doc) throws InvocationTargetException, IOException {
        return CalculationInputsXMLFile.loadXML(doc, 1, false)[0];
    }

    public static CalculationInputsXMLFile[] loadXML(Document doc, int threads, boolean multERFs) throws InvocationTargetException, IOException {
        CurveResultsArchiver archiver;
        Preconditions.checkArgument((threads >= 1 ? 1 : 0) != 0, (Object)"threads must be >= 1");
        Element root = doc.getRootElement();
        ERF[] erfs = new ERF[threads];
        for (int i = 0; i < threads; ++i) {
            ERF erf;
            if (i == 0 || multERFs) {
                Element erfElement = root.element("ERF");
                Attribute className = erfElement.attribute("className");
                if (className == null) {
                    String erfFileName = erfElement.attribute("fileName").getValue();
                    erf = (AbstractERF)FileUtils.loadObject(erfFileName);
                } else {
                    erf = AbstractERF.fromXMLMetadata(erfElement);
                    System.out.println("Updating Forecast");
                    if (UDPATE_FORECAST) {
                        erf.updateForecast();
                    }
                }
            } else {
                erf = erfs[0];
            }
            erfs[i] = erf;
        }
        Element imrsEl = root.element(XML_IMRS_NAME);
        ArrayList<ArrayList<ScalarIMR>> imrsList = new ArrayList<ArrayList<ScalarIMR>>();
        for (int i = 0; i < threads; ++i) {
            ArrayList<ScalarIMR> imrs = CalculationInputsXMLFile.imrsFromXML(imrsEl);
            imrsList.add(imrs);
        }
        ArrayList paramsToAdd = new ArrayList();
        for (ScalarIMR imr : (ArrayList)imrsList.get(0)) {
            for (Parameter<?> param : imr.getSiteParams()) {
                boolean add = true;
                for (Parameter parameter : paramsToAdd) {
                    if (!param.getName().equals(parameter.getName())) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                paramsToAdd.add(param);
            }
        }
        Element imrMapsEl = root.element(XML_IMR_MAP_LIST_NAME);
        ArrayList<List<Map<TectonicRegionType, ScalarIMR>>> imrMapsList = new ArrayList<List<Map<TectonicRegionType, ScalarIMR>>>();
        for (int i = 0; i < threads; ++i) {
            imrMapsList.add(CalculationInputsXMLFile.imrMapsFromXML((List)imrsList.get(i), imrMapsEl));
        }
        List<Parameter<Double>> imts = CalculationInputsXMLFile.imtsFromXML((ScalarIMR)((ArrayList)imrsList.get(0)).get(0), imrMapsEl);
        Element sitesEl = root.element(Site.XML_METADATA_LIST_NAME);
        ArrayList<Site> sites = Site.loadSitesFromXML(sitesEl, paramsToAdd);
        Element calcSettingsEl = root.element("CalculationSettings");
        CalculationSettings calculationSettings = CalculationSettings.fromXMLMetadata(calcSettingsEl);
        Element archiverEl = root.element("AsciiFileCurveArchiver");
        if (archiverEl != null) {
            archiver = AsciiFileCurveArchiver.fromXMLMetadata(archiverEl);
        } else {
            archiverEl = root.element("BinaryFileCurveArchiver");
            HashMap xValsMap = Maps.newHashMap();
            List thread0IMRMaps = (List)imrMapsList.get(0);
            for (int i = 0; i < thread0IMRMaps.size(); ++i) {
                ScalarIMR imr = (ScalarIMR)((Map)thread0IMRMaps.get(i)).values().iterator().next();
                xValsMap.put("imrs" + (i + 1), calculationSettings.getXValues(imr.getIntensityMeasure().getName()));
            }
            archiver = BinaryCurveArchiver.fromXMLMetadata(archiverEl, sites.size(), xValsMap);
        }
        CalculationInputsXMLFile[] inputs = new CalculationInputsXMLFile[threads];
        for (int i = 0; i < threads; ++i) {
            inputs[i] = new CalculationInputsXMLFile(erfs[i], (List)imrMapsList.get(i), imts, sites, calculationSettings, archiver);
        }
        return inputs;
    }

    public static Element imrsToXML(ArrayList<ScalarIMR> imrs, Element root) {
        Element imrsEl = root.addElement(XML_IMRS_NAME);
        for (ScalarIMR imr : imrs) {
            if (imr instanceof AbstractIMR) {
                AbstractIMR attenRel = (AbstractIMR)((Object)imr);
                attenRel.toXMLMetadata(imrsEl);
                continue;
            }
            throw new ClassCastException("Currently only IntensityMeasureRelationship subclasses can be saved to XML.");
        }
        return root;
    }

    public static ArrayList<ScalarIMR> imrsFromXML(Element imrsEl) throws InvocationTargetException {
        ArrayList<ScalarIMR> imrs = new ArrayList<ScalarIMR>();
        Iterator it = imrsEl.elementIterator();
        while (it.hasNext()) {
            Element imrEl = (Element)it.next();
            ScalarIMR imr = (ScalarIMR)((Object)AbstractIMR.fromXMLMetadata(imrEl, null));
            imrs.add(imr);
        }
        return imrs;
    }

    public static Element imrMapToXML(Map<TectonicRegionType, ScalarIMR> map, List<Parameter<Double>> imts, Element root, int index) {
        Element mapEl = root.addElement(XML_IMR_MAP_NAME);
        mapEl.addAttribute("index", "" + index);
        for (TectonicRegionType tect : map.keySet()) {
            Element mapingEl = mapEl.addElement(XML_IMR_MAPING_NAME);
            ScalarIMR imr = map.get(tect);
            mapingEl.addAttribute("tectonicRegionType", tect.toString());
            mapingEl.addAttribute("imr", imr.getShortName());
        }
        if (imts != null) {
            imts.get(index).toXMLMetadata(mapEl, "IntensityMeasure");
        }
        return root;
    }

    public static Parameter<Double> imtFromXML(ScalarIMR testIMR, Element imrMapEl) {
        Element imtElem = imrMapEl.element("IntensityMeasure");
        if (imtElem == null) {
            return null;
        }
        String imtName = imtElem.attributeValue("name");
        System.out.println("IMT Name: " + imtName);
        testIMR.setIntensityMeasure(imtName);
        Parameter imt = testIMR.getIntensityMeasure();
        imt.setValueFromXMLMetadata(imtElem);
        return imt;
    }

    public static List<Parameter<Double>> imtsFromXML(ScalarIMR testIMR, Element imrMapsEl) {
        ArrayList<Parameter<Double>> imts = new ArrayList<Parameter<Double>>();
        Iterator it = imrMapsEl.elementIterator(XML_IMR_MAP_NAME);
        HashMap<Integer, Parameter> listsMap = new HashMap<Integer, Parameter>();
        while (it.hasNext()) {
            Element imrMapEl = (Element)it.next();
            int index = Integer.parseInt(imrMapEl.attributeValue("index"));
            Parameter<Double> imt = CalculationInputsXMLFile.imtFromXML(testIMR, imrMapEl);
            if (imt == null) {
                return null;
            }
            listsMap.put(index, (Parameter)imt.clone());
        }
        for (int i = 0; i < listsMap.size(); ++i) {
            Parameter imt = (Parameter)listsMap.get(i);
            Object meta = imt.getName();
            if (imt.getName().equals("SA")) {
                double period = (Double)imt.getIndependentParameter("SA Period").getValue();
                meta = (String)meta + " (Period: " + period + " sec)";
            }
            System.out.println("IMT " + i + ": " + (String)meta);
            imts.add(imt);
        }
        return imts;
    }

    public static Map<TectonicRegionType, ScalarIMR> imrMapFromXML(List<ScalarIMR> imrs, Element imrMapEl) {
        HashMap<TectonicRegionType, ScalarIMR> map = new HashMap<TectonicRegionType, ScalarIMR>();
        Iterator it = imrMapEl.elementIterator(XML_IMR_MAPING_NAME);
        while (it.hasNext()) {
            Element mappingEl = (Element)it.next();
            String tectName = mappingEl.attributeValue("tectonicRegionType");
            String imrName = mappingEl.attributeValue("imr");
            TectonicRegionType tect = TectonicRegionType.getTypeForName(tectName);
            ScalarIMR imr = null;
            for (ScalarIMR testIMR : imrs) {
                if (!imrName.equals(testIMR.getShortName())) continue;
                imr = testIMR;
                break;
            }
            if (imr == null) {
                throw new RuntimeException("IMR '" + imrName + "' not found in XML mapping lookup");
            }
            map.put(tect, imr);
        }
        return map;
    }

    public static Element imrMapsToXML(ArrayList<Map<TectonicRegionType, ScalarIMR>> maps, List<Parameter<Double>> imts, Element root) {
        Element mapsEl = root.addElement(XML_IMR_MAP_LIST_NAME);
        for (int i = 0; i < maps.size(); ++i) {
            Map<TectonicRegionType, ScalarIMR> map = maps.get(i);
            mapsEl = CalculationInputsXMLFile.imrMapToXML(map, imts, mapsEl, i);
        }
        return root;
    }

    public static List<Map<TectonicRegionType, ScalarIMR>> imrMapsFromXML(List<ScalarIMR> imrs, Element imrMapsEl) {
        ArrayList<Map<TectonicRegionType, ScalarIMR>> maps = new ArrayList<Map<TectonicRegionType, ScalarIMR>>();
        Iterator it = imrMapsEl.elementIterator(XML_IMR_MAP_NAME);
        HashMap<Integer, Map<TectonicRegionType, ScalarIMR>> mapsMap = new HashMap<Integer, Map<TectonicRegionType, ScalarIMR>>();
        while (it.hasNext()) {
            Element imrMapEl = (Element)it.next();
            int index = Integer.parseInt(imrMapEl.attributeValue("index"));
            Map<TectonicRegionType, ScalarIMR> map = CalculationInputsXMLFile.imrMapFromXML(imrs, imrMapEl);
            mapsMap.put(index, map);
        }
        for (int i = 0; i < mapsMap.size(); ++i) {
            maps.add((Map)mapsMap.get(i));
        }
        return maps;
    }
}

