/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.hazus;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class HazusIML_FileGenerator {
    private final String Hazus = "HazusMapDataSets/";
    DecimalFormat format = new DecimalFormat("0.000000##");

    public HazusIML_FileGenerator() {
        this.format.setMaximumFractionDigits(6);
        try {
            FileReader fr = new FileReader("HazusMapDataSets/metadata.dat");
            BufferedReader br = new BufferedReader(fr);
            Object metadata = "#";
            Object temp = br.readLine() + "\n";
            while (temp != null) {
                metadata = (String)metadata + (String)temp + "\n#";
                temp = br.readLine();
            }
            double rate = 0.01;
            this.createReturnPdFile("HazusMapDataSets/final_100.dat", rate, (String)metadata);
            rate = 0.004;
            this.createReturnPdFile("HazusMapDataSets/final_250.dat", rate, (String)metadata);
            rate = 0.002;
            this.createReturnPdFile("HazusMapDataSets/final_500.dat", rate, (String)metadata);
            rate = 0.0013333333333333333;
            this.createReturnPdFile("HazusMapDataSets/final_750.dat", rate, (String)metadata);
            rate = 0.001;
            this.createReturnPdFile("HazusMapDataSets/final_1000.dat", rate, (String)metadata);
            rate = 6.666666666666666E-4;
            this.createReturnPdFile("HazusMapDataSets/final_1500.dat", rate, (String)metadata);
            rate = 5.0E-4;
            this.createReturnPdFile("HazusMapDataSets/final_2000.dat", rate, (String)metadata);
            rate = 4.0E-4;
            this.createReturnPdFile("HazusMapDataSets/final_2500.dat", rate, (String)metadata);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createReturnPdFile(String fileName, double rate, String metaData) {
        ArrayList<Double> imlVector = new ArrayList<Double>();
        File dirsPGA = new File("HazusMapDataSets/pga/");
        String[] dirListPGA = dirsPGA.list();
        File dirsPGV = new File("HazusMapDataSets/pgv/");
        String[] dirListPGV = dirsPGV.list();
        File dirsSA = new File("HazusMapDataSets/sa_.3/");
        String[] dirListSA = dirsSA.list();
        File dirsSA_1 = new File("HazusMapDataSets/sa_1/");
        String[] dirListSA_1 = dirsSA_1.list();
        try {
            FileWriter fw = new FileWriter(fileName);
            fw.write(metaData);
            fw.write("#Column Info: Lat,Lon,PGA,PGV,SA-0.3,SA-1\n\n");
            for (int i = 0; i < dirListPGA.length; ++i) {
                imlVector.clear();
                if (dirListPGA[i].endsWith(".txt")) {
                    imlVector.add(this.getIML("HazusMapDataSets/pga/" + dirListPGA[i], rate));
                    imlVector.add(this.getIML("HazusMapDataSets/pgv/" + dirListPGV[i], rate) / 2.5);
                    imlVector.add(this.getIML("HazusMapDataSets/sa_.3/" + dirListSA[i], rate));
                    imlVector.add(this.getIML("HazusMapDataSets/sa_1/" + dirListSA_1[i], rate));
                }
                String lat = dirListPGA[i].substring(0, dirListPGA[i].indexOf("_"));
                String lon = dirListPGA[i].substring(dirListPGA[i].indexOf("_") + 1, dirListPGA[i].indexOf(".txt"));
                fw.write(lat + "," + lon + ",");
                for (int j = 0; j < imlVector.size() - 1; ++j) {
                    fw.write(this.format.format((Double)imlVector.get(j)) + ",");
                }
                fw.write(this.format.format((Double)imlVector.get(imlVector.size() - 1)) + "\n");
            }
            fw.close();
        }
        catch (Exception e) {
            System.out.println("Error Occured");
            e.printStackTrace();
        }
    }

    private double getIML(String filename, double rate) {
        try {
            FileReader fr = new FileReader(filename);
            BufferedReader br = new BufferedReader(fr);
            String prevLine = br.readLine();
            String currLine = br.readLine();
            StringTokenizer st = null;
            while (currLine != null) {
                st = new StringTokenizer(prevLine);
                double prevIML = Double.valueOf(st.nextToken());
                double prevRate = Double.valueOf(st.nextToken());
                st = new StringTokenizer(currLine);
                double currIML = Double.valueOf(st.nextToken());
                double currRate = Double.valueOf(st.nextToken());
                if (rate >= currRate && rate <= prevRate) {
                    double logCurrRate = Math.log(currRate);
                    double logPrevRate = Math.log(prevRate);
                    double logCurrIML = Math.log(currIML);
                    double logPrevIML = Math.log(prevIML);
                    rate = Math.log(rate);
                    double iml = (rate - logCurrRate) / (logPrevRate - logCurrRate) * (logPrevIML - logCurrIML) + logCurrIML;
                    return Math.exp(iml);
                }
                prevLine = currLine;
                currLine = br.readLine();
            }
        }
        catch (Exception e) {
            System.out.println(filename + " file not found");
            e.printStackTrace();
        }
        return 0.0;
    }
}

