/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.hazus.parallel;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.util.ClassUtils;
import org.opensha.commons.util.FileUtils;
import org.opensha.sha.calc.hazardMap.HazardDataSetLoader;

public class HazusDataSetAssmbler {
    public static final String METADATA_RP_REPLACE_STR = "$RETURN_PERIOD";
    public static final String METADATA_RP_REGEX_REPLACE_STR = "\\$RETURN_PERIOD";
    public static int[] hazus_return_periods = new int[]{100, 250, 500, 750, 1000, 1500, 2000, 2500};
    public static DecimalFormat df = new DecimalFormat("0.000000");
    HashMap<Location, ArbitrarilyDiscretizedFunc> pgaCurves;
    HashMap<Location, ArbitrarilyDiscretizedFunc> pgvCurves;
    HashMap<Location, ArbitrarilyDiscretizedFunc> sa03Curves;
    HashMap<Location, ArbitrarilyDiscretizedFunc> sa10Curves;
    ArrayList<String> metadata = null;

    public HazusDataSetAssmbler(String hazardMapDir) throws IOException {
        this(hazardMapDir + File.separator + "imrs1", hazardMapDir + File.separator + "imrs2", hazardMapDir + File.separator + "imrs3", hazardMapDir + File.separator + "imrs4");
    }

    public HazusDataSetAssmbler(String pgaDir, String pgvDir, String sa03Dir, String sa10Dir) throws IOException {
        if (!new File(sa10Dir).exists()) {
            sa10Dir = sa03Dir;
            sa03Dir = pgvDir;
            pgvDir = null;
        }
        System.out.println("Loading PGA curves");
        this.pgaCurves = HazardDataSetLoader.loadDataSet(new File(pgaDir));
        System.out.println("Loading PGV curves");
        if (pgvDir == null) {
            System.out.println("Doesn't have PGV!");
        } else {
            this.pgvCurves = HazardDataSetLoader.loadDataSet(new File(pgvDir));
        }
        System.out.println("Loading SA 0.3s curves");
        this.sa03Curves = HazardDataSetLoader.loadDataSet(new File(sa03Dir));
        System.out.println("Loading SA 1.0s curves");
        this.sa10Curves = HazardDataSetLoader.loadDataSet(new File(sa10Dir));
    }

    public void loadMetadataFile(String fileName) throws IOException {
        this.metadata = FileUtils.loadFile(fileName, false);
    }

    private boolean hasMetadata() {
        return this.metadata != null && !this.metadata.isEmpty();
    }

    private void writeMetadata(String fileName) throws IOException {
        FileWriter fw = new FileWriter(fileName);
        for (String line : this.metadata) {
            if ((line = line.trim()).contains(METADATA_RP_REPLACE_STR)) {
                line = "";
            }
            fw.write(line + "\n");
        }
        fw.close();
    }

    public HashMap<Location, double[]> assemble(double returnPeriod, int years) {
        HashMap<Location, double[]> results = new HashMap<Location, double[]>();
        for (Location loc : this.pgaCurves.keySet()) {
            double pgaVal = HazusDataSetAssmbler.getValFromCurve(this.pgaCurves.get(loc), returnPeriod, years);
            double pgvVal = this.pgvCurves == null ? Double.NaN : HazusDataSetAssmbler.getValFromCurve(this.pgvCurves.get(loc), returnPeriod, years);
            double sa03Val = HazusDataSetAssmbler.getValFromCurve(this.sa03Curves.get(loc), returnPeriod, years);
            double sa10Val = HazusDataSetAssmbler.getValFromCurve(this.sa10Curves.get(loc), returnPeriod, years);
            double[] result = new double[]{pgaVal, pgvVal, sa03Val, sa10Val};
            results.put(loc, result);
        }
        return results;
    }

    /*
     * WARNING - void declaration
     */
    public void writeFile(String fileName, HashMap<Location, double[]> results, double returnPeriod) throws IOException {
        FileWriter fw = new FileWriter(fileName);
        if (this.metadata != null) {
            for (String string : this.metadata) {
                void var7_6;
                String string2 = string.replaceAll(METADATA_RP_REGEX_REPLACE_STR, "" + returnPeriod).trim();
                if (!string2.startsWith("#")) {
                    String string3 = "#" + string2;
                }
                fw.write((String)var7_6 + "\n");
            }
        }
        fw.write("#Column Info: Lat,Lon,PGA,PGV,SA-0.3,SA-1\n");
        for (Location location : results.keySet()) {
            double[] result = results.get(location);
            String line = df.format(location.getLatitude()) + "," + df.format(location.getLongitude());
            for (int i = 0; i < 4; ++i) {
                double val = result[i];
                line = Double.isNaN(val) ? line + ",NaN" : line + "," + df.format(val);
            }
            fw.write(line + "\n");
        }
        fw.close();
    }

    public static void writeSitesFile(String fileName, Collection<Location> locs) throws IOException {
        double minLat = LocationUtils.calcMinLat(locs);
        double maxLat = LocationUtils.calcMaxLat(locs);
        double minLon = LocationUtils.calcMinLon(locs);
        double maxLon = LocationUtils.calcMaxLon(locs);
        double latSpacing = Double.MAX_VALUE;
        double lonSpacing = Double.MAX_VALUE;
        for (Location loc : locs) {
            double myLatSpacing = loc.getLatitude() - minLat;
            double myLonSpacing = loc.getLongitude() - minLon;
            if (myLatSpacing > 0.0 && myLatSpacing < latSpacing) {
                latSpacing = myLatSpacing;
            }
            if (!(myLonSpacing > 0.0) || !(myLonSpacing < lonSpacing)) continue;
            lonSpacing = myLonSpacing;
        }
        FileWriter fw = new FileWriter(fileName);
        fw.write((float)minLat + " " + (float)maxLat + " " + (float)latSpacing + "\n");
        fw.write((float)minLon + " " + (float)maxLon + " " + (float)lonSpacing + "\n");
        fw.close();
    }

    public static double getProbValue(double returnPeriod, int years) {
        return 1.0 - Math.exp(-((double)years) / returnPeriod);
    }

    public static double getValFromCurve(ArbitrarilyDiscretizedFunc curve, double returnPeriod, int years) {
        double probVal = HazusDataSetAssmbler.getProbValue(returnPeriod, years);
        try {
            return curve.getFirstInterpolatedX_inLogXLogYDomain(probVal);
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public static void main(String[] args) throws IOException {
        Object fileName;
        String dataDir = null;
        String metadataFile = null;
        int years = -1;
        if (args.length == 0) {
            System.err.println("WARNING: Running with hardcoded paths!");
            dataDir = "/home/kevin/OpenSHA/hazus/grid_fix/indep/curves_merged";
            years = 50;
            metadataFile = "/home/kevin/OpenSHA/hazus/grid_fix/indep/metadata.dat";
        } else if (args.length == 2 || args.length == 3) {
            dataDir = args[0];
            years = Integer.parseInt(args[1]);
            if (args.length == 3) {
                metadataFile = args[2];
            }
        } else {
            String cname = ClassUtils.getClassNameWithoutPackage(HazusDataSetAssmbler.class);
            System.out.println("USAGE: " + cname + " <dataDir> <years> [<metadataFile>]");
            System.exit(2);
        }
        if (!new File(dataDir).exists()) {
            throw new FileNotFoundException("Data dir doesn't exist: " + dataDir);
        }
        if (years < 1) {
            throw new IllegalArgumentException("Years must be >= 1");
        }
        HazusDataSetAssmbler assem = new HazusDataSetAssmbler(dataDir);
        if (metadataFile != null) {
            assem.loadMetadataFile(metadataFile);
        }
        HashMap<Location, double[]> results = null;
        ArrayList<String> fileNames = new ArrayList<String>();
        for (int rp : hazus_return_periods) {
            results = assem.assemble(rp, years);
            fileName = "final_" + rp + ".dat";
            assem.writeFile(dataDir + "/" + (String)fileName, results, rp);
            fileNames.add((String)fileName);
        }
        fileName = "sites.dat";
        HazusDataSetAssmbler.writeSitesFile(dataDir + "/" + (String)fileName, results.keySet());
        fileNames.add((String)fileName);
        if (assem.hasMetadata()) {
            fileName = "metadata.dat";
            assem.writeMetadata(dataDir + "/" + (String)fileName);
            fileNames.add((String)fileName);
        }
        String zipFile = dataDir + "/hazus.zip";
        FileUtils.createZipFile(zipFile, dataDir, fileNames);
    }
}

