/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.params.filters;

import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.sha.calc.params.MagDistCutoffParam;
import org.opensha.sha.calc.params.filters.SourceFilter;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.earthquake.EqkSource;

public class MagDependentDistCutoffFilter
implements SourceFilter,
ParameterChangeListener {
    private MagDistCutoffParam magDist = new MagDistCutoffParam();
    private ArbitrarilyDiscretizedFunc magDistFunc;
    private ParameterList params;

    public MagDependentDistCutoffFilter() {
        this.magDist.addParameterChangeListener(this);
        this.magDistFunc = (ArbitrarilyDiscretizedFunc)this.magDist.getValue();
        this.params = new ParameterList();
        this.params.addParameter(this.magDist);
    }

    public void setMagDistFunc(ArbitrarilyDiscretizedFunc magDistFunc) {
        this.magDist.setValue(magDistFunc);
    }

    public ArbitrarilyDiscretizedFunc getMagDistFunc() {
        return this.magDistFunc;
    }

    public MagDistCutoffParam getParam() {
        return this.magDist;
    }

    @Override
    public boolean canSkipSource(EqkSource source, Site site, double sourceSiteDistance) {
        return sourceSiteDistance > this.magDistFunc.getMaxX();
    }

    @Override
    public boolean canSkipRupture(EqkRupture rup, Site site) {
        double dist = rup.getRuptureSurface().getQuickDistance(site.getLocation());
        if (dist < this.magDistFunc.getMinX()) {
            return false;
        }
        if (dist > this.magDistFunc.getMaxX()) {
            return true;
        }
        double magThresh = this.magDistFunc.getInterpolatedY(dist);
        return rup.getMag() < magThresh;
    }

    @Override
    public ParameterList getAdjustableParams() {
        return this.params;
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        this.magDistFunc = (ArbitrarilyDiscretizedFunc)this.magDist.getValue();
    }

    public String toString() {
        Object str = "MagDistFunc=[";
        for (int i = 0; i < this.magDistFunc.size(); ++i) {
            if (i > 0) {
                str = (String)str + ", ";
            }
            str = (String)str + (float)this.magDistFunc.getX(i) + ":" + (float)this.magDistFunc.getY(i);
        }
        str = (String)str + "]";
        return str;
    }
}

