/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.params.filters;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.opensha.sha.calc.params.filters.FixedDistanceCutoffFilter;
import org.opensha.sha.calc.params.filters.MagDependentDistCutoffFilter;
import org.opensha.sha.calc.params.filters.SourceFilter;
import org.opensha.sha.calc.params.filters.SourceFilters;
import org.opensha.sha.calc.params.filters.TectonicRegionDistCutoffFilter;

public class SourceFilterManager {
    static final SourceFilters[] filters = SourceFilters.values();
    private SourceFilter[] filterInstances = new SourceFilter[filters.length];
    private boolean[] filterEnableds = new boolean[filters.length];
    private List<SourceFilter> enabledFilterList = null;

    public SourceFilterManager(SourceFilters ... enabledByDefault) {
        for (SourceFilters filter : enabledByDefault) {
            this.filterInstances[filter.ordinal()] = filter.initFilter();
            this.filterEnableds[filter.ordinal()] = true;
        }
    }

    public List<SourceFilter> getEnabledFilters() {
        if (this.enabledFilterList == null) {
            ArrayList<SourceFilter> ret = new ArrayList<SourceFilter>();
            for (int i = 0; i < this.filterInstances.length; ++i) {
                if (!this.filterEnableds[i]) continue;
                Preconditions.checkNotNull((Object)this.filterInstances[i]);
                ret.add(this.filterInstances[i]);
            }
            this.enabledFilterList = ret;
        }
        return this.enabledFilterList;
    }

    public void setEnabled(SourceFilters filter, boolean enabled) {
        this.enabledFilterList = null;
        this.filterEnableds[filter.ordinal()] = enabled;
        if (enabled && this.filterInstances[filter.ordinal()] == null) {
            this.filterInstances[filter.ordinal()] = filter.initFilter();
        }
    }

    public boolean isEnabled(SourceFilters filter) {
        return this.filterEnableds[filter.ordinal()];
    }

    public <E extends SourceFilter> E getFilterInstance(Class<E> clazz) {
        for (SourceFilters filter : SourceFilters.values()) {
            if (!clazz.isAssignableFrom(filter.getFilterClass())) continue;
            SourceFilter instance = this.getFilterInstance(filter);
            Preconditions.checkState((boolean)clazz.isAssignableFrom(instance.getClass()));
            return (E)((SourceFilter)clazz.cast(instance));
        }
        throw new IllegalStateException("Unexpected filter class: " + clazz.getName());
    }

    public SourceFilter getFilterInstance(SourceFilters filter) {
        if (this.filterInstances[filter.ordinal()] == null) {
            this.filterInstances[filter.ordinal()] = filter.initFilter();
        }
        return this.filterInstances[filter.ordinal()];
    }

    public double getMaxDistance() {
        double maxDist = Double.POSITIVE_INFINITY;
        if (this.isEnabled(SourceFilters.FIXED_DIST_CUTOFF)) {
            maxDist = this.getFilterInstance(FixedDistanceCutoffFilter.class).getMaxDistance();
        }
        if (this.isEnabled(SourceFilters.MAG_DIST_CUTOFFS)) {
            maxDist = Math.min(maxDist, this.getFilterInstance(MagDependentDistCutoffFilter.class).getMagDistFunc().getMaxX());
        }
        if (this.isEnabled(SourceFilters.TRT_DIST_CUTOFFS)) {
            maxDist = Math.min(maxDist, this.getFilterInstance(TectonicRegionDistCutoffFilter.class).getCutoffs().getLargestCutoffDist());
        }
        return maxDist;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        boolean first = true;
        for (int i = 0; i < filters.length; ++i) {
            if (!this.filterEnableds[i]) continue;
            if (first) {
                first = false;
            } else {
                str.append(", ");
            }
            str.append(this.filterInstances[i].toString());
        }
        str.append("]");
        return str.toString();
    }
}

