/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Element;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.geo.Region;
import org.opensha.commons.metadata.MetadataLoader;
import org.opensha.commons.metadata.XMLSaveable;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.event.TimeSpanChangeListener;
import org.opensha.sha.calc.params.filters.SourceFilter;
import org.opensha.sha.earthquake.BaseERF;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.SiteAdaptiveSource;
import org.opensha.sha.util.TectonicRegionType;

public abstract class AbstractERF
implements ERF,
TimeSpanChangeListener,
ParameterChangeListener,
XMLSaveable {
    private static final long serialVersionUID = 1L;
    protected ParameterList adjustableParams = new ParameterList();
    protected TimeSpan timeSpan;
    protected boolean parameterChangeFlag = true;
    protected int totNumRups = -1;
    protected ArrayList<int[]> nthRupIndicesForSource;
    protected int[] srcIndexForNthRup;
    protected int[] rupIndexForNthRup;
    public static final String XML_METADATA_NAME = "ERF";

    @Override
    public Region getApplicableRegion() {
        return null;
    }

    public Parameter getParameter(String paramName) {
        return this.getAdjustableParameterList().getParameter(paramName);
    }

    @Override
    public void setTimeSpan(TimeSpan time) {
        if (!time.getStartTimePrecision().equalsIgnoreCase("None")) {
            this.timeSpan.setStartTime(time.getStartTimeCalendar());
        }
        this.timeSpan.setDuration(time.getDuration(), time.getDurationUnits());
    }

    @Override
    public TimeSpan getTimeSpan() {
        return this.timeSpan;
    }

    @Override
    public void setParameter(String name, Object value) {
        AbstractERF.setParameter(this, name, value);
    }

    public static void setParameter(BaseERF erf, String name, Object value) {
        TimeSpan timeSpan = erf.getTimeSpan();
        if (erf.getAdjustableParameterList().containsParameter(name)) {
            erf.getAdjustableParameterList().getParameter(name).setValue(value);
        } else if (timeSpan.getAdjustableParams().containsParameter(name)) {
            timeSpan.getAdjustableParams().getParameter(name).setValue(value);
        } else {
            throw new IllegalArgumentException("Parameter '" + name + "' not present in ERF adjustable parameter list!");
        }
    }

    @Override
    public void timeSpanChange(EventObject event) {
        this.parameterChangeFlag = true;
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        this.parameterChangeFlag = true;
    }

    @Override
    public int getNumRuptures(int iSource) {
        return this.getSource(iSource).getNumRuptures();
    }

    public ProbEqkRupture getRuptureClone(int iSource, int nRupture) {
        return this.getSource(iSource).getRuptureClone(nRupture);
    }

    @Override
    public ProbEqkRupture getRupture(int iSource, int nRupture) {
        return this.getSource(iSource).getRupture(nRupture);
    }

    public ProbEqkSource getSourceClone(int iSource) {
        return null;
    }

    @Override
    public ParameterList getAdjustableParameterList() {
        return this.adjustableParams;
    }

    public void setParameterChangeFlag(boolean flag) {
        this.parameterChangeFlag = flag;
    }

    protected static void baseERF_ToXML(BaseERF erf, Element erfEl) {
        erfEl.addAttribute("className", erf.getClass().getName());
        ListIterator<Parameter<?>> paramIt = erf.getAdjustableParameterList().getParametersIterator();
        Element paramsElement = erfEl.addElement("Parameters");
        while (paramIt.hasNext()) {
            Parameter<?> param = paramIt.next();
            paramsElement = param.toXMLMetadata(paramsElement);
        }
        erfEl = erf.getTimeSpan().toXMLMetadata(erfEl);
    }

    protected static BaseERF baseERF_FromXML(Element el) throws InvocationTargetException {
        String className = el.attribute("className").getValue();
        BaseERF erf = (BaseERF)MetadataLoader.createClassInstance(className);
        Element paramsElement = el.element("Parameters");
        ParameterList.setParamsInListFromXML(erf.getAdjustableParameterList(), paramsElement);
        erf.setTimeSpan(TimeSpan.fromXMLMetadata(el.element("TimeSpan")));
        return erf;
    }

    @Override
    public Element toXMLMetadata(Element root) {
        Element xml = root.addElement(XML_METADATA_NAME);
        AbstractERF.baseERF_ToXML(this, xml);
        return root;
    }

    public static AbstractERF fromXMLMetadata(Element el) throws InvocationTargetException {
        return (AbstractERF)AbstractERF.baseERF_FromXML(el);
    }

    public ArrayList<EqkRupture> drawRandomEventSet(Site site, Collection<SourceFilter> sourceFilters) {
        boolean doFilter = site != null && sourceFilters != null && !sourceFilters.isEmpty();
        ArrayList<EqkRupture> rupList = new ArrayList<EqkRupture>();
        for (int s = 0; s < this.getNumSources(); ++s) {
            ProbEqkSource source = this.getSource(s);
            if (site != null && source instanceof SiteAdaptiveSource) {
                source = ((SiteAdaptiveSource)((Object)source)).getForSite(site);
            }
            if (doFilter) {
                boolean skip = false;
                double dist = source.getMinDistance(site);
                for (SourceFilter filter : sourceFilters) {
                    if (!filter.canSkipSource(source, site, dist)) continue;
                    skip = true;
                    break;
                }
                if (skip) continue;
                ArrayList<ProbEqkRupture> rups = source.drawRandomEqkRuptures();
                for (ProbEqkRupture rup : rups) {
                    skip = false;
                    for (SourceFilter filter : sourceFilters) {
                        if (!filter.canSkipRupture(rup, site)) continue;
                        skip = true;
                        break;
                    }
                    if (skip) continue;
                    rupList.add(rup);
                }
                continue;
            }
            rupList.addAll(source.drawRandomEqkRuptures());
        }
        return rupList;
    }

    @Override
    public ArrayList<TectonicRegionType> getIncludedTectonicRegionTypes() {
        ArrayList<TectonicRegionType> list = new ArrayList<TectonicRegionType>();
        list.add(TectonicRegionType.ACTIVE_SHALLOW);
        return list;
    }

    @Override
    public int compareTo(BaseERF o) {
        return this.getName().compareToIgnoreCase(o.getName());
    }

    @Override
    public List<ProbEqkSource> getSourceList() {
        ArrayList<ProbEqkSource> list = new ArrayList<ProbEqkSource>();
        for (int s = 0; s < this.getNumSources(); ++s) {
            list.add(this.getSource(s));
        }
        return list;
    }

    @Override
    public Iterator<ProbEqkSource> iterator() {
        return new Iterator<ProbEqkSource>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < AbstractERF.this.getNumSources();
            }

            @Override
            public ProbEqkSource next() {
                return AbstractERF.this.getSource(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported by this iterator");
            }
        };
    }
}

