/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.calc.recurInterval;

import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.sha.earthquake.calc.recurInterval.EqkProbDistCalc;

public final class BPT_DistCalc
extends EqkProbDistCalc
implements ParameterChangeListener {
    static final double SAFE_ONE_MINUS_CDF = 1.0E-13;
    static final double MIN_NORM_DURATION = 0.01;
    double safeTimeSinceLast = Double.NaN;

    public BPT_DistCalc() {
        this.NAME = "BPT";
    }

    @Override
    protected void computeDistributions() {
        this.integratedCDF = null;
        this.integratedOneMinusCDF = null;
        this.pdf = new EvenlyDiscretizedFunc(0.0, this.numPoints, this.deltaX);
        this.cdf = new EvenlyDiscretizedFunc(0.0, this.numPoints, this.deltaX);
        this.pdf.set(0, 0.0);
        this.cdf.set(0, 0.0);
        double temp1 = this.mean / (Math.PI * 2 * (this.aperiodicity * this.aperiodicity));
        double temp2 = 2.0 * this.mean * (this.aperiodicity * this.aperiodicity);
        double cd = 0.0;
        for (int i = 1; i < this.pdf.size(); ++i) {
            double t = this.cdf.getX(i);
            double pd = Math.sqrt(temp1 / (t * t * t)) * Math.exp(-(t - this.mean) * (t - this.mean) / (temp2 * t));
            if (Double.isNaN(pd)) {
                pd = 0.0;
                System.out.println("pd=0 for i=" + i);
            }
            this.pdf.set(i, pd);
            this.cdf.set(i, cd += this.deltaX * (pd + this.pdf.getY(i - 1)) / 2.0);
        }
        this.computeSafeTimeSinceLastCutoff();
        this.upToDate = true;
    }

    public static double getCondProb(double mean, double aperiodicity, double timeSinceLast, double duration) {
        double step = 0.001;
        double cdf = 0.0;
        double pdf_last = 0.0;
        double cBPT1 = 0.0;
        double x = timeSinceLast / mean > aperiodicity * 10.0 ? 10.0 * aperiodicity * mean : timeSinceLast;
        int i1 = Math.round((float)(x / mean / step));
        int i2 = Math.round((float)((x + duration) / mean / step));
        double temp1 = 1.0 / (Math.PI * 2 * (aperiodicity * aperiodicity));
        double temp2 = 2.0 * (aperiodicity * aperiodicity) * 1.0;
        double t = step * 1.0;
        for (int i = 1; i <= i2; ++i) {
            double pdf = Math.sqrt(temp1 / (t * t * t)) * Math.exp(-(t - 1.0) * (t - 1.0) / (temp2 * t));
            cdf += step * (pdf + pdf_last) / 2.0;
            if (i == i1) {
                cBPT1 = cdf;
            }
            t += step;
            pdf_last = pdf;
        }
        double cBPT2 = cdf;
        if (cBPT1 >= 1.0) {
            return Double.NaN;
        }
        return (cBPT2 - cBPT1) / (1.0 - cBPT1);
    }

    @Override
    public double getCondProb(double timeSinceLast, double duration) {
        this.duration = duration;
        if (!this.upToDate) {
            this.computeDistributions();
        }
        double result = Double.NaN;
        if (duration / this.mean >= 0.009999000000000001) {
            if (timeSinceLast + duration <= this.safeTimeSinceLast) {
                result = super.getCondProb(timeSinceLast, duration);
            } else {
                if (this.safeTimeSinceLast - duration * 1.0001 < 0.0) {
                    return 1.0;
                }
                double condProbAtSafeTime = super.getCondProb(this.safeTimeSinceLast - duration * 1.0001, duration);
                double condProbAtInfTime = 1.0 - Math.exp(-duration / (this.aperiodicity * this.aperiodicity * this.mean * 2.0));
                if (timeSinceLast + duration > this.cdf.getMaxX()) {
                    return condProbAtInfTime;
                }
                result = condProbAtSafeTime + (condProbAtInfTime - condProbAtSafeTime) * (timeSinceLast - (this.safeTimeSinceLast - duration)) / (10.0 * this.mean - (this.safeTimeSinceLast - duration));
            }
        } else {
            double condProbForMinNormDur = this.getCondProb(timeSinceLast, 0.01 * this.mean);
            result = condProbForMinNormDur * duration / (0.01 * this.mean);
            this.duration = duration;
        }
        return result;
    }

    @Override
    public EvenlyDiscretizedFunc getCondProbFunc() {
        EvenlyDiscretizedFunc func = super.getCondProbFunc();
        func.setName(this.NAME + " Safe Conditional Probability Function");
        func.setInfo(this.adjustableParams.toString() + "\nsafeTimeSinceLast=" + this.safeTimeSinceLast);
        return func;
    }

    @Override
    public double getCondProbForUnknownTimeSinceLastEvent() {
        double denom;
        double numer;
        double result;
        double lastTime;
        if (!this.upToDate) {
            this.computeDistributions();
        }
        double condProbAtSafeTime = this.getCondProb(this.safeTimeSinceLast, this.duration);
        if (this.histOpenInterval >= this.safeTimeSinceLast) {
            return condProbAtSafeTime;
        }
        double diffFromFirst = Math.abs((condProbAtSafeTime - this.getCondProb(this.histOpenInterval, this.duration)) / condProbAtSafeTime);
        if (diffFromFirst < 1.0E-4) {
            return condProbAtSafeTime;
        }
        if (this.integratedCDF == null) {
            this.makeIntegratedCDFs();
        }
        if ((lastTime = this.histOpenInterval + this.duration) > this.integratedCDF.getMaxX()) {
            lastTime = this.integratedCDF.getMaxX();
        }
        if ((result = (numer = this.duration - (this.integratedCDF.getInterpolatedY(lastTime) - this.integratedCDF.getInterpolatedY(this.histOpenInterval))) / (denom = this.integratedOneMinusCDF.getY(this.numPoints - 1) - this.integratedOneMinusCDF.getInterpolatedY(this.histOpenInterval))) > 1.0) {
            result = 1.0;
        }
        if (numer > 1.0E-10 && denom > 1.0E-10) {
            return result;
        }
        result = 0.0;
        double normDenom = 0.0;
        EvenlyDiscretizedFunc condProbFunc = this.getCondProbFunc();
        int firstIndex = condProbFunc.getClosestXIndex(this.histOpenInterval);
        int indexOfSafeTime = condProbFunc.getClosestXIndex(this.safeTimeSinceLast);
        for (int i = firstIndex; i <= indexOfSafeTime; ++i) {
            double probOfTimeSince = 1.0 - this.cdf.getY(i);
            if (i == firstIndex) {
                probOfTimeSince *= (this.cdf.getX(i) + this.deltaX / 2.0 - this.histOpenInterval) / this.deltaX;
            }
            normDenom += probOfTimeSince;
            result += condProbFunc.getY(i) * probOfTimeSince;
        }
        if ((result /= normDenom) > 1.0) {
            result = 1.0;
        }
        return result;
    }

    public double getSafeTimeSinceLastCutoff() {
        if (!this.upToDate) {
            this.computeDistributions();
        }
        return this.safeTimeSinceLast;
    }

    private void computeSafeTimeSinceLastCutoff() {
        this.safeTimeSinceLast = Double.NaN;
        for (int x = 0; x < this.cdf.size() && !(1.0 - this.cdf.getY(x) < 1.0E-13); ++x) {
            this.safeTimeSinceLast = this.cdf.getX(x);
        }
        if (Double.isNaN(this.safeTimeSinceLast)) {
            throw new RuntimeException("CDF never gets close to 1.0; need to increase numPoints?");
        }
    }

    public void testSafeCalcs() {
        double[] durations = new double[]{1.0, 0.1, 0.01, 0.001, 1.0E-4};
        double[] aperiodicities = new double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
        System.out.println("fractDiff\tsafeProb\tprob\taper\ttimeSince\tdur\tsafeDist");
        for (double aper : aperiodicities) {
            for (double dur : durations) {
                this.setAll(1.0, aper, 0.01, 1000, dur);
                double safeDist = this.getSafeTimeSinceLastCutoff();
                EvenlyDiscretizedFunc condProbFuncOnlyForXvalues = super.getCondProbFunc();
                for (int i = 0; i < condProbFuncOnlyForXvalues.size(); ++i) {
                    double timeSince = condProbFuncOnlyForXvalues.getX(i);
                    if (!(timeSince < safeDist)) continue;
                    double safeProb = this.getCondProb(timeSince, dur);
                    double prob = super.getCondProb(timeSince, dur);
                    double fractDiff = prob < 1.0E-16 && safeProb < 1.0E-16 ? 0.0 : Math.abs((safeProb - prob) / safeProb);
                    if (!(fractDiff > 0.001)) continue;
                    System.out.println(fractDiff + "\t" + safeProb + "\t" + prob + "\t" + aper + "\t" + timeSince + "\t" + dur + "\t" + safeDist);
                }
            }
        }
    }

    public static void main(String[] args) {
        double p;
        BPT_DistCalc calcBPT = new BPT_DistCalc();
        calcBPT.testSafeCalcs();
        System.exit(0);
        double timeSinceLast = 96.0;
        double nYr = 30.0;
        double alph = 0.5;
        double[] rate = new double[]{0.00466746464, 0.00432087015, 0.004199435, 0.004199435};
        double[] prob = new double[]{0.130127236, 0.105091952, 0.0964599401, 0.0964599401};
        double[] static_prob = new double[rate.length];
        System.out.println("Test1: static-method comparison with probs from WG02 code");
        for (int i = 0; i < rate.length; ++i) {
            p = BPT_DistCalc.getCondProb(1.0 / rate[i], alph, timeSinceLast, nYr);
            System.out.println("Test1 (static): prob=" + (float)p + "; ratio=" + (float)(p / prob[i]));
            static_prob[i] = p;
        }
        BPT_DistCalc calc = new BPT_DistCalc();
        double[] nonStatic_prob = new double[rate.length];
        System.out.println("Test2: non-static method compared to static");
        for (int i = 0; i < rate.length; ++i) {
            calc.setAll(1.0 / rate[i], alph);
            p = calc.getCondProb(timeSinceLast, nYr);
            System.out.println("Test2: prob=" + (float)p + "; ratio=" + (float)(p / static_prob[i]));
            nonStatic_prob[i] = p;
        }
    }
}

