/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.calc.recurInterval.gui;

import com.google.common.collect.Lists;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.gui.plot.GraphWidget;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotElement;

public class PlottingPanel
extends JPanel {
    private GraphWidget graphWidget;
    private List<PlotElement> funcList;

    public PlottingPanel() {
        this.setLayout(new GridBagLayout());
        this.funcList = new ArrayList<PlotElement>();
        this.graphWidget = new GraphWidget();
        this.add((Component)this.graphWidget, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void addGraphPanel() {
        this.graphWidget.getPlotSpec().setPlotElems(this.funcList);
        this.graphWidget.drawGraph();
        this.graphWidget.validate();
        this.graphWidget.repaint();
    }

    public void plotGraphUsingPlotPreferences() {
        this.clearPlot();
        this.addGraphPanel();
    }

    public void save() {
        try {
            this.graphWidget.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void print() {
        this.graphWidget.print();
    }

    public void peelOff() {
        GraphWindow graphWindow = new GraphWindow(this.graphWidget);
        this.remove(this.graphWidget);
        this.graphWidget = new GraphWidget();
        this.funcList = Lists.newArrayList();
        this.add((Component)this.graphWidget, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        graphWindow.setVisible(true);
    }

    public void clearPlot() {
        this.graphWidget.removeChartAndMetadata();
        this.funcList.clear();
        this.graphWidget.setAutoRange();
        this.graphWidget.validate();
        this.graphWidget.repaint();
    }

    public void addFunc(DiscretizedFunc func) {
        this.funcList.add(func);
        this.addGraphPanel();
    }
}

