/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.erf;

import com.google.common.base.Preconditions;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.faultSurface.CompoundSurface;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.RuptureSurface;

public class ProxyRupsFaultRuptureSource
extends ProbEqkSource {
    private List<Region> polys = null;
    private List<RuptureSurface> origSectSurfaces;
    private List<ProbEqkRupture> rups;

    public ProxyRupsFaultRuptureSource(List<? extends FaultSection> origSects, List<List<FaultSection>> proxySects, double mag, double rate, double rake, double duration, boolean isPoisson, double gridSpacing, boolean aseisReducesArea) {
        this(origSects, proxySects, new DefaultXY_DataSet(new double[]{mag}, new double[]{rate}), rake, duration, isPoisson, gridSpacing, aseisReducesArea);
    }

    public ProxyRupsFaultRuptureSource(List<? extends FaultSection> origSects, List<List<FaultSection>> proxySects, XY_DataSet rupMFD, double rake, double duration, boolean isPoisson, double gridSpacing, boolean aseisReducesArea) {
        this.polys = new ArrayList<Region>(origSects.size());
        for (FaultSection faultSection : origSects) {
            Region poly = faultSection.getZonePolygon();
            if (poly == null) {
                this.polys = null;
                break;
            }
            this.polys.add(poly);
        }
        if (this.polys == null) {
            this.origSectSurfaces = new ArrayList<RuptureSurface>(origSects.size());
            for (FaultSection faultSection : origSects) {
                this.origSectSurfaces.add(faultSection.getFaultSurface(gridSpacing));
            }
        }
        Preconditions.checkState((rupMFD.size() >= 1 ? 1 : 0) != 0);
        this.rups = new ArrayList<ProbEqkRupture>(proxySects.size() * rupMFD.size());
        for (List list : proxySects) {
            ArrayList<RuptureSurface> rupSurfs = new ArrayList<RuptureSurface>(list.size());
            for (FaultSection fltData : list) {
                rupSurfs.add(fltData.getFaultSurface(gridSpacing, false, aseisReducesArea));
            }
            RuptureSurface surf = rupSurfs.size() == 1 ? (RuptureSurface)rupSurfs.get(0) : new CompoundSurface(rupSurfs);
            for (Point2D mfdPt : rupMFD) {
                double mag = mfdPt.getX();
                double origRate = mfdPt.getY();
                double scaledRate = origRate / (double)proxySects.size();
                double prob = isPoisson ? 1.0 - Math.exp(-scaledRate * duration) : Math.min(1.0, scaledRate * duration);
                ProbEqkRupture probEqkRupture = new ProbEqkRupture();
                probEqkRupture.setAveRake(rake);
                probEqkRupture.setRuptureSurface(surf);
                probEqkRupture.setMag(mag);
                probEqkRupture.setProbability(prob);
                this.rups.add(probEqkRupture);
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public LocationList getAllSourceLocs() {
        throw new UnsupportedOperationException("Not Supported");
    }

    @Override
    public RuptureSurface getSourceSurface() {
        throw new UnsupportedOperationException("Not Supported");
    }

    @Override
    public double getMinDistance(Site site) {
        double minDist = Double.POSITIVE_INFINITY;
        if (this.polys != null) {
            for (Region poly : this.polys) {
                if ((minDist = Math.min(minDist, poly.distanceToLocation(site.getLocation()))) != 0.0) continue;
                return 0.0;
            }
        } else {
            for (RuptureSurface surf : this.origSectSurfaces) {
                minDist = Math.min(minDist, surf.getQuickDistance(site.getLocation()));
            }
        }
        return minDist;
    }

    @Override
    public int getNumRuptures() {
        return this.rups.size();
    }

    @Override
    public ProbEqkRupture getRupture(int nRupture) {
        return this.rups.get(nRupture);
    }
}

