/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.hazard;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.primitives.Doubles;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.math3.util.Precision;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.CSVWriter;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.logicTree.LogicTree;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.util.FileNameUtils;
import org.opensha.commons.util.io.archive.ArchiveInput;
import org.opensha.commons.util.io.archive.ArchiveOutput;
import org.opensha.sha.earthquake.faultSysSolution.hazard.LogicTreeSimplifiedMapCurveWriter;
import org.opensha.sha.earthquake.faultSysSolution.hazard.SiteLogicTreeHazardPageGen;
import org.opensha.sha.earthquake.faultSysSolution.hazard.mpj.MPJ_SiteLogicTreeHazardCurveCalc;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;
import org.opensha.sha.imr.attenRelImpl.nshmp.NSHMP_Config;

public class LogicTreeSimplifiedSiteCurveWriter {
    private static final DecimalFormat timeDF = new DecimalFormat("0.0");

    public static Options createOptions() {
        Options ops = new Options();
        ops.addOption(null, "max-zip-threads", true, "Maximum parallel zip threads (>=1, more use more memory). Default is min(8, cpus-4).");
        ops.addOption(null, "nshmp-imls", false, "Flag to store data at NSHMP-lib IMLs (period-dependent)");
        return ops;
    }

    public static void main(String[] args) {
        try {
            LogicTreeSimplifiedSiteCurveWriter.run(args);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void run(String[] args) throws IOException {
        ArchiveOutput[] outputs;
        File summaryOutputFile;
        File fullOutputFile;
        CommandLine cmd = FaultSysTools.parseOptions(LogicTreeSimplifiedSiteCurveWriter.createOptions(), args, LogicTreeSimplifiedSiteCurveWriter.class);
        args = cmd.getArgs();
        if (args.length < 2 || args.length > 3) {
            System.err.println("USAGE: LogicTreeSimplifiedSiteCurveWriter <input-site-hazard.zip> [<output-site-full-curves.zip>] <output-site-summaries.zip>");
            System.exit(1);
        }
        File inputFile = new File(args[0]);
        Preconditions.checkState((boolean)inputFile.exists());
        if (args.length == 2) {
            fullOutputFile = null;
            summaryOutputFile = new File(args[1]);
        } else {
            fullOutputFile = new File(args[1]);
            summaryOutputFile = new File(args[2]);
        }
        boolean nshmpIMLs = cmd.hasOption("nshmp-imls");
        ArchiveInput input = ArchiveInput.getDefaultInput(inputFile);
        BufferedInputStream ltIS = new BufferedInputStream(input.getInputStream("logic_tree.json"));
        LogicTree<LogicTreeNode> tree = LogicTree.read(new InputStreamReader(ltIS));
        CSVFile<String> sitesCSV = CSVFile.readStream(input.getInputStream("sites.csv"), true);
        CSVFile<String> sitesOutputCSV = new CSVFile<String>(true);
        sitesOutputCSV.addLine("Site Name", "Latitude", "Longitude", "Site Filename Prefix");
        String[] sitePrefixes = new String[sitesCSV.getNumRows() - 1];
        for (int row = 1; row < sitesCSV.getNumRows(); ++row) {
            String sitePrefix;
            String siteName = sitesCSV.get(row, 0);
            sitePrefixes[row - 1] = sitePrefix = FileNameUtils.simplify(siteName);
            sitesOutputCSV.addLine(siteName, sitesCSV.get(row, 1), sitesCSV.get(row, 2), sitePrefix);
        }
        ArchiveOutput.AsynchronousZipFileOutput summaryOutput = new ArchiveOutput.AsynchronousZipFileOutput(summaryOutputFile);
        ArchiveOutput.ApacheZipFileOutput tmpFullOutput = null;
        if (fullOutputFile != null) {
            int threads = FaultSysTools.defaultNumThreads();
            int maxThreads = Integer.min(8, threads - 4);
            if (cmd.hasOption("max-zip-threads")) {
                maxThreads = Integer.parseInt(cmd.getOptionValue("max-zip-threads"));
                Preconditions.checkState((maxThreads >= 1 ? 1 : 0) != 0, (Object)"Must have at least 1 zip thread");
            }
            tmpFullOutput = threads < 8 || maxThreads == 1 ? new ArchiveOutput.AsynchronousZipFileOutput(fullOutputFile) : new ArchiveOutput.ParallelZipFileOutput(fullOutputFile, maxThreads, true);
            outputs = new ArchiveOutput[]{summaryOutput, tmpFullOutput};
        } else {
            outputs = new ArchiveOutput[]{summaryOutput};
        }
        final ArchiveOutput.AsynchronousZipFileOutput fullOutput = tmpFullOutput;
        int treeSize = tree.size();
        final ArrayList<Double> branchWeights = new ArrayList<Double>(treeSize);
        double sumWeights = 0.0;
        for (int i = 0; i < treeSize; ++i) {
            double weight = tree.getBranchWeight(i);
            branchWeights.add(weight);
            sumWeights += weight;
        }
        if (!Precision.equals((double)sumWeights, (double)1.0, (double)1.0E-5)) {
            double scalar = 1.0 / sumWeights;
            for (int i = 0; i < treeSize; ++i) {
                branchWeights.set(i, (Double)branchWeights.get(i) * scalar);
            }
        }
        CSVFile<String> logicTreeCSV = LogicTreeSimplifiedMapCurveWriter.buildLogicTreeCSV(tree, branchWeights);
        for (ArchiveOutput output : outputs) {
            output.putNextEntry("sites.csv");
            sitesOutputCSV.writeToStream(output.getOutputStream());
            output.closeEntry();
            tree.writeToArchive(output, "");
            output.putNextEntry("logic_tree.csv");
            logicTreeCSV.writeToStream(output.getOutputStream());
            output.closeEntry();
        }
        sitesCSV = null;
        sitesOutputCSV = null;
        logicTreeCSV = null;
        System.out.println("Detecting calculation periods from " + inputFile.getName());
        ArrayList<Double> periodsList = new ArrayList<Double>(LogicTreeSimplifiedSiteCurveWriter.locateSiteCurveCSVs(sitePrefixes[0], input).keySet());
        Collections.sort(periodsList);
        double[] periods = Doubles.toArray(periodsList);
        Stopwatch overallWatch = Stopwatch.createStarted();
        CompletableFuture<Void> fullWriteFuture = null;
        CompletableFuture<Void> summaryWriteFuture = null;
        for (int s = 0; s < sitePrefixes.length; ++s) {
            System.out.println("Processing site " + s + "/" + sitePrefixes.length + ": " + sitePrefixes[s]);
            Stopwatch siteWatch = Stopwatch.createStarted();
            for (int p = 0; p < periods.length; ++p) {
                String perUnits;
                Object perLabel;
                if (periods[p] == -1.0) {
                    perLabel = "PGV";
                    perUnits = "cm/s";
                } else if (periods[p] == 0.0) {
                    perLabel = "PGA";
                    perUnits = "g";
                } else {
                    perLabel = (float)periods[p] + "s SA";
                    perUnits = "g";
                }
                final String csvName = MPJ_SiteLogicTreeHazardCurveCalc.getSitePeriodPrefix(sitePrefixes[s], periods[p]) + ".csv";
                double[] nshmpXVals = nshmpIMLs ? NSHMP_Config.imlsFor(periods[p]) : null;
                CSVFile<String> curvesCSV = CSVFile.readStream(input.getInputStream(csvName), true);
                final ArrayList<DiscretizedFunc> curves = new ArrayList<DiscretizedFunc>();
                ArrayList<Double> weights = new ArrayList<Double>();
                System.out.println("\tLoading curves and building dists for " + (String)perLabel);
                final SiteLogicTreeHazardPageGen.ValueDistribution[] dists = SiteLogicTreeHazardPageGen.loadCurvesAndDists(curvesCSV, tree.getLevels(), curves, null, weights, true, nshmpXVals);
                Preconditions.checkState((curves.size() == treeSize ? 1 : 0) != 0);
                for (int i = 0; i < treeSize; ++i) {
                    double fileWeight = (Double)weights.get(i) / sumWeights;
                    double branchWeight = (Double)weights.get(i);
                    Preconditions.checkState((boolean)Precision.equals((double)fileWeight, (double)branchWeight, (double)1.0E-5), (String)"Bad weight for curve file branch %s: %s != %s", (Object)i, (Object)Float.valueOf((float)fileWeight), (Object)Float.valueOf((float)branchWeight));
                }
                DiscretizedFunc xVals = null;
                for (DiscretizedFunc curve : curves) {
                    if (curve == null) continue;
                    xVals = curve;
                    break;
                }
                Preconditions.checkNotNull(xVals, (Object)"No non-null curves found!");
                final DiscretizedFunc finalXVals = xVals;
                if (fullOutput != null) {
                    if (fullWriteFuture != null) {
                        fullWriteFuture.join();
                    }
                    fullWriteFuture = CompletableFuture.runAsync(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                int i;
                                fullOutput.putNextEntry(csvName);
                                CSVWriter writer = new CSVWriter(fullOutput.getOutputStream(), true);
                                ArrayList<String> header = new ArrayList<String>(2 + ((DiscretizedFunc)curves.get(0)).size());
                                header.add("Branch Index");
                                header.add("Branch Weight");
                                for (i = 0; i < finalXVals.size(); ++i) {
                                    header.add("" + (float)finalXVals.getX(i));
                                }
                                writer.write(header);
                                for (i = 0; i < curves.size(); ++i) {
                                    ArrayList<String> line = new ArrayList<String>(header.size());
                                    line.add("" + i);
                                    line.add("" + ((Double)branchWeights.get(i)).floatValue());
                                    DiscretizedFunc curve = (DiscretizedFunc)curves.get(i);
                                    Preconditions.checkState((curve.size() == header.size() - 2 ? 1 : 0) != 0);
                                    for (int j = 0; j < curve.size(); ++j) {
                                        line.add("" + (float)curve.getY(j));
                                    }
                                    writer.write(line);
                                }
                                writer.flush();
                                fullOutput.closeEntry();
                            }
                            catch (IOException e) {
                                throw ExceptionUtils.asRuntimeException((Throwable)e);
                            }
                        }
                    });
                }
                if (summaryWriteFuture != null) {
                    summaryWriteFuture.join();
                }
                summaryWriteFuture = CompletableFuture.runAsync(new Runnable(){
                    final /* synthetic */ String val$perLabel;
                    final /* synthetic */ String val$perUnits;
                    final /* synthetic */ DiscretizedFunc val$finalXVals;
                    final /* synthetic */ ArchiveOutput val$summaryOutput;
                    final /* synthetic */ String val$csvName;
                    {
                        this.val$perLabel = string;
                        this.val$perUnits = string2;
                        this.val$finalXVals = discretizedFunc;
                        this.val$summaryOutput = archiveOutput;
                        this.val$csvName = string3;
                    }

                    @Override
                    public void run() {
                        CSVFile<String> csv = LogicTreeSimplifiedMapCurveWriter.buildCurveDistCSV(dists, this.val$perLabel + " (" + this.val$perUnits + ")", this.val$finalXVals);
                        try {
                            this.val$summaryOutput.putNextEntry(this.val$csvName);
                            csv.writeToStream(this.val$summaryOutput.getOutputStream());
                            this.val$summaryOutput.closeEntry();
                        }
                        catch (IOException e) {
                            throw ExceptionUtils.asRuntimeException((Throwable)e);
                        }
                    }
                });
            }
            siteWatch.stop();
            System.out.println("\tDONE with " + sitePrefixes[s] + "; took " + LogicTreeSimplifiedSiteCurveWriter.timeStr(siteWatch));
        }
        if (fullWriteFuture != null) {
            fullWriteFuture.join();
        }
        if (summaryWriteFuture != null) {
            summaryWriteFuture.join();
        }
        if (fullOutput != null) {
            fullOutput.close();
        }
        summaryOutput.close();
        System.out.println("DONE");
        overallWatch.stop();
        System.out.println("Took " + LogicTreeSimplifiedSiteCurveWriter.timeStr(overallWatch));
        System.exit(0);
    }

    public static Map<Double, String> locateSiteCurveCSVs(String sitePrefix, ArchiveInput input) throws IOException {
        HashMap<Double, String> perEntires = new HashMap<Double, String>();
        for (String entry : input.getEntries()) {
            double period;
            if (!entry.startsWith(sitePrefix)) continue;
            String nameLeft = entry.substring(sitePrefix.length());
            if (nameLeft.equals("_pgv.csv")) {
                period = -1.0;
            } else if (nameLeft.equals("_pga.csv")) {
                period = 0.0;
            } else if (nameLeft.startsWith("_sa_") && nameLeft.endsWith(".csv")) {
                String perStr = nameLeft.substring(4, nameLeft.length() - 4);
                period = Double.parseDouble(perStr);
            } else {
                System.err.println("Skipping unexpected file that we couldn't parse for a period: " + entry);
                continue;
            }
            perEntires.put(period, entry);
        }
        return perEntires;
    }

    private static String timeStr(Stopwatch watch) {
        double secs = (double)watch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
        if (secs > 60.0) {
            double mins = secs / 60.0;
            if (mins > 60.0) {
                return timeDF.format(mins / 60.0) + "h";
            }
            return timeDF.format(mins) + "m";
        }
        return timeDF.format(secs) + "s";
    }
}

