/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.hazard.mpj;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import edu.usc.kmilner.mpj.taskDispatch.AsyncPostBatchHook;
import edu.usc.kmilner.mpj.taskDispatch.MPJTaskCalculator;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.xyz.AbstractXYZ_DataSet;
import org.opensha.commons.data.xyz.ArbDiscrGeoDataSet;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.data.xyz.XYZ_DataSet;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Region;
import org.opensha.commons.geo.json.Feature;
import org.opensha.commons.logicTree.LogicTree;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeLevel;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.FileUtils;
import org.opensha.commons.util.io.archive.ArchiveInput;
import org.opensha.commons.util.io.archive.ArchiveOutput;
import org.opensha.commons.util.modules.ModuleArchive;
import org.opensha.sha.calc.params.filters.SourceFilterManager;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.hazard.LogicTreeCurveAverager;
import org.opensha.sha.earthquake.faultSysSolution.hazard.QuickGriddedHazardMapCalc;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.modules.SolutionLogicTree;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportMetadata;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysHazardCalcSettings;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;
import org.opensha.sha.earthquake.faultSysSolution.util.SolHazardMapCalc;
import org.opensha.sha.earthquake.param.IncludeBackgroundOption;
import org.opensha.sha.earthquake.util.GriddedSeismicitySettings;
import org.opensha.sha.imr.AttenRelSupplier;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.logicTree.ScalarIMR_ParamsLogicTreeNode;
import org.opensha.sha.imr.logicTree.ScalarIMRsLogicTreeNode;
import org.opensha.sha.util.TectonicRegionType;

public class MPJ_LogicTreeHazardCalc
extends MPJTaskCalculator {
    private File outputDir;
    private SolutionLogicTree solTree;
    static final double GRID_SPACING_DEFAULT = 0.1;
    private double gridSpacing = 0.1;
    private SourceFilterManager sourceFilter;
    private SourceFilterManager siteSkipSourceFilter;
    private Map<TectonicRegionType, AttenRelSupplier> gmmRefs;
    public static final double[] PERIODS_DEFAULT = new double[]{0.0, 1.0};
    private double[] periods = PERIODS_DEFAULT;
    private SolHazardMapCalc.ReturnPeriods[] rps = SolHazardMapCalc.MAP_RPS;
    static final IncludeBackgroundOption GRID_SEIS_DEFAULT = IncludeBackgroundOption.EXCLUDE;
    private IncludeBackgroundOption gridSeisOp = GRID_SEIS_DEFAULT;
    private GriddedSeismicitySettings griddedSettings;
    static final boolean AFTERSHOCK_FILTER_DEFAULT = false;
    private boolean applyAftershockFilter = false;
    static final boolean ASEIS_REDUCES_AREA_DEFAULT = true;
    boolean aseisReducesArea = true;
    private GriddedRegion gridRegion;
    private List<File> combineWithOtherDirs;
    private boolean combineOnly;
    private String hazardSubDirName;
    private String combineWithHazardExcludingSubDirName;
    private String combineWithHazardBGOnlySubDirName;
    private LogicTreeCurveAverager[] runningMeanCurves;
    private File nodesAverageDir;
    private File myAverageDir;
    private GridSourceProvider externalGridProv;
    private SolHazardMapCalc externalGriddedCurveCalc;
    private FaultSystemSolution externalSol;
    private SolHazardMapCalc externalSolCurveCalc;
    private QuickGriddedHazardMapCalc[] quickGridCalcs;
    private ExecutorService quickGridExec;
    private boolean noMFDs;
    private boolean noProxyRups;
    public static final String GRID_REGION_ENTRY_NAME = "gridded_region.geojson";
    public static final String LEVEL_CHOICE_MAPS_ENTRY_PREFIX = "level_choice_maps/";

    public MPJ_LogicTreeHazardCalc(CommandLine cmd) throws IOException {
        super(cmd);
        LogicTree<LogicTreeNode> tree;
        Object logicTreeFile;
        this.shuffle = false;
        File inputFile = new File(cmd.getOptionValue("input-file"));
        Preconditions.checkState((boolean)inputFile.exists(), (String)"Input file doesn't exist: %s", (Object)inputFile.getAbsolutePath());
        if (inputFile.isDirectory()) {
            Preconditions.checkArgument((boolean)cmd.hasOption("logic-tree"), (Object)"Must supply logic tree file if input-file is a results directory");
            logicTreeFile = new File(cmd.getOptionValue("logic-tree"));
            Preconditions.checkArgument((boolean)((File)logicTreeFile).exists(), (String)"Logic tree file doesn't exist: %s", (Object)((File)logicTreeFile).getAbsolutePath());
            tree = LogicTree.read((File)logicTreeFile);
            this.solTree = new SolutionLogicTree.ResultsDirReader(inputFile, tree);
        } else if (cmd.hasOption("logic-tree")) {
            logicTreeFile = new File(cmd.getOptionValue("logic-tree"));
            Preconditions.checkArgument((boolean)((File)logicTreeFile).exists(), (String)"Logic tree file doesn't exist: %s", (Object)((File)logicTreeFile).getAbsolutePath());
            tree = LogicTree.read((File)logicTreeFile);
            this.solTree = SolutionLogicTree.load(inputFile, tree);
        } else {
            this.solTree = SolutionLogicTree.load(inputFile);
        }
        if (this.rank == 0) {
            this.debug("Loaded " + this.solTree.getLogicTree().size() + " tree nodes/solutions");
        }
        this.outputDir = new File(cmd.getOptionValue("output-dir"));
        if (cmd.hasOption("gridded-seis")) {
            this.gridSeisOp = IncludeBackgroundOption.valueOf(cmd.getOptionValue("gridded-seis"));
        }
        this.griddedSettings = FaultSysHazardCalcSettings.getGridSeisSettings(cmd);
        if (this.gridSeisOp != IncludeBackgroundOption.EXCLUDE) {
            this.debug("Gridded settings: " + String.valueOf(this.griddedSettings));
        }
        if (cmd.hasOption("grid-spacing")) {
            this.gridSpacing = Double.parseDouble(cmd.getOptionValue("grid-spacing"));
        }
        this.sourceFilter = FaultSysHazardCalcSettings.getSourceFilters(cmd);
        this.siteSkipSourceFilter = FaultSysHazardCalcSettings.getSiteSkipSourceFilters(this.sourceFilter, cmd);
        this.gmmRefs = FaultSysHazardCalcSettings.getGMMs(cmd);
        if (this.rank == 0) {
            this.debug("GMMs:");
            for (TectonicRegionType trt : this.gmmRefs.keySet()) {
                this.debug("\tGMM for " + trt.name() + ": " + this.gmmRefs.get(trt).getName());
            }
        }
        if (cmd.hasOption("periods")) {
            ArrayList<Double> periodsList = new ArrayList<Double>();
            String periodsStr = cmd.getOptionValue("periods");
            if (periodsStr.contains(",")) {
                String[] split;
                for (String str : split = periodsStr.split(",")) {
                    periodsList.add(Double.parseDouble(str));
                }
            } else {
                periodsList.add(Double.parseDouble(periodsStr));
            }
            this.periods = Doubles.toArray(periodsList);
        }
        if (cmd.hasOption("region")) {
            Region region;
            File regFile = new File(cmd.getOptionValue("region"));
            Preconditions.checkState((boolean)regFile.exists(), (String)"Supplied region file doesn't exist: %s", (Object)regFile.getAbsolutePath());
            if (regFile.getName().toLowerCase().endsWith(".zip")) {
                ZipFile zip = new ZipFile(regFile);
                ZipEntry regEntry = zip.getEntry(GRID_REGION_ENTRY_NAME);
                if (this.rank == 0) {
                    this.debug("Reading gridded region from zip file: " + regEntry.getName());
                }
                BufferedReader bRead = new BufferedReader(new InputStreamReader(zip.getInputStream(regEntry)));
                region = GriddedRegion.fromFeature(Feature.read(bRead));
                zip.close();
            } else {
                Feature feature = Feature.read(regFile);
                region = Region.fromFeature(feature);
            }
            if (region instanceof GriddedRegion) {
                this.gridRegion = (GriddedRegion)region;
                Preconditions.checkState((!cmd.hasOption("grid-spacing") || (float)this.gridSpacing == (float)this.gridRegion.getSpacing() ? 1 : 0) != 0, (Object)"Supplied a gridded region via the command line, cannont also specify grid spacing.");
                this.gridSpacing = this.gridRegion.getSpacing();
            } else {
                this.gridRegion = new GriddedRegion(region, this.gridSpacing, GriddedRegion.ANCHOR_0_0);
            }
        }
        if (cmd.hasOption("aftershock-filter")) {
            this.applyAftershockFilter = true;
        }
        if (cmd.hasOption("aseis-reduces-area") || cmd.hasOption("no-aseis-reduces-area")) {
            Preconditions.checkState((!cmd.hasOption("aseis-reduces-area") || !cmd.hasOption("no-aseis-reduces-area") ? 1 : 0) != 0, (Object)"Can't both enable and disable aseismicity area reductions!");
            this.aseisReducesArea = cmd.hasOption("aseis-reduces-area");
        }
        String hazardPrefix = "hazard_" + (float)this.gridSpacing + "deg";
        if (this.applyAftershockFilter) {
            hazardPrefix = hazardPrefix + "_aftershock_filter";
        }
        hazardPrefix = hazardPrefix + "_grid_seis_";
        this.hazardSubDirName = hazardPrefix + this.gridSeisOp.name();
        if (cmd.hasOption("external-grid-prov")) {
            File gpFile = new File(cmd.getOptionValue("external-grid-prov"));
            Preconditions.checkState((boolean)gpFile.exists());
            ArchiveInput resultsInput = ArchiveInput.getDefaultInput(gpFile);
            if (FaultSystemSolution.isSolution(resultsInput)) {
                this.externalGridProv = FaultSystemSolution.load(resultsInput).requireModule(GridSourceProvider.class);
            } else {
                ModuleArchive avgArchive = new ModuleArchive(resultsInput);
                this.externalGridProv = avgArchive.requireModule(GridSourceProvider.class);
            }
            Preconditions.checkArgument((this.gridSeisOp != IncludeBackgroundOption.EXCLUDE ? 1 : 0) != 0, (Object)"External single grid provider was supplied, but background seismicity is disabled?");
            resultsInput.close();
        }
        if (cmd.hasOption("external-fss")) {
            File solFile = new File(cmd.getOptionValue("external-fss"));
            Preconditions.checkState((boolean)solFile.exists());
            this.externalSol = FaultSystemSolution.load(solFile);
            Preconditions.checkArgument((this.gridSeisOp != IncludeBackgroundOption.ONLY ? 1 : 0) != 0, (Object)"External single solution was supplied, but only calculating for background seismicity?");
        }
        if (this.gridSeisOp != IncludeBackgroundOption.EXCLUDE) {
            this.combineWithHazardExcludingSubDirName = hazardPrefix + IncludeBackgroundOption.EXCLUDE.name();
            this.combineWithHazardBGOnlySubDirName = hazardPrefix + IncludeBackgroundOption.ONLY.name();
        }
        if (cmd.hasOption("combine-with-dir")) {
            String[] cwds = cmd.getOptionValues("combine-with-dir");
            this.combineWithOtherDirs = new ArrayList<File>(cwds.length);
            for (String cwd : cwds) {
                File combineWithOtherDir = new File(cwd);
                if (!combineWithOtherDir.exists()) continue;
                this.combineWithOtherDirs.add(combineWithOtherDir);
            }
            if (this.combineWithOtherDirs.isEmpty()) {
                this.combineWithOtherDirs = null;
            }
        }
        this.combineOnly = cmd.hasOption("combine-only");
        if (cmd.hasOption("quick-grid-calc") && (this.gridSeisOp == IncludeBackgroundOption.INCLUDE || this.gridSeisOp == IncludeBackgroundOption.ONLY)) {
            this.quickGridCalcs = new QuickGriddedHazardMapCalc[this.periods.length];
            for (int p = 0; p < this.quickGridCalcs.length; ++p) {
                this.quickGridCalcs[p] = new QuickGriddedHazardMapCalc(this.gmmRefs, this.periods[p], FaultSysHazardCalcSettings.getDefaultXVals(this.periods[p]), this.sourceFilter, this.griddedSettings);
            }
        }
        this.noMFDs = cmd.hasOption("no-mfds");
        this.noProxyRups = cmd.hasOption("no-proxy-ruptures");
        if (this.rank == 0) {
            MPJ_LogicTreeHazardCalc.waitOnDir(this.outputDir, 5, 1000L);
            File outputFile = cmd.hasOption("output-file") ? new File(cmd.getOptionValue("output-file")) : new File(this.outputDir.getParentFile(), this.outputDir.getName() + "_hazard.zip");
            this.postBatchHook = new AsyncHazardWriter(outputFile);
        }
        this.nodesAverageDir = new File(this.outputDir, "node_hazard_averages");
        if (this.rank == 0) {
            if (this.nodesAverageDir.exists()) {
                for (File file : this.nodesAverageDir.listFiles()) {
                    Preconditions.checkState((boolean)FileUtils.deleteRecursive(file));
                }
            } else {
                Preconditions.checkState((this.nodesAverageDir.mkdir() || this.nodesAverageDir.exists() ? 1 : 0) != 0);
            }
        }
        this.myAverageDir = new File(this.nodesAverageDir, "rank_" + this.rank);
    }

    private synchronized void checkInitRunningMean() {
        if (this.runningMeanCurves == null) {
            HashSet<LogicTreeNode> variableNodes = new HashSet<LogicTreeNode>();
            HashMap nodeLevels = new HashMap();
            LogicTreeCurveAverager.populateVariableNodes(this.solTree.getLogicTree(), variableNodes, nodeLevels);
            this.runningMeanCurves = new LogicTreeCurveAverager[this.periods.length];
            for (int p = 0; p < this.periods.length; ++p) {
                this.runningMeanCurves[p] = new LogicTreeCurveAverager(this.gridRegion.getNodeList(), variableNodes, nodeLevels);
            }
        }
    }

    public static void writeMeanCurvesAndMaps(ZipOutputStream zout, LogicTreeCurveAverager[] meanCurves, GriddedRegion gridRegion, double[] periods, SolHazardMapCalc.ReturnPeriods[] rps) throws IOException {
        MPJ_LogicTreeHazardCalc.writeMeanCurvesAndMaps(new ArchiveOutput.ZipFileOutput(zout), meanCurves, gridRegion, periods, rps);
    }

    public static void writeMeanCurvesAndMaps(ArchiveOutput output, LogicTreeCurveAverager[] meanCurves, GriddedRegion gridRegion, double[] periods, SolHazardMapCalc.ReturnPeriods[] rps) throws IOException {
        boolean firstLT = true;
        for (int p = 0; p < periods.length; ++p) {
            Map<String, DiscretizedFunc[]> normCurves = meanCurves[p].getNormalizedCurves();
            for (String key : normCurves.keySet()) {
                Object prefix;
                DiscretizedFunc[] curves = normCurves.get(key);
                if (key.equals("mean")) {
                    CSVFile<String> csv = SolHazardMapCalc.buildCurvesCSV(curves, gridRegion.getNodeList());
                    String fileName = "mean_" + SolHazardMapCalc.getCSV_FileName("curves", periods[p]);
                    output.putNextEntry(fileName);
                    csv.writeToStream(output.getOutputStream());
                    output.closeEntry();
                    prefix = key;
                } else {
                    prefix = LEVEL_CHOICE_MAPS_ENTRY_PREFIX;
                    if (firstLT) {
                        output.putNextEntry((String)prefix);
                        output.closeEntry();
                        firstLT = false;
                    }
                    prefix = (String)prefix + key;
                }
                for (SolHazardMapCalc.ReturnPeriods rp : rps) {
                    String mapFileName = (String)prefix + "_" + MPJ_LogicTreeHazardCalc.mapPrefix(periods[p], rp) + ".txt";
                    double curveLevel = rp.oneYearProb;
                    GriddedGeoDataSet xyz = new GriddedGeoDataSet(gridRegion, false);
                    for (int i = 0; i < xyz.size(); ++i) {
                        DiscretizedFunc curve = curves[i];
                        double val = curveLevel > curve.getMaxY() ? 0.0 : (curveLevel < curve.getMinY() ? curve.getMaxX() : curve.getFirstInterpolatedX_inLogXLogYDomain(curveLevel));
                        xyz.set(i, val);
                    }
                    output.putNextEntry(mapFileName);
                    ArbDiscrGeoDataSet.writeXYZStream(xyz, output.getOutputStream());
                    output.closeEntry();
                }
            }
        }
    }

    protected void doFinalAssembly() throws Exception {
        if (this.quickGridExec != null) {
            this.quickGridExec.shutdown();
        }
        Preconditions.checkState((this.myAverageDir.exists() || this.myAverageDir.mkdir() ? 1 : 0) != 0);
        if (this.runningMeanCurves != null) {
            for (int p = 0; p < this.periods.length; ++p) {
                Object imt = this.periods[p] == -1.0 ? "PGV" : (this.periods[p] == 0.0 ? "PGA" : (float)this.periods[p] + "s");
                this.debug("Caching " + (String)imt + " mean curves to " + this.myAverageDir.getAbsolutePath());
                this.runningMeanCurves[p].rawCacheToDir(this.myAverageDir, this.periods[p]);
            }
        }
        if (this.rank == 0) {
            this.debug("waiting for any post batch hook operations to finish");
            ((AsyncPostBatchHook)this.postBatchHook).shutdown();
            this.debug("post batch hook done");
        }
    }

    public static void waitOnDir(File dir, int maxRetries, long sleepMillis) {
        int retry = 0;
        while (!dir.exists() && !dir.mkdir()) {
            try {
                Thread.sleep(sleepMillis);
            }
            catch (InterruptedException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            if (retry++ <= maxRetries) continue;
            throw new IllegalStateException("Directory doesn't exist and couldn't be created after " + maxRetries + " retries: " + dir.getAbsolutePath());
        }
    }

    protected int getNumTasks() {
        return this.solTree.getLogicTree().size();
    }

    protected File getSolDir(LogicTreeBranch<?> branch) {
        return this.getSolDir(branch, true);
    }

    protected File getSolDir(LogicTreeBranch<?> branch, boolean mkdir) {
        return this.getSolDir(this.outputDir, branch, mkdir);
    }

    private File getSolDir(File outputDir, LogicTreeBranch<?> branch, boolean mkdir) {
        return branch.getBranchDirectory(outputDir, mkdir);
    }

    public static String mapPrefix(double period, SolHazardMapCalc.ReturnPeriods rp) {
        Object ret = "map_";
        ret = period == 0.0 ? (String)ret + "pga" : (String)ret + (float)period + "s";
        ret = (String)ret + "_" + rp.name();
        return ret;
    }

    private GriddedRegion detectRegion(FaultSystemSolution sol) {
        Region region = ReportMetadata.detectRegion(sol);
        return new GriddedRegion(region, this.gridSpacing, GriddedRegion.ANCHOR_0_0);
    }

    private File getHazardOutputDir(File runDir, LogicTreeBranch<?> branch) {
        File onlyHazardDir;
        File hazardOutDir = new File(runDir, this.hazardSubDirName);
        if (this.gridSeisOp == IncludeBackgroundOption.ONLY && (onlyHazardDir = this.getGriddedOnlyHazardDir(branch, this.outputDir, null)) != null) {
            this.debug("Will write any outputs to upstream gridded-only hazard directory: " + onlyHazardDir.getAbsolutePath());
            File parentDir = onlyHazardDir.getParentFile();
            Preconditions.checkState((parentDir.exists() || parentDir.mkdir() ? 1 : 0) != 0);
            hazardOutDir = onlyHazardDir;
        }
        return hazardOutDir;
    }

    protected void calculateBatch(int[] batch) throws Exception {
        for (int index : batch) {
            File runDir;
            File hazardOutDir;
            System.gc();
            LogicTreeBranch<?> branch = this.solTree.getLogicTree().getBranch(index);
            this.debug("Loading index " + index + ": " + String.valueOf(branch));
            FaultSystemSolution sol = null;
            if (this.gridRegion == null) {
                sol = this.solTree.forBranch(branch);
                this.gridRegion = this.detectRegion(sol);
            }
            Preconditions.checkState(((hazardOutDir = this.getHazardOutputDir(runDir = this.getSolDir(branch), branch)).exists() || hazardOutDir.mkdir() ? 1 : 0) != 0);
            String curvesPrefix = "curves";
            SolHazardMapCalc calc = null;
            if (hazardOutDir.exists()) {
                try {
                    calc = SolHazardMapCalc.loadCurves(sol, this.gridRegion, this.periods, hazardOutDir, curvesPrefix);
                }
                catch (Exception e) {
                    this.debug("Hazard subdir ('" + this.hazardSubDirName + "') exsists, but couldn't be reused: " + e.getMessage());
                }
            }
            SolHazardMapCalc combineWithExcludeCurves = null;
            SolHazardMapCalc combineWithOnlyCurves = null;
            if (calc == null) {
                ArrayList<File> combineFromDirs = new ArrayList<File>();
                combineFromDirs.add(null);
                if (this.combineWithOtherDirs != null) {
                    combineFromDirs.addAll(this.combineWithOtherDirs);
                }
                if (this.gridSeisOp != IncludeBackgroundOption.EXCLUDE) {
                    File combineFromRunDir;
                    if (this.gridSeisOp != IncludeBackgroundOption.ONLY) {
                        for (File sourceDir : combineFromDirs) {
                            block68: {
                                boolean verbose;
                                block67: {
                                    if (sourceDir == null) {
                                        verbose = false;
                                        combineFromRunDir = runDir;
                                    } else {
                                        verbose = true;
                                        combineFromRunDir = this.getSolDir(sourceDir, branch, false);
                                    }
                                    File combineWithSubDir = new File(combineFromRunDir, this.combineWithHazardExcludingSubDirName);
                                    if (combineWithSubDir.exists()) {
                                        if (verbose) {
                                            this.debug("Seeing if we can reuse existing curves excluding gridded seismicity from " + combineWithSubDir.getAbsolutePath());
                                        }
                                        try {
                                            combineWithExcludeCurves = SolHazardMapCalc.loadCurves(sol, this.gridRegion, this.periods, combineWithSubDir, curvesPrefix);
                                        }
                                        catch (Exception e) {
                                            if (!verbose) break block67;
                                            this.debug("Can't reuse: " + e.getMessage());
                                        }
                                    }
                                }
                                if (combineWithExcludeCurves == null) {
                                    LogicTreeBranch subBranch;
                                    File subRunDir;
                                    File subHazardDir;
                                    ArrayList faultLevels = new ArrayList();
                                    ArrayList faultNodes = new ArrayList();
                                    for (int i = 0; i < branch.size(); ++i) {
                                        LogicTreeLevel<?> level = branch.getLevel(i);
                                        Object node = branch.getValue(i);
                                        if (!level.affects("rates.csv", true) && !(node instanceof ScalarIMRsLogicTreeNode) && !(node instanceof ScalarIMR_ParamsLogicTreeNode)) continue;
                                        faultLevels.add(level);
                                        faultNodes.add(branch.getValue(i));
                                    }
                                    if (faultLevels.size() < branch.size() && (subHazardDir = new File(subRunDir = this.getSolDir(sourceDir == null ? runDir : sourceDir, subBranch = new LogicTreeBranch(faultLevels, faultNodes), false), this.combineWithHazardExcludingSubDirName)).exists()) {
                                        try {
                                            if (verbose) {
                                                this.debug("Seeing if we can reuse existing curves excluding gridded seismicity from " + subHazardDir.getAbsolutePath());
                                            }
                                            combineWithExcludeCurves = SolHazardMapCalc.loadCurves(sol, this.gridRegion, this.periods, subHazardDir, curvesPrefix);
                                        }
                                        catch (Exception e) {
                                            if (!verbose) break block68;
                                            this.debug("Can't reuse: " + e.getMessage());
                                        }
                                    }
                                }
                            }
                            if (combineWithExcludeCurves == null) continue;
                            break;
                        }
                    }
                    for (File sourceDir : combineFromDirs) {
                        File subHazardDir;
                        combineFromRunDir = sourceDir == null ? runDir : this.getSolDir(sourceDir, branch, false);
                        File combineWithSubDir = new File(combineFromRunDir, this.combineWithHazardBGOnlySubDirName);
                        if (combineWithSubDir.exists()) {
                            this.debug("Seeing if we can reuse existing curves with only gridded seismicity from " + combineWithSubDir.getAbsolutePath());
                            try {
                                combineWithOnlyCurves = SolHazardMapCalc.loadCurves(sol, this.gridRegion, this.periods, combineWithSubDir, curvesPrefix);
                            }
                            catch (Exception e) {
                                this.debug("Can't reuse: " + e.getMessage());
                            }
                        }
                        if (combineWithOnlyCurves == null && (subHazardDir = this.getGriddedOnlyHazardDir(branch, sourceDir, combineFromRunDir)) != null) {
                            this.debug("testing gridLevels dir: " + subHazardDir.getAbsolutePath());
                            if (subHazardDir.exists()) {
                                try {
                                    this.debug("Seeing if we can reuse existing curves with only gridded seismicity from " + subHazardDir.getAbsolutePath());
                                    combineWithOnlyCurves = SolHazardMapCalc.loadCurves(sol, this.gridRegion, this.periods, subHazardDir, curvesPrefix);
                                }
                                catch (Exception e) {
                                    this.debug("Can't reuse: " + e.getMessage());
                                }
                            }
                        }
                        if (combineWithOnlyCurves == null) continue;
                        break;
                    }
                }
                if (combineWithOnlyCurves == null && this.externalGridProv != null) {
                    if (this.externalGriddedCurveCalc == null) {
                        if (sol == null) {
                            sol = this.solTree.forBranch(branch);
                        }
                        this.debug("Calculating external grid source provider curves (will only do this once)");
                        FaultSystemSolution extSol = new FaultSystemSolution(sol.getRupSet(), sol.getRateForAllRups());
                        extSol.setGridSourceProvider(this.externalGridProv);
                        this.externalGriddedCurveCalc = new SolHazardMapCalc(extSol, FaultSysHazardCalcSettings.getGMM_Suppliers(branch, this.gmmRefs, true), this.gridRegion, IncludeBackgroundOption.ONLY, this.applyAftershockFilter, this.periods);
                        this.externalGriddedCurveCalc.setSourceFilter(this.sourceFilter);
                        this.externalGriddedCurveCalc.setSiteSkipSourceFilter(this.siteSkipSourceFilter);
                        this.externalGriddedCurveCalc.setGriddedSeismicitySettings(this.griddedSettings);
                        this.externalGriddedCurveCalc.setCacheGridSources(true);
                        this.externalGriddedCurveCalc.calcHazardCurves(this.getNumThreads());
                    }
                    combineWithOnlyCurves = this.externalGriddedCurveCalc;
                }
                if (this.externalSol != null && this.gridSeisOp != IncludeBackgroundOption.ONLY && combineWithExcludeCurves == null) {
                    if (this.externalSolCurveCalc == null) {
                        if (sol == null) {
                            sol = this.solTree.forBranch(branch);
                        }
                        this.debug("Calculating external solution curves (will only do this once)");
                        this.externalSolCurveCalc = new SolHazardMapCalc(this.externalSol, FaultSysHazardCalcSettings.getGMM_Suppliers(branch, this.gmmRefs, true), this.gridRegion, IncludeBackgroundOption.EXCLUDE, this.applyAftershockFilter, this.periods);
                        this.externalSolCurveCalc.setSourceFilter(this.sourceFilter);
                        this.externalSolCurveCalc.setSiteSkipSourceFilter(this.siteSkipSourceFilter);
                        this.externalSolCurveCalc.setCacheGridSources(false);
                        this.externalSolCurveCalc.calcHazardCurves(this.getNumThreads());
                    }
                    combineWithExcludeCurves = this.externalSolCurveCalc;
                }
                if (this.quickGridCalcs != null && combineWithOnlyCurves == null) {
                    Preconditions.checkState((!this.combineOnly ? 1 : 0) != 0, (Object)("Combine-only flag is set, but we need to calculate gridded only for " + String.valueOf(branch)));
                    if (sol == null) {
                        sol = this.solTree.forBranch(branch);
                    }
                    QuickGriddedHazardMapCalc[] quickGridCalcs = this.quickGridCalcs;
                    if (branch.hasValue(ScalarIMRsLogicTreeNode.class) || branch.hasValue(ScalarIMR_ParamsLogicTreeNode.class)) {
                        quickGridCalcs = new QuickGriddedHazardMapCalc[this.periods.length];
                        for (int p = 0; p < this.periods.length; ++p) {
                            quickGridCalcs[p] = new QuickGriddedHazardMapCalc(FaultSysHazardCalcSettings.getGMM_Suppliers(branch, this.gmmRefs, true), this.periods[p], FaultSysHazardCalcSettings.getDefaultXVals(this.periods[p]), this.sourceFilter, this.griddedSettings);
                        }
                    }
                    this.debug("Doing quick gridded seismicity calc for " + index);
                    Object curves = new ArrayList();
                    if (this.quickGridExec == null) {
                        this.quickGridExec = Executors.newFixedThreadPool(this.getNumThreads());
                    }
                    for (int p = 0; p < this.periods.length; ++p) {
                        curves.add(quickGridCalcs[p].calc(sol.getGridSourceProvider(), this.gridRegion, this.quickGridExec, this.getNumThreads()));
                    }
                    combineWithOnlyCurves = SolHazardMapCalc.forCurves(sol, this.gridRegion, this.periods, (List<DiscretizedFunc[]>)curves);
                    if (this.gridSeisOp == IncludeBackgroundOption.ONLY) {
                        combineWithOnlyCurves.writeCurvesCSVs(hazardOutDir, curvesPrefix, true);
                    }
                }
                if (this.gridSeisOp == IncludeBackgroundOption.INCLUDE && combineWithOnlyCurves != null && combineWithExcludeCurves != null) {
                    ArrayList<DiscretizedFunc[]> combCurvesList = new ArrayList<DiscretizedFunc[]>();
                    for (double period : this.periods) {
                        DiscretizedFunc[] excludeCurves = combineWithExcludeCurves.getCurves(period);
                        DiscretizedFunc[] onlyCurves = combineWithOnlyCurves.getCurves(period);
                        Preconditions.checkState((excludeCurves.length == this.gridRegion.getNodeCount() ? 1 : 0) != 0);
                        Preconditions.checkState((excludeCurves.length == onlyCurves.length ? 1 : 0) != 0);
                        DiscretizedFunc[] combCurves = new DiscretizedFunc[excludeCurves.length];
                        for (int i = 0; i < combCurves.length; ++i) {
                            DiscretizedFunc combCurve;
                            DiscretizedFunc curve1 = excludeCurves[i];
                            DiscretizedFunc curve2 = onlyCurves[i];
                            if (curve1 == null && curve2 == null) {
                                combCurve = null;
                            } else if (curve1 == null) {
                                combCurve = curve2;
                            } else if (curve2 == null) {
                                combCurve = curve1;
                            } else {
                                Preconditions.checkState((curve1.size() == curve2.size() ? 1 : 0) != 0);
                                combCurve = new ArbitrarilyDiscretizedFunc();
                                for (int j = 0; j < curve1.size(); ++j) {
                                    double x = curve1.getX(j);
                                    Preconditions.checkState(((float)x == (float)curve2.getX(j) ? 1 : 0) != 0);
                                    double y1 = curve1.getY(j);
                                    double y2 = curve2.getY(j);
                                    combCurve.set(x, 1.0 - (1.0 - y1) * (1.0 - y2));
                                }
                            }
                            combCurves[i] = combCurve;
                        }
                        combCurvesList.add(combCurves);
                    }
                    calc = SolHazardMapCalc.forCurves(sol, this.gridRegion, this.periods, combCurvesList);
                    calc.writeCurvesCSVs(hazardOutDir, curvesPrefix, true);
                } else if (calc == null && this.gridSeisOp == IncludeBackgroundOption.ONLY && combineWithOnlyCurves != null) {
                    calc = combineWithOnlyCurves;
                }
            }
            if (calc == null) {
                if (sol == null) {
                    sol = this.solTree.forBranch(branch);
                }
                Map<TectonicRegionType, AttenRelSupplier> gmpeSuppliers = FaultSysHazardCalcSettings.getGMM_Suppliers(branch, this.gmmRefs, true);
                Object gmpeParamsStr = "";
                if (gmpeSuppliers.size() == 1) {
                    ScalarIMR gmpe = (ScalarIMR)((Supplier)gmpeSuppliers.values().iterator().next()).get();
                    gmpeParamsStr = "\n\tGMPE: " + gmpe.getName();
                    for (Parameter<?> param : gmpe.getOtherParams()) {
                        gmpeParamsStr = (String)gmpeParamsStr + "; " + param.getName() + ": " + String.valueOf(param.getValue());
                    }
                }
                this.debug("Calculating hazard curves for " + index + ", bgOption=" + this.gridSeisOp.name() + ", combineExclude=" + (combineWithExcludeCurves != null) + ", combineOnly=" + this.combineOnly + "\n\tBranch: " + String.valueOf(branch) + (String)gmpeParamsStr);
                Preconditions.checkState((!this.combineOnly ? 1 : 0) != 0, (Object)("Combine-only flag is set, but we need to calculate for " + String.valueOf(branch)));
                SolHazardMapCalc combineWithCurves = null;
                if (combineWithExcludeCurves == null && combineWithOnlyCurves == null) {
                    calc = new SolHazardMapCalc(sol, gmpeSuppliers, this.gridRegion, this.gridSeisOp, this.applyAftershockFilter, this.periods);
                } else if (combineWithExcludeCurves != null) {
                    this.debug("Reusing fault-based hazard for " + index + ", will only compute gridded hazard");
                    combineWithCurves = combineWithExcludeCurves;
                    calc = new SolHazardMapCalc(sol, gmpeSuppliers, this.gridRegion, IncludeBackgroundOption.ONLY, this.applyAftershockFilter, this.periods);
                } else if (combineWithOnlyCurves != null) {
                    this.debug("Reusing fault-based hazard for " + index + ", will only compute gridded hazard");
                    combineWithCurves = combineWithOnlyCurves;
                    calc = new SolHazardMapCalc(sol, gmpeSuppliers, this.gridRegion, IncludeBackgroundOption.EXCLUDE, this.applyAftershockFilter, this.periods);
                }
                calc.setSourceFilter(this.sourceFilter);
                calc.setSiteSkipSourceFilter(this.siteSkipSourceFilter);
                calc.setGriddedSeismicitySettings(this.griddedSettings);
                calc.setCacheGridSources(true);
                calc.setAseisReducesArea(this.aseisReducesArea);
                calc.setNoMFDs(this.noMFDs);
                calc.setUseProxyRups(!this.noProxyRups);
                calc.calcHazardCurves(this.getNumThreads(), combineWithCurves);
                calc.writeCurvesCSVs(hazardOutDir, curvesPrefix, true);
            }
            this.checkInitRunningMean();
            double branchWeight = this.solTree.getLogicTree().getBranchWeight(branch);
            for (int p = 0; p < this.periods.length; ++p) {
                DiscretizedFunc[] curves = calc.getCurves(this.periods[p]);
                this.runningMeanCurves[p].processBranchCurves(branch, branchWeight, curves);
            }
            for (SolHazardMapCalc.ReturnPeriods rp : this.rps) {
                for (double period : this.periods) {
                    GriddedGeoDataSet map = calc.buildMap(period, rp);
                    String prefix = MPJ_LogicTreeHazardCalc.mapPrefix(period, rp);
                    AbstractXYZ_DataSet.writeXYZFile((XYZ_DataSet)map, new File(hazardOutDir, prefix + ".txt"));
                }
            }
        }
    }

    private File getGriddedOnlyHazardDir(LogicTreeBranch<?> branch, File sourceDir, File combineFromRunDir) {
        ArrayList gridLevels = new ArrayList();
        ArrayList gridNodes = new ArrayList();
        for (int i = 0; i < branch.size(); ++i) {
            LogicTreeLevel<?> level = branch.getLevel(i);
            Object node = branch.getValue(i);
            if (!GridSourceProvider.affectedByLevel(level) && !(node instanceof ScalarIMRsLogicTreeNode) && !(node instanceof ScalarIMR_ParamsLogicTreeNode)) continue;
            gridLevels.add(level);
            gridNodes.add(branch.getValue(i));
        }
        if (gridLevels.size() < branch.size()) {
            LogicTreeBranch subBranch = new LogicTreeBranch(gridLevels, gridNodes);
            File subRunDir = this.getSolDir(sourceDir == null ? this.outputDir : sourceDir, subBranch, false);
            File subHazardDir = new File(subRunDir, this.combineWithHazardBGOnlySubDirName);
            if (combineFromRunDir != null && !subHazardDir.exists()) {
                subRunDir = this.getSolDir(this.outputDir, subBranch, false);
                subHazardDir = new File(subRunDir, this.combineWithHazardBGOnlySubDirName);
            }
            return subHazardDir;
        }
        return null;
    }

    public static Options createOptions() {
        Options ops = MPJTaskCalculator.createOptions();
        FaultSysHazardCalcSettings.addCommonOptions(ops, true);
        ops.addRequiredOption("if", "input-file", true, "Path to input file (solution logic tree zip)");
        ops.addOption("lt", "logic-tree", true, "Path to logic tree JSON file, required if a results directory is supplied with --input-file");
        ops.addRequiredOption("od", "output-dir", true, "Path to output directory");
        ops.addOption("of", "output-file", true, "Path to output zip file. Default will be based on the output directory");
        ops.addOption("sp", "grid-spacing", true, "Grid spacing in decimal degrees. Default: 0.1");
        ops.addOption("gs", "gridded-seis", true, "Gridded seismicity option. One of " + FaultSysTools.enumOptions(IncludeBackgroundOption.class) + ". Default: " + GRID_SEIS_DEFAULT.name());
        ops.addOption("r", "region", true, "Optional path to GeoJSON file containing a region for which we should compute hazard. Can be a gridded region or an outline. If not supplied, then one will be detected from the model. If a zip file is supplied, then it is assumed that the file is a prior hazard calculation zip file and the region will be reused from that prior calculation.");
        ops.addOption("af", "aftershock-filter", false, "If supplied, the aftershock filter will be applied in the ERF");
        ops.addOption(null, "aseis-reduces-area", false, "If supplied, aseismicity area reductions are enabled");
        ops.addOption(null, "no-aseis-reduces-area", false, "If supplied, aseismicity area reductions are disabled");
        ops.addOption("egp", "external-grid-prov", true, "Path to external grid source provider to use for hazard calculations. Can be either a fault system solution, or a zip file containing just a grid source provider.");
        ops.addOption(null, "external-fss", true, "Path to external fault-system solution to use for hazard calculations; the regular input-file will only be used for gridded-seismicity.");
        ops.addOption("qgc", "quick-grid-calc", false, "Flag to enable quick gridded seismicity calculation.");
        ops.addOption("cwd", "combine-with-dir", true, "Path to a different directory to serach for pre-computed curves to draw from. Can supply multiple times to specify multiple directories.");
        ops.addOption(null, "combine-only", false, "Flag to ensure that no actual calculations are done, just combinations.");
        ops.addOption(null, "no-mfds", false, "Flag to disable rupture MFDs, i.e., use a single magnitude for all ruptures in the case of a branch-averaged solution");
        ops.addOption(null, "no-proxy-ruptures", false, "Flag to disable proxy ruptures MFDs, i.e., use a single proxy fault instead of distributed proxies that fill the source zone");
        return ops;
    }

    public static void main(String[] args) {
        System.setProperty("java.awt.headless", "true");
        try {
            args = MPJTaskCalculator.initMPJ((String[])args);
            Options options = MPJ_LogicTreeHazardCalc.createOptions();
            CommandLine cmd = MPJ_LogicTreeHazardCalc.parse((Options)options, (String[])args, MPJ_LogicTreeHazardCalc.class);
            MPJ_LogicTreeHazardCalc driver = new MPJ_LogicTreeHazardCalc(cmd);
            driver.run();
            MPJ_LogicTreeHazardCalc.finalizeMPJ();
            System.exit(0);
        }
        catch (Throwable t) {
            MPJ_LogicTreeHazardCalc.abortAndExit((Throwable)t);
        }
    }

    private class AsyncHazardWriter
    extends AsyncPostBatchHook {
        private ArchiveOutput zout;
        private double[] rankWeights;

        public AsyncHazardWriter(File destFile) throws IOException {
            super(1);
            this.zout = new ArchiveOutput.ParallelZipFileOutput(destFile, 4, false);
            this.rankWeights = new double[MPJ_LogicTreeHazardCalc.this.size];
        }

        public void shutdown() {
            super.shutdown();
            try {
                if (MPJ_LogicTreeHazardCalc.this.gridRegion == null) {
                    LogicTreeBranch<?> branch = MPJ_LogicTreeHazardCalc.this.solTree.getLogicTree().getBranch(0);
                    MPJ_LogicTreeHazardCalc.this.debug("Loading solution 0 to detect region: " + String.valueOf(branch));
                    FaultSystemSolution sol = MPJ_LogicTreeHazardCalc.this.solTree.forBranch(branch);
                    MPJ_LogicTreeHazardCalc.this.gridRegion = MPJ_LogicTreeHazardCalc.this.detectRegion(sol);
                }
                MPJ_LogicTreeHazardCalc.this.checkInitRunningMean();
                int loadThreads = Integer.max(1, Integer.min(8, MPJ_LogicTreeHazardCalc.this.getNumThreads()));
                ExecutorService loadExec = Executors.newFixedThreadPool(loadThreads);
                for (int p = 0; p < MPJ_LogicTreeHazardCalc.this.periods.length; ++p) {
                    final LogicTreeCurveAverager globalCurves = MPJ_LogicTreeHazardCalc.this.runningMeanCurves[p];
                    CompletableFuture<Void> mergeFuture = null;
                    for (int rank = 1; rank < MPJ_LogicTreeHazardCalc.this.size; ++rank) {
                        if (this.rankWeights[rank] == 0.0) continue;
                        File rankDir = new File(MPJ_LogicTreeHazardCalc.this.nodesAverageDir, "rank_" + rank);
                        MPJ_LogicTreeHazardCalc.this.debug("Async: Merging in p=" + (float)MPJ_LogicTreeHazardCalc.this.periods[p] + " mean curves from " + rank + ": " + rankDir.getAbsolutePath());
                        Preconditions.checkState((boolean)rankDir.exists(), (String)"Dir doesn't exist: %s", (Object)rankDir.getAbsolutePath());
                        final LogicTreeCurveAverager rankCurves = LogicTreeCurveAverager.readRawCacheDir(rankDir, MPJ_LogicTreeHazardCalc.this.periods[p], loadExec);
                        if (mergeFuture != null) {
                            mergeFuture.join();
                        }
                        mergeFuture = CompletableFuture.runAsync(new Runnable(){
                            final /* synthetic */ AsyncHazardWriter this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                globalCurves.addFrom(rankCurves);
                            }
                        });
                    }
                    if (mergeFuture == null) continue;
                    mergeFuture.join();
                }
                loadExec.shutdown();
                MPJ_LogicTreeHazardCalc.this.debug("Async: deleting " + MPJ_LogicTreeHazardCalc.this.nodesAverageDir.getAbsolutePath());
                CompletableFuture<Void> deleteFuture = CompletableFuture.runAsync(new Runnable(){

                    @Override
                    public void run() {
                        FileUtils.deleteRecursive(MPJ_LogicTreeHazardCalc.this.nodesAverageDir);
                    }
                });
                MPJ_LogicTreeHazardCalc.this.debug("Async: writing mean curves and maps");
                MPJ_LogicTreeHazardCalc.writeMeanCurvesAndMaps(this.zout, MPJ_LogicTreeHazardCalc.this.runningMeanCurves, MPJ_LogicTreeHazardCalc.this.gridRegion, MPJ_LogicTreeHazardCalc.this.periods, MPJ_LogicTreeHazardCalc.this.rps);
                Feature feature = MPJ_LogicTreeHazardCalc.this.gridRegion.toFeature();
                this.zout.putNextEntry(MPJ_LogicTreeHazardCalc.GRID_REGION_ENTRY_NAME);
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.zout.getOutputStream()));
                Feature.write(feature, writer);
                writer.flush();
                this.zout.closeEntry();
                LogicTree<?> tree = MPJ_LogicTreeHazardCalc.this.solTree.getLogicTree();
                this.zout.putNextEntry("logic_tree.json");
                writer = new BufferedWriter(new OutputStreamWriter(this.zout.getOutputStream()));
                Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(LogicTree.class, new LogicTree.Adapter()).create();
                gson.toJson(tree, LogicTree.class, (Appendable)writer);
                writer.flush();
                this.zout.closeEntry();
                this.zout.close();
                try {
                    deleteFuture.get();
                }
                catch (Exception e) {
                    System.err.println("WARNING: exception deleting " + MPJ_LogicTreeHazardCalc.this.nodesAverageDir.getAbsolutePath());
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
        }

        protected void batchProcessedAsync(int[] batch, int processIndex) {
            MPJ_LogicTreeHazardCalc.this.debug("Async: processing batch of size " + batch.length + " from " + processIndex + ": " + this.getCountsString());
            try {
                for (int index : batch) {
                    LogicTreeBranch<?> branch = MPJ_LogicTreeHazardCalc.this.solTree.getLogicTree().getBranch(index);
                    File runDir = MPJ_LogicTreeHazardCalc.this.getSolDir(branch);
                    File hazardOutDir = MPJ_LogicTreeHazardCalc.this.getHazardOutputDir(runDir, branch);
                    Preconditions.checkState((boolean)hazardOutDir.exists());
                    this.zout.putNextEntry(runDir.getName() + "/");
                    this.zout.closeEntry();
                    for (SolHazardMapCalc.ReturnPeriods rp : MPJ_LogicTreeHazardCalc.this.rps) {
                        for (double period : MPJ_LogicTreeHazardCalc.this.periods) {
                            String prefix = MPJ_LogicTreeHazardCalc.mapPrefix(period, rp);
                            File mapFile = new File(hazardOutDir, prefix + ".txt");
                            Preconditions.checkState((boolean)mapFile.exists());
                            String mapEntry = runDir.getName() + "/" + mapFile.getName();
                            MPJ_LogicTreeHazardCalc.this.debug("Async: zipping " + mapEntry);
                            this.zout.transferFrom(new BufferedInputStream(new FileInputStream(mapFile)), mapEntry);
                        }
                    }
                    int n = processIndex;
                    this.rankWeights[n] = this.rankWeights[n] + MPJ_LogicTreeHazardCalc.this.solTree.getLogicTree().getBranchWeight(index);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                MPJTaskCalculator.abortAndExit((Throwable)e, (int)1);
            }
            MPJ_LogicTreeHazardCalc.this.debug("Async: DONE processing batch of size " + batch.length + " from " + processIndex + ": " + this.getCountsString());
        }
    }
}

