/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.InversionConstraint;

public class APrioriInversionConstraint
extends InversionConstraint {
    public static final String NAME = "A Priori Rupture Rate";
    public static final String SHORT_NAME = "APriori";
    private double weightForZeroRates;
    private double[] aPrioriRates;

    public APrioriInversionConstraint(double weight, double weightForZeroRates, double[] aPrioriRates) {
        super(NAME, SHORT_NAME, weight, false);
        this.weightForZeroRates = weightForZeroRates;
        this.aPrioriRates = aPrioriRates;
    }

    @Override
    public int getNumRows() {
        int numNonZero = 0;
        for (double rate : this.aPrioriRates) {
            if (!(rate > 0.0)) continue;
            ++numNonZero;
        }
        if (this.weightForZeroRates > 0.0) {
            return numNonZero + 1;
        }
        return numNonZero;
    }

    @Override
    public long encode(DoubleMatrix2D A, double[] d, int startRow) {
        int rup;
        long numNonZeroElements = 0L;
        int rowIndex = startRow;
        if (this.weight > 0.0) {
            for (rup = 0; rup < this.aPrioriRates.length; ++rup) {
                if (!(this.aPrioriRates[rup] > 0.0)) continue;
                this.setA(A, rowIndex, rup, this.weight);
                d[rowIndex] = this.aPrioriRates[rup] * this.weight;
                ++numNonZeroElements;
                ++rowIndex;
            }
        }
        if (this.weightForZeroRates > 0.0) {
            for (rup = 0; rup < this.aPrioriRates.length; ++rup) {
                if (this.aPrioriRates[rup] != 0.0) continue;
                this.setA(A, rowIndex, rup, this.weightForZeroRates);
                ++numNonZeroElements;
            }
            d[rowIndex] = 0.0;
        }
        return numNonZeroElements;
    }
}

