/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.data.uncertainty.BoundedUncertainty;
import org.opensha.commons.data.uncertainty.Uncertainty;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.ConstraintWeightingType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.InversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.PaleoSlipProbabilityModel;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.UncertainDataConstraint;
import org.opensha.sha.earthquake.faultSysSolution.modules.AveSlipModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.PaleoseismicConstraintData;
import org.opensha.sha.earthquake.faultSysSolution.modules.SectSlipRates;
import org.opensha.sha.earthquake.faultSysSolution.modules.SlipAlongRuptureModel;

public class PaleoSlipInversionConstraint
extends InversionConstraint {
    public static final String NAME = "Paleoseismic Average Slip";
    public static final String SHORT_NAME = "PaleoSlip";
    private transient FaultSystemRupSet rupSet;
    private transient AveSlipModule aveSlipModule;
    private transient SlipAlongRuptureModel slipAlongModule;
    private List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> aveSlipConstraints;
    private PaleoSlipProbabilityModel slipObsProbModel;
    private boolean applySlipRateUncertainty;

    public PaleoSlipInversionConstraint(FaultSystemRupSet rupSet, double weight, List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> aveSlipConstraints, PaleoSlipProbabilityModel slipObsProbModel, boolean applySlipRateUncertainty) {
        this(rupSet, weight, aveSlipConstraints, slipObsProbModel, applySlipRateUncertainty, ConstraintWeightingType.NORMALIZED_BY_UNCERTAINTY);
    }

    public PaleoSlipInversionConstraint(FaultSystemRupSet rupSet, double weight, List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> aveSlipConstraints, PaleoSlipProbabilityModel slipObsProbModel, boolean applySlipRateUncertainty, ConstraintWeightingType weightingType) {
        super(NAME, SHORT_NAME, weight, false, weightingType);
        this.setRuptureSet(rupSet);
        this.aveSlipConstraints = aveSlipConstraints;
        this.slipObsProbModel = slipObsProbModel;
        this.applySlipRateUncertainty = applySlipRateUncertainty;
    }

    public void setInequality(boolean inequality) {
        this.inequality = inequality;
    }

    @Override
    public int getNumRows() {
        return this.aveSlipConstraints.size();
    }

    protected List<UncertainDataConstraint.SectMappedUncertainDataConstraint> inferRateConstraints(FaultSystemRupSet rupSet, List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> aveSlipConstraints, boolean applySlipRateUncertainty) {
        return PaleoseismicConstraintData.inferRatesFromSlipConstraints(rupSet, aveSlipConstraints, applySlipRateUncertainty);
    }

    @Override
    public long encode(DoubleMatrix2D A, double[] d, int startRow) {
        long numNonZeroElements = 0L;
        List<UncertainDataConstraint.SectMappedUncertainDataConstraint> rateConstraints = this.inferRateConstraints(this.rupSet, this.aveSlipConstraints, this.applySlipRateUncertainty);
        for (int i = 0; i < rateConstraints.size(); ++i) {
            UncertainDataConstraint.SectMappedUncertainDataConstraint rateConstraint = rateConstraints.get(i);
            double stdDev = rateConstraint.getPreferredStdDev();
            double meanRate = rateConstraint.bestEstimate;
            int row = startRow + i;
            d[row] = this.weight * this.weightingType.getD(meanRate, stdDev);
            double scalar = this.weightingType.getA_Scalar(meanRate, stdDev);
            List<Integer> rupsForSect = this.rupSet.getRupturesForSection(rateConstraint.sectionIndex);
            for (int rupIndex = 0; rupIndex < rupsForSect.size(); ++rupIndex) {
                int rup = rupsForSect.get(rupIndex);
                int sectIndexInRup = this.rupSet.getSectionsIndicesForRup(rup).indexOf(rateConstraint.sectionIndex);
                double slipOnSect = this.slipAlongModule.calcSlipOnSectionsForRup(this.rupSet, this.aveSlipModule, rup)[sectIndexInRup];
                double probVisible = this.slipObsProbModel.getProbabilityOfObservedSlip(slipOnSect);
                this.setA(A, row, rup, this.weight * probVisible * scalar);
                ++numNonZeroElements;
            }
        }
        return numNonZeroElements;
    }

    @Override
    public void setRuptureSet(FaultSystemRupSet rupSet) {
        this.rupSet = rupSet;
        this.aveSlipModule = rupSet.requireModule(AveSlipModule.class);
        this.slipAlongModule = rupSet.requireModule(SlipAlongRuptureModel.class);
    }

    public static class UCERF3
    extends PaleoSlipInversionConstraint {
        public UCERF3(FaultSystemRupSet rupSet, double weight, List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> aveSlipConstraints, PaleoSlipProbabilityModel slipObsProbModel) {
            super(rupSet, weight, aveSlipConstraints, slipObsProbModel, false);
        }

        @Override
        protected List<UncertainDataConstraint.SectMappedUncertainDataConstraint> inferRateConstraints(FaultSystemRupSet rupSet, List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> aveSlipConstraints, boolean applySlipRateUncertainty) {
            SectSlipRates targetSlipRates = rupSet.requireModule(SectSlipRates.class);
            Preconditions.checkState((!applySlipRateUncertainty ? 1 : 0) != 0);
            ArrayList<UncertainDataConstraint.SectMappedUncertainDataConstraint> inferred = new ArrayList<UncertainDataConstraint.SectMappedUncertainDataConstraint>();
            for (UncertainDataConstraint.SectMappedUncertainDataConstraint sectMappedUncertainDataConstraint : aveSlipConstraints) {
                double targetSlipRate = targetSlipRates.getSlipRate(sectMappedUncertainDataConstraint.sectionIndex);
                double aveSlip = sectMappedUncertainDataConstraint.bestEstimate;
                Preconditions.checkState((boolean)(sectMappedUncertainDataConstraint.uncertainties[0] instanceof BoundedUncertainty), (Object)"UCERF3 paleo slip uncertainty estimation requires bounded uncertainties");
                BoundedUncertainty slipUncert = (BoundedUncertainty)sectMappedUncertainDataConstraint.uncertainties[0];
                Preconditions.checkState((slipUncert.lowerBound > 0.0 ? 1 : 0) != 0, (Object)"UCERF3 paleo slip uncertainty estimation can't handle lower bounds <= 0");
                System.out.println("Inferring rate constraint from paleo slip constraint on " + sectMappedUncertainDataConstraint.sectionName);
                System.out.println("\tslip=" + (float)aveSlip + "\tuncert=" + String.valueOf(slipUncert));
                System.out.println("\tslip rate=" + (float)targetSlipRate);
                double meanRate = targetSlipRate / aveSlip;
                double rateSD = slipUncert.type.estimateStdDev(targetSlipRate / slipUncert.upperBound, targetSlipRate / slipUncert.lowerBound);
                System.out.println("\trate=" + (float)meanRate + " +/- " + (float)rateSD);
                inferred.add(new UncertainDataConstraint.SectMappedUncertainDataConstraint(sectMappedUncertainDataConstraint.name, sectMappedUncertainDataConstraint.sectionIndex, sectMappedUncertainDataConstraint.sectionName, sectMappedUncertainDataConstraint.dataLocation, meanRate, new Uncertainty(rateSD)));
            }
            return inferred;
        }
    }
}

