/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import java.util.List;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.ConstraintWeightingType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.InversionConstraint;

public class ParkfieldInversionConstraint
extends InversionConstraint {
    private double targetRate;
    private List<Integer> parkfieldRups;
    private double targetWeightStdDev;

    public ParkfieldInversionConstraint(double weight, double targetRate, List<Integer> parkfieldRups) {
        this(weight, targetRate, parkfieldRups, ConstraintWeightingType.UNNORMALIZED, 0.0);
    }

    public ParkfieldInversionConstraint(double weight, double targetRate, List<Integer> parkfieldRups, ConstraintWeightingType weightingType, double targetWeightStdDev) {
        super(weightingType.applyNamePrefix("Parkfield"), weightingType.applyShortNamePrefix("Parkfield"), weight, false, weightingType);
        this.targetRate = targetRate;
        this.parkfieldRups = parkfieldRups;
        this.weightingType = weightingType;
        this.targetWeightStdDev = targetWeightStdDev;
    }

    @Override
    public int getNumRows() {
        return 1;
    }

    @Override
    public long encode(DoubleMatrix2D A, double[] d, int startRow) {
        long numNonZeroElements = 0L;
        double scalar = this.weightingType.getA_Scalar(this.targetRate, this.targetWeightStdDev);
        double target = this.weightingType.getD(this.targetRate, this.targetWeightStdDev);
        for (int r = 0; r < this.parkfieldRups.size(); ++r) {
            int rup = this.parkfieldRups.get(r);
            this.setA(A, startRow, rup, this.weight * scalar);
            ++numNonZeroElements;
        }
        d[startRow] = this.weight * target;
        return numNonZeroElements;
    }
}

