/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.function.DoubleUnaryOperator;
import org.apache.commons.math3.stat.StatUtils;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.inversion.Inversions;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.ConstraintWeightingType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.InversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.modules.ModSectMinMags;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;

public class RelativeBValueConstraint
extends InversionConstraint {
    private transient FaultSystemRupSet rupSet;
    private transient int[] rupMagIndexes;
    private transient int[] rupMagCounts;
    private transient double a_inferred;
    private double b;
    private double[] magBins;
    private double magDelta;
    private double[] magBinRelStdDevs;
    private static final DecimalFormat bDF = new DecimalFormat("0.#");

    public RelativeBValueConstraint(FaultSystemRupSet rupSet, double b, double weight) {
        this(rupSet, b, weight, ConstraintWeightingType.NORMALIZED, null);
    }

    public RelativeBValueConstraint(FaultSystemRupSet rupSet, double b, double weight, ConstraintWeightingType weightingType, DoubleUnaryOperator relMagStdDevFunc) {
        this(rupSet, b, weight, weightingType, relMagStdDevFunc, false);
    }

    public RelativeBValueConstraint(FaultSystemRupSet rupSet, double b, double weight, ConstraintWeightingType weightingType, DoubleUnaryOperator relMagStdDevFunc, boolean inequality) {
        super(weightingType.applyNamePrefix(RelativeBValueConstraint.getName(b, inequality)), weightingType.applyShortNamePrefix(RelativeBValueConstraint.getShortName(b, inequality)), weight, inequality, weightingType);
        this.b = b;
        this.initMagBins(rupSet);
        this.setRuptureSet(rupSet);
        if (relMagStdDevFunc != null) {
            this.magBinRelStdDevs = new double[this.magBins.length];
            for (int m = 0; m < this.magBinRelStdDevs.length; ++m) {
                this.magBinRelStdDevs[m] = relMagStdDevFunc.applyAsDouble(this.magBins[m]);
            }
        } else {
            Preconditions.checkState((weightingType != ConstraintWeightingType.NORMALIZED_BY_UNCERTAINTY ? 1 : 0) != 0, (Object)"Uncertainty-normalization selected but magnitude-dependent uncertainties not supplied");
        }
    }

    private void initMagBins(FaultSystemRupSet rupSet) {
        double maxMag = rupSet.getMaxMag();
        double minMag = rupSet.hasModule(ModSectMinMags.class) ? StatUtils.min((double[])rupSet.getModule(ModSectMinMags.class).getMinMagForSections()) : rupSet.getMinMag();
        Preconditions.checkState((maxMag > minMag + 0.2 ? 1 : 0) != 0, (String)"Minimum and maximum magnitude are too close for b-value constraint: %s %s", (Object)minMag, (Object)maxMag);
        minMag = Math.floor(minMag * 10.0) / 10.0 + 0.05;
        maxMag = Math.ceil(maxMag * 10.0) / 10.0 - 0.05;
        int num = (int)((maxMag - minMag) / 0.1) + 2;
        Preconditions.checkState((num > 1 ? 1 : 0) != 0, (Object)"Must have at least 2 MFD bins to constraint relative b-value");
        EvenlyDiscretizedFunc magFunc = new EvenlyDiscretizedFunc(minMag, maxMag, num);
        this.magBins = new double[num];
        for (int m = 0; m < num; ++m) {
            this.magBins[m] = magFunc.getX(m);
        }
        this.magDelta = magFunc.getDelta();
    }

    private static String getShortName(double b, boolean inequality) {
        if (inequality) {
            return "G-R,b\u2265" + bDF.format(b);
        }
        return "G-R,b=" + bDF.format(b);
    }

    private static String getName(double b, boolean inequality) {
        if (inequality) {
            return "G-R b-value constrant (b\u2265" + bDF.format(b) + ")";
        }
        return "G-R b-value constrant (b=" + bDF.format(b) + ")";
    }

    @Override
    public int getNumRows() {
        int rows = 0;
        for (int m1 = 0; m1 < this.magBins.length; ++m1) {
            for (int m2 = m1 + 1; m2 < this.magBins.length; ++m2) {
                if (this.rupMagCounts[m1] <= 0 || this.rupMagCounts[m2] <= 0) continue;
                ++rows;
            }
        }
        return rows;
    }

    private static double incrGR(double a, double b, double m1, double m2) {
        Preconditions.checkState((m2 > m1 ? 1 : 0) != 0);
        return RelativeBValueConstraint.cmlGR(a, b, m1) - RelativeBValueConstraint.cmlGR(a, b, m2);
    }

    private static double cmlGR(double a, double b, double M) {
        return Math.pow(10.0, a - b * M);
    }

    @Override
    public long encode(DoubleMatrix2D A, double[] d, int startRow) {
        long count = 0L;
        double halfMagBin = this.magDelta * 0.5;
        int row = startRow;
        for (int m1 = 0; m1 < this.magBins.length; ++m1) {
            if (this.rupMagCounts[m1] == 0) {
                System.out.println("Skipping M1=" + (float)this.magBins[m1] + " (no ruptures)");
                continue;
            }
            double val1 = RelativeBValueConstraint.incrGR(this.a_inferred, this.b, this.magBins[m1] - halfMagBin, this.magBins[m1] + halfMagBin);
            System.out.println("Building b-value constraints for ruptures with M1=" + (float)this.magBins[m1]);
            for (int m2 = m1 + 1; m2 < this.magBins.length; ++m2) {
                double aScalar;
                if (this.rupMagCounts[m2] == 0) {
                    System.out.println("\tSkipping M2=" + (float)this.magBins[m2] + " (no ruptures)");
                    continue;
                }
                double val2 = RelativeBValueConstraint.incrGR(this.a_inferred, this.b, this.magBins[m2] - halfMagBin, this.magBins[m2] + halfMagBin);
                double ratio = val1 / val2;
                switch (this.weightingType) {
                    case UNNORMALIZED: {
                        aScalar = 1.0;
                        break;
                    }
                    case NORMALIZED: {
                        aScalar = 1.0 / val1;
                        break;
                    }
                    case NORMALIZED_BY_UNCERTAINTY: {
                        double uncert = this.magBinRelStdDevs[m1] * val1 + this.magBinRelStdDevs[m2] * val1;
                        aScalar = 1.0 / uncert;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                System.out.println("\tTarget ratio relative to M2=" + (float)this.magBins[m2] + ": " + (float)ratio + "\taScalar=" + (float)aScalar);
                double myWeight = this.weight * aScalar;
                for (int r = 0; r < this.rupMagIndexes.length; ++r) {
                    int magIndex = this.rupMagIndexes[r];
                    if (magIndex < 0) continue;
                    if (magIndex == m2) {
                        this.setA(A, row, r, myWeight * ratio);
                        ++count;
                        continue;
                    }
                    if (magIndex != m1) continue;
                    this.setA(A, row, r, -myWeight);
                    ++count;
                }
                d[row] = 0.0;
                ++row;
            }
        }
        return count;
    }

    @Override
    public void setRuptureSet(FaultSystemRupSet rupSet) {
        if (rupSet != this.rupSet) {
            double[] rupMags = rupSet.getMagForAllRups();
            this.rupMagIndexes = new int[rupMags.length];
            EvenlyDiscretizedFunc magFunc = new EvenlyDiscretizedFunc(this.magBins[0], this.magBins[this.magBins.length - 1], this.magBins.length);
            for (int i = 0; i < this.magBins.length; ++i) {
                Preconditions.checkState(((float)this.magBins[i] == (float)magFunc.getX(i) ? 1 : 0) != 0);
            }
            double globalMin = magFunc.getMinX() - 0.5 * magFunc.getDelta();
            double globalMax = magFunc.getMaxX() + 0.5 * magFunc.getDelta();
            this.rupMagCounts = new int[magFunc.size()];
            for (int r = 0; r < rupMags.length; ++r) {
                if ((float)rupMags[r] < (float)globalMin || (float)rupMags[r] > (float)globalMax) {
                    this.rupMagIndexes[r] = -1;
                    continue;
                }
                this.rupMagIndexes[r] = magFunc.getClosestXIndex(rupMags[r]);
                int n = this.rupMagIndexes[r];
                this.rupMagCounts[n] = this.rupMagCounts[n] + 1;
            }
            GutenbergRichterMagFreqDist inferredGR = Inversions.inferTargetGRFromSlipRates(rupSet, this.b);
            EvenlyDiscretizedFunc cml = inferredGR.getCumRateDistWithOffset();
            double totRate = cml.getY(0);
            double m = cml.getX(0);
            this.a_inferred = Math.log10(totRate) + this.b * m;
            this.rupSet = rupSet;
        }
    }

    public static void main(String[] args) throws IOException {
        FaultSystemRupSet rupSet = FaultSystemRupSet.load(new File("/home/kevin/markdown/inversions/fm3_1_u3ref_uniform_reproduce_ucerf3.zip"));
        double b = 1.0;
        RelativeBValueConstraint constr = new RelativeBValueConstraint(rupSet, b, 1.0);
        System.out.println("Func has " + constr.magBins.length + " bins");
        System.out.println("Rows: " + constr.getNumRows());
        System.out.print("Bins:\t");
        for (double mag : constr.magBins) {
            System.out.print((float)mag + " ");
        }
        System.out.println();
        if (constr.magBinRelStdDevs != null) {
            System.out.print("Uncerts:\t");
            for (double uncert : constr.magBinRelStdDevs) {
                System.out.print((float)uncert + " ");
            }
            System.out.println();
        }
        System.out.println("Inferred GR a=" + (float)constr.a_inferred);
    }
}

