/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.util.modules.AverageableModule;
import org.opensha.commons.util.modules.helpers.CSV_BackedModule;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.ConstraintRange;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.InversionState;

public class AnnealingProgress
implements CSV_BackedModule,
AverageableModule<AnnealingProgress> {
    private ImmutableList<String> energyTypes;
    private List<Long> times;
    private List<Long> iterations;
    private List<Long> perturbs;
    private List<Long> worseKepts;
    private List<double[]> energies;
    private List<Integer> numNonZeros;
    public static final List<String> defaultTypes = ImmutableList.of((Object)"Total Energy", (Object)"Equality Energy", (Object)"Entropy Energy", (Object)"Inequality Energy");
    public static final String PROGRESS_FILE_NAME = "annealing_progress.csv";

    private AnnealingProgress() {
    }

    public static AnnealingProgress forConstraintRanges(List<ConstraintRange> constraintRanges) {
        ArrayList<String> types = new ArrayList<String>(defaultTypes);
        if (constraintRanges != null) {
            for (ConstraintRange range : constraintRanges) {
                types.add(range.name);
            }
        }
        return new AnnealingProgress(types);
    }

    public AnnealingProgress(List<String> energyTypes) {
        this.energyTypes = ImmutableList.copyOf(energyTypes);
        this.times = new ArrayList<Long>();
        this.iterations = new ArrayList<Long>();
        this.perturbs = new ArrayList<Long>();
        this.worseKepts = new ArrayList<Long>();
        this.energies = new ArrayList<double[]>();
        this.numNonZeros = new ArrayList<Integer>();
    }

    public AnnealingProgress(CSVFile<String> csv) {
        this();
        this.initFromCSV(csv);
    }

    @Override
    public String getFileName() {
        return PROGRESS_FILE_NAME;
    }

    @Override
    public String getName() {
        return "Annealing Progress";
    }

    @Override
    public CSVFile<?> getCSV() {
        CSVFile csv = new CSVFile(true);
        ArrayList<String> header = new ArrayList<String>();
        header.add("Iteration");
        header.add("Time (ms)");
        header.add("# Perturbations");
        if (this.worseKepts != null) {
            header.add("# Worse Values Kept");
        }
        header.add("# Non-Zero");
        for (String energyType : this.energyTypes) {
            header.add(energyType);
        }
        csv.addLine(header);
        for (int i = 0; i < this.times.size(); ++i) {
            ArrayList<CallSite> line = new ArrayList<CallSite>(header.size());
            line.add((CallSite)((Object)String.valueOf(this.iterations.get(i))));
            line.add((CallSite)((Object)String.valueOf(this.times.get(i))));
            line.add((CallSite)((Object)String.valueOf(this.perturbs.get(i))));
            if (this.worseKepts != null) {
                line.add((CallSite)((Object)String.valueOf(this.worseKepts.get(i))));
            }
            line.add((CallSite)((Object)String.valueOf(this.numNonZeros.get(i))));
            for (double energy : this.energies.get(i)) {
                line.add((CallSite)((Object)("" + (float)energy)));
            }
            csv.addLine(line);
        }
        return csv;
    }

    @Override
    public void initFromCSV(CSVFile<String> csv) {
        int typeStartIndex;
        ImmutableList.Builder energyTypeBuilder = ImmutableList.builder();
        this.times = new ArrayList<Long>();
        this.iterations = new ArrayList<Long>();
        this.perturbs = new ArrayList<Long>();
        if (csv.get(0, 3).contains("Worse")) {
            typeStartIndex = 5;
            this.worseKepts = new ArrayList<Long>();
        } else {
            typeStartIndex = 4;
            this.worseKepts = null;
        }
        this.numNonZeros = new ArrayList<Integer>();
        this.energies = new ArrayList<double[]>();
        List<String> header = csv.getLine(0);
        for (int i = typeStartIndex; i < header.size(); ++i) {
            energyTypeBuilder.add((Object)header.get(i));
        }
        this.energyTypes = energyTypeBuilder.build();
        for (int row = 1; row < csv.getNumRows(); ++row) {
            int col = 0;
            this.iterations.add(csv.getLong(row, col++));
            this.times.add(csv.getLong(row, col++));
            this.perturbs.add(csv.getLong(row, col++));
            if (this.worseKepts != null) {
                this.worseKepts.add(csv.getLong(row, col++));
            }
            this.numNonZeros.add(csv.getInt(row, col++));
            double[] energies = new double[this.energyTypes.size()];
            for (int i = 0; i < this.energyTypes.size(); ++i) {
                energies[i] = csv.getDouble(row, col++);
            }
            this.energies.add(energies);
        }
    }

    public void addProgress(InversionState state) {
        Preconditions.checkState((state.energy.length == this.energyTypes.size() ? 1 : 0) != 0, (String)"Expected %s energies, have %s", (int)this.energyTypes.size(), (int)state.energy.length);
        this.times.add(state.elapsedTimeMillis);
        this.iterations.add(state.iterations);
        this.perturbs.add(state.numPerturbsKept);
        this.worseKepts.add(state.numWorseValuesKept);
        this.numNonZeros.add(state.numNonZero);
        this.energies.add(state.energy);
    }

    public int size() {
        return this.times.size();
    }

    public long getTime(int index) {
        return this.times.get(index);
    }

    public long getIterations(int index) {
        return this.iterations.get(index);
    }

    public long getNumPerturbations(int index) {
        return this.perturbs.get(index);
    }

    public boolean hasWorseKepts() {
        return this.worseKepts != null;
    }

    public long getNumWorseKept(int index) {
        return this.worseKepts.get(index);
    }

    public int getNumNonZero(int index) {
        return this.numNonZeros.get(index);
    }

    public double[] getEnergies(int index) {
        return this.energies.get(index);
    }

    public ImmutableList<String> getEnergyTypes() {
        return this.energyTypes;
    }

    public static AnnealingProgress average(List<AnnealingProgress> progresses) {
        double avgMinTime = 0.0;
        double avgMinIters = 0.0;
        double avgMaxTime = 0.0;
        double avgMaxIters = 0.0;
        double avgSize = 0.0;
        ImmutableList<String> types = progresses.get((int)0).energyTypes;
        double scalarEach = 1.0 / (double)progresses.size();
        for (AnnealingProgress progress : progresses) {
            Preconditions.checkState((types.size() == progress.energyTypes.size() ? 1 : 0) != 0);
            Preconditions.checkState((boolean)types.equals(progress.energyTypes));
            avgMinTime += scalarEach * (double)progress.times.get(0).longValue();
            avgMinIters += scalarEach * (double)progress.iterations.get(0).longValue();
            avgMaxTime += scalarEach * (double)progress.times.get(progress.size() - 1).longValue();
            avgMaxIters += scalarEach * (double)progress.iterations.get(progress.size() - 1).longValue();
            avgSize += scalarEach * (double)progress.size();
        }
        int finalSize = (int)Math.round(avgSize);
        if (finalSize < 2) {
            finalSize = 2;
        }
        List<Long> times = AnnealingProgress.evenlyDiscr(avgMinTime, avgMaxTime, finalSize);
        List<Long> iters = AnnealingProgress.evenlyDiscr(avgMinIters, avgMaxIters, finalSize);
        ArrayList<Double> avgPerturbs = new ArrayList<Double>();
        ArrayList<Double> avgWorseKepts = new ArrayList<Double>();
        ArrayList<Double> avgNonZeros = new ArrayList<Double>();
        ArrayList<double[]> avgEnergies = new ArrayList<double[]>();
        for (int i = 0; i < finalSize; ++i) {
            avgPerturbs.add(0.0);
            avgNonZeros.add(0.0);
            avgEnergies.add(new double[types.size()]);
            avgWorseKepts.add(0.0);
        }
        for (AnnealingProgress progress : progresses) {
            int i;
            DiscretizedFunc[] relEnergyTimeFuncs = new DiscretizedFunc[progress.energyTypes.size()];
            DiscretizedFunc[] relEnergyIterFuncs = new DiscretizedFunc[progress.energyTypes.size()];
            for (int i2 = 0; i2 < types.size(); ++i2) {
                relEnergyTimeFuncs[i2] = new ArbitrarilyDiscretizedFunc();
                relEnergyIterFuncs[i2] = new ArbitrarilyDiscretizedFunc();
            }
            if (!progress.hasWorseKepts()) {
                avgWorseKepts = null;
            }
            ArbitrarilyDiscretizedFunc relPerturbs = new ArbitrarilyDiscretizedFunc();
            ArbitrarilyDiscretizedFunc relWorseKepts = new ArbitrarilyDiscretizedFunc();
            ArbitrarilyDiscretizedFunc relNonZeros = new ArbitrarilyDiscretizedFunc();
            long myMinTime = progress.times.get(0);
            long myMinIters = progress.iterations.get(0);
            double myMaxTime = progress.times.get(progress.size() - 1).longValue();
            double myMaxIters = progress.iterations.get(progress.size() - 1).longValue();
            double myTimeDur = myMaxTime - (double)myMinTime;
            double myIters = myMaxIters - (double)myMinIters;
            for (i = 0; i < progress.size(); ++i) {
                double relTime = (double)(progress.times.get(i) - myMinTime) / myTimeDur;
                Preconditions.checkState(((float)relTime >= 0.0f && (float)relTime <= 1.0f ? 1 : 0) != 0, (String)"Bad relTime=%s", (Object)relTime);
                double relIters = (double)(progress.iterations.get(i) - myMinIters) / myIters;
                Preconditions.checkState(((float)relIters >= 0.0f && (float)relIters <= 1.0f ? 1 : 0) != 0, (String)"Bad relIters=%s", (Object)relIters);
                double[] energies = progress.energies.get(i);
                for (int j = 0; j < energies.length; ++j) {
                    relEnergyTimeFuncs[j].set(relTime, energies[j]);
                    relEnergyIterFuncs[j].set(relIters, energies[j]);
                }
                relPerturbs.set(relIters, (double)progress.perturbs.get(i).longValue());
                relNonZeros.set(relIters, (double)progress.numNonZeros.get(i).intValue());
                if (avgWorseKepts == null) continue;
                relWorseKepts.set(relIters, (double)progress.worseKepts.get(i).longValue());
            }
            for (i = 0; i < finalSize; ++i) {
                double relX = (double)i / (double)(finalSize - 1);
                double[] energies = (double[])avgEnergies.get(i);
                for (int j = 0; j < energies.length; ++j) {
                    int n = j;
                    energies[n] = energies[n] + scalarEach * 0.5 * (relEnergyIterFuncs[j].getInterpolatedY(relX) + relEnergyTimeFuncs[j].getInterpolatedY(relX));
                }
                avgPerturbs.set(i, (Double)avgPerturbs.get(i) + scalarEach * relPerturbs.getInterpolatedY(relX));
                avgNonZeros.set(i, (Double)avgNonZeros.get(i) + scalarEach * relNonZeros.getInterpolatedY(relX));
                if (avgWorseKepts == null) continue;
                avgWorseKepts.set(i, (Double)avgWorseKepts.get(i) + scalarEach * relWorseKepts.getInterpolatedY(relX));
            }
        }
        ArrayList<Long> perturbs = new ArrayList<Long>();
        ArrayList<Long> worseKepts = avgWorseKepts == null ? null : new ArrayList<Long>();
        ArrayList<Integer> numNonZeros = new ArrayList<Integer>();
        for (int i = 0; i < finalSize; ++i) {
            perturbs.add(Math.round((Double)avgPerturbs.get(i)));
            numNonZeros.add((int)Math.round((Double)avgNonZeros.get(i)));
            if (worseKepts == null) continue;
            worseKepts.add(Math.round((Double)avgWorseKepts.get(i)));
        }
        AnnealingProgress ret = new AnnealingProgress();
        ret.energyTypes = types;
        ret.times = times;
        ret.iterations = iters;
        ret.perturbs = perturbs;
        ret.worseKepts = worseKepts;
        ret.energies = avgEnergies;
        ret.numNonZeros = numNonZeros;
        return ret;
    }

    private static List<Long> evenlyDiscr(double min, double max, int size) {
        EvenlyDiscretizedFunc func = new EvenlyDiscretizedFunc(min, max, size);
        ArrayList<Long> ret = new ArrayList<Long>(size);
        for (int i = 0; i < size; ++i) {
            ret.add((long)func.getX(i));
        }
        return ret;
    }

    @Override
    public AverageableModule.AveragingAccumulator<AnnealingProgress> averagingAccumulator() {
        return new AverageableModule.AveragingAccumulator<AnnealingProgress>(){
            List<AnnealingProgress> progresses = new ArrayList<AnnealingProgress>();

            @Override
            public void process(AnnealingProgress module, double weight) {
                this.progresses.add(module);
            }

            @Override
            public AnnealingProgress getAverage() {
                return AnnealingProgress.average(this.progresses);
            }

            @Override
            public Class<AnnealingProgress> getType() {
                return AnnealingProgress.class;
            }
        };
    }
}

