/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.InversionState;

@JsonAdapter(value=Adapter.class)
public interface CompletionCriteria {
    public boolean isSatisfied(InversionState var1);

    public static class Adapter
    extends TypeAdapter<CompletionCriteria> {
        Gson gson = new Gson();

        public void write(JsonWriter out, CompletionCriteria value) throws IOException {
            out.beginObject();
            out.name("type").value(value.getClass().getName());
            out.name("criteria");
            this.gson.toJson((Object)value, value.getClass(), out);
            out.endObject();
        }

        public CompletionCriteria read(JsonReader in) throws IOException {
            Class<?> type = null;
            in.beginObject();
            Preconditions.checkState((boolean)in.nextName().equals("type"), (Object)"JSON 'type' object must be first");
            try {
                type = Class.forName(in.nextString());
            }
            catch (ClassNotFoundException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            Preconditions.checkState((boolean)in.nextName().equals("criteria"), (Object)"JSON 'data' object must be second");
            CompletionCriteria criteria = (CompletionCriteria)this.gson.fromJson(in, type);
            in.endObject();
            return criteria;
        }
    }

    public static interface EstimationCompletionCriteria
    extends CompletionCriteria {
        default public long estimateTimeLeft(InversionState state) {
            double fractDone = this.estimateFractCompleted(state);
            long ellapsed = state.elapsedTimeMillis;
            long expected = (long)((double)ellapsed / fractDone);
            return expected - ellapsed;
        }

        public double estimateFractCompleted(InversionState var1);
    }
}

